//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securityinsights/armsecurityinsights"
)

func unmarshalAlertRuleClassification(rawMsg json.RawMessage) (armsecurityinsights.AlertRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armsecurityinsights.AlertRuleClassification
	switch m["kind"] {
	case string(armsecurityinsights.AlertRuleKindFusion):
		b = &armsecurityinsights.FusionAlertRule{}
	case string(armsecurityinsights.AlertRuleKindMicrosoftSecurityIncidentCreation):
		b = &armsecurityinsights.MicrosoftSecurityIncidentCreationAlertRule{}
	case string(armsecurityinsights.AlertRuleKindScheduled):
		b = &armsecurityinsights.ScheduledAlertRule{}
	default:
		b = &armsecurityinsights.AlertRule{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDataConnectorClassification(rawMsg json.RawMessage) (armsecurityinsights.DataConnectorClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armsecurityinsights.DataConnectorClassification
	switch m["kind"] {
	case string(armsecurityinsights.DataConnectorKindAmazonWebServicesCloudTrail):
		b = &armsecurityinsights.AwsCloudTrailDataConnector{}
	case string(armsecurityinsights.DataConnectorKindAzureActiveDirectory):
		b = &armsecurityinsights.AADDataConnector{}
	case string(armsecurityinsights.DataConnectorKindAzureAdvancedThreatProtection):
		b = &armsecurityinsights.AATPDataConnector{}
	case string(armsecurityinsights.DataConnectorKindAzureSecurityCenter):
		b = &armsecurityinsights.ASCDataConnector{}
	case string(armsecurityinsights.DataConnectorKindMicrosoftCloudAppSecurity):
		b = &armsecurityinsights.MCASDataConnector{}
	case string(armsecurityinsights.DataConnectorKindMicrosoftDefenderAdvancedThreatProtection):
		b = &armsecurityinsights.MDATPDataConnector{}
	case string(armsecurityinsights.DataConnectorKindOffice365):
		b = &armsecurityinsights.OfficeDataConnector{}
	case string(armsecurityinsights.DataConnectorKindThreatIntelligence):
		b = &armsecurityinsights.TIDataConnector{}
	default:
		b = &armsecurityinsights.DataConnector{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
