//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armserialconsole_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/serialconsole/armserialconsole"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/serialconsole/resource-manager/Microsoft.SerialConsole/stable/2018-05-01/examples/GetOperationsExample.json
func ExampleMicrosoftSerialConsoleClient_ListOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armserialconsole.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMicrosoftSerialConsoleClient().ListOperations(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Operations = armserialconsole.Operations{
	// 	Value: []*armserialconsole.OperationsValueItem{
	// 		{
	// 			Name: to.Ptr("Microsoft.SerialConsole/consoleServices/read"),
	// 			Display: &armserialconsole.OperationsValueItemDisplay{
	// 				Description: to.Ptr("Retrieves the current subscription state"),
	// 				Operation: to.Ptr("Default"),
	// 				Provider: to.Ptr("Microsoft.SerialConsole"),
	// 				Resource: to.Ptr("Serial Console instance"),
	// 			},
	// 			IsDataAction: to.Ptr("false"),
	// 		},
	// 		{
	// 			Name: to.Ptr("Microsoft.SerialConsole/consoleServices/disableConsole/action"),
	// 			Display: &armserialconsole.OperationsValueItemDisplay{
	// 				Description: to.Ptr("Disable Serial Console for a subscription"),
	// 				Operation: to.Ptr("Disable Console"),
	// 				Provider: to.Ptr("Microsoft.SerialConsole"),
	// 				Resource: to.Ptr("Serial Console instance"),
	// 			},
	// 			IsDataAction: to.Ptr("false"),
	// 		},
	// 		{
	// 			Name: to.Ptr("Microsoft.SerialConsole/consoleServices/enableConsole/action"),
	// 			Display: &armserialconsole.OperationsValueItemDisplay{
	// 				Description: to.Ptr("Enable Serial Console for a subscription"),
	// 				Operation: to.Ptr("Enable Console"),
	// 				Provider: to.Ptr("Microsoft.SerialConsole"),
	// 				Resource: to.Ptr("Serial Console instance"),
	// 			},
	// 			IsDataAction: to.Ptr("false"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/serialconsole/resource-manager/Microsoft.SerialConsole/stable/2018-05-01/examples/SerialConsoleStatus.json
func ExampleMicrosoftSerialConsoleClient_GetConsoleStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armserialconsole.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMicrosoftSerialConsoleClient().GetConsoleStatus(ctx, "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = armserialconsole.Status{
	// 	Disabled: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/serialconsole/resource-manager/Microsoft.SerialConsole/stable/2018-05-01/examples/DisableConsoleExamples.json
func ExampleMicrosoftSerialConsoleClient_DisableConsole() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armserialconsole.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMicrosoftSerialConsoleClient().DisableConsole(ctx, "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = armserialconsole.DisableSerialConsoleResult{
	// 	Disabled: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/serialconsole/resource-manager/Microsoft.SerialConsole/stable/2018-05-01/examples/EnableConsoleExamples.json
func ExampleMicrosoftSerialConsoleClient_EnableConsole() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armserialconsole.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMicrosoftSerialConsoleClient().EnableConsole(ctx, "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = armserialconsole.EnableSerialConsoleResult{
	// 	Disabled: to.Ptr(false),
	// }
}
