//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicelinker/armservicelinker/v2"
	"net/http"
	"net/url"
)

// ConfigurationNamesServer is a fake server for instances of the armservicelinker.ConfigurationNamesClient type.
type ConfigurationNamesServer struct {
	// NewListPager is the fake for method ConfigurationNamesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armservicelinker.ConfigurationNamesClientListOptions) (resp azfake.PagerResponder[armservicelinker.ConfigurationNamesClientListResponse])
}

// NewConfigurationNamesServerTransport creates a new instance of ConfigurationNamesServerTransport with the provided implementation.
// The returned ConfigurationNamesServerTransport instance is connected to an instance of armservicelinker.ConfigurationNamesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConfigurationNamesServerTransport(srv *ConfigurationNamesServer) *ConfigurationNamesServerTransport {
	return &ConfigurationNamesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armservicelinker.ConfigurationNamesClientListResponse]](),
	}
}

// ConfigurationNamesServerTransport connects instances of armservicelinker.ConfigurationNamesClient to instances of ConfigurationNamesServer.
// Don't use this type directly, use NewConfigurationNamesServerTransport instead.
type ConfigurationNamesServerTransport struct {
	srv          *ConfigurationNamesServer
	newListPager *tracker[azfake.PagerResponder[armservicelinker.ConfigurationNamesClientListResponse]]
}

// Do implements the policy.Transporter interface for ConfigurationNamesServerTransport.
func (c *ConfigurationNamesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConfigurationNamesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConfigurationNamesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armservicelinker.ConfigurationNamesClientListOptions
		if filterParam != nil || skipTokenParam != nil {
			options = &armservicelinker.ConfigurationNamesClientListOptions{
				Filter:    filterParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListPager(options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armservicelinker.ConfigurationNamesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
