//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DatabaseSQLVulnerabilityAssessmentExecuteScanServer is a fake server for instances of the armsql.DatabaseSQLVulnerabilityAssessmentExecuteScanClient type.
type DatabaseSQLVulnerabilityAssessmentExecuteScanServer struct {
	// BeginExecute is the fake for method DatabaseSQLVulnerabilityAssessmentExecuteScanClient.BeginExecute
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginExecute func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.DatabaseSQLVulnerabilityAssessmentExecuteScanClientBeginExecuteOptions) (resp azfake.PollerResponder[armsql.DatabaseSQLVulnerabilityAssessmentExecuteScanClientExecuteResponse], errResp azfake.ErrorResponder)
}

// NewDatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport creates a new instance of DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport with the provided implementation.
// The returned DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport instance is connected to an instance of armsql.DatabaseSQLVulnerabilityAssessmentExecuteScanClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport(srv *DatabaseSQLVulnerabilityAssessmentExecuteScanServer) *DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport {
	return &DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport{
		srv:          srv,
		beginExecute: newTracker[azfake.PollerResponder[armsql.DatabaseSQLVulnerabilityAssessmentExecuteScanClientExecuteResponse]](),
	}
}

// DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport connects instances of armsql.DatabaseSQLVulnerabilityAssessmentExecuteScanClient to instances of DatabaseSQLVulnerabilityAssessmentExecuteScanServer.
// Don't use this type directly, use NewDatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport instead.
type DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport struct {
	srv          *DatabaseSQLVulnerabilityAssessmentExecuteScanServer
	beginExecute *tracker[azfake.PollerResponder[armsql.DatabaseSQLVulnerabilityAssessmentExecuteScanClientExecuteResponse]]
}

// Do implements the policy.Transporter interface for DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport.
func (d *DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabaseSQLVulnerabilityAssessmentExecuteScanClient.BeginExecute":
		resp, err = d.dispatchBeginExecute(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabaseSQLVulnerabilityAssessmentExecuteScanServerTransport) dispatchBeginExecute(req *http.Request) (*http.Response, error) {
	if d.srv.BeginExecute == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginExecute not implemented")}
	}
	beginExecute := d.beginExecute.get(req)
	if beginExecute == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/initiateScan`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginExecute(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginExecute = &respr
		d.beginExecute.add(req, beginExecute)
	}

	resp, err := server.PollerResponderNext(beginExecute, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginExecute.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginExecute) {
		d.beginExecute.remove(req)
	}

	return resp, nil
}
