//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// EncryptionProtectorsServer is a fake server for instances of the armsql.EncryptionProtectorsClient type.
type EncryptionProtectorsServer struct {
	// BeginCreateOrUpdate is the fake for method EncryptionProtectorsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, encryptionProtectorName armsql.EncryptionProtectorName, parameters armsql.EncryptionProtector, options *armsql.EncryptionProtectorsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.EncryptionProtectorsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method EncryptionProtectorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, encryptionProtectorName armsql.EncryptionProtectorName, options *armsql.EncryptionProtectorsClientGetOptions) (resp azfake.Responder[armsql.EncryptionProtectorsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByServerPager is the fake for method EncryptionProtectorsClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(resourceGroupName string, serverName string, options *armsql.EncryptionProtectorsClientListByServerOptions) (resp azfake.PagerResponder[armsql.EncryptionProtectorsClientListByServerResponse])

	// BeginRevalidate is the fake for method EncryptionProtectorsClient.BeginRevalidate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRevalidate func(ctx context.Context, resourceGroupName string, serverName string, encryptionProtectorName armsql.EncryptionProtectorName, options *armsql.EncryptionProtectorsClientBeginRevalidateOptions) (resp azfake.PollerResponder[armsql.EncryptionProtectorsClientRevalidateResponse], errResp azfake.ErrorResponder)
}

// NewEncryptionProtectorsServerTransport creates a new instance of EncryptionProtectorsServerTransport with the provided implementation.
// The returned EncryptionProtectorsServerTransport instance is connected to an instance of armsql.EncryptionProtectorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEncryptionProtectorsServerTransport(srv *EncryptionProtectorsServer) *EncryptionProtectorsServerTransport {
	return &EncryptionProtectorsServerTransport{
		srv:                  srv,
		beginCreateOrUpdate:  newTracker[azfake.PollerResponder[armsql.EncryptionProtectorsClientCreateOrUpdateResponse]](),
		newListByServerPager: newTracker[azfake.PagerResponder[armsql.EncryptionProtectorsClientListByServerResponse]](),
		beginRevalidate:      newTracker[azfake.PollerResponder[armsql.EncryptionProtectorsClientRevalidateResponse]](),
	}
}

// EncryptionProtectorsServerTransport connects instances of armsql.EncryptionProtectorsClient to instances of EncryptionProtectorsServer.
// Don't use this type directly, use NewEncryptionProtectorsServerTransport instead.
type EncryptionProtectorsServerTransport struct {
	srv                  *EncryptionProtectorsServer
	beginCreateOrUpdate  *tracker[azfake.PollerResponder[armsql.EncryptionProtectorsClientCreateOrUpdateResponse]]
	newListByServerPager *tracker[azfake.PagerResponder[armsql.EncryptionProtectorsClientListByServerResponse]]
	beginRevalidate      *tracker[azfake.PollerResponder[armsql.EncryptionProtectorsClientRevalidateResponse]]
}

// Do implements the policy.Transporter interface for EncryptionProtectorsServerTransport.
func (e *EncryptionProtectorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EncryptionProtectorsClient.BeginCreateOrUpdate":
		resp, err = e.dispatchBeginCreateOrUpdate(req)
	case "EncryptionProtectorsClient.Get":
		resp, err = e.dispatchGet(req)
	case "EncryptionProtectorsClient.NewListByServerPager":
		resp, err = e.dispatchNewListByServerPager(req)
	case "EncryptionProtectorsClient.BeginRevalidate":
		resp, err = e.dispatchBeginRevalidate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EncryptionProtectorsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := e.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector/(?P<encryptionProtectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.EncryptionProtector](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		encryptionProtectorNameParam, err := parseWithCast(matches[regex.SubexpIndex("encryptionProtectorName")], func(v string) (armsql.EncryptionProtectorName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.EncryptionProtectorName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, encryptionProtectorNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		e.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		e.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (e *EncryptionProtectorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector/(?P<encryptionProtectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	encryptionProtectorNameParam, err := parseWithCast(matches[regex.SubexpIndex("encryptionProtectorName")], func(v string) (armsql.EncryptionProtectorName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.EncryptionProtectorName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, encryptionProtectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EncryptionProtector, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EncryptionProtectorsServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := e.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListByServerPager(resourceGroupNameParam, serverNameParam, nil)
		newListByServerPager = &resp
		e.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armsql.EncryptionProtectorsClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		e.newListByServerPager.remove(req)
	}
	return resp, nil
}

func (e *EncryptionProtectorsServerTransport) dispatchBeginRevalidate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginRevalidate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRevalidate not implemented")}
	}
	beginRevalidate := e.beginRevalidate.get(req)
	if beginRevalidate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/encryptionProtector/(?P<encryptionProtectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revalidate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		encryptionProtectorNameParam, err := parseWithCast(matches[regex.SubexpIndex("encryptionProtectorName")], func(v string) (armsql.EncryptionProtectorName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.EncryptionProtectorName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginRevalidate(req.Context(), resourceGroupNameParam, serverNameParam, encryptionProtectorNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRevalidate = &respr
		e.beginRevalidate.add(req, beginRevalidate)
	}

	resp, err := server.PollerResponderNext(beginRevalidate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginRevalidate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRevalidate) {
		e.beginRevalidate.remove(req)
	}

	return resp, nil
}
