//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// VulnerabilityAssessmentScanResultServer is a fake server for instances of the armsql.VulnerabilityAssessmentScanResultClient type.
type VulnerabilityAssessmentScanResultServer struct {
	// Get is the fake for method VulnerabilityAssessmentScanResultClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.SQLVulnerabilityAssessmentName, scanID string, scanResultID string, options *armsql.VulnerabilityAssessmentScanResultClientGetOptions) (resp azfake.Responder[armsql.VulnerabilityAssessmentScanResultClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByScanPager is the fake for method VulnerabilityAssessmentScanResultClient.NewListByScanPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByScanPager func(resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.SQLVulnerabilityAssessmentName, scanID string, options *armsql.VulnerabilityAssessmentScanResultClientListByScanOptions) (resp azfake.PagerResponder[armsql.VulnerabilityAssessmentScanResultClientListByScanResponse])
}

// NewVulnerabilityAssessmentScanResultServerTransport creates a new instance of VulnerabilityAssessmentScanResultServerTransport with the provided implementation.
// The returned VulnerabilityAssessmentScanResultServerTransport instance is connected to an instance of armsql.VulnerabilityAssessmentScanResultClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVulnerabilityAssessmentScanResultServerTransport(srv *VulnerabilityAssessmentScanResultServer) *VulnerabilityAssessmentScanResultServerTransport {
	return &VulnerabilityAssessmentScanResultServerTransport{
		srv:                srv,
		newListByScanPager: newTracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentScanResultClientListByScanResponse]](),
	}
}

// VulnerabilityAssessmentScanResultServerTransport connects instances of armsql.VulnerabilityAssessmentScanResultClient to instances of VulnerabilityAssessmentScanResultServer.
// Don't use this type directly, use NewVulnerabilityAssessmentScanResultServerTransport instead.
type VulnerabilityAssessmentScanResultServerTransport struct {
	srv                *VulnerabilityAssessmentScanResultServer
	newListByScanPager *tracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentScanResultClientListByScanResponse]]
}

// Do implements the policy.Transporter interface for VulnerabilityAssessmentScanResultServerTransport.
func (v *VulnerabilityAssessmentScanResultServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VulnerabilityAssessmentScanResultClient.Get":
		resp, err = v.dispatchGet(req)
	case "VulnerabilityAssessmentScanResultClient.NewListByScanPager":
		resp, err = v.dispatchNewListByScanPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VulnerabilityAssessmentScanResultServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scanResults/(?P<scanResultId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.SQLVulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.SQLVulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	scanResultIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanResultId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, scanIDParam, scanResultIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VulnerabilityAssessmentScanResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VulnerabilityAssessmentScanResultServerTransport) dispatchNewListByScanPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByScanPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByScanPager not implemented")}
	}
	newListByScanPager := v.newListByScanPager.get(req)
	if newListByScanPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scanResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.SQLVulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.SQLVulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListByScanPager(resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
		newListByScanPager = &resp
		v.newListByScanPager.add(req, newListByScanPager)
		server.PagerResponderInjectNextLinks(newListByScanPager, req, func(page *armsql.VulnerabilityAssessmentScanResultClientListByScanResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByScanPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByScanPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByScanPager) {
		v.newListByScanPager.remove(req)
	}
	return resp, nil
}
