//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ListJobExecutionsByAgentWithFilter.json
func ExampleJobExecutionsClient_NewListByAgentPager_listAllJobExecutionsInAJobAgentWithFiltering() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewJobExecutionsClient().NewListByAgentPager("group1", "server1", "agent1", &armsql.JobExecutionsClientListByAgentOptions{CreateTimeMin: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:00:00.000Z"); return t }()),
		CreateTimeMax: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:05:00.000Z"); return t }()),
		EndTimeMin:    to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:20:00.000Z"); return t }()),
		EndTimeMax:    to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:25:00.000Z"); return t }()),
		IsActive:      to.Ptr(false),
		Skip:          nil,
		Top:           nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.JobExecutionListResult = armsql.JobExecutionListResult{
		// 	Value: []*armsql.JobExecution{
		// 		{
		// 			Name: to.Ptr("5555-6666-7777-8888-999999999999"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/jobAgents/jobs/executions"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job1/executions/5555-6666-7777-8888-999999999999"),
		// 			Properties: &armsql.JobExecutionProperties{
		// 				CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:02:00.870Z"); return t}()),
		// 				CurrentAttemptStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:12:00.870Z"); return t}()),
		// 				CurrentAttempts: to.Ptr[int32](0),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:22:00.870Z"); return t}()),
		// 				JobExecutionID: to.Ptr("5A86BF65-43AC-F258-2524-9E92992F97CA"),
		// 				JobVersion: to.Ptr[int32](1),
		// 				LastMessage: to.Ptr("Job execution created."),
		// 				Lifecycle: to.Ptr(armsql.JobExecutionLifecycleCreated),
		// 				ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:12:00.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/jobAgents/jobs/executions"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job2/executions/aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 			Properties: &armsql.JobExecutionProperties{
		// 				CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:02:00.870Z"); return t}()),
		// 				CurrentAttempts: to.Ptr[int32](1),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:22:00.870Z"); return t}()),
		// 				JobExecutionID: to.Ptr("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 				JobVersion: to.Ptr[int32](1),
		// 				LastMessage: to.Ptr("Job execution succeeded."),
		// 				Lifecycle: to.Ptr(armsql.JobExecutionLifecycleSucceeded),
		// 				ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:12:00.870Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ListJobExecutionsByAgent.json
func ExampleJobExecutionsClient_NewListByAgentPager_listAllJobExecutionsInAJobAgent() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewJobExecutionsClient().NewListByAgentPager("group1", "server1", "agent1", &armsql.JobExecutionsClientListByAgentOptions{CreateTimeMin: nil,
		CreateTimeMax: nil,
		EndTimeMin:    nil,
		EndTimeMax:    nil,
		IsActive:      nil,
		Skip:          nil,
		Top:           nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.JobExecutionListResult = armsql.JobExecutionListResult{
		// 	Value: []*armsql.JobExecution{
		// 		{
		// 			Name: to.Ptr("5555-6666-7777-8888-999999999999"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/jobAgents/jobs/executions"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job1/executions/5555-6666-7777-8888-999999999999"),
		// 			Properties: &armsql.JobExecutionProperties{
		// 				CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:02:00.870Z"); return t}()),
		// 				CurrentAttemptStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:12:00.870Z"); return t}()),
		// 				CurrentAttempts: to.Ptr[int32](0),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:22:00.870Z"); return t}()),
		// 				JobExecutionID: to.Ptr("5A86BF65-43AC-F258-2524-9E92992F97CA"),
		// 				JobVersion: to.Ptr[int32](1),
		// 				LastMessage: to.Ptr("Job execution created."),
		// 				Lifecycle: to.Ptr(armsql.JobExecutionLifecycleCreated),
		// 				ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:12:00.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/jobAgents/jobs/executions"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job2/executions/aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 			Properties: &armsql.JobExecutionProperties{
		// 				CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:02:00.870Z"); return t}()),
		// 				CurrentAttempts: to.Ptr[int32](1),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:22:00.870Z"); return t}()),
		// 				JobExecutionID: to.Ptr("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 				JobVersion: to.Ptr[int32](1),
		// 				LastMessage: to.Ptr("Job execution succeeded."),
		// 				Lifecycle: to.Ptr(armsql.JobExecutionLifecycleSucceeded),
		// 				ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:12:00.870Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CancelJobExecution.json
func ExampleJobExecutionsClient_Cancel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewJobExecutionsClient().Cancel(ctx, "group1", "server1", "agent1", "job1", "5A86BF65-43AC-F258-2524-9E92992F97CA", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateJobExecution.json
func ExampleJobExecutionsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewJobExecutionsClient().BeginCreate(ctx, "group1", "server1", "agent1", "job1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobExecution = armsql.JobExecution{
	// 	Name: to.Ptr("5555-6666-7777-8888-999999999999"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/jobAgents/executions"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job1/executions/5555-6666-7777-8888-999999999999"),
	// 	Properties: &armsql.JobExecutionProperties{
	// 		CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-09-23T01:00:00.000Z"); return t}()),
	// 		CurrentAttempts: to.Ptr[int32](0),
	// 		JobExecutionID: to.Ptr("5A86BF65-43AC-F258-2524-9E92992F97CA"),
	// 		JobVersion: to.Ptr[int32](1),
	// 		LastMessage: to.Ptr("Job execution created."),
	// 		Lifecycle: to.Ptr(armsql.JobExecutionLifecycleCreated),
	// 		ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ListJobExecutionsByJob.json
func ExampleJobExecutionsClient_NewListByJobPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewJobExecutionsClient().NewListByJobPager("group1", "server1", "agent1", "job1", &armsql.JobExecutionsClientListByJobOptions{CreateTimeMin: nil,
		CreateTimeMax: nil,
		EndTimeMin:    nil,
		EndTimeMax:    nil,
		IsActive:      nil,
		Skip:          nil,
		Top:           nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.JobExecutionListResult = armsql.JobExecutionListResult{
		// 	Value: []*armsql.JobExecution{
		// 		{
		// 			Name: to.Ptr("5555-6666-7777-8888-999999999999"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/jobAgents/jobs/executions"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job1/executions/5555-6666-7777-8888-999999999999"),
		// 			Properties: &armsql.JobExecutionProperties{
		// 				CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:02:00.870Z"); return t}()),
		// 				CurrentAttemptStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:12:00.870Z"); return t}()),
		// 				CurrentAttempts: to.Ptr[int32](0),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:22:00.870Z"); return t}()),
		// 				JobExecutionID: to.Ptr("5A86BF65-43AC-F258-2524-9E92992F97CA"),
		// 				JobVersion: to.Ptr[int32](1),
		// 				LastMessage: to.Ptr("Job execution created."),
		// 				Lifecycle: to.Ptr(armsql.JobExecutionLifecycleCreated),
		// 				ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-21T19:12:00.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/jobAgents/jobs/executions"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job1/executions/aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 			Properties: &armsql.JobExecutionProperties{
		// 				CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:02:00.870Z"); return t}()),
		// 				CurrentAttempts: to.Ptr[int32](1),
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:22:00.870Z"); return t}()),
		// 				JobExecutionID: to.Ptr("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
		// 				JobVersion: to.Ptr[int32](1),
		// 				LastMessage: to.Ptr("Job execution succeeded."),
		// 				Lifecycle: to.Ptr(armsql.JobExecutionLifecycleSucceeded),
		// 				ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-15T19:12:00.870Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/GetJobExecution.json
func ExampleJobExecutionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobExecutionsClient().Get(ctx, "group1", "server1", "agent1", "job1", "5A86BF65-43AC-F258-2524-9E92992F97CA", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobExecution = armsql.JobExecution{
	// 	Name: to.Ptr("5555-6666-7777-8888-999999999999"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/jobAgents/executions"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job1/executions/5555-6666-7777-8888-999999999999"),
	// 	Properties: &armsql.JobExecutionProperties{
	// 		CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-21T19:02:00.870Z"); return t}()),
	// 		CurrentAttemptStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-13T19:12:00.870Z"); return t}()),
	// 		CurrentAttempts: to.Ptr[int32](0),
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-21T19:22:00.870Z"); return t}()),
	// 		JobExecutionID: to.Ptr("5A86BF65-43AC-F258-2524-9E92992F97CA"),
	// 		JobVersion: to.Ptr[int32](1),
	// 		LastMessage: to.Ptr("Job execution created."),
	// 		Lifecycle: to.Ptr(armsql.JobExecutionLifecycleCreated),
	// 		ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-21T19:12:00.870Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/CreateOrUpdateJobExecution.json
func ExampleJobExecutionsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewJobExecutionsClient().BeginCreateOrUpdate(ctx, "group1", "server1", "agent1", "job1", "5A86BF65-43AC-F258-2524-9E92992F97CA", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobExecution = armsql.JobExecution{
	// 	Name: to.Ptr("5555-6666-7777-8888-999999999999"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/jobAgents/executions"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/jobs/job1/executions/5555-6666-7777-8888-999999999999"),
	// 	Properties: &armsql.JobExecutionProperties{
	// 		CreateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-18T19:02:00.870Z"); return t}()),
	// 		CurrentAttempts: to.Ptr[int32](0),
	// 		JobExecutionID: to.Ptr("5A86BF65-43AC-F258-2524-9E92992F97CA"),
	// 		JobVersion: to.Ptr[int32](1),
	// 		LastMessage: to.Ptr("Job execution created."),
	// 		Lifecycle: to.Ptr(armsql.JobExecutionLifecycleCreated),
	// 		ProvisioningState: to.Ptr(armsql.ProvisioningStateSucceeded),
	// 	},
	// }
}
