//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient contains the methods for the ManagedDatabaseVulnerabilityAssessmentRuleBaselines group.
// Don't use this type directly, use NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient() instead.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient creates a new instance of ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - managedInstanceName - The name of the managed instance.
//   - databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
//     and master for server level rule).
//   - parameters - The requested rule baseline resource.
//   - options - ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters
//     for the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate method.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, parameters, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) createOrUpdateHandleResponse(resp *http.Response) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse, error) {
	result := ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentRuleBaseline); err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Removes the database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - managedInstanceName - The name of the managed instance.
//   - databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
//     and master for server level rule).
//   - options - ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the
//     ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete method.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse, error) {
	var err error
	const operationName = "ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, err
	}
	return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - managedInstanceName - The name of the managed instance.
//   - databaseName - The name of the database for which the vulnerability assessment rule baseline is defined.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - baselineName - The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule
//     and master for server level rule).
//   - options - ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the
//     ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Get method.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	var err error
	const operationName = "ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleID, baselineName, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) getCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, options *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) getHandleResponse(resp *http.Response) (ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse, error) {
	result := ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentRuleBaseline); err != nil {
		return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse{}, err
	}
	return result, nil
}
