//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ProblemClassificationsClient contains the methods for the ProblemClassifications group.
// Don't use this type directly, use NewProblemClassificationsClient() instead.
type ProblemClassificationsClient struct {
	internal *arm.Client
}

// NewProblemClassificationsClient creates a new instance of ProblemClassificationsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewProblemClassificationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ProblemClassificationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ProblemClassificationsClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get problem classification details for a specific Azure service.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01
//   - serviceName - Name of the Azure service available for support.
//   - problemClassificationName - Name of problem classification.
//   - options - ProblemClassificationsClientGetOptions contains the optional parameters for the ProblemClassificationsClient.Get
//     method.
func (client *ProblemClassificationsClient) Get(ctx context.Context, serviceName string, problemClassificationName string, options *ProblemClassificationsClientGetOptions) (ProblemClassificationsClientGetResponse, error) {
	var err error
	const operationName = "ProblemClassificationsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, serviceName, problemClassificationName, options)
	if err != nil {
		return ProblemClassificationsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ProblemClassificationsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ProblemClassificationsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ProblemClassificationsClient) getCreateRequest(ctx context.Context, serviceName string, problemClassificationName string, options *ProblemClassificationsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/services/{serviceName}/problemClassifications/{problemClassificationName}"
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	if problemClassificationName == "" {
		return nil, errors.New("parameter problemClassificationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{problemClassificationName}", url.PathEscape(problemClassificationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ProblemClassificationsClient) getHandleResponse(resp *http.Response) (ProblemClassificationsClientGetResponse, error) {
	result := ProblemClassificationsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProblemClassification); err != nil {
		return ProblemClassificationsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists all the problem classifications (categories) available for a specific Azure service. Always use the
// service and problem classifications obtained programmatically. This practice ensures that you
// always have the most recent set of service and problem classification Ids.
//
// Generated from API version 2024-04-01
//   - serviceName - Name of the Azure service for which the problem classifications need to be retrieved.
//   - options - ProblemClassificationsClientListOptions contains the optional parameters for the ProblemClassificationsClient.NewListPager
//     method.
func (client *ProblemClassificationsClient) NewListPager(serviceName string, options *ProblemClassificationsClientListOptions) *runtime.Pager[ProblemClassificationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProblemClassificationsClientListResponse]{
		More: func(page ProblemClassificationsClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ProblemClassificationsClientListResponse) (ProblemClassificationsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProblemClassificationsClient.NewListPager")
			req, err := client.listCreateRequest(ctx, serviceName, options)
			if err != nil {
				return ProblemClassificationsClientListResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ProblemClassificationsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ProblemClassificationsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ProblemClassificationsClient) listCreateRequest(ctx context.Context, serviceName string, options *ProblemClassificationsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/services/{serviceName}/problemClassifications"
	if serviceName == "" {
		return nil, errors.New("parameter serviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serviceName}", url.PathEscape(serviceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ProblemClassificationsClient) listHandleResponse(resp *http.Response) (ProblemClassificationsClientListResponse, error) {
	result := ProblemClassificationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProblemClassificationsListResult); err != nil {
		return ProblemClassificationsClientListResponse{}, err
	}
	return result, nil
}
