//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AnalysisResultsClient contains the methods for the AnalysisResults group.
// Don't use this type directly, use NewAnalysisResultsClient() instead.
type AnalysisResultsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAnalysisResultsClient creates a new instance of AnalysisResultsClient with the specified values.
//   - subscriptionID - The Azure subscription ID. This is a GUID-formatted string.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAnalysisResultsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AnalysisResultsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AnalysisResultsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets an Analysis Result of a Test Result by name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-12-16-preview
//   - resourceGroupName - The name of the resource group that contains the resource.
//   - testBaseAccountName - The resource name of the Test Base Account.
//   - packageName - The resource name of the Test Base Package.
//   - testResultName - The Test Result Name. It equals to {osName}-{TestResultId} string.
//   - analysisResultName - The name of the Analysis Result of a Test Result.
//   - options - AnalysisResultsClientGetOptions contains the optional parameters for the AnalysisResultsClient.Get method.
func (client *AnalysisResultsClient) Get(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, analysisResultName AnalysisResultName, options *AnalysisResultsClientGetOptions) (AnalysisResultsClientGetResponse, error) {
	var err error
	const operationName = "AnalysisResultsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, testResultName, analysisResultName, options)
	if err != nil {
		return AnalysisResultsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AnalysisResultsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AnalysisResultsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AnalysisResultsClient) getCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, analysisResultName AnalysisResultName, options *AnalysisResultsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/analysisResults/{analysisResultName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if testResultName == "" {
		return nil, errors.New("parameter testResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testResultName}", url.PathEscape(testResultName))
	if analysisResultName == "" {
		return nil, errors.New("parameter analysisResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{analysisResultName}", url.PathEscape(string(analysisResultName)))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AnalysisResultsClient) getHandleResponse(resp *http.Response) (AnalysisResultsClientGetResponse, error) {
	result := AnalysisResultsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AnalysisResultSingletonResource); err != nil {
		return AnalysisResultsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists the Analysis Results of a Test Result. The result collection will only contain one element as all
// the data will be nested in a singleton object.
//
// Generated from API version 2020-12-16-preview
//   - resourceGroupName - The name of the resource group that contains the resource.
//   - testBaseAccountName - The resource name of the Test Base Account.
//   - packageName - The resource name of the Test Base Package.
//   - testResultName - The Test Result Name. It equals to {osName}-{TestResultId} string.
//   - analysisResultType - The type of the Analysis Result of a Test Result.
//   - options - AnalysisResultsClientListOptions contains the optional parameters for the AnalysisResultsClient.NewListPager
//     method.
func (client *AnalysisResultsClient) NewListPager(resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, analysisResultType AnalysisResultType, options *AnalysisResultsClientListOptions) *runtime.Pager[AnalysisResultsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AnalysisResultsClientListResponse]{
		More: func(page AnalysisResultsClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *AnalysisResultsClientListResponse) (AnalysisResultsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AnalysisResultsClient.NewListPager")
			req, err := client.listCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, testResultName, analysisResultType, options)
			if err != nil {
				return AnalysisResultsClientListResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return AnalysisResultsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AnalysisResultsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *AnalysisResultsClient) listCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, analysisResultType AnalysisResultType, options *AnalysisResultsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/analysisResults"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if testResultName == "" {
		return nil, errors.New("parameter testResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testResultName}", url.PathEscape(testResultName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("analysisResultType", string(analysisResultType))
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AnalysisResultsClient) listHandleResponse(resp *http.Response) (AnalysisResultsClientListResponse, error) {
	result := AnalysisResultsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AnalysisResultListResult); err != nil {
		return AnalysisResultsClientListResponse{}, err
	}
	return result, nil
}
