//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/testbase/armtestbase"
	"net/http"
	"net/url"
	"regexp"
)

// TestResultsServer is a fake server for instances of the armtestbase.TestResultsClient type.
type TestResultsServer struct {
	// Get is the fake for method TestResultsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *armtestbase.TestResultsClientGetOptions) (resp azfake.Responder[armtestbase.TestResultsClientGetResponse], errResp azfake.ErrorResponder)

	// GetDownloadURL is the fake for method TestResultsClient.GetDownloadURL
	// HTTP status codes to indicate success: http.StatusOK
	GetDownloadURL func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *armtestbase.TestResultsClientGetDownloadURLOptions) (resp azfake.Responder[armtestbase.TestResultsClientGetDownloadURLResponse], errResp azfake.ErrorResponder)

	// GetVideoDownloadURL is the fake for method TestResultsClient.GetVideoDownloadURL
	// HTTP status codes to indicate success: http.StatusOK
	GetVideoDownloadURL func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *armtestbase.TestResultsClientGetVideoDownloadURLOptions) (resp azfake.Responder[armtestbase.TestResultsClientGetVideoDownloadURLResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method TestResultsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, testBaseAccountName string, packageName string, osUpdateType armtestbase.OsUpdateType, options *armtestbase.TestResultsClientListOptions) (resp azfake.PagerResponder[armtestbase.TestResultsClientListResponse])
}

// NewTestResultsServerTransport creates a new instance of TestResultsServerTransport with the provided implementation.
// The returned TestResultsServerTransport instance is connected to an instance of armtestbase.TestResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTestResultsServerTransport(srv *TestResultsServer) *TestResultsServerTransport {
	return &TestResultsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armtestbase.TestResultsClientListResponse]](),
	}
}

// TestResultsServerTransport connects instances of armtestbase.TestResultsClient to instances of TestResultsServer.
// Don't use this type directly, use NewTestResultsServerTransport instead.
type TestResultsServerTransport struct {
	srv          *TestResultsServer
	newListPager *tracker[azfake.PagerResponder[armtestbase.TestResultsClientListResponse]]
}

// Do implements the policy.Transporter interface for TestResultsServerTransport.
func (t *TestResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TestResultsClient.Get":
		resp, err = t.dispatchGet(req)
	case "TestResultsClient.GetDownloadURL":
		resp, err = t.dispatchGetDownloadURL(req)
	case "TestResultsClient.GetVideoDownloadURL":
		resp, err = t.dispatchGetVideoDownloadURL(req)
	case "TestResultsClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TestResultsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testResults/(?P<testResultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
	if err != nil {
		return nil, err
	}
	packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
	if err != nil {
		return nil, err
	}
	testResultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testResultName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, testResultNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TestResultResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestResultsServerTransport) dispatchGetDownloadURL(req *http.Request) (*http.Response, error) {
	if t.srv.GetDownloadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDownloadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testResults/(?P<testResultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getDownloadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
	if err != nil {
		return nil, err
	}
	packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
	if err != nil {
		return nil, err
	}
	testResultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testResultName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetDownloadURL(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, testResultNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DownloadURLResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestResultsServerTransport) dispatchGetVideoDownloadURL(req *http.Request) (*http.Response, error) {
	if t.srv.GetVideoDownloadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVideoDownloadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testResults/(?P<testResultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getVideoDownloadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
	if err != nil {
		return nil, err
	}
	packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
	if err != nil {
		return nil, err
	}
	testResultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testResultName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetVideoDownloadURL(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, testResultNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DownloadURLResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestResultsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
		if err != nil {
			return nil, err
		}
		osUpdateTypeParam, err := parseWithCast(qp.Get("osUpdateType"), func(v string) (armtestbase.OsUpdateType, error) {
			p, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armtestbase.OsUpdateType(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armtestbase.TestResultsClientListOptions
		if filterParam != nil {
			options = &armtestbase.TestResultsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := t.srv.NewListPager(resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, osUpdateTypeParam, options)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armtestbase.TestResultsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}
