//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armtrafficmanager_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/trafficmanager/armtrafficmanager"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/NameAvailabilityTest_NameAvailable-POST-example-21.json
func ExampleProfilesClient_CheckTrafficManagerRelativeDNSNameAvailability_nameAvailabilityTestNameAvailablePost21() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CheckTrafficManagerRelativeDNSNameAvailability(ctx, armtrafficmanager.CheckTrafficManagerRelativeDNSNameAvailabilityParameters{
		Name: to.Ptr("azsmnet5403"),
		Type: to.Ptr("microsoft.network/trafficmanagerprofiles"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailability = armtrafficmanager.NameAvailability{
	// 	Name: to.Ptr("azsmnet5403"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/NameAvailabilityTest_NameNotAvailable-POST-example-23.json
func ExampleProfilesClient_CheckTrafficManagerRelativeDNSNameAvailability_nameAvailabilityTestNameNotAvailablePost23() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CheckTrafficManagerRelativeDNSNameAvailability(ctx, armtrafficmanager.CheckTrafficManagerRelativeDNSNameAvailabilityParameters{
		Name: to.Ptr("azsmnet4696"),
		Type: to.Ptr("microsoft.network/trafficmanagerprofiles"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailability = armtrafficmanager.NameAvailability{
	// 	Name: to.Ptr("azsmnet4696"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	Message: to.Ptr("Domain name azsmnet4696.tmpreview.watmtest.azure-test.net already exists. Please choose a different DNS prefix."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("AlreadyExists"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/NameAvailabilityV2Test_NameAvailable-POST-example-21.json
func ExampleProfilesClient_CheckTrafficManagerNameAvailabilityV2_nameAvailabilityV2TestNameAvailablePost21() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CheckTrafficManagerNameAvailabilityV2(ctx, armtrafficmanager.CheckTrafficManagerRelativeDNSNameAvailabilityParameters{
		Name: to.Ptr("azsmnet5403"),
		Type: to.Ptr("microsoft.network/trafficmanagerprofiles"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailability = armtrafficmanager.NameAvailability{
	// 	Name: to.Ptr("azsmnet5403"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/NameAvailabilityV2Test_NameNotAvailable-POST-example-23.json
func ExampleProfilesClient_CheckTrafficManagerNameAvailabilityV2_nameAvailabilityV2TestNameNotAvailablePost23() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CheckTrafficManagerNameAvailabilityV2(ctx, armtrafficmanager.CheckTrafficManagerRelativeDNSNameAvailabilityParameters{
		Name: to.Ptr("azsmnet4696"),
		Type: to.Ptr("microsoft.network/trafficmanagerprofiles"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailability = armtrafficmanager.NameAvailability{
	// 	Name: to.Ptr("azsmnet4696"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	Message: to.Ptr("Domain name azsmnet4696.tmpreview.watmtest.azure-test.net already exists. Please choose a different DNS prefix."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("AlreadyExists"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-GET-ByResourceGroup.json
func ExampleProfilesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProfilesClient().NewListByResourceGroupPager("azuresdkfornetautoresttrafficmanager3640", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProfileListResult = armtrafficmanager.ProfileListResult{
		// 	Value: []*armtrafficmanager.Profile{
		// 		{
		// 			Name: to.Ptr("azuresdkfornetautoresttrafficmanager1005"),
		// 			Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager3640/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager1005"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtrafficmanager.ProfileProperties{
		// 				DNSConfig: &armtrafficmanager.DNSConfig{
		// 					Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager1005.tmpreview.watmtest.azure-test.net"),
		// 					RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager1005"),
		// 					TTL: to.Ptr[int64](35),
		// 				},
		// 				Endpoints: []*armtrafficmanager.Endpoint{
		// 					{
		// 						Name: to.Ptr("My external endpoint"),
		// 						Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
		// 						ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager3640/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager1005/externalEndpoints/My external endpoint"),
		// 						Properties: &armtrafficmanager.EndpointProperties{
		// 							EndpointLocation: to.Ptr("North Europe"),
		// 							EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
		// 							EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
		// 							Priority: to.Ptr[int64](1),
		// 							Target: to.Ptr("foobar.contoso.com"),
		// 							Weight: to.Ptr[int64](1),
		// 						},
		// 				}},
		// 				MonitorConfig: &armtrafficmanager.MonitorConfig{
		// 					Path: to.Ptr("/testpath.aspx"),
		// 					IntervalInSeconds: to.Ptr[int64](30),
		// 					Port: to.Ptr[int64](80),
		// 					ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusOnline),
		// 					TimeoutInSeconds: to.Ptr[int64](10),
		// 					ToleratedNumberOfFailures: to.Ptr[int64](3),
		// 					Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
		// 				},
		// 				ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
		// 				TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("azuresdkfornetautoresttrafficmanager959"),
		// 			Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager3640/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager959"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtrafficmanager.ProfileProperties{
		// 				DNSConfig: &armtrafficmanager.DNSConfig{
		// 					Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager959.tmpreview.watmtest.azure-test.net"),
		// 					RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager959"),
		// 					TTL: to.Ptr[int64](35),
		// 				},
		// 				Endpoints: []*armtrafficmanager.Endpoint{
		// 					{
		// 						Name: to.Ptr("My external endpoint"),
		// 						Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
		// 						ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager3640/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager959/externalEndpoints/My external endpoint"),
		// 						Properties: &armtrafficmanager.EndpointProperties{
		// 							EndpointLocation: to.Ptr("North Europe"),
		// 							EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusOnline),
		// 							EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
		// 							Priority: to.Ptr[int64](1),
		// 							Target: to.Ptr("foobar.contoso.com"),
		// 							Weight: to.Ptr[int64](1),
		// 						},
		// 				}},
		// 				MonitorConfig: &armtrafficmanager.MonitorConfig{
		// 					Path: to.Ptr("/testpath.aspx"),
		// 					IntervalInSeconds: to.Ptr[int64](30),
		// 					Port: to.Ptr[int64](80),
		// 					ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusOnline),
		// 					TimeoutInSeconds: to.Ptr[int64](10),
		// 					ToleratedNumberOfFailures: to.Ptr[int64](3),
		// 					Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
		// 				},
		// 				ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
		// 				TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-GET-BySubscription.json
func ExampleProfilesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProfilesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProfileListResult = armtrafficmanager.ProfileListResult{
		// 	Value: []*armtrafficmanager.Profile{
		// 		{
		// 			Name: to.Ptr("azsmnet5183"),
		// 			Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azsmnet1719/providers/Microsoft.Network/trafficManagerProfiles/azsmnet5183"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtrafficmanager.ProfileProperties{
		// 				DNSConfig: &armtrafficmanager.DNSConfig{
		// 					Fqdn: to.Ptr("azsmnet4696.tmpreview.watmtest.azure-test.net"),
		// 					RelativeName: to.Ptr("azsmnet4696"),
		// 					TTL: to.Ptr[int64](35),
		// 				},
		// 				Endpoints: []*armtrafficmanager.Endpoint{
		// 				},
		// 				MonitorConfig: &armtrafficmanager.MonitorConfig{
		// 					Path: to.Ptr("/testpath.aspx"),
		// 					IntervalInSeconds: to.Ptr[int64](30),
		// 					Port: to.Ptr[int64](80),
		// 					ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusOnline),
		// 					TimeoutInSeconds: to.Ptr[int64](10),
		// 					ToleratedNumberOfFailures: to.Ptr[int64](3),
		// 					Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
		// 				},
		// 				ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
		// 				TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("azuresdkfornetautoresttrafficmanager3440"),
		// 			Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager5168/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3440"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtrafficmanager.ProfileProperties{
		// 				DNSConfig: &armtrafficmanager.DNSConfig{
		// 					Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager3440.tmpreview.watmtest.azure-test.net"),
		// 					RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager3440"),
		// 					TTL: to.Ptr[int64](35),
		// 				},
		// 				Endpoints: []*armtrafficmanager.Endpoint{
		// 					{
		// 						Name: to.Ptr("My external endpoint"),
		// 						Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
		// 						ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager5168/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3440/externalEndpoints/My external endpoint"),
		// 						Properties: &armtrafficmanager.EndpointProperties{
		// 							EndpointLocation: to.Ptr("North Europe"),
		// 							EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusOnline),
		// 							EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
		// 							Priority: to.Ptr[int64](1),
		// 							Target: to.Ptr("foobar.contoso.com"),
		// 							Weight: to.Ptr[int64](1),
		// 						},
		// 				}},
		// 				MonitorConfig: &armtrafficmanager.MonitorConfig{
		// 					Path: to.Ptr("/testpath.aspx"),
		// 					IntervalInSeconds: to.Ptr[int64](30),
		// 					Port: to.Ptr[int64](80),
		// 					ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusOnline),
		// 					TimeoutInSeconds: to.Ptr[int64](10),
		// 					ToleratedNumberOfFailures: to.Ptr[int64](3),
		// 					Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
		// 				},
		// 				ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
		// 				TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("onesdk8819"),
		// 			Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/onesdk9785/providers/Microsoft.Network/trafficManagerProfiles/onesdk8819"),
		// 			Location: to.Ptr("global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtrafficmanager.ProfileProperties{
		// 				DNSConfig: &armtrafficmanager.DNSConfig{
		// 					Fqdn: to.Ptr("onesdk7242.tmpreview.watmtest.azure-test.net"),
		// 					RelativeName: to.Ptr("onesdk7242"),
		// 					TTL: to.Ptr[int64](51),
		// 				},
		// 				Endpoints: []*armtrafficmanager.Endpoint{
		// 					{
		// 						Name: to.Ptr("MyNestedEndpoint"),
		// 						Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
		// 						ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/onesdk9785/providers/Microsoft.Network/trafficManagerProfiles/onesdk8819/nestedEndpoints/MyNestedEndpoint"),
		// 						Properties: &armtrafficmanager.EndpointProperties{
		// 							EndpointLocation: to.Ptr("West Europe"),
		// 							EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusStopped),
		// 							EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
		// 							MinChildEndpoints: to.Ptr[int64](1),
		// 							Priority: to.Ptr[int64](1),
		// 							Target: to.Ptr("onesdk4285.tmpreview.watmtest.azure-test.net"),
		// 							TargetResourceID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/onesdk9785/providers/Microsoft.Network/trafficManagerProfiles/onesdk1792"),
		// 							Weight: to.Ptr[int64](1),
		// 						},
		// 				}},
		// 				MonitorConfig: &armtrafficmanager.MonitorConfig{
		// 					Path: to.Ptr("/testparent.asp"),
		// 					IntervalInSeconds: to.Ptr[int64](30),
		// 					Port: to.Ptr[int64](111),
		// 					ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusOnline),
		// 					TimeoutInSeconds: to.Ptr[int64](10),
		// 					ToleratedNumberOfFailures: to.Ptr[int64](3),
		// 					Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTPS),
		// 				},
		// 				ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
		// 				TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-GET-WithEndpoints.json
func ExampleProfilesClient_Get_profileGetWithEndpoints() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Get(ctx, "azuresdkfornetautoresttrafficmanager1323", "azuresdkfornetautoresttrafficmanager3880", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azuresdkfornetautoresttrafficmanager3880"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1323/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3880"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager3880.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager3880"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 			{
	// 				Name: to.Ptr("My external endpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1323/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3880/externalEndpoints/My external endpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					EndpointLocation: to.Ptr("North Europe"),
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("foobar.contoso.com"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 		}},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			IntervalInSeconds: to.Ptr[int64](30),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 			TimeoutInSeconds: to.Ptr[int64](10),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](3),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-GET-WithTrafficViewDisabled.json
func ExampleProfilesClient_Get_profileGetWithTrafficViewDisabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Get(ctx, "azuresdkfornetautoresttrafficmanager1323", "azuresdkfornetautoresttrafficmanager3880", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azuresdkfornetautoresttrafficmanager3880"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1323/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3880"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager3880.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager3880"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 			{
	// 				Name: to.Ptr("My external endpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1323/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3880/externalEndpoints/My external endpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					EndpointLocation: to.Ptr("North Europe"),
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("foobar.contoso.com"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 		}},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			IntervalInSeconds: to.Ptr[int64](30),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 			TimeoutInSeconds: to.Ptr[int64](10),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](3),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 		TrafficViewEnrollmentStatus: to.Ptr(armtrafficmanager.TrafficViewEnrollmentStatusDisabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-GET-WithTrafficViewEnabled.json
func ExampleProfilesClient_Get_profileGetWithTrafficViewEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Get(ctx, "azuresdkfornetautoresttrafficmanager1323", "azuresdkfornetautoresttrafficmanager3880", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azuresdkfornetautoresttrafficmanager3880"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1323/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3880"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager3880.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager3880"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 			{
	// 				Name: to.Ptr("My external endpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1323/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager3880/externalEndpoints/My external endpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					EndpointLocation: to.Ptr("North Europe"),
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("foobar.contoso.com"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 		}},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			IntervalInSeconds: to.Ptr[int64](30),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 			TimeoutInSeconds: to.Ptr[int64](10),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](3),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 		TrafficViewEnrollmentStatus: to.Ptr(armtrafficmanager.TrafficViewEnrollmentStatusEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-PUT-MultiValue.json
func ExampleProfilesClient_CreateOrUpdate_profilePutMultiValue() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CreateOrUpdate(ctx, "azuresdkfornetautoresttrafficmanager1421", "azsmnet6386", armtrafficmanager.Profile{
		Location: to.Ptr("global"),
		Properties: &armtrafficmanager.ProfileProperties{
			DNSConfig: &armtrafficmanager.DNSConfig{
				RelativeName: to.Ptr("azsmnet6386"),
				TTL:          to.Ptr[int64](35),
			},
			MaxReturn: to.Ptr[int64](2),
			MonitorConfig: &armtrafficmanager.MonitorConfig{
				Path:     to.Ptr("/testpath.aspx"),
				Port:     to.Ptr[int64](80),
				Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
			},
			ProfileStatus:               to.Ptr(armtrafficmanager.ProfileStatusEnabled),
			TrafficRoutingMethod:        to.Ptr(armtrafficmanager.TrafficRoutingMethodMultiValue),
			TrafficViewEnrollmentStatus: to.Ptr(armtrafficmanager.TrafficViewEnrollmentStatusDisabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azsmnet6386"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1421/providers/Microsoft.Network/trafficManagerProfiles/azsmnet6386"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azsmnet6386.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azsmnet6386"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 		},
	// 		MaxReturn: to.Ptr[int64](2),
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			IntervalInSeconds: to.Ptr[int64](30),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusInactive),
	// 			TimeoutInSeconds: to.Ptr[int64](10),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](3),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodMultiValue),
	// 		TrafficViewEnrollmentStatus: to.Ptr(armtrafficmanager.TrafficViewEnrollmentStatusDisabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-PUT-NoEndpoints.json
func ExampleProfilesClient_CreateOrUpdate_profilePutNoEndpoints() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CreateOrUpdate(ctx, "azuresdkfornetautoresttrafficmanager1421", "azsmnet6386", armtrafficmanager.Profile{
		Location: to.Ptr("global"),
		Properties: &armtrafficmanager.ProfileProperties{
			DNSConfig: &armtrafficmanager.DNSConfig{
				RelativeName: to.Ptr("azsmnet6386"),
				TTL:          to.Ptr[int64](35),
			},
			MonitorConfig: &armtrafficmanager.MonitorConfig{
				Path:     to.Ptr("/testpath.aspx"),
				Port:     to.Ptr[int64](80),
				Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
			},
			ProfileStatus:        to.Ptr(armtrafficmanager.ProfileStatusEnabled),
			TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azsmnet6386"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager1421/providers/Microsoft.Network/trafficManagerProfiles/azsmnet6386"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azsmnet6386.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azsmnet6386"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 		},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			IntervalInSeconds: to.Ptr[int64](30),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusInactive),
	// 			TimeoutInSeconds: to.Ptr[int64](10),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](3),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-PUT-WithAliasing.json
func ExampleProfilesClient_CreateOrUpdate_profilePutWithAliasing() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CreateOrUpdate(ctx, "azuresdkfornetautoresttrafficmanager2583", "azuresdkfornetautoresttrafficmanager6192", armtrafficmanager.Profile{
		Location: to.Ptr("global"),
		Properties: &armtrafficmanager.ProfileProperties{
			AllowedEndpointRecordTypes: []*armtrafficmanager.AllowedEndpointRecordType{
				to.Ptr(armtrafficmanager.AllowedEndpointRecordTypeDomainName)},
			DNSConfig: &armtrafficmanager.DNSConfig{
				RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
				TTL:          to.Ptr[int64](35),
			},
			Endpoints: []*armtrafficmanager.Endpoint{
				{
					Name: to.Ptr("My external endpoint"),
					Type: to.Ptr("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
					Properties: &armtrafficmanager.EndpointProperties{
						EndpointLocation: to.Ptr("North Europe"),
						EndpointStatus:   to.Ptr(armtrafficmanager.EndpointStatusEnabled),
						Target:           to.Ptr("foobar.contoso.com"),
					},
				}},
			MonitorConfig: &armtrafficmanager.MonitorConfig{
				Path:                      to.Ptr("/testpath.aspx"),
				IntervalInSeconds:         to.Ptr[int64](10),
				Port:                      to.Ptr[int64](80),
				TimeoutInSeconds:          to.Ptr[int64](5),
				ToleratedNumberOfFailures: to.Ptr[int64](2),
				Protocol:                  to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
			},
			ProfileStatus:        to.Ptr(armtrafficmanager.ProfileStatusEnabled),
			TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		AllowedEndpointRecordTypes: []*armtrafficmanager.AllowedEndpointRecordType{
	// 			to.Ptr(armtrafficmanager.AllowedEndpointRecordTypeDomainName)},
	// 			DNSConfig: &armtrafficmanager.DNSConfig{
	// 				Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager6192.tmpreview.watmtest.azure-test.net"),
	// 				RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 				TTL: to.Ptr[int64](35),
	// 			},
	// 			Endpoints: []*armtrafficmanager.Endpoint{
	// 				{
	// 					Name: to.Ptr("My external endpoint"),
	// 					Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
	// 					ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192/externalEndpoints/My external endpoint"),
	// 					Properties: &armtrafficmanager.EndpointProperties{
	// 						CustomHeaders: []*armtrafficmanager.EndpointPropertiesCustomHeadersItem{
	// 							{
	// 								Name: to.Ptr("header-2"),
	// 								Value: to.Ptr("value-2-overridden"),
	// 						}},
	// 						EndpointLocation: to.Ptr("North Europe"),
	// 						EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 						EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 						Priority: to.Ptr[int64](1),
	// 						Target: to.Ptr("foobar.contoso.com"),
	// 						Weight: to.Ptr[int64](1),
	// 					},
	// 			}},
	// 			MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 				Path: to.Ptr("/testpath.aspx"),
	// 				CustomHeaders: []*armtrafficmanager.MonitorConfigCustomHeadersItem{
	// 					{
	// 						Name: to.Ptr("header-1"),
	// 						Value: to.Ptr("value-1"),
	// 					},
	// 					{
	// 						Name: to.Ptr("header-2"),
	// 						Value: to.Ptr("value-2"),
	// 				}},
	// 				IntervalInSeconds: to.Ptr[int64](10),
	// 				Port: to.Ptr[int64](80),
	// 				ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 				TimeoutInSeconds: to.Ptr[int64](5),
	// 				ToleratedNumberOfFailures: to.Ptr[int64](2),
	// 				Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 			},
	// 			ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 			TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-PUT-WithCustomHeaders.json
func ExampleProfilesClient_CreateOrUpdate_profilePutWithCustomHeaders() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CreateOrUpdate(ctx, "azuresdkfornetautoresttrafficmanager2583", "azuresdkfornetautoresttrafficmanager6192", armtrafficmanager.Profile{
		Location: to.Ptr("global"),
		Properties: &armtrafficmanager.ProfileProperties{
			DNSConfig: &armtrafficmanager.DNSConfig{
				RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
				TTL:          to.Ptr[int64](35),
			},
			Endpoints: []*armtrafficmanager.Endpoint{
				{
					Name: to.Ptr("My external endpoint"),
					Type: to.Ptr("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
					Properties: &armtrafficmanager.EndpointProperties{
						CustomHeaders: []*armtrafficmanager.EndpointPropertiesCustomHeadersItem{
							{
								Name:  to.Ptr("header-2"),
								Value: to.Ptr("value-2-overridden"),
							}},
						EndpointLocation: to.Ptr("North Europe"),
						EndpointStatus:   to.Ptr(armtrafficmanager.EndpointStatusEnabled),
						Target:           to.Ptr("foobar.contoso.com"),
					},
				}},
			MonitorConfig: &armtrafficmanager.MonitorConfig{
				Path: to.Ptr("/testpath.aspx"),
				CustomHeaders: []*armtrafficmanager.MonitorConfigCustomHeadersItem{
					{
						Name:  to.Ptr("header-1"),
						Value: to.Ptr("value-1"),
					},
					{
						Name:  to.Ptr("header-2"),
						Value: to.Ptr("value-2"),
					}},
				ExpectedStatusCodeRanges: []*armtrafficmanager.MonitorConfigExpectedStatusCodeRangesItem{
					{
						Max: to.Ptr[int32](205),
						Min: to.Ptr[int32](200),
					},
					{
						Max: to.Ptr[int32](410),
						Min: to.Ptr[int32](400),
					}},
				IntervalInSeconds:         to.Ptr[int64](10),
				Port:                      to.Ptr[int64](80),
				TimeoutInSeconds:          to.Ptr[int64](5),
				ToleratedNumberOfFailures: to.Ptr[int64](2),
				Protocol:                  to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
			},
			ProfileStatus:               to.Ptr(armtrafficmanager.ProfileStatusEnabled),
			TrafficRoutingMethod:        to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
			TrafficViewEnrollmentStatus: to.Ptr(armtrafficmanager.TrafficViewEnrollmentStatusDisabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager6192.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 			{
	// 				Name: to.Ptr("My external endpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192/externalEndpoints/My external endpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					CustomHeaders: []*armtrafficmanager.EndpointPropertiesCustomHeadersItem{
	// 						{
	// 							Name: to.Ptr("header-2"),
	// 							Value: to.Ptr("value-2-overridden"),
	// 					}},
	// 					EndpointLocation: to.Ptr("North Europe"),
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("foobar.contoso.com"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 		}},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			CustomHeaders: []*armtrafficmanager.MonitorConfigCustomHeadersItem{
	// 				{
	// 					Name: to.Ptr("header-1"),
	// 					Value: to.Ptr("value-1"),
	// 				},
	// 				{
	// 					Name: to.Ptr("header-2"),
	// 					Value: to.Ptr("value-2"),
	// 			}},
	// 			IntervalInSeconds: to.Ptr[int64](10),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 			TimeoutInSeconds: to.Ptr[int64](5),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](2),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 		TrafficViewEnrollmentStatus: to.Ptr(armtrafficmanager.TrafficViewEnrollmentStatusDisabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-PUT-WithEndpoints.json
func ExampleProfilesClient_CreateOrUpdate_profilePutWithEndpoints() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CreateOrUpdate(ctx, "azuresdkfornetautoresttrafficmanager2583", "azuresdkfornetautoresttrafficmanager6192", armtrafficmanager.Profile{
		Location: to.Ptr("global"),
		Properties: &armtrafficmanager.ProfileProperties{
			DNSConfig: &armtrafficmanager.DNSConfig{
				RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
				TTL:          to.Ptr[int64](35),
			},
			Endpoints: []*armtrafficmanager.Endpoint{
				{
					Name: to.Ptr("My external endpoint"),
					Type: to.Ptr("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
					Properties: &armtrafficmanager.EndpointProperties{
						EndpointLocation: to.Ptr("North Europe"),
						EndpointStatus:   to.Ptr(armtrafficmanager.EndpointStatusEnabled),
						Target:           to.Ptr("foobar.contoso.com"),
					},
				}},
			MonitorConfig: &armtrafficmanager.MonitorConfig{
				Path:                      to.Ptr("/testpath.aspx"),
				IntervalInSeconds:         to.Ptr[int64](10),
				Port:                      to.Ptr[int64](80),
				TimeoutInSeconds:          to.Ptr[int64](5),
				ToleratedNumberOfFailures: to.Ptr[int64](2),
				Protocol:                  to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
			},
			ProfileStatus:        to.Ptr(armtrafficmanager.ProfileStatusEnabled),
			TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager6192.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 			{
	// 				Name: to.Ptr("My external endpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192/externalEndpoints/My external endpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					EndpointLocation: to.Ptr("North Europe"),
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("foobar.contoso.com"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 		}},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			IntervalInSeconds: to.Ptr[int64](10),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 			TimeoutInSeconds: to.Ptr[int64](5),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](2),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-PUT-WithNestedEndpoints.json
func ExampleProfilesClient_CreateOrUpdate_profilePutWithNestedEndpoints() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().CreateOrUpdate(ctx, "myresourcegroup", "parentprofile", armtrafficmanager.Profile{
		Location: to.Ptr("global"),
		Properties: &armtrafficmanager.ProfileProperties{
			DNSConfig: &armtrafficmanager.DNSConfig{
				RelativeName: to.Ptr("parentprofile"),
				TTL:          to.Ptr[int64](35),
			},
			Endpoints: []*armtrafficmanager.Endpoint{
				{
					Name: to.Ptr("MyFirstNestedEndpoint"),
					Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
					Properties: &armtrafficmanager.EndpointProperties{
						EndpointStatus:        to.Ptr(armtrafficmanager.EndpointStatusEnabled),
						MinChildEndpoints:     to.Ptr[int64](2),
						MinChildEndpointsIPv4: to.Ptr[int64](1),
						MinChildEndpointsIPv6: to.Ptr[int64](2),
						Priority:              to.Ptr[int64](1),
						Target:                to.Ptr("firstnestedprofile.tmpreview.watmtest.azure-test.net"),
						Weight:                to.Ptr[int64](1),
					},
				},
				{
					Name: to.Ptr("MySecondNestedEndpoint"),
					Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
					Properties: &armtrafficmanager.EndpointProperties{
						EndpointStatus:        to.Ptr(armtrafficmanager.EndpointStatusEnabled),
						MinChildEndpoints:     to.Ptr[int64](2),
						MinChildEndpointsIPv4: to.Ptr[int64](2),
						MinChildEndpointsIPv6: to.Ptr[int64](1),
						Priority:              to.Ptr[int64](2),
						Target:                to.Ptr("secondnestedprofile.tmpreview.watmtest.azure-test.net"),
						Weight:                to.Ptr[int64](1),
					},
				}},
			MonitorConfig: &armtrafficmanager.MonitorConfig{
				Path:                      to.Ptr("/testpath.aspx"),
				IntervalInSeconds:         to.Ptr[int64](10),
				Port:                      to.Ptr[int64](80),
				TimeoutInSeconds:          to.Ptr[int64](5),
				ToleratedNumberOfFailures: to.Ptr[int64](2),
				Protocol:                  to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
			},
			ProfileStatus:        to.Ptr(armtrafficmanager.ProfileStatusEnabled),
			TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPriority),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("parentprofile"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myresourcegroup/providers/Microsoft.Network/trafficManagerProfiles/parentprofile"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("parentprofile.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("parentprofile"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 			{
	// 				Name: to.Ptr("MyFirstNestedEndpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myresourcegroup/providers/Microsoft.Network/trafficManagerProfiles/parentprofile/nestedEndpoints/MyFirstNestedEndpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					MinChildEndpoints: to.Ptr[int64](2),
	// 					MinChildEndpointsIPv4: to.Ptr[int64](1),
	// 					MinChildEndpointsIPv6: to.Ptr[int64](2),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("firstnestedprofile.tmpreview.watmtest.azure-test.net"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("MySecondNestedEndpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myresourcegroup/providers/Microsoft.Network/trafficManagerProfiles/parentprofile/nestedEndpoints/MySecondNestedEndpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					MinChildEndpoints: to.Ptr[int64](2),
	// 					MinChildEndpointsIPv4: to.Ptr[int64](2),
	// 					MinChildEndpointsIPv6: to.Ptr[int64](1),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("secondnestedprofile.tmpreview.watmtest.azure-test.net"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 		}},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			IntervalInSeconds: to.Ptr[int64](10),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 			TimeoutInSeconds: to.Ptr[int64](5),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](2),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPriority),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-DELETE.json
func ExampleProfilesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Delete(ctx, "azuresdkfornetautoresttrafficmanager1323", "azuresdkfornetautoresttrafficmanager3880", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeleteOperationResult = armtrafficmanager.DeleteOperationResult{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0d41e635294dce73dfa99b07f3da4b68a9c9e29c/specification/trafficmanager/resource-manager/Microsoft.Network/stable/2022-04-01/examples/Profile-PATCH-MonitorConfig.json
func ExampleProfilesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtrafficmanager.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Update(ctx, "azuresdkfornetautoresttrafficmanager2583", "azuresdkfornetautoresttrafficmanager6192", armtrafficmanager.Profile{
		Properties: &armtrafficmanager.ProfileProperties{
			MonitorConfig: &armtrafficmanager.MonitorConfig{
				Path: to.Ptr("/testpath.aspx"),
				CustomHeaders: []*armtrafficmanager.MonitorConfigCustomHeadersItem{
					{
						Name:  to.Ptr("header-1"),
						Value: to.Ptr("value-1"),
					},
					{
						Name:  to.Ptr("header-2"),
						Value: to.Ptr("value-2"),
					}},
				IntervalInSeconds:         to.Ptr[int64](30),
				Port:                      to.Ptr[int64](80),
				TimeoutInSeconds:          to.Ptr[int64](6),
				ToleratedNumberOfFailures: to.Ptr[int64](4),
				Protocol:                  to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armtrafficmanager.Profile{
	// 	Name: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 	Type: to.Ptr("Microsoft.Network/trafficManagerProfiles"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192"),
	// 	Location: to.Ptr("global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armtrafficmanager.ProfileProperties{
	// 		DNSConfig: &armtrafficmanager.DNSConfig{
	// 			Fqdn: to.Ptr("azuresdkfornetautoresttrafficmanager6192.tmpreview.watmtest.azure-test.net"),
	// 			RelativeName: to.Ptr("azuresdkfornetautoresttrafficmanager6192"),
	// 			TTL: to.Ptr[int64](35),
	// 		},
	// 		Endpoints: []*armtrafficmanager.Endpoint{
	// 			{
	// 				Name: to.Ptr("My external endpoint"),
	// 				Type: to.Ptr("Microsoft.Network/trafficManagerProfiles/externalEndpoints"),
	// 				ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/azuresdkfornetautoresttrafficmanager2583/providers/Microsoft.Network/trafficManagerProfiles/azuresdkfornetautoresttrafficmanager6192/externalEndpoints/My external endpoint"),
	// 				Properties: &armtrafficmanager.EndpointProperties{
	// 					EndpointLocation: to.Ptr("North Europe"),
	// 					EndpointMonitorStatus: to.Ptr(armtrafficmanager.EndpointMonitorStatusCheckingEndpoint),
	// 					EndpointStatus: to.Ptr(armtrafficmanager.EndpointStatusEnabled),
	// 					Priority: to.Ptr[int64](1),
	// 					Target: to.Ptr("foobar.contoso.com"),
	// 					Weight: to.Ptr[int64](1),
	// 				},
	// 		}},
	// 		MonitorConfig: &armtrafficmanager.MonitorConfig{
	// 			Path: to.Ptr("/testpath.aspx"),
	// 			CustomHeaders: []*armtrafficmanager.MonitorConfigCustomHeadersItem{
	// 				{
	// 					Name: to.Ptr("header-1"),
	// 					Value: to.Ptr("value-1"),
	// 				},
	// 				{
	// 					Name: to.Ptr("header-2"),
	// 					Value: to.Ptr("value-2"),
	// 			}},
	// 			IntervalInSeconds: to.Ptr[int64](30),
	// 			Port: to.Ptr[int64](80),
	// 			ProfileMonitorStatus: to.Ptr(armtrafficmanager.ProfileMonitorStatusCheckingEndpoints),
	// 			TimeoutInSeconds: to.Ptr[int64](6),
	// 			ToleratedNumberOfFailures: to.Ptr[int64](4),
	// 			Protocol: to.Ptr(armtrafficmanager.MonitorProtocolHTTP),
	// 		},
	// 		ProfileStatus: to.Ptr(armtrafficmanager.ProfileStatusEnabled),
	// 		TrafficRoutingMethod: to.Ptr(armtrafficmanager.TrafficRoutingMethodPerformance),
	// 	},
	// }
}
