# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.7.7"
  license "MIT"

  on_macos do
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.7/actionlint_1.7.7_darwin_amd64.tar.gz"
      sha256 "28e5de5a05fc558474f638323d736d822fff183d2d492f0aecb2b73cc44584f5"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.7/actionlint_1.7.7_darwin_arm64.tar.gz"
      sha256 "2693315b9093aeacb4ebd91a993fea54fc215057bf0da2659056b4bc033873db"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.intel?
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.7/actionlint_1.7.7_linux_amd64.tar.gz"
        sha256 "023070a287cd8cccd71515fedc843f1985bf96c436b7effaecce67290e7e0757"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    if Hardware::CPU.arm?
      if !Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.7/actionlint_1.7.7_linux_armv6.tar.gz"
        sha256 "82e98d7252341b83fa557764824f225fa50431801b8e3d8e99f70dc1efc317b2"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    if Hardware::CPU.arm?
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.7/actionlint_1.7.7_linux_arm64.tar.gz"
        sha256 "401942f9c24ed71e4fe71b76c7d638f66d8633575c4016efd2977ce7c28317d0"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
  end

  deprecate! date: "2025-10-01", because: "migrated to cask. see caveats"

  def caveats
    <<~EOS
      This formula is no longer maintained after v1.7.7 in favor of `actionlint` cask package.
      This formula will be removed at v1.7.9 release. Please migrate to the cask:
        brew uninstall actionlint
        brew install --cask actionlint
    EOS
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
