// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The details of an alert manager definition. It is the configuration for the
// alert manager, including information about receivers for routing alerts.
type AlertManagerDefinitionDescription struct {

	// The date and time that the alert manager definition was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The actual alert manager definition.
	//
	// For details about the alert manager definition, see [AlertManagedDefinitionData].
	//
	// [AlertManagedDefinitionData]: https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html
	//
	// This member is required.
	Data []byte

	// The date and time that the alert manager definition was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// A structure that displays the current status of the alert manager definition..
	//
	// This member is required.
	Status *AlertManagerDefinitionStatus

	noSmithyDocumentSerde
}

// The status of the alert manager.
type AlertManagerDefinitionStatus struct {

	// The current status of the alert manager.
	//
	// This member is required.
	StatusCode AlertManagerDefinitionStatusCode

	// If there is a failure, the reason for the failure.
	StatusReason *string

	noSmithyDocumentSerde
}

// The AmpConfiguration structure defines the Amazon Managed Service for
// Prometheus instance a scraper should send metrics to.
type AmpConfiguration struct {

	// ARN of the Amazon Managed Service for Prometheus workspace.
	//
	// This member is required.
	WorkspaceArn *string

	noSmithyDocumentSerde
}

// Configuration details for logging to CloudWatch Logs.
type CloudWatchLogDestination struct {

	// The ARN of the CloudWatch log group to which the vended log data will be
	// published. This log group must exist prior to calling this operation.
	//
	// This member is required.
	LogGroupArn *string

	noSmithyDocumentSerde
}

// Where to send the metrics from a scraper.
//
// The following types satisfy this interface:
//
//	DestinationMemberAmpConfiguration
type Destination interface {
	isDestination()
}

// The Amazon Managed Service for Prometheus workspace to send metrics to.
type DestinationMemberAmpConfiguration struct {
	Value AmpConfiguration

	noSmithyDocumentSerde
}

func (*DestinationMemberAmpConfiguration) isDestination() {}

// The EksConfiguration structure describes the connection to the Amazon EKS
// cluster from which a scraper collects metrics.
type EksConfiguration struct {

	// ARN of the Amazon EKS cluster.
	//
	// This member is required.
	ClusterArn *string

	// A list of subnet IDs for the Amazon EKS cluster VPC configuration.
	//
	// This member is required.
	SubnetIds []string

	// A list of the security group IDs for the Amazon EKS cluster VPC configuration.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

// This structure defines one label set used to enforce active time series limits
// for the workspace, and defines the limit for that label set.
//
// A label set is a unique combination of label-value pairs. Use them to control
// time series limits and to monitor usage by specific label groups. Example label
// sets might be team:finance or env:prod
type LimitsPerLabelSet struct {

	// This defines one label set that will have an enforced active time series limit.
	//
	// Label values accept ASCII characters and must contain at least one character
	// that isn't whitespace. ASCII control characters are not accepted. If the label
	// name is metric name label __name__ , then the metric part of the name must
	// conform to the following pattern: [a-zA-Z_:][a-zA-Z0-9_:]*
	//
	// This member is required.
	LabelSet map[string]string

	// This structure contains the information about the limits that apply to time
	// series that match this label set.
	//
	// This member is required.
	Limits *LimitsPerLabelSetEntry

	noSmithyDocumentSerde
}

// This structure contains the information about the limits that apply to time
// series that match one label set.
type LimitsPerLabelSetEntry struct {

	// The maximum number of active series that can be ingested that match this label
	// set.
	//
	// Setting this to 0 causes no label set limit to be enforced, but it does cause
	// Amazon Managed Service for Prometheus to vend label set metrics to CloudWatch
	MaxSeries *int64

	noSmithyDocumentSerde
}

// Contains information about the current rules and alerting logging configuration
// for the workspace.
//
// These logging configurations are only for rules and alerting logs.
type LoggingConfigurationMetadata struct {

	// The date and time that the logging configuration was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ARN of the CloudWatch log group to which the vended log data will be
	// published.
	//
	// This member is required.
	LogGroupArn *string

	// The date and time that the logging configuration was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The current status of the logging configuration.
	//
	// This member is required.
	Status *LoggingConfigurationStatus

	// The ID of the workspace the logging configuration is for.
	//
	// This member is required.
	Workspace *string

	noSmithyDocumentSerde
}

// The status of the logging configuration.
type LoggingConfigurationStatus struct {

	// The current status of the current rules and alerting logging configuration.
	//
	// These logging configurations are only for rules and alerting logs.
	//
	// This member is required.
	StatusCode LoggingConfigurationStatusCode

	// If failed, the reason for the failure.
	StatusReason *string

	noSmithyDocumentSerde
}

// Defines a destination and its associated filtering criteria for query logging.
type LoggingDestination struct {

	// Configuration details for logging to CloudWatch Logs.
	//
	// This member is required.
	CloudWatchLogs *CloudWatchLogDestination

	// Filtering criteria that determine which queries are logged.
	//
	// This member is required.
	Filters *LoggingFilter

	noSmithyDocumentSerde
}

// Filtering criteria that determine which queries are logged.
type LoggingFilter struct {

	// The Query Samples Processed (QSP) threshold above which queries will be logged.
	// Queries processing more samples than this threshold will be captured in logs.
	//
	// This member is required.
	QspThreshold *int64

	noSmithyDocumentSerde
}

// The metadata for a query logging configuration.
type QueryLoggingConfigurationMetadata struct {

	// The date and time when the query logging configuration was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The configured destinations for the query logging configuration.
	//
	// This member is required.
	Destinations []LoggingDestination

	// The date and time when the query logging configuration was last modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The current status of the query logging configuration.
	//
	// This member is required.
	Status *QueryLoggingConfigurationStatus

	// The ID of the workspace associated with this query logging configuration.
	//
	// This member is required.
	Workspace *string

	noSmithyDocumentSerde
}

// The status information for a query logging configuration.
type QueryLoggingConfigurationStatus struct {

	// The current status of the query logging configuration.
	//
	// This member is required.
	StatusCode QueryLoggingConfigurationStatusCode

	// If there is a failure, the reason for the failure.
	StatusReason *string

	noSmithyDocumentSerde
}

// Use this structure to enable cross-account access, so that you can use a target
// account to access Prometheus metrics from source accounts.
type RoleConfiguration struct {

	// The Amazon Resource Name (ARN) of the role used in the source account to enable
	// cross-account scraping. For information about the contents of this policy, see [Cross-account setup].
	//
	// [Cross-account setup]: https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#cross-account-remote-write
	SourceRoleArn *string

	// The Amazon Resource Name (ARN) of the role used in the target account to enable
	// cross-account scraping. For information about the contents of this policy, see [Cross-account setup].
	//
	// [Cross-account setup]: https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#cross-account-remote-write
	TargetRoleArn *string

	noSmithyDocumentSerde
}

// The details about one rule groups namespace.
type RuleGroupsNamespaceDescription struct {

	// The ARN of the rule groups namespace. For example,
	// arn:aws:aps:<region>:123456789012:rulegroupsnamespace/ws-example1-1234-abcd-5678-ef90abcd1234/rulesfile1
	// .
	//
	// This member is required.
	Arn *string

	// The date and time that the rule groups namespace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The rule groups file used in the namespace.
	//
	// For details about the rule groups namespace structure, see [RuleGroupsNamespaceData].
	//
	// [RuleGroupsNamespaceData]: https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html
	//
	// This member is required.
	Data []byte

	// The date and time that the rule groups namespace was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name of the rule groups namespace.
	//
	// This member is required.
	Name *string

	// The current status of the rule groups namespace.
	//
	// This member is required.
	Status *RuleGroupsNamespaceStatus

	// The list of tag keys and values that are associated with the rule groups
	// namespace.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The status information about a rule groups namespace.
type RuleGroupsNamespaceStatus struct {

	// The current status of the namespace.
	//
	// This member is required.
	StatusCode RuleGroupsNamespaceStatusCode

	// The reason for the failure, if any.
	StatusReason *string

	noSmithyDocumentSerde
}

// The high-level information about a rule groups namespace. To retrieve more
// information, use DescribeRuleGroupsNamespace .
type RuleGroupsNamespaceSummary struct {

	// The ARN of the rule groups namespace.
	//
	// This member is required.
	Arn *string

	// The date and time that the rule groups namespace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time that the rule groups namespace was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name of the rule groups namespace.
	//
	// This member is required.
	Name *string

	// A structure that displays the current status of the rule groups namespace.
	//
	// This member is required.
	Status *RuleGroupsNamespaceStatus

	// The list of tag keys and values that are associated with the rule groups
	// namespace.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A scrape configuration for a scraper, base 64 encoded. For more information,
// see [Scraper configuration]in the Amazon Managed Service for Prometheus User Guide.
//
// The following types satisfy this interface:
//
//	ScrapeConfigurationMemberConfigurationBlob
//
// [Scraper configuration]: https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration
type ScrapeConfiguration interface {
	isScrapeConfiguration()
}

// The base 64 encoded scrape configuration file.
type ScrapeConfigurationMemberConfigurationBlob struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ScrapeConfigurationMemberConfigurationBlob) isScrapeConfiguration() {}

// The ScraperDescription structure contains the full details about one scraper in
// your account.
type ScraperDescription struct {

	// The Amazon Resource Name (ARN) of the scraper. For example,
	// arn:aws:aps:<region>:123456798012:scraper/s-example1-1234-abcd-5678-ef9012abcd34
	// .
	//
	// This member is required.
	Arn *string

	// The date and time that the scraper was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Managed Service for Prometheus workspace the scraper sends metrics
	// to.
	//
	// This member is required.
	Destination Destination

	// The date and time that the scraper was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions for
	// the scraper to discover and collect metrics on your behalf.
	//
	// For example,
	// arn:aws:iam::123456789012:role/service-role/AmazonGrafanaServiceRole-12example .
	//
	// This member is required.
	RoleArn *string

	// The configuration in use by the scraper.
	//
	// This member is required.
	ScrapeConfiguration ScrapeConfiguration

	// The ID of the scraper. For example, s-example1-1234-abcd-5678-ef9012abcd34 .
	//
	// This member is required.
	ScraperId *string

	// The Amazon EKS cluster from which the scraper collects metrics.
	//
	// This member is required.
	Source Source

	// A structure that contains the current status of the scraper.
	//
	// This member is required.
	Status *ScraperStatus

	// (Optional) A name associated with the scraper.
	Alias *string

	// This structure displays information about the IAM roles used for cross-account
	// scraping configuration.
	RoleConfiguration *RoleConfiguration

	// If there is a failure, the reason for the failure.
	StatusReason *string

	// (Optional) The list of tag keys and values associated with the scraper.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The ScraperStatus structure contains status information about the scraper.
type ScraperStatus struct {

	// The current status of the scraper.
	//
	// This member is required.
	StatusCode ScraperStatusCode

	noSmithyDocumentSerde
}

// The ScraperSummary structure contains a summary of the details about one
// scraper in your account.
type ScraperSummary struct {

	// The Amazon Resource Name (ARN) of the scraper.
	//
	// This member is required.
	Arn *string

	// The date and time that the scraper was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Managed Service for Prometheus workspace the scraper sends metrics
	// to.
	//
	// This member is required.
	Destination Destination

	// The date and time that the scraper was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions for
	// the scraper to discover and collect metrics on your behalf.
	//
	// This member is required.
	RoleArn *string

	// The ID of the scraper.
	//
	// This member is required.
	ScraperId *string

	// The Amazon EKS cluster from which the scraper collects metrics.
	//
	// This member is required.
	Source Source

	// A structure that contains the current status of the scraper.
	//
	// This member is required.
	Status *ScraperStatus

	// (Optional) A name associated with the scraper.
	Alias *string

	// This structure displays information about the IAM roles used for cross-account
	// scraping configuration.
	RoleConfiguration *RoleConfiguration

	// If there is a failure, the reason for the failure.
	StatusReason *string

	// (Optional) The list of tag keys and values associated with the scraper.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The source of collected metrics for a scraper.
//
// The following types satisfy this interface:
//
//	SourceMemberEksConfiguration
type Source interface {
	isSource()
}

// The Amazon EKS cluster from which a scraper collects metrics.
type SourceMemberEksConfiguration struct {
	Value EksConfiguration

	noSmithyDocumentSerde
}

func (*SourceMemberEksConfiguration) isSource() {}

// Information about a field passed into a request that resulted in an exception.
type ValidationExceptionField struct {

	// A message describing why the field caused an exception.
	//
	// This member is required.
	Message *string

	// The name of the field that caused an exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// This structure contains the description of the workspace configuration.
type WorkspaceConfigurationDescription struct {

	// This structure displays the current status of the workspace configuration, and
	// might also contain a reason for that status.
	//
	// This member is required.
	Status *WorkspaceConfigurationStatus

	// This is an array of structures, where each structure displays one label sets
	// for the workspace and the limits for that label set.
	LimitsPerLabelSet []LimitsPerLabelSet

	// This field displays how many days that metrics are retained in the workspace.
	RetentionPeriodInDays *int32

	noSmithyDocumentSerde
}

// This structure displays the current status of the workspace configuration, and
// might also contain a reason for that status.
type WorkspaceConfigurationStatus struct {

	// The current status of the workspace configuration.
	//
	// This member is required.
	StatusCode WorkspaceConfigurationStatusCode

	// The reason for the current status, if a reason is available.
	StatusReason *string

	noSmithyDocumentSerde
}

// The full details about one Amazon Managed Service for Prometheus workspace in
// your account.
type WorkspaceDescription struct {

	// The ARN of the workspace. For example,
	// arn:aws:aps:<region>:123456789012:workspace/ws-example1-1234-abcd-5678-ef90abcd1234
	// .
	//
	// This member is required.
	Arn *string

	// The date and time that the workspace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the workspace.
	//
	// This member is required.
	Status *WorkspaceStatus

	// The unique ID for the workspace. For example,
	// ws-example1-1234-abcd-5678-ef90abcd1234 .
	//
	// This member is required.
	WorkspaceId *string

	// The alias that is assigned to this workspace to help identify it. It does not
	// need to be unique.
	Alias *string

	// (optional) If the workspace was created with a customer managed KMS key, the
	// ARN for the key used.
	KmsKeyArn *string

	// The Prometheus endpoint available for this workspace. For example,
	// https://aps-workspaces.<region>.amazonaws.com/workspaces/ws-example1-1234-abcd-5678-ef90abcd1234/api/v1/
	// .
	PrometheusEndpoint *string

	// The list of tag keys and values that are associated with the workspace.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The status of the workspace.
type WorkspaceStatus struct {

	// The current status of the workspace.
	//
	// This member is required.
	StatusCode WorkspaceStatusCode

	noSmithyDocumentSerde
}

// The information about one Amazon Managed Service for Prometheus workspace in
// your account.
type WorkspaceSummary struct {

	// The ARN of the workspace.
	//
	// This member is required.
	Arn *string

	// The date and time that the workspace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the workspace.
	//
	// This member is required.
	Status *WorkspaceStatus

	// The unique ID for the workspace.
	//
	// This member is required.
	WorkspaceId *string

	// The alias that is assigned to this workspace to help identify it. It does not
	// need to be unique.
	Alias *string

	// (optional) If the workspace was created with a customer managed KMS key, the
	// ARN for the key used.
	KmsKeyArn *string

	// The list of tag keys and values that are associated with the workspace.
	Tags map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDestination()         {}
func (*UnknownUnionMember) isScrapeConfiguration() {}
func (*UnknownUnionMember) isSource()              {}
