// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appstream/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a Directory Config object in AppStream 2.0. This object includes the
// configuration information required to join fleets and image builders to
// Microsoft Active Directory domains.
func (c *Client) CreateDirectoryConfig(ctx context.Context, params *CreateDirectoryConfigInput, optFns ...func(*Options)) (*CreateDirectoryConfigOutput, error) {
	if params == nil {
		params = &CreateDirectoryConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDirectoryConfig", params, optFns, c.addOperationCreateDirectoryConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDirectoryConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDirectoryConfigInput struct {

	// The fully qualified name of the directory (for example, corp.example.com).
	//
	// This member is required.
	DirectoryName *string

	// The distinguished names of the organizational units for computer accounts.
	//
	// This member is required.
	OrganizationalUnitDistinguishedNames []string

	// The certificate-based authentication properties used to authenticate SAML 2.0
	// Identity Provider (IdP) user identities to Active Directory domain-joined
	// streaming instances. Fallback is turned on by default when certificate-based
	// authentication is Enabled . Fallback allows users to log in using their AD
	// domain password if certificate-based authentication is unsuccessful, or to
	// unlock a desktop lock screen. Enabled_no_directory_login_fallback enables
	// certificate-based authentication, but does not allow users to log in using their
	// AD domain password. Users will be disconnected to re-authenticate using
	// certificates.
	CertificateBasedAuthProperties *types.CertificateBasedAuthProperties

	// The credentials for the service account used by the fleet or image builder to
	// connect to the directory.
	ServiceAccountCredentials *types.ServiceAccountCredentials

	noSmithyDocumentSerde
}

type CreateDirectoryConfigOutput struct {

	// Information about the directory configuration.
	DirectoryConfig *types.DirectoryConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDirectoryConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDirectoryConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDirectoryConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDirectoryConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDirectoryConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDirectoryConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDirectoryConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDirectoryConfig",
	}
}
