// Code generated by smithy-go-codegen DO NOT EDIT.

package b2bi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/b2bi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Takes sample input and output documents and uses Amazon Bedrock to generate a
// mapping automatically. Depending on the accuracy and other factors, you can then
// edit the mapping for your needs.
//
// Before you can use the AI-assisted feature for Amazon Web Services B2B Data
// Interchange you must enable models in Amazon Bedrock. For details, see [AI-assisted template mapping prerequisites]in the
// Amazon Web Services B2B Data Interchange User guide.
//
// [AI-assisted template mapping prerequisites]: https://docs.aws.amazon.com/b2bi/latest/userguide/ai-assisted-mapping.html#ai-assist-prereq
func (c *Client) GenerateMapping(ctx context.Context, params *GenerateMappingInput, optFns ...func(*Options)) (*GenerateMappingOutput, error) {
	if params == nil {
		params = &GenerateMappingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GenerateMapping", params, optFns, c.addOperationGenerateMappingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GenerateMappingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GenerateMappingInput struct {

	// Provide the contents of a sample X12 EDI file (for inbound EDI) or JSON/XML
	// file (for outbound EDI) to use as a starting point for the mapping.
	//
	// This member is required.
	InputFileContent *string

	// Specify the mapping type: either JSONATA or XSLT.
	//
	// This member is required.
	MappingType types.MappingType

	// Provide the contents of a sample X12 EDI file (for outbound EDI) or JSON/XML
	// file (for inbound EDI) to use as a target for the mapping.
	//
	// This member is required.
	OutputFileContent *string

	noSmithyDocumentSerde
}

type GenerateMappingOutput struct {

	// Returns a mapping template based on your inputs.
	//
	// This member is required.
	MappingTemplate *string

	// Returns a percentage that estimates the accuracy of the generated mapping.
	MappingAccuracy *float32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGenerateMappingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGenerateMapping{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGenerateMapping{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GenerateMapping"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGenerateMappingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGenerateMapping(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGenerateMapping(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GenerateMapping",
	}
}
