// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/batch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Batch job queue. When you create a job queue, you associate one or
// more compute environments to the queue and assign an order of preference for the
// compute environments.
//
// You also set a priority to the job queue that determines the order that the
// Batch scheduler places jobs onto its associated compute environments. For
// example, if a compute environment is associated with more than one job queue,
// the job queue with a higher priority is given preference for scheduling jobs to
// that compute environment.
func (c *Client) CreateJobQueue(ctx context.Context, params *CreateJobQueueInput, optFns ...func(*Options)) (*CreateJobQueueOutput, error) {
	if params == nil {
		params = &CreateJobQueueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateJobQueue", params, optFns, c.addOperationCreateJobQueueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateJobQueueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Contains the parameters for CreateJobQueue .
type CreateJobQueueInput struct {

	// The set of compute environments mapped to a job queue and their order relative
	// to each other. The job scheduler uses this parameter to determine which compute
	// environment runs a specific job. Compute environments must be in the VALID
	// state before you can associate them with a job queue. You can associate up to
	// three compute environments with a job queue. All of the compute environments
	// must be either EC2 ( EC2 or SPOT ) or Fargate ( FARGATE or FARGATE_SPOT ); EC2
	// and Fargate compute environments can't be mixed.
	//
	// All compute environments that are associated with a job queue must share the
	// same architecture. Batch doesn't support mixing compute environment architecture
	// types in a single job queue.
	//
	// This member is required.
	ComputeEnvironmentOrder []types.ComputeEnvironmentOrder

	// The name of the job queue. It can be up to 128 letters long. It can contain
	// uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
	//
	// This member is required.
	JobQueueName *string

	// The priority of the job queue. Job queues with a higher priority (or a higher
	// integer value for the priority parameter) are evaluated first when associated
	// with the same compute environment. Priority is determined in descending order.
	// For example, a job queue with a priority value of 10 is given scheduling
	// preference over a job queue with a priority value of 1 . All of the compute
	// environments must be either EC2 ( EC2 or SPOT ) or Fargate ( FARGATE or
	// FARGATE_SPOT ); EC2 and Fargate compute environments can't be mixed.
	//
	// This member is required.
	Priority *int32

	// The set of actions that Batch performs on jobs that remain at the head of the
	// job queue in the specified state longer than specified times. Batch will perform
	// each action after maxTimeSeconds has passed. (Note: The minimum value for
	// maxTimeSeconds is 600 (10 minutes) and its maximum value is 86,400 (24 hours).)
	JobStateTimeLimitActions []types.JobStateTimeLimitAction

	// The Amazon Resource Name (ARN) of the fair-share scheduling policy. Job queues
	// that don't have a fair-share scheduling policy are scheduled in a first-in,
	// first-out (FIFO) model. After a job queue has a fair-share scheduling policy, it
	// can be replaced but can't be removed.
	//
	// The format is aws:Partition:batch:Region:Account:scheduling-policy/Name .
	//
	// An example is
	// aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy .
	//
	// A job queue without a fair-share scheduling policy is scheduled as a FIFO job
	// queue and can't have a fair-share scheduling policy added. Jobs queues with a
	// fair-share scheduling policy can have a maximum of 500 active share identifiers.
	// When the limit has been reached, submissions of any jobs that add a new share
	// identifier fail.
	SchedulingPolicyArn *string

	// The state of the job queue. If the job queue state is ENABLED , it is able to
	// accept jobs. If the job queue state is DISABLED , new jobs can't be added to the
	// queue, but jobs already in the queue can finish.
	State types.JQState

	// The tags that you apply to the job queue to help you categorize and organize
	// your resources. Each tag consists of a key and an optional value. For more
	// information, see [Tagging your Batch resources]in Batch User Guide.
	//
	// [Tagging your Batch resources]: https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateJobQueueOutput struct {

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// This member is required.
	JobQueueArn *string

	// The name of the job queue.
	//
	// This member is required.
	JobQueueName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateJobQueueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateJobQueue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateJobQueue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateJobQueue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateJobQueueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateJobQueue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateJobQueue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateJobQueue",
	}
}
