// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Delete usage that you have created in a Workload estimate. You can only delete
//
// usage that you had added and cannot model deletion (or removal) of a existing
// usage. If you want model removal of an existing usage, see [BatchUpdateWorkloadEstimateUsage].
//
// The BatchDeleteWorkloadEstimateUsage operation doesn't have its own IAM
// permission. To authorize this operation for Amazon Web Services principals,
// include the permission bcm-pricing-calculator:DeleteWorkloadEstimateUsage in
// your policies.
//
// [BatchUpdateWorkloadEstimateUsage]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html
func (c *Client) BatchDeleteWorkloadEstimateUsage(ctx context.Context, params *BatchDeleteWorkloadEstimateUsageInput, optFns ...func(*Options)) (*BatchDeleteWorkloadEstimateUsageOutput, error) {
	if params == nil {
		params = &BatchDeleteWorkloadEstimateUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDeleteWorkloadEstimateUsage", params, optFns, c.addOperationBatchDeleteWorkloadEstimateUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDeleteWorkloadEstimateUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDeleteWorkloadEstimateUsageInput struct {

	//  List of usage that you want to delete from the Workload estimate.
	//
	// This member is required.
	Ids []string

	//  The ID of the Workload estimate for which you want to delete the modeled
	// usage.
	//
	// This member is required.
	WorkloadEstimateId *string

	noSmithyDocumentSerde
}

type BatchDeleteWorkloadEstimateUsageOutput struct {

	//  Returns the list of errors reason and the usage item keys that cannot be
	// deleted from the Workload estimate.
	Errors []types.BatchDeleteWorkloadEstimateUsageError

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDeleteWorkloadEstimateUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpBatchDeleteWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpBatchDeleteWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDeleteWorkloadEstimateUsage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchDeleteWorkloadEstimateUsageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDeleteWorkloadEstimateUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDeleteWorkloadEstimateUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDeleteWorkloadEstimateUsage",
	}
}
