// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the commitments associated with a bill estimate.
func (c *Client) ListBillEstimateCommitments(ctx context.Context, params *ListBillEstimateCommitmentsInput, optFns ...func(*Options)) (*ListBillEstimateCommitmentsOutput, error) {
	if params == nil {
		params = &ListBillEstimateCommitmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBillEstimateCommitments", params, optFns, c.addOperationListBillEstimateCommitmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBillEstimateCommitmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBillEstimateCommitmentsInput struct {

	//  The unique identifier of the bill estimate to list commitments for.
	//
	// This member is required.
	BillEstimateId *string

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListBillEstimateCommitmentsOutput struct {

	//  The list of commitments associated with the bill estimate.
	Items []types.BillEstimateCommitmentSummary

	//  A token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBillEstimateCommitmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBillEstimateCommitments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBillEstimateCommitments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBillEstimateCommitments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBillEstimateCommitmentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBillEstimateCommitments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListBillEstimateCommitmentsPaginatorOptions is the paginator options for
// ListBillEstimateCommitments
type ListBillEstimateCommitmentsPaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBillEstimateCommitmentsPaginator is a paginator for
// ListBillEstimateCommitments
type ListBillEstimateCommitmentsPaginator struct {
	options   ListBillEstimateCommitmentsPaginatorOptions
	client    ListBillEstimateCommitmentsAPIClient
	params    *ListBillEstimateCommitmentsInput
	nextToken *string
	firstPage bool
}

// NewListBillEstimateCommitmentsPaginator returns a new
// ListBillEstimateCommitmentsPaginator
func NewListBillEstimateCommitmentsPaginator(client ListBillEstimateCommitmentsAPIClient, params *ListBillEstimateCommitmentsInput, optFns ...func(*ListBillEstimateCommitmentsPaginatorOptions)) *ListBillEstimateCommitmentsPaginator {
	if params == nil {
		params = &ListBillEstimateCommitmentsInput{}
	}

	options := ListBillEstimateCommitmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBillEstimateCommitmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBillEstimateCommitmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBillEstimateCommitments page.
func (p *ListBillEstimateCommitmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBillEstimateCommitmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBillEstimateCommitments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBillEstimateCommitmentsAPIClient is a client that implements the
// ListBillEstimateCommitments operation.
type ListBillEstimateCommitmentsAPIClient interface {
	ListBillEstimateCommitments(context.Context, *ListBillEstimateCommitmentsInput, ...func(*Options)) (*ListBillEstimateCommitmentsOutput, error)
}

var _ ListBillEstimateCommitmentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBillEstimateCommitments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBillEstimateCommitments",
	}
}
