// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/document"
	internaldocument "github.com/aws/aws-sdk-go-v2/service/bedrock/internal/document"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpBatchDeleteEvaluationJob struct {
}

func (*awsRestjson1_serializeOpBatchDeleteEvaluationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteEvaluationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteEvaluationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-jobs/batch-delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteEvaluationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteEvaluationJobInput(v *BatchDeleteEvaluationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteEvaluationJobInput(v *BatchDeleteEvaluationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobIdentifiers != nil {
		ok := object.Key("jobIdentifiers")
		if err := awsRestjson1_serializeDocumentEvaluationJobIdentifiers(v.JobIdentifiers, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateEvaluationJob struct {
}

func (*awsRestjson1_serializeOpCreateEvaluationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEvaluationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEvaluationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateEvaluationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEvaluationJobInput(v *CreateEvaluationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateEvaluationJobInput(v *CreateEvaluationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ApplicationType) > 0 {
		ok := object.Key("applicationType")
		ok.String(string(v.ApplicationType))
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.CustomerEncryptionKeyId != nil {
		ok := object.Key("customerEncryptionKeyId")
		ok.String(*v.CustomerEncryptionKeyId)
	}

	if v.EvaluationConfig != nil {
		ok := object.Key("evaluationConfig")
		if err := awsRestjson1_serializeDocumentEvaluationConfig(v.EvaluationConfig, ok); err != nil {
			return err
		}
	}

	if v.InferenceConfig != nil {
		ok := object.Key("inferenceConfig")
		if err := awsRestjson1_serializeDocumentEvaluationInferenceConfig(v.InferenceConfig, ok); err != nil {
			return err
		}
	}

	if v.JobDescription != nil {
		ok := object.Key("jobDescription")
		ok.String(*v.JobDescription)
	}

	if v.JobName != nil {
		ok := object.Key("jobName")
		ok.String(*v.JobName)
	}

	if v.JobTags != nil {
		ok := object.Key("jobTags")
		if err := awsRestjson1_serializeDocumentTagList(v.JobTags, ok); err != nil {
			return err
		}
	}

	if v.OutputDataConfig != nil {
		ok := object.Key("outputDataConfig")
		if err := awsRestjson1_serializeDocumentEvaluationOutputDataConfig(v.OutputDataConfig, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateGuardrail struct {
}

func (*awsRestjson1_serializeOpCreateGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGuardrailInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGuardrailInput(v *CreateGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGuardrailInput(v *CreateGuardrailInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedInputMessaging != nil {
		ok := object.Key("blockedInputMessaging")
		ok.String(*v.BlockedInputMessaging)
	}

	if v.BlockedOutputsMessaging != nil {
		ok := object.Key("blockedOutputsMessaging")
		ok.String(*v.BlockedOutputsMessaging)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.ContentPolicyConfig != nil {
		ok := object.Key("contentPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContentPolicyConfig(v.ContentPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.ContextualGroundingPolicyConfig != nil {
		ok := object.Key("contextualGroundingPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContextualGroundingPolicyConfig(v.ContextualGroundingPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.CrossRegionConfig != nil {
		ok := object.Key("crossRegionConfig")
		if err := awsRestjson1_serializeDocumentGuardrailCrossRegionConfig(v.CrossRegionConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SensitiveInformationPolicyConfig != nil {
		ok := object.Key("sensitiveInformationPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailSensitiveInformationPolicyConfig(v.SensitiveInformationPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TopicPolicyConfig != nil {
		ok := object.Key("topicPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailTopicPolicyConfig(v.TopicPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.WordPolicyConfig != nil {
		ok := object.Key("wordPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailWordPolicyConfig(v.WordPolicyConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGuardrailVersion struct {
}

func (*awsRestjson1_serializeOpCreateGuardrailVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGuardrailVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGuardrailVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateGuardrailVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGuardrailVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGuardrailVersionInput(v *CreateGuardrailVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGuardrailVersionInput(v *CreateGuardrailVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpCreateInferenceProfile struct {
}

func (*awsRestjson1_serializeOpCreateInferenceProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInferenceProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInferenceProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inference-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateInferenceProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInferenceProfileInput(v *CreateInferenceProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateInferenceProfileInput(v *CreateInferenceProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.InferenceProfileName != nil {
		ok := object.Key("inferenceProfileName")
		ok.String(*v.InferenceProfileName)
	}

	if v.ModelSource != nil {
		ok := object.Key("modelSource")
		if err := awsRestjson1_serializeDocumentInferenceProfileModelSource(v.ModelSource, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMarketplaceModelEndpoint struct {
}

func (*awsRestjson1_serializeOpCreateMarketplaceModelEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMarketplaceModelEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMarketplaceModelEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/marketplace-model/endpoints")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMarketplaceModelEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMarketplaceModelEndpointInput(v *CreateMarketplaceModelEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMarketplaceModelEndpointInput(v *CreateMarketplaceModelEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcceptEula {
		ok := object.Key("acceptEula")
		ok.Boolean(v.AcceptEula)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.EndpointConfig != nil {
		ok := object.Key("endpointConfig")
		if err := awsRestjson1_serializeDocumentEndpointConfig(v.EndpointConfig, ok); err != nil {
			return err
		}
	}

	if v.EndpointName != nil {
		ok := object.Key("endpointName")
		ok.String(*v.EndpointName)
	}

	if v.ModelSourceIdentifier != nil {
		ok := object.Key("modelSourceIdentifier")
		ok.String(*v.ModelSourceIdentifier)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateModelCopyJob struct {
}

func (*awsRestjson1_serializeOpCreateModelCopyJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateModelCopyJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateModelCopyJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-copy-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateModelCopyJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateModelCopyJobInput(v *CreateModelCopyJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateModelCopyJobInput(v *CreateModelCopyJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.ModelKmsKeyId != nil {
		ok := object.Key("modelKmsKeyId")
		ok.String(*v.ModelKmsKeyId)
	}

	if v.SourceModelArn != nil {
		ok := object.Key("sourceModelArn")
		ok.String(*v.SourceModelArn)
	}

	if v.TargetModelName != nil {
		ok := object.Key("targetModelName")
		ok.String(*v.TargetModelName)
	}

	if v.TargetModelTags != nil {
		ok := object.Key("targetModelTags")
		if err := awsRestjson1_serializeDocumentTagList(v.TargetModelTags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateModelCustomizationJob struct {
}

func (*awsRestjson1_serializeOpCreateModelCustomizationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateModelCustomizationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateModelCustomizationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateModelCustomizationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateModelCustomizationJobInput(v *CreateModelCustomizationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateModelCustomizationJobInput(v *CreateModelCustomizationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseModelIdentifier != nil {
		ok := object.Key("baseModelIdentifier")
		ok.String(*v.BaseModelIdentifier)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.CustomizationConfig != nil {
		ok := object.Key("customizationConfig")
		if err := awsRestjson1_serializeDocumentCustomizationConfig(v.CustomizationConfig, ok); err != nil {
			return err
		}
	}

	if len(v.CustomizationType) > 0 {
		ok := object.Key("customizationType")
		ok.String(string(v.CustomizationType))
	}

	if v.CustomModelKmsKeyId != nil {
		ok := object.Key("customModelKmsKeyId")
		ok.String(*v.CustomModelKmsKeyId)
	}

	if v.CustomModelName != nil {
		ok := object.Key("customModelName")
		ok.String(*v.CustomModelName)
	}

	if v.CustomModelTags != nil {
		ok := object.Key("customModelTags")
		if err := awsRestjson1_serializeDocumentTagList(v.CustomModelTags, ok); err != nil {
			return err
		}
	}

	if v.HyperParameters != nil {
		ok := object.Key("hyperParameters")
		if err := awsRestjson1_serializeDocumentModelCustomizationHyperParameters(v.HyperParameters, ok); err != nil {
			return err
		}
	}

	if v.JobName != nil {
		ok := object.Key("jobName")
		ok.String(*v.JobName)
	}

	if v.JobTags != nil {
		ok := object.Key("jobTags")
		if err := awsRestjson1_serializeDocumentTagList(v.JobTags, ok); err != nil {
			return err
		}
	}

	if v.OutputDataConfig != nil {
		ok := object.Key("outputDataConfig")
		if err := awsRestjson1_serializeDocumentOutputDataConfig(v.OutputDataConfig, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TrainingDataConfig != nil {
		ok := object.Key("trainingDataConfig")
		if err := awsRestjson1_serializeDocumentTrainingDataConfig(v.TrainingDataConfig, ok); err != nil {
			return err
		}
	}

	if v.ValidationDataConfig != nil {
		ok := object.Key("validationDataConfig")
		if err := awsRestjson1_serializeDocumentValidationDataConfig(v.ValidationDataConfig, ok); err != nil {
			return err
		}
	}

	if v.VpcConfig != nil {
		ok := object.Key("vpcConfig")
		if err := awsRestjson1_serializeDocumentVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateModelImportJob struct {
}

func (*awsRestjson1_serializeOpCreateModelImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateModelImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateModelImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-import-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateModelImportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateModelImportJobInput(v *CreateModelImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateModelImportJobInput(v *CreateModelImportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.ImportedModelKmsKeyId != nil {
		ok := object.Key("importedModelKmsKeyId")
		ok.String(*v.ImportedModelKmsKeyId)
	}

	if v.ImportedModelName != nil {
		ok := object.Key("importedModelName")
		ok.String(*v.ImportedModelName)
	}

	if v.ImportedModelTags != nil {
		ok := object.Key("importedModelTags")
		if err := awsRestjson1_serializeDocumentTagList(v.ImportedModelTags, ok); err != nil {
			return err
		}
	}

	if v.JobName != nil {
		ok := object.Key("jobName")
		ok.String(*v.JobName)
	}

	if v.JobTags != nil {
		ok := object.Key("jobTags")
		if err := awsRestjson1_serializeDocumentTagList(v.JobTags, ok); err != nil {
			return err
		}
	}

	if v.ModelDataSource != nil {
		ok := object.Key("modelDataSource")
		if err := awsRestjson1_serializeDocumentModelDataSource(v.ModelDataSource, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.VpcConfig != nil {
		ok := object.Key("vpcConfig")
		if err := awsRestjson1_serializeDocumentVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateModelInvocationJob struct {
}

func (*awsRestjson1_serializeOpCreateModelInvocationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateModelInvocationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateModelInvocationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-invocation-job")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateModelInvocationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateModelInvocationJobInput(v *CreateModelInvocationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateModelInvocationJobInput(v *CreateModelInvocationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.InputDataConfig != nil {
		ok := object.Key("inputDataConfig")
		if err := awsRestjson1_serializeDocumentModelInvocationJobInputDataConfig(v.InputDataConfig, ok); err != nil {
			return err
		}
	}

	if v.JobName != nil {
		ok := object.Key("jobName")
		ok.String(*v.JobName)
	}

	if v.ModelId != nil {
		ok := object.Key("modelId")
		ok.String(*v.ModelId)
	}

	if v.OutputDataConfig != nil {
		ok := object.Key("outputDataConfig")
		if err := awsRestjson1_serializeDocumentModelInvocationJobOutputDataConfig(v.OutputDataConfig, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TimeoutDurationInHours != nil {
		ok := object.Key("timeoutDurationInHours")
		ok.Integer(*v.TimeoutDurationInHours)
	}

	if v.VpcConfig != nil {
		ok := object.Key("vpcConfig")
		if err := awsRestjson1_serializeDocumentVpcConfig(v.VpcConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePromptRouter struct {
}

func (*awsRestjson1_serializeOpCreatePromptRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePromptRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePromptRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prompt-routers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePromptRouterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePromptRouterInput(v *CreatePromptRouterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePromptRouterInput(v *CreatePromptRouterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FallbackModel != nil {
		ok := object.Key("fallbackModel")
		if err := awsRestjson1_serializeDocumentPromptRouterTargetModel(v.FallbackModel, ok); err != nil {
			return err
		}
	}

	if v.Models != nil {
		ok := object.Key("models")
		if err := awsRestjson1_serializeDocumentPromptRouterTargetModels(v.Models, ok); err != nil {
			return err
		}
	}

	if v.PromptRouterName != nil {
		ok := object.Key("promptRouterName")
		ok.String(*v.PromptRouterName)
	}

	if v.RoutingCriteria != nil {
		ok := object.Key("routingCriteria")
		if err := awsRestjson1_serializeDocumentRoutingCriteria(v.RoutingCriteria, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpCreateProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateProvisionedModelThroughputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateProvisionedModelThroughputInput(v *CreateProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateProvisionedModelThroughputInput(v *CreateProvisionedModelThroughputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.CommitmentDuration) > 0 {
		ok := object.Key("commitmentDuration")
		ok.String(string(v.CommitmentDuration))
	}

	if v.ModelId != nil {
		ok := object.Key("modelId")
		ok.String(*v.ModelId)
	}

	if v.ModelUnits != nil {
		ok := object.Key("modelUnits")
		ok.Integer(*v.ModelUnits)
	}

	if v.ProvisionedModelName != nil {
		ok := object.Key("provisionedModelName")
		ok.String(*v.ProvisionedModelName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCustomModel struct {
}

func (*awsRestjson1_serializeOpDeleteCustomModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCustomModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCustomModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCustomModelInput(v *DeleteCustomModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGuardrail struct {
}

func (*awsRestjson1_serializeOpDeleteGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGuardrailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGuardrailInput(v *DeleteGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	if v.GuardrailVersion != nil {
		encoder.SetQuery("guardrailVersion").String(*v.GuardrailVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteImportedModel struct {
}

func (*awsRestjson1_serializeOpDeleteImportedModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteImportedModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteImportedModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/imported-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteImportedModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteImportedModelInput(v *DeleteImportedModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInferenceProfile struct {
}

func (*awsRestjson1_serializeOpDeleteInferenceProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInferenceProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInferenceProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inference-profiles/{inferenceProfileIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInferenceProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInferenceProfileInput(v *DeleteInferenceProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InferenceProfileIdentifier == nil || len(*v.InferenceProfileIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member inferenceProfileIdentifier must not be empty")}
	}
	if v.InferenceProfileIdentifier != nil {
		if err := encoder.SetURI("inferenceProfileIdentifier").String(*v.InferenceProfileIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMarketplaceModelEndpoint struct {
}

func (*awsRestjson1_serializeOpDeleteMarketplaceModelEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMarketplaceModelEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMarketplaceModelEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/marketplace-model/endpoints/{endpointArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMarketplaceModelEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMarketplaceModelEndpointInput(v *DeleteMarketplaceModelEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndpointArn == nil || len(*v.EndpointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member endpointArn must not be empty")}
	}
	if v.EndpointArn != nil {
		if err := encoder.SetURI("endpointArn").String(*v.EndpointArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteModelInvocationLoggingConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteModelInvocationLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteModelInvocationLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteModelInvocationLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging/modelinvocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteModelInvocationLoggingConfigurationInput(v *DeleteModelInvocationLoggingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDeletePromptRouter struct {
}

func (*awsRestjson1_serializeOpDeletePromptRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePromptRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePromptRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prompt-routers/{promptRouterArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePromptRouterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePromptRouterInput(v *DeletePromptRouterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PromptRouterArn == nil || len(*v.PromptRouterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member promptRouterArn must not be empty")}
	}
	if v.PromptRouterArn != nil {
		if err := encoder.SetURI("promptRouterArn").String(*v.PromptRouterArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpDeleteProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput/{provisionedModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProvisionedModelThroughputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProvisionedModelThroughputInput(v *DeleteProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProvisionedModelId == nil || len(*v.ProvisionedModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provisionedModelId must not be empty")}
	}
	if v.ProvisionedModelId != nil {
		if err := encoder.SetURI("provisionedModelId").String(*v.ProvisionedModelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeregisterMarketplaceModelEndpoint struct {
}

func (*awsRestjson1_serializeOpDeregisterMarketplaceModelEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeregisterMarketplaceModelEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterMarketplaceModelEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/marketplace-model/endpoints/{endpointArn}/registration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeregisterMarketplaceModelEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeregisterMarketplaceModelEndpointInput(v *DeregisterMarketplaceModelEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndpointArn == nil || len(*v.EndpointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member endpointArn must not be empty")}
	}
	if v.EndpointArn != nil {
		if err := encoder.SetURI("endpointArn").String(*v.EndpointArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCustomModel struct {
}

func (*awsRestjson1_serializeOpGetCustomModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCustomModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCustomModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCustomModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCustomModelInput(v *GetCustomModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEvaluationJob struct {
}

func (*awsRestjson1_serializeOpGetEvaluationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEvaluationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEvaluationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-jobs/{jobIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEvaluationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEvaluationJobInput(v *GetEvaluationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFoundationModel struct {
}

func (*awsRestjson1_serializeOpGetFoundationModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFoundationModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFoundationModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/foundation-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFoundationModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFoundationModelInput(v *GetFoundationModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetGuardrail struct {
}

func (*awsRestjson1_serializeOpGetGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGuardrailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGuardrailInput(v *GetGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	if v.GuardrailVersion != nil {
		encoder.SetQuery("guardrailVersion").String(*v.GuardrailVersion)
	}

	return nil
}

type awsRestjson1_serializeOpGetImportedModel struct {
}

func (*awsRestjson1_serializeOpGetImportedModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetImportedModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetImportedModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/imported-models/{modelIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetImportedModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetImportedModelInput(v *GetImportedModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ModelIdentifier == nil || len(*v.ModelIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member modelIdentifier must not be empty")}
	}
	if v.ModelIdentifier != nil {
		if err := encoder.SetURI("modelIdentifier").String(*v.ModelIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetInferenceProfile struct {
}

func (*awsRestjson1_serializeOpGetInferenceProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInferenceProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInferenceProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inference-profiles/{inferenceProfileIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetInferenceProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInferenceProfileInput(v *GetInferenceProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InferenceProfileIdentifier == nil || len(*v.InferenceProfileIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member inferenceProfileIdentifier must not be empty")}
	}
	if v.InferenceProfileIdentifier != nil {
		if err := encoder.SetURI("inferenceProfileIdentifier").String(*v.InferenceProfileIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMarketplaceModelEndpoint struct {
}

func (*awsRestjson1_serializeOpGetMarketplaceModelEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMarketplaceModelEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMarketplaceModelEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/marketplace-model/endpoints/{endpointArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMarketplaceModelEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMarketplaceModelEndpointInput(v *GetMarketplaceModelEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndpointArn == nil || len(*v.EndpointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member endpointArn must not be empty")}
	}
	if v.EndpointArn != nil {
		if err := encoder.SetURI("endpointArn").String(*v.EndpointArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetModelCopyJob struct {
}

func (*awsRestjson1_serializeOpGetModelCopyJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelCopyJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelCopyJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-copy-jobs/{jobArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelCopyJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelCopyJobInput(v *GetModelCopyJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobArn == nil || len(*v.JobArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobArn must not be empty")}
	}
	if v.JobArn != nil {
		if err := encoder.SetURI("jobArn").String(*v.JobArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetModelCustomizationJob struct {
}

func (*awsRestjson1_serializeOpGetModelCustomizationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelCustomizationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelCustomizationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs/{jobIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelCustomizationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelCustomizationJobInput(v *GetModelCustomizationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetModelImportJob struct {
}

func (*awsRestjson1_serializeOpGetModelImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-import-jobs/{jobIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelImportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelImportJobInput(v *GetModelImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetModelInvocationJob struct {
}

func (*awsRestjson1_serializeOpGetModelInvocationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelInvocationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelInvocationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-invocation-job/{jobIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetModelInvocationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelInvocationJobInput(v *GetModelInvocationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetModelInvocationLoggingConfiguration struct {
}

func (*awsRestjson1_serializeOpGetModelInvocationLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetModelInvocationLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelInvocationLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging/modelinvocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetModelInvocationLoggingConfigurationInput(v *GetModelInvocationLoggingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetPromptRouter struct {
}

func (*awsRestjson1_serializeOpGetPromptRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPromptRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPromptRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prompt-routers/{promptRouterArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPromptRouterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPromptRouterInput(v *GetPromptRouterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PromptRouterArn == nil || len(*v.PromptRouterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member promptRouterArn must not be empty")}
	}
	if v.PromptRouterArn != nil {
		if err := encoder.SetURI("promptRouterArn").String(*v.PromptRouterArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpGetProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput/{provisionedModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetProvisionedModelThroughputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetProvisionedModelThroughputInput(v *GetProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProvisionedModelId == nil || len(*v.ProvisionedModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provisionedModelId must not be empty")}
	}
	if v.ProvisionedModelId != nil {
		if err := encoder.SetURI("provisionedModelId").String(*v.ProvisionedModelId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListCustomModels struct {
}

func (*awsRestjson1_serializeOpListCustomModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCustomModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCustomModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/custom-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCustomModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCustomModelsInput(v *ListCustomModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BaseModelArnEquals != nil {
		encoder.SetQuery("baseModelArnEquals").String(*v.BaseModelArnEquals)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.FoundationModelArnEquals != nil {
		encoder.SetQuery("foundationModelArnEquals").String(*v.FoundationModelArnEquals)
	}

	if v.IsOwned != nil {
		encoder.SetQuery("isOwned").Boolean(*v.IsOwned)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListEvaluationJobs struct {
}

func (*awsRestjson1_serializeOpListEvaluationJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEvaluationJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEvaluationJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEvaluationJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEvaluationJobsInput(v *ListEvaluationJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ApplicationTypeEquals) > 0 {
		encoder.SetQuery("applicationTypeEquals").String(string(v.ApplicationTypeEquals))
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListFoundationModels struct {
}

func (*awsRestjson1_serializeOpListFoundationModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFoundationModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFoundationModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/foundation-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFoundationModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFoundationModelsInput(v *ListFoundationModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ByCustomizationType) > 0 {
		encoder.SetQuery("byCustomizationType").String(string(v.ByCustomizationType))
	}

	if len(v.ByInferenceType) > 0 {
		encoder.SetQuery("byInferenceType").String(string(v.ByInferenceType))
	}

	if len(v.ByOutputModality) > 0 {
		encoder.SetQuery("byOutputModality").String(string(v.ByOutputModality))
	}

	if v.ByProvider != nil {
		encoder.SetQuery("byProvider").String(*v.ByProvider)
	}

	return nil
}

type awsRestjson1_serializeOpListGuardrails struct {
}

func (*awsRestjson1_serializeOpListGuardrails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGuardrails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGuardrailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGuardrailsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGuardrailsInput(v *ListGuardrailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier != nil {
		encoder.SetQuery("guardrailIdentifier").String(*v.GuardrailIdentifier)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListImportedModels struct {
}

func (*awsRestjson1_serializeOpListImportedModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListImportedModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListImportedModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/imported-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListImportedModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListImportedModelsInput(v *ListImportedModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	return nil
}

type awsRestjson1_serializeOpListInferenceProfiles struct {
}

func (*awsRestjson1_serializeOpListInferenceProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInferenceProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInferenceProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inference-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInferenceProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInferenceProfilesInput(v *ListInferenceProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.TypeEquals) > 0 {
		encoder.SetQuery("type").String(string(v.TypeEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListMarketplaceModelEndpoints struct {
}

func (*awsRestjson1_serializeOpListMarketplaceModelEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMarketplaceModelEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMarketplaceModelEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/marketplace-model/endpoints")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMarketplaceModelEndpointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMarketplaceModelEndpointsInput(v *ListMarketplaceModelEndpointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.ModelSourceEquals != nil {
		encoder.SetQuery("modelSourceIdentifier").String(*v.ModelSourceEquals)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListModelCopyJobs struct {
}

func (*awsRestjson1_serializeOpListModelCopyJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListModelCopyJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelCopyJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-copy-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListModelCopyJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListModelCopyJobsInput(v *ListModelCopyJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if v.SourceAccountEquals != nil {
		encoder.SetQuery("sourceAccountEquals").String(*v.SourceAccountEquals)
	}

	if v.SourceModelArnEquals != nil {
		encoder.SetQuery("sourceModelArnEquals").String(*v.SourceModelArnEquals)
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	if v.TargetModelNameContains != nil {
		encoder.SetQuery("outputModelNameContains").String(*v.TargetModelNameContains)
	}

	return nil
}

type awsRestjson1_serializeOpListModelCustomizationJobs struct {
}

func (*awsRestjson1_serializeOpListModelCustomizationJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListModelCustomizationJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelCustomizationJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListModelCustomizationJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListModelCustomizationJobsInput(v *ListModelCustomizationJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListModelImportJobs struct {
}

func (*awsRestjson1_serializeOpListModelImportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListModelImportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelImportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-import-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListModelImportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListModelImportJobsInput(v *ListModelImportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListModelInvocationJobs struct {
}

func (*awsRestjson1_serializeOpListModelInvocationJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListModelInvocationJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelInvocationJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-invocation-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListModelInvocationJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListModelInvocationJobsInput(v *ListModelInvocationJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	if v.SubmitTimeAfter != nil {
		encoder.SetQuery("submitTimeAfter").String(smithytime.FormatDateTime(*v.SubmitTimeAfter))
	}

	if v.SubmitTimeBefore != nil {
		encoder.SetQuery("submitTimeBefore").String(smithytime.FormatDateTime(*v.SubmitTimeBefore))
	}

	return nil
}

type awsRestjson1_serializeOpListPromptRouters struct {
}

func (*awsRestjson1_serializeOpListPromptRouters) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPromptRouters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPromptRoutersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prompt-routers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPromptRoutersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPromptRoutersInput(v *ListPromptRoutersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("type").String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpListProvisionedModelThroughputs struct {
}

func (*awsRestjson1_serializeOpListProvisionedModelThroughputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProvisionedModelThroughputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProvisionedModelThroughputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProvisionedModelThroughputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProvisionedModelThroughputsInput(v *ListProvisionedModelThroughputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreationTimeAfter != nil {
		encoder.SetQuery("creationTimeAfter").String(smithytime.FormatDateTime(*v.CreationTimeAfter))
	}

	if v.CreationTimeBefore != nil {
		encoder.SetQuery("creationTimeBefore").String(smithytime.FormatDateTime(*v.CreationTimeBefore))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.ModelArnEquals != nil {
		encoder.SetQuery("modelArnEquals").String(*v.ModelArnEquals)
	}

	if v.NameContains != nil {
		encoder.SetQuery("nameContains").String(*v.NameContains)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		encoder.SetQuery("sortBy").String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		encoder.SetQuery("sortOrder").String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		encoder.SetQuery("statusEquals").String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/listTagsForResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

type awsRestjson1_serializeOpPutModelInvocationLoggingConfiguration struct {
}

func (*awsRestjson1_serializeOpPutModelInvocationLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutModelInvocationLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutModelInvocationLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging/modelinvocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutModelInvocationLoggingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutModelInvocationLoggingConfigurationInput(v *PutModelInvocationLoggingConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutModelInvocationLoggingConfigurationInput(v *PutModelInvocationLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LoggingConfig != nil {
		ok := object.Key("loggingConfig")
		if err := awsRestjson1_serializeDocumentLoggingConfig(v.LoggingConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRegisterMarketplaceModelEndpoint struct {
}

func (*awsRestjson1_serializeOpRegisterMarketplaceModelEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterMarketplaceModelEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterMarketplaceModelEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/marketplace-model/endpoints/{endpointIdentifier}/registration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRegisterMarketplaceModelEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterMarketplaceModelEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterMarketplaceModelEndpointInput(v *RegisterMarketplaceModelEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndpointIdentifier == nil || len(*v.EndpointIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member endpointIdentifier must not be empty")}
	}
	if v.EndpointIdentifier != nil {
		if err := encoder.SetURI("endpointIdentifier").String(*v.EndpointIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterMarketplaceModelEndpointInput(v *RegisterMarketplaceModelEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelSourceIdentifier != nil {
		ok := object.Key("modelSourceIdentifier")
		ok.String(*v.ModelSourceIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpStopEvaluationJob struct {
}

func (*awsRestjson1_serializeOpStopEvaluationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopEvaluationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopEvaluationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/evaluation-job/{jobIdentifier}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopEvaluationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopEvaluationJobInput(v *StopEvaluationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopModelCustomizationJob struct {
}

func (*awsRestjson1_serializeOpStopModelCustomizationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopModelCustomizationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopModelCustomizationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-customization-jobs/{jobIdentifier}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopModelCustomizationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopModelCustomizationJobInput(v *StopModelCustomizationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopModelInvocationJob struct {
}

func (*awsRestjson1_serializeOpStopModelInvocationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopModelInvocationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopModelInvocationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/model-invocation-job/{jobIdentifier}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopModelInvocationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopModelInvocationJobInput(v *StopModelInvocationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobIdentifier == nil || len(*v.JobIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobIdentifier must not be empty")}
	}
	if v.JobIdentifier != nil {
		if err := encoder.SetURI("jobIdentifier").String(*v.JobIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/untagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGuardrail struct {
}

func (*awsRestjson1_serializeOpUpdateGuardrail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGuardrail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGuardrailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/guardrails/{guardrailIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGuardrailInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGuardrailInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGuardrailInput(v *UpdateGuardrailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GuardrailIdentifier == nil || len(*v.GuardrailIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member guardrailIdentifier must not be empty")}
	}
	if v.GuardrailIdentifier != nil {
		if err := encoder.SetURI("guardrailIdentifier").String(*v.GuardrailIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGuardrailInput(v *UpdateGuardrailInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedInputMessaging != nil {
		ok := object.Key("blockedInputMessaging")
		ok.String(*v.BlockedInputMessaging)
	}

	if v.BlockedOutputsMessaging != nil {
		ok := object.Key("blockedOutputsMessaging")
		ok.String(*v.BlockedOutputsMessaging)
	}

	if v.ContentPolicyConfig != nil {
		ok := object.Key("contentPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContentPolicyConfig(v.ContentPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.ContextualGroundingPolicyConfig != nil {
		ok := object.Key("contextualGroundingPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContextualGroundingPolicyConfig(v.ContextualGroundingPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.CrossRegionConfig != nil {
		ok := object.Key("crossRegionConfig")
		if err := awsRestjson1_serializeDocumentGuardrailCrossRegionConfig(v.CrossRegionConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SensitiveInformationPolicyConfig != nil {
		ok := object.Key("sensitiveInformationPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailSensitiveInformationPolicyConfig(v.SensitiveInformationPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.TopicPolicyConfig != nil {
		ok := object.Key("topicPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailTopicPolicyConfig(v.TopicPolicyConfig, ok); err != nil {
			return err
		}
	}

	if v.WordPolicyConfig != nil {
		ok := object.Key("wordPolicyConfig")
		if err := awsRestjson1_serializeDocumentGuardrailWordPolicyConfig(v.WordPolicyConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMarketplaceModelEndpoint struct {
}

func (*awsRestjson1_serializeOpUpdateMarketplaceModelEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMarketplaceModelEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMarketplaceModelEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/marketplace-model/endpoints/{endpointArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMarketplaceModelEndpointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMarketplaceModelEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMarketplaceModelEndpointInput(v *UpdateMarketplaceModelEndpointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndpointArn == nil || len(*v.EndpointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member endpointArn must not be empty")}
	}
	if v.EndpointArn != nil {
		if err := encoder.SetURI("endpointArn").String(*v.EndpointArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMarketplaceModelEndpointInput(v *UpdateMarketplaceModelEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.EndpointConfig != nil {
		ok := object.Key("endpointConfig")
		if err := awsRestjson1_serializeDocumentEndpointConfig(v.EndpointConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateProvisionedModelThroughput struct {
}

func (*awsRestjson1_serializeOpUpdateProvisionedModelThroughput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateProvisionedModelThroughput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateProvisionedModelThroughputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/provisioned-model-throughput/{provisionedModelId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateProvisionedModelThroughputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateProvisionedModelThroughputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateProvisionedModelThroughputInput(v *UpdateProvisionedModelThroughputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ProvisionedModelId == nil || len(*v.ProvisionedModelId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provisionedModelId must not be empty")}
	}
	if v.ProvisionedModelId != nil {
		if err := encoder.SetURI("provisionedModelId").String(*v.ProvisionedModelId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateProvisionedModelThroughputInput(v *UpdateProvisionedModelThroughputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DesiredModelId != nil {
		ok := object.Key("desiredModelId")
		ok.String(*v.DesiredModelId)
	}

	if v.DesiredProvisionedModelName != nil {
		ok := object.Key("desiredProvisionedModelName")
		ok.String(*v.DesiredProvisionedModelName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAdditionalModelRequestFields(v map[string]document.Interface, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentAdditionalModelRequestFieldsValue(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAdditionalModelRequestFieldsValue(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentAutomatedEvaluationConfig(v *types.AutomatedEvaluationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomMetricConfig != nil {
		ok := object.Key("customMetricConfig")
		if err := awsRestjson1_serializeDocumentAutomatedEvaluationCustomMetricConfig(v.CustomMetricConfig, ok); err != nil {
			return err
		}
	}

	if v.DatasetMetricConfigs != nil {
		ok := object.Key("datasetMetricConfigs")
		if err := awsRestjson1_serializeDocumentEvaluationDatasetMetricConfigs(v.DatasetMetricConfigs, ok); err != nil {
			return err
		}
	}

	if v.EvaluatorModelConfig != nil {
		ok := object.Key("evaluatorModelConfig")
		if err := awsRestjson1_serializeDocumentEvaluatorModelConfig(v.EvaluatorModelConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomatedEvaluationCustomMetricConfig(v *types.AutomatedEvaluationCustomMetricConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomMetrics != nil {
		ok := object.Key("customMetrics")
		if err := awsRestjson1_serializeDocumentAutomatedEvaluationCustomMetrics(v.CustomMetrics, ok); err != nil {
			return err
		}
	}

	if v.EvaluatorModelConfig != nil {
		ok := object.Key("evaluatorModelConfig")
		if err := awsRestjson1_serializeDocumentCustomMetricEvaluatorModelConfig(v.EvaluatorModelConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomatedEvaluationCustomMetrics(v []types.AutomatedEvaluationCustomMetricSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentAutomatedEvaluationCustomMetricSource(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAutomatedEvaluationCustomMetricSource(v types.AutomatedEvaluationCustomMetricSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AutomatedEvaluationCustomMetricSourceMemberCustomMetricDefinition:
		av := object.Key("customMetricDefinition")
		if err := awsRestjson1_serializeDocumentCustomMetricDefinition(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentBedrockEvaluatorModel(v *types.BedrockEvaluatorModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelIdentifier != nil {
		ok := object.Key("modelIdentifier")
		ok.String(*v.ModelIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentBedrockEvaluatorModels(v []types.BedrockEvaluatorModel, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBedrockEvaluatorModel(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentByteContentDoc(v *types.ByteContentDoc, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentType != nil {
		ok := object.Key("contentType")
		ok.String(*v.ContentType)
	}

	if v.Data != nil {
		ok := object.Key("data")
		ok.Base64EncodeBytes(v.Data)
	}

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchConfig(v *types.CloudWatchConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LargeDataDeliveryS3Config != nil {
		ok := object.Key("largeDataDeliveryS3Config")
		if err := awsRestjson1_serializeDocumentS3Config(v.LargeDataDeliveryS3Config, ok); err != nil {
			return err
		}
	}

	if v.LogGroupName != nil {
		ok := object.Key("logGroupName")
		ok.String(*v.LogGroupName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomizationConfig(v types.CustomizationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CustomizationConfigMemberDistillationConfig:
		av := object.Key("distillationConfig")
		if err := awsRestjson1_serializeDocumentDistillationConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCustomMetricBedrockEvaluatorModel(v *types.CustomMetricBedrockEvaluatorModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelIdentifier != nil {
		ok := object.Key("modelIdentifier")
		ok.String(*v.ModelIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomMetricBedrockEvaluatorModels(v []types.CustomMetricBedrockEvaluatorModel, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCustomMetricBedrockEvaluatorModel(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomMetricDefinition(v *types.CustomMetricDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Instructions != nil {
		ok := object.Key("instructions")
		ok.String(*v.Instructions)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RatingScale != nil {
		ok := object.Key("ratingScale")
		if err := awsRestjson1_serializeDocumentRatingScale(v.RatingScale, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomMetricEvaluatorModelConfig(v *types.CustomMetricEvaluatorModelConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BedrockEvaluatorModels != nil {
		ok := object.Key("bedrockEvaluatorModels")
		if err := awsRestjson1_serializeDocumentCustomMetricBedrockEvaluatorModels(v.BedrockEvaluatorModels, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDistillationConfig(v *types.DistillationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TeacherModelConfig != nil {
		ok := object.Key("teacherModelConfig")
		if err := awsRestjson1_serializeDocumentTeacherModelConfig(v.TeacherModelConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEndpointConfig(v types.EndpointConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EndpointConfigMemberSageMaker:
		av := object.Key("sageMaker")
		if err := awsRestjson1_serializeDocumentSageMakerEndpoint(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationBedrockModel(v *types.EvaluationBedrockModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InferenceParams != nil {
		ok := object.Key("inferenceParams")
		ok.String(*v.InferenceParams)
	}

	if v.ModelIdentifier != nil {
		ok := object.Key("modelIdentifier")
		ok.String(*v.ModelIdentifier)
	}

	if v.PerformanceConfig != nil {
		ok := object.Key("performanceConfig")
		if err := awsRestjson1_serializeDocumentPerformanceConfiguration(v.PerformanceConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationConfig(v types.EvaluationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationConfigMemberAutomated:
		av := object.Key("automated")
		if err := awsRestjson1_serializeDocumentAutomatedEvaluationConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.EvaluationConfigMemberHuman:
		av := object.Key("human")
		if err := awsRestjson1_serializeDocumentHumanEvaluationConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationDataset(v *types.EvaluationDataset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetLocation != nil {
		ok := object.Key("datasetLocation")
		if err := awsRestjson1_serializeDocumentEvaluationDatasetLocation(v.DatasetLocation, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationDatasetLocation(v types.EvaluationDatasetLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationDatasetLocationMemberS3Uri:
		av := object.Key("s3Uri")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationDatasetMetricConfig(v *types.EvaluationDatasetMetricConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dataset != nil {
		ok := object.Key("dataset")
		if err := awsRestjson1_serializeDocumentEvaluationDataset(v.Dataset, ok); err != nil {
			return err
		}
	}

	if v.MetricNames != nil {
		ok := object.Key("metricNames")
		if err := awsRestjson1_serializeDocumentEvaluationMetricNames(v.MetricNames, ok); err != nil {
			return err
		}
	}

	if len(v.TaskType) > 0 {
		ok := object.Key("taskType")
		ok.String(string(v.TaskType))
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationDatasetMetricConfigs(v []types.EvaluationDatasetMetricConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEvaluationDatasetMetricConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationInferenceConfig(v types.EvaluationInferenceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationInferenceConfigMemberModels:
		av := object.Key("models")
		if err := awsRestjson1_serializeDocumentEvaluationModelConfigs(uv.Value, av); err != nil {
			return err
		}

	case *types.EvaluationInferenceConfigMemberRagConfigs:
		av := object.Key("ragConfigs")
		if err := awsRestjson1_serializeDocumentRagConfigs(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationJobIdentifiers(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationMetricNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationModelConfig(v types.EvaluationModelConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationModelConfigMemberBedrockModel:
		av := object.Key("bedrockModel")
		if err := awsRestjson1_serializeDocumentEvaluationBedrockModel(&uv.Value, av); err != nil {
			return err
		}

	case *types.EvaluationModelConfigMemberPrecomputedInferenceSource:
		av := object.Key("precomputedInferenceSource")
		if err := awsRestjson1_serializeDocumentEvaluationPrecomputedInferenceSource(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationModelConfigs(v []types.EvaluationModelConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentEvaluationModelConfig(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationOutputDataConfig(v *types.EvaluationOutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationPrecomputedInferenceSource(v *types.EvaluationPrecomputedInferenceSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InferenceSourceIdentifier != nil {
		ok := object.Key("inferenceSourceIdentifier")
		ok.String(*v.InferenceSourceIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationPrecomputedRagSourceConfig(v types.EvaluationPrecomputedRagSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluationPrecomputedRagSourceConfigMemberRetrieveAndGenerateSourceConfig:
		av := object.Key("retrieveAndGenerateSourceConfig")
		if err := awsRestjson1_serializeDocumentEvaluationPrecomputedRetrieveAndGenerateSourceConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.EvaluationPrecomputedRagSourceConfigMemberRetrieveSourceConfig:
		av := object.Key("retrieveSourceConfig")
		if err := awsRestjson1_serializeDocumentEvaluationPrecomputedRetrieveSourceConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluationPrecomputedRetrieveAndGenerateSourceConfig(v *types.EvaluationPrecomputedRetrieveAndGenerateSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RagSourceIdentifier != nil {
		ok := object.Key("ragSourceIdentifier")
		ok.String(*v.RagSourceIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluationPrecomputedRetrieveSourceConfig(v *types.EvaluationPrecomputedRetrieveSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RagSourceIdentifier != nil {
		ok := object.Key("ragSourceIdentifier")
		ok.String(*v.RagSourceIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluatorModelConfig(v types.EvaluatorModelConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EvaluatorModelConfigMemberBedrockEvaluatorModels:
		av := object.Key("bedrockEvaluatorModels")
		if err := awsRestjson1_serializeDocumentBedrockEvaluatorModels(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentExternalSource(v *types.ExternalSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ByteContent != nil {
		ok := object.Key("byteContent")
		if err := awsRestjson1_serializeDocumentByteContentDoc(v.ByteContent, ok); err != nil {
			return err
		}
	}

	if v.S3Location != nil {
		ok := object.Key("s3Location")
		if err := awsRestjson1_serializeDocumentS3ObjectDoc(v.S3Location, ok); err != nil {
			return err
		}
	}

	if len(v.SourceType) > 0 {
		ok := object.Key("sourceType")
		ok.String(string(v.SourceType))
	}

	return nil
}

func awsRestjson1_serializeDocumentExternalSources(v []types.ExternalSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentExternalSource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentExternalSourcesGenerationConfiguration(v *types.ExternalSourcesGenerationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalModelRequestFields != nil {
		ok := object.Key("additionalModelRequestFields")
		if err := awsRestjson1_serializeDocumentAdditionalModelRequestFields(v.AdditionalModelRequestFields, ok); err != nil {
			return err
		}
	}

	if v.GuardrailConfiguration != nil {
		ok := object.Key("guardrailConfiguration")
		if err := awsRestjson1_serializeDocumentGuardrailConfiguration(v.GuardrailConfiguration, ok); err != nil {
			return err
		}
	}

	if v.KbInferenceConfig != nil {
		ok := object.Key("kbInferenceConfig")
		if err := awsRestjson1_serializeDocumentKbInferenceConfig(v.KbInferenceConfig, ok); err != nil {
			return err
		}
	}

	if v.PromptTemplate != nil {
		ok := object.Key("promptTemplate")
		if err := awsRestjson1_serializeDocumentPromptTemplate(v.PromptTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExternalSourcesRetrieveAndGenerateConfiguration(v *types.ExternalSourcesRetrieveAndGenerateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GenerationConfiguration != nil {
		ok := object.Key("generationConfiguration")
		if err := awsRestjson1_serializeDocumentExternalSourcesGenerationConfiguration(v.GenerationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ModelArn != nil {
		ok := object.Key("modelArn")
		ok.String(*v.ModelArn)
	}

	if v.Sources != nil {
		ok := object.Key("sources")
		if err := awsRestjson1_serializeDocumentExternalSources(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterAttribute(v *types.FilterAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentFilterValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterValue(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentGenerationConfiguration(v *types.GenerationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalModelRequestFields != nil {
		ok := object.Key("additionalModelRequestFields")
		if err := awsRestjson1_serializeDocumentAdditionalModelRequestFields(v.AdditionalModelRequestFields, ok); err != nil {
			return err
		}
	}

	if v.GuardrailConfiguration != nil {
		ok := object.Key("guardrailConfiguration")
		if err := awsRestjson1_serializeDocumentGuardrailConfiguration(v.GuardrailConfiguration, ok); err != nil {
			return err
		}
	}

	if v.KbInferenceConfig != nil {
		ok := object.Key("kbInferenceConfig")
		if err := awsRestjson1_serializeDocumentKbInferenceConfig(v.KbInferenceConfig, ok); err != nil {
			return err
		}
	}

	if v.PromptTemplate != nil {
		ok := object.Key("promptTemplate")
		if err := awsRestjson1_serializeDocumentPromptTemplate(v.PromptTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailConfiguration(v *types.GuardrailConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GuardrailId != nil {
		ok := object.Key("guardrailId")
		ok.String(*v.GuardrailId)
	}

	if v.GuardrailVersion != nil {
		ok := object.Key("guardrailVersion")
		ok.String(*v.GuardrailVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentFilterConfig(v *types.GuardrailContentFilterConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputAction) > 0 {
		ok := object.Key("inputAction")
		ok.String(string(v.InputAction))
	}

	if v.InputEnabled != nil {
		ok := object.Key("inputEnabled")
		ok.Boolean(*v.InputEnabled)
	}

	if v.InputModalities != nil {
		ok := object.Key("inputModalities")
		if err := awsRestjson1_serializeDocumentGuardrailModalities(v.InputModalities, ok); err != nil {
			return err
		}
	}

	if len(v.InputStrength) > 0 {
		ok := object.Key("inputStrength")
		ok.String(string(v.InputStrength))
	}

	if len(v.OutputAction) > 0 {
		ok := object.Key("outputAction")
		ok.String(string(v.OutputAction))
	}

	if v.OutputEnabled != nil {
		ok := object.Key("outputEnabled")
		ok.Boolean(*v.OutputEnabled)
	}

	if v.OutputModalities != nil {
		ok := object.Key("outputModalities")
		if err := awsRestjson1_serializeDocumentGuardrailModalities(v.OutputModalities, ok); err != nil {
			return err
		}
	}

	if len(v.OutputStrength) > 0 {
		ok := object.Key("outputStrength")
		ok.String(string(v.OutputStrength))
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentFiltersConfig(v []types.GuardrailContentFilterConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailContentFilterConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailContentPolicyConfig(v *types.GuardrailContentPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FiltersConfig != nil {
		ok := object.Key("filtersConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContentFiltersConfig(v.FiltersConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailContextualGroundingFilterConfig(v *types.GuardrailContextualGroundingFilterConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.Threshold != nil {
		ok := object.Key("threshold")
		switch {
		case math.IsNaN(*v.Threshold):
			ok.String("NaN")

		case math.IsInf(*v.Threshold, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Threshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Threshold)

		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailContextualGroundingFiltersConfig(v []types.GuardrailContextualGroundingFilterConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailContextualGroundingFilterConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailContextualGroundingPolicyConfig(v *types.GuardrailContextualGroundingPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FiltersConfig != nil {
		ok := object.Key("filtersConfig")
		if err := awsRestjson1_serializeDocumentGuardrailContextualGroundingFiltersConfig(v.FiltersConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailCrossRegionConfig(v *types.GuardrailCrossRegionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GuardrailProfileIdentifier != nil {
		ok := object.Key("guardrailProfileIdentifier")
		ok.String(*v.GuardrailProfileIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailManagedWordListsConfig(v []types.GuardrailManagedWordsConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailManagedWordsConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailManagedWordsConfig(v *types.GuardrailManagedWordsConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputAction) > 0 {
		ok := object.Key("inputAction")
		ok.String(string(v.InputAction))
	}

	if v.InputEnabled != nil {
		ok := object.Key("inputEnabled")
		ok.Boolean(*v.InputEnabled)
	}

	if len(v.OutputAction) > 0 {
		ok := object.Key("outputAction")
		ok.String(string(v.OutputAction))
	}

	if v.OutputEnabled != nil {
		ok := object.Key("outputEnabled")
		ok.Boolean(*v.OutputEnabled)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailModalities(v []types.GuardrailModality, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailPiiEntitiesConfig(v []types.GuardrailPiiEntityConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailPiiEntityConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailPiiEntityConfig(v *types.GuardrailPiiEntityConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if len(v.InputAction) > 0 {
		ok := object.Key("inputAction")
		ok.String(string(v.InputAction))
	}

	if v.InputEnabled != nil {
		ok := object.Key("inputEnabled")
		ok.Boolean(*v.InputEnabled)
	}

	if len(v.OutputAction) > 0 {
		ok := object.Key("outputAction")
		ok.String(string(v.OutputAction))
	}

	if v.OutputEnabled != nil {
		ok := object.Key("outputEnabled")
		ok.Boolean(*v.OutputEnabled)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailRegexConfig(v *types.GuardrailRegexConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if len(v.InputAction) > 0 {
		ok := object.Key("inputAction")
		ok.String(string(v.InputAction))
	}

	if v.InputEnabled != nil {
		ok := object.Key("inputEnabled")
		ok.Boolean(*v.InputEnabled)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.OutputAction) > 0 {
		ok := object.Key("outputAction")
		ok.String(string(v.OutputAction))
	}

	if v.OutputEnabled != nil {
		ok := object.Key("outputEnabled")
		ok.Boolean(*v.OutputEnabled)
	}

	if v.Pattern != nil {
		ok := object.Key("pattern")
		ok.String(*v.Pattern)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailRegexesConfig(v []types.GuardrailRegexConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailRegexConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailSensitiveInformationPolicyConfig(v *types.GuardrailSensitiveInformationPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PiiEntitiesConfig != nil {
		ok := object.Key("piiEntitiesConfig")
		if err := awsRestjson1_serializeDocumentGuardrailPiiEntitiesConfig(v.PiiEntitiesConfig, ok); err != nil {
			return err
		}
	}

	if v.RegexesConfig != nil {
		ok := object.Key("regexesConfig")
		if err := awsRestjson1_serializeDocumentGuardrailRegexesConfig(v.RegexesConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicConfig(v *types.GuardrailTopicConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		ok.String(*v.Definition)
	}

	if v.Examples != nil {
		ok := object.Key("examples")
		if err := awsRestjson1_serializeDocumentGuardrailTopicExamples(v.Examples, ok); err != nil {
			return err
		}
	}

	if len(v.InputAction) > 0 {
		ok := object.Key("inputAction")
		ok.String(string(v.InputAction))
	}

	if v.InputEnabled != nil {
		ok := object.Key("inputEnabled")
		ok.Boolean(*v.InputEnabled)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.OutputAction) > 0 {
		ok := object.Key("outputAction")
		ok.String(string(v.OutputAction))
	}

	if v.OutputEnabled != nil {
		ok := object.Key("outputEnabled")
		ok.Boolean(*v.OutputEnabled)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicExamples(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicPolicyConfig(v *types.GuardrailTopicPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TopicsConfig != nil {
		ok := object.Key("topicsConfig")
		if err := awsRestjson1_serializeDocumentGuardrailTopicsConfig(v.TopicsConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailTopicsConfig(v []types.GuardrailTopicConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailTopicConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGuardrailWordConfig(v *types.GuardrailWordConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InputAction) > 0 {
		ok := object.Key("inputAction")
		ok.String(string(v.InputAction))
	}

	if v.InputEnabled != nil {
		ok := object.Key("inputEnabled")
		ok.Boolean(*v.InputEnabled)
	}

	if len(v.OutputAction) > 0 {
		ok := object.Key("outputAction")
		ok.String(string(v.OutputAction))
	}

	if v.OutputEnabled != nil {
		ok := object.Key("outputEnabled")
		ok.Boolean(*v.OutputEnabled)
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailWordPolicyConfig(v *types.GuardrailWordPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManagedWordListsConfig != nil {
		ok := object.Key("managedWordListsConfig")
		if err := awsRestjson1_serializeDocumentGuardrailManagedWordListsConfig(v.ManagedWordListsConfig, ok); err != nil {
			return err
		}
	}

	if v.WordsConfig != nil {
		ok := object.Key("wordsConfig")
		if err := awsRestjson1_serializeDocumentGuardrailWordsConfig(v.WordsConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGuardrailWordsConfig(v []types.GuardrailWordConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGuardrailWordConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHumanEvaluationConfig(v *types.HumanEvaluationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomMetrics != nil {
		ok := object.Key("customMetrics")
		if err := awsRestjson1_serializeDocumentHumanEvaluationCustomMetrics(v.CustomMetrics, ok); err != nil {
			return err
		}
	}

	if v.DatasetMetricConfigs != nil {
		ok := object.Key("datasetMetricConfigs")
		if err := awsRestjson1_serializeDocumentEvaluationDatasetMetricConfigs(v.DatasetMetricConfigs, ok); err != nil {
			return err
		}
	}

	if v.HumanWorkflowConfig != nil {
		ok := object.Key("humanWorkflowConfig")
		if err := awsRestjson1_serializeDocumentHumanWorkflowConfig(v.HumanWorkflowConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHumanEvaluationCustomMetric(v *types.HumanEvaluationCustomMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RatingMethod != nil {
		ok := object.Key("ratingMethod")
		ok.String(*v.RatingMethod)
	}

	return nil
}

func awsRestjson1_serializeDocumentHumanEvaluationCustomMetrics(v []types.HumanEvaluationCustomMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHumanEvaluationCustomMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentHumanWorkflowConfig(v *types.HumanWorkflowConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowDefinitionArn != nil {
		ok := object.Key("flowDefinitionArn")
		ok.String(*v.FlowDefinitionArn)
	}

	if v.Instructions != nil {
		ok := object.Key("instructions")
		ok.String(*v.Instructions)
	}

	return nil
}

func awsRestjson1_serializeDocumentInferenceProfileModelSource(v types.InferenceProfileModelSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.InferenceProfileModelSourceMemberCopyFrom:
		av := object.Key("copyFrom")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentInvocationLogsConfig(v *types.InvocationLogsConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InvocationLogSource != nil {
		ok := object.Key("invocationLogSource")
		if err := awsRestjson1_serializeDocumentInvocationLogSource(v.InvocationLogSource, ok); err != nil {
			return err
		}
	}

	if v.RequestMetadataFilters != nil {
		ok := object.Key("requestMetadataFilters")
		if err := awsRestjson1_serializeDocumentRequestMetadataFilters(v.RequestMetadataFilters, ok); err != nil {
			return err
		}
	}

	if v.UsePromptResponse {
		ok := object.Key("usePromptResponse")
		ok.Boolean(v.UsePromptResponse)
	}

	return nil
}

func awsRestjson1_serializeDocumentInvocationLogSource(v types.InvocationLogSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.InvocationLogSourceMemberS3Uri:
		av := object.Key("s3Uri")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentKbInferenceConfig(v *types.KbInferenceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TextInferenceConfig != nil {
		ok := object.Key("textInferenceConfig")
		if err := awsRestjson1_serializeDocumentTextInferenceConfig(v.TextInferenceConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKnowledgeBaseConfig(v types.KnowledgeBaseConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.KnowledgeBaseConfigMemberRetrieveAndGenerateConfig:
		av := object.Key("retrieveAndGenerateConfig")
		if err := awsRestjson1_serializeDocumentRetrieveAndGenerateConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.KnowledgeBaseConfigMemberRetrieveConfig:
		av := object.Key("retrieveConfig")
		if err := awsRestjson1_serializeDocumentRetrieveConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentKnowledgeBaseRetrievalConfiguration(v *types.KnowledgeBaseRetrievalConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VectorSearchConfiguration != nil {
		ok := object.Key("vectorSearchConfiguration")
		if err := awsRestjson1_serializeDocumentKnowledgeBaseVectorSearchConfiguration(v.VectorSearchConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKnowledgeBaseRetrieveAndGenerateConfiguration(v *types.KnowledgeBaseRetrieveAndGenerateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GenerationConfiguration != nil {
		ok := object.Key("generationConfiguration")
		if err := awsRestjson1_serializeDocumentGenerationConfiguration(v.GenerationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.KnowledgeBaseId != nil {
		ok := object.Key("knowledgeBaseId")
		ok.String(*v.KnowledgeBaseId)
	}

	if v.ModelArn != nil {
		ok := object.Key("modelArn")
		ok.String(*v.ModelArn)
	}

	if v.OrchestrationConfiguration != nil {
		ok := object.Key("orchestrationConfiguration")
		if err := awsRestjson1_serializeDocumentOrchestrationConfiguration(v.OrchestrationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetrievalConfiguration != nil {
		ok := object.Key("retrievalConfiguration")
		if err := awsRestjson1_serializeDocumentKnowledgeBaseRetrievalConfiguration(v.RetrievalConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKnowledgeBaseVectorSearchConfiguration(v *types.KnowledgeBaseVectorSearchConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsRestjson1_serializeDocumentRetrievalFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.NumberOfResults != nil {
		ok := object.Key("numberOfResults")
		ok.Integer(*v.NumberOfResults)
	}

	if len(v.OverrideSearchType) > 0 {
		ok := object.Key("overrideSearchType")
		ok.String(string(v.OverrideSearchType))
	}

	return nil
}

func awsRestjson1_serializeDocumentLoggingConfig(v *types.LoggingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchConfig != nil {
		ok := object.Key("cloudWatchConfig")
		if err := awsRestjson1_serializeDocumentCloudWatchConfig(v.CloudWatchConfig, ok); err != nil {
			return err
		}
	}

	if v.EmbeddingDataDeliveryEnabled != nil {
		ok := object.Key("embeddingDataDeliveryEnabled")
		ok.Boolean(*v.EmbeddingDataDeliveryEnabled)
	}

	if v.ImageDataDeliveryEnabled != nil {
		ok := object.Key("imageDataDeliveryEnabled")
		ok.Boolean(*v.ImageDataDeliveryEnabled)
	}

	if v.S3Config != nil {
		ok := object.Key("s3Config")
		if err := awsRestjson1_serializeDocumentS3Config(v.S3Config, ok); err != nil {
			return err
		}
	}

	if v.TextDataDeliveryEnabled != nil {
		ok := object.Key("textDataDeliveryEnabled")
		ok.Boolean(*v.TextDataDeliveryEnabled)
	}

	if v.VideoDataDeliveryEnabled != nil {
		ok := object.Key("videoDataDeliveryEnabled")
		ok.Boolean(*v.VideoDataDeliveryEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentModelCustomizationHyperParameters(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentModelDataSource(v types.ModelDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ModelDataSourceMemberS3DataSource:
		av := object.Key("s3DataSource")
		if err := awsRestjson1_serializeDocumentS3DataSource(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentModelInvocationJobInputDataConfig(v types.ModelInvocationJobInputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ModelInvocationJobInputDataConfigMemberS3InputDataConfig:
		av := object.Key("s3InputDataConfig")
		if err := awsRestjson1_serializeDocumentModelInvocationJobS3InputDataConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentModelInvocationJobOutputDataConfig(v types.ModelInvocationJobOutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ModelInvocationJobOutputDataConfigMemberS3OutputDataConfig:
		av := object.Key("s3OutputDataConfig")
		if err := awsRestjson1_serializeDocumentModelInvocationJobS3OutputDataConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentModelInvocationJobS3InputDataConfig(v *types.ModelInvocationJobS3InputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3BucketOwner != nil {
		ok := object.Key("s3BucketOwner")
		ok.String(*v.S3BucketOwner)
	}

	if len(v.S3InputFormat) > 0 {
		ok := object.Key("s3InputFormat")
		ok.String(string(v.S3InputFormat))
	}

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentModelInvocationJobS3OutputDataConfig(v *types.ModelInvocationJobS3OutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3BucketOwner != nil {
		ok := object.Key("s3BucketOwner")
		ok.String(*v.S3BucketOwner)
	}

	if v.S3EncryptionKeyId != nil {
		ok := object.Key("s3EncryptionKeyId")
		ok.String(*v.S3EncryptionKeyId)
	}

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentOrchestrationConfiguration(v *types.OrchestrationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QueryTransformationConfiguration != nil {
		ok := object.Key("queryTransformationConfiguration")
		if err := awsRestjson1_serializeDocumentQueryTransformationConfiguration(v.QueryTransformationConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputDataConfig(v *types.OutputDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentPerformanceConfiguration(v *types.PerformanceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Latency) > 0 {
		ok := object.Key("latency")
		ok.String(string(v.Latency))
	}

	return nil
}

func awsRestjson1_serializeDocumentPromptRouterTargetModel(v *types.PromptRouterTargetModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelArn != nil {
		ok := object.Key("modelArn")
		ok.String(*v.ModelArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentPromptRouterTargetModels(v []types.PromptRouterTargetModel, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPromptRouterTargetModel(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPromptTemplate(v *types.PromptTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TextPromptTemplate != nil {
		ok := object.Key("textPromptTemplate")
		ok.String(*v.TextPromptTemplate)
	}

	return nil
}

func awsRestjson1_serializeDocumentQueryTransformationConfiguration(v *types.QueryTransformationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentRAGConfig(v types.RAGConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RAGConfigMemberKnowledgeBaseConfig:
		av := object.Key("knowledgeBaseConfig")
		if err := awsRestjson1_serializeDocumentKnowledgeBaseConfig(uv.Value, av); err != nil {
			return err
		}

	case *types.RAGConfigMemberPrecomputedRagSourceConfig:
		av := object.Key("precomputedRagSourceConfig")
		if err := awsRestjson1_serializeDocumentEvaluationPrecomputedRagSourceConfig(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRagConfigs(v []types.RAGConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentRAGConfig(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRAGStopSequences(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRatingScale(v []types.RatingScaleItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRatingScaleItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRatingScaleItem(v *types.RatingScaleItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		ok.String(*v.Definition)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentRatingScaleItemValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRatingScaleItemValue(v types.RatingScaleItemValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RatingScaleItemValueMemberFloatValue:
		av := object.Key("floatValue")
		switch {
		case math.IsNaN(float64(uv.Value)):
			av.String("NaN")

		case math.IsInf(float64(uv.Value), 1):
			av.String("Infinity")

		case math.IsInf(float64(uv.Value), -1):
			av.String("-Infinity")

		default:
			av.Float(uv.Value)

		}

	case *types.RatingScaleItemValueMemberStringValue:
		av := object.Key("stringValue")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRequestMetadataBaseFilters(v *types.RequestMetadataBaseFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Equals != nil {
		ok := object.Key("equals")
		if err := awsRestjson1_serializeDocumentRequestMetadataMap(v.Equals, ok); err != nil {
			return err
		}
	}

	if v.NotEquals != nil {
		ok := object.Key("notEquals")
		if err := awsRestjson1_serializeDocumentRequestMetadataMap(v.NotEquals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestMetadataFilters(v types.RequestMetadataFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RequestMetadataFiltersMemberAndAll:
		av := object.Key("andAll")
		if err := awsRestjson1_serializeDocumentRequestMetadataFiltersList(uv.Value, av); err != nil {
			return err
		}

	case *types.RequestMetadataFiltersMemberEquals:
		av := object.Key("equals")
		if err := awsRestjson1_serializeDocumentRequestMetadataMap(uv.Value, av); err != nil {
			return err
		}

	case *types.RequestMetadataFiltersMemberNotEquals:
		av := object.Key("notEquals")
		if err := awsRestjson1_serializeDocumentRequestMetadataMap(uv.Value, av); err != nil {
			return err
		}

	case *types.RequestMetadataFiltersMemberOrAll:
		av := object.Key("orAll")
		if err := awsRestjson1_serializeDocumentRequestMetadataFiltersList(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRequestMetadataFiltersList(v []types.RequestMetadataBaseFilters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRequestMetadataBaseFilters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRequestMetadataMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentRetrievalFilter(v types.RetrievalFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RetrievalFilterMemberAndAll:
		av := object.Key("andAll")
		if err := awsRestjson1_serializeDocumentRetrievalFilterList(uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberEquals:
		av := object.Key("equals")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberGreaterThan:
		av := object.Key("greaterThan")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberGreaterThanOrEquals:
		av := object.Key("greaterThanOrEquals")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberIn:
		av := object.Key("in")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberLessThan:
		av := object.Key("lessThan")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberLessThanOrEquals:
		av := object.Key("lessThanOrEquals")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberListContains:
		av := object.Key("listContains")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberNotEquals:
		av := object.Key("notEquals")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberNotIn:
		av := object.Key("notIn")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberOrAll:
		av := object.Key("orAll")
		if err := awsRestjson1_serializeDocumentRetrievalFilterList(uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberStartsWith:
		av := object.Key("startsWith")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrievalFilterMemberStringContains:
		av := object.Key("stringContains")
		if err := awsRestjson1_serializeDocumentFilterAttribute(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRetrievalFilterList(v []types.RetrievalFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentRetrievalFilter(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRetrieveAndGenerateConfiguration(v *types.RetrieveAndGenerateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExternalSourcesConfiguration != nil {
		ok := object.Key("externalSourcesConfiguration")
		if err := awsRestjson1_serializeDocumentExternalSourcesRetrieveAndGenerateConfiguration(v.ExternalSourcesConfiguration, ok); err != nil {
			return err
		}
	}

	if v.KnowledgeBaseConfiguration != nil {
		ok := object.Key("knowledgeBaseConfiguration")
		if err := awsRestjson1_serializeDocumentKnowledgeBaseRetrieveAndGenerateConfiguration(v.KnowledgeBaseConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentRetrieveConfig(v *types.RetrieveConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KnowledgeBaseId != nil {
		ok := object.Key("knowledgeBaseId")
		ok.String(*v.KnowledgeBaseId)
	}

	if v.KnowledgeBaseRetrievalConfiguration != nil {
		ok := object.Key("knowledgeBaseRetrievalConfiguration")
		if err := awsRestjson1_serializeDocumentKnowledgeBaseRetrievalConfiguration(v.KnowledgeBaseRetrievalConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRoutingCriteria(v *types.RoutingCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResponseQualityDifference != nil {
		ok := object.Key("responseQualityDifference")
		switch {
		case math.IsNaN(*v.ResponseQualityDifference):
			ok.String("NaN")

		case math.IsInf(*v.ResponseQualityDifference, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ResponseQualityDifference, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ResponseQualityDifference)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Config(v *types.S3Config, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.KeyPrefix != nil {
		ok := object.Key("keyPrefix")
		ok.String(*v.KeyPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3DataSource(v *types.S3DataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3ObjectDoc(v *types.S3ObjectDoc, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Uri != nil {
		ok := object.Key("uri")
		ok.String(*v.Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentSageMakerEndpoint(v *types.SageMakerEndpoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionRole != nil {
		ok := object.Key("executionRole")
		ok.String(*v.ExecutionRole)
	}

	if v.InitialInstanceCount != nil {
		ok := object.Key("initialInstanceCount")
		ok.Integer(*v.InitialInstanceCount)
	}

	if v.InstanceType != nil {
		ok := object.Key("instanceType")
		ok.String(*v.InstanceType)
	}

	if v.KmsEncryptionKey != nil {
		ok := object.Key("kmsEncryptionKey")
		ok.String(*v.KmsEncryptionKey)
	}

	if v.Vpc != nil {
		ok := object.Key("vpc")
		if err := awsRestjson1_serializeDocumentVpcConfig(v.Vpc, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTeacherModelConfig(v *types.TeacherModelConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResponseLengthForInference != nil {
		ok := object.Key("maxResponseLengthForInference")
		ok.Integer(*v.MaxResponseLengthForInference)
	}

	if v.TeacherModelIdentifier != nil {
		ok := object.Key("teacherModelIdentifier")
		ok.String(*v.TeacherModelIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentTextInferenceConfig(v *types.TextInferenceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxTokens != nil {
		ok := object.Key("maxTokens")
		ok.Integer(*v.MaxTokens)
	}

	if v.StopSequences != nil {
		ok := object.Key("stopSequences")
		if err := awsRestjson1_serializeDocumentRAGStopSequences(v.StopSequences, ok); err != nil {
			return err
		}
	}

	if v.Temperature != nil {
		ok := object.Key("temperature")
		switch {
		case math.IsNaN(float64(*v.Temperature)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Temperature), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Temperature), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Temperature)

		}
	}

	if v.TopP != nil {
		ok := object.Key("topP")
		switch {
		case math.IsNaN(float64(*v.TopP)):
			ok.String("NaN")

		case math.IsInf(float64(*v.TopP), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.TopP), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.TopP)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainingDataConfig(v *types.TrainingDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InvocationLogsConfig != nil {
		ok := object.Key("invocationLogsConfig")
		if err := awsRestjson1_serializeDocumentInvocationLogsConfig(v.InvocationLogsConfig, ok); err != nil {
			return err
		}
	}

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentValidationDataConfig(v *types.ValidationDataConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Validators != nil {
		ok := object.Key("validators")
		if err := awsRestjson1_serializeDocumentValidators(v.Validators, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentValidator(v *types.Validator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentValidators(v []types.Validator, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentValidator(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVpcConfig(v *types.VpcConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}
