// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Modifies a flow. Include both fields that you want to keep and fields that you
// want to change. For more information, see [How it works]and [Create a flow in Amazon Bedrock] in the Amazon Bedrock User Guide.
//
// [How it works]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html
// [Create a flow in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html
func (c *Client) UpdateFlow(ctx context.Context, params *UpdateFlowInput, optFns ...func(*Options)) (*UpdateFlowOutput, error) {
	if params == nil {
		params = &UpdateFlowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateFlow", params, optFns, c.addOperationUpdateFlowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateFlowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateFlowInput struct {

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	// [Create a service role for flows in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html
	//
	// This member is required.
	ExecutionRoleArn *string

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowIdentifier *string

	// A name for the flow.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
	CustomerEncryptionKeyArn *string

	// A definition of the nodes and the connections between the nodes in the flow.
	Definition *types.FlowDefinition

	// A description for the flow.
	Description *string

	noSmithyDocumentSerde
}

type UpdateFlowOutput struct {

	// The Amazon Resource Name (ARN) of the flow.
	//
	// This member is required.
	Arn *string

	// The time at which the flow was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the service role with permissions to create a
	// flow. For more information, see [Create a service role for flows in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	// [Create a service role for flows in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html
	//
	// This member is required.
	ExecutionRoleArn *string

	// The unique identifier of the flow.
	//
	// This member is required.
	Id *string

	// The name of the flow.
	//
	// This member is required.
	Name *string

	// The status of the flow. When you submit this request, the status will be
	// NotPrepared . If updating fails, the status becomes Failed .
	//
	// This member is required.
	Status types.FlowStatus

	// The time at which the flow was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the flow. When you update a flow, the version updated is the
	// DRAFT version.
	//
	// This member is required.
	Version *string

	// The Amazon Resource Name (ARN) of the KMS key that the flow was encrypted with.
	CustomerEncryptionKeyArn *string

	// A definition of the nodes and the connections between nodes in the flow.
	Definition *types.FlowDefinition

	// The description of the flow.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateFlowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateFlow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateFlow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateFlow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateFlowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateFlow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateFlow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateFlow",
	}
}
