// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about a specific ML input channel in a collaboration.
func (c *Client) GetCollaborationMLInputChannel(ctx context.Context, params *GetCollaborationMLInputChannelInput, optFns ...func(*Options)) (*GetCollaborationMLInputChannelOutput, error) {
	if params == nil {
		params = &GetCollaborationMLInputChannelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCollaborationMLInputChannel", params, optFns, c.addOperationGetCollaborationMLInputChannelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCollaborationMLInputChannelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCollaborationMLInputChannelInput struct {

	// The collaboration ID of the collaboration that contains the ML input channel
	// that you want to get.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The Amazon Resource Name (ARN) of the ML input channel that you want to get.
	//
	// This member is required.
	MlInputChannelArn *string

	noSmithyDocumentSerde
}

type GetCollaborationMLInputChannelOutput struct {

	// The collaboration ID of the collaboration that contains the ML input channel.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The configured model algorithm associations that were used to create the ML
	// input channel.
	//
	// This member is required.
	ConfiguredModelAlgorithmAssociations []string

	// The time at which the ML input channel was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The account ID of the member who created the ML input channel.
	//
	// This member is required.
	CreatorAccountId *string

	// The membership ID of the membership that contains the ML input channel.
	//
	// This member is required.
	MembershipIdentifier *string

	// The Amazon Resource Name (ARN) of the ML input channel.
	//
	// This member is required.
	MlInputChannelArn *string

	// The name of the ML input channel.
	//
	// This member is required.
	Name *string

	// The number of days to retain the data for the ML input channel.
	//
	// This member is required.
	RetentionInDays *int32

	// The status of the ML input channel.
	//
	// This member is required.
	Status types.MLInputChannelStatus

	// The most recent time at which the ML input channel was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the ML input channel.
	Description *string

	// The number of records in the ML input channel.
	NumberOfRecords *int64

	// Details about the status of a resource.
	StatusDetails *types.StatusDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCollaborationMLInputChannelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCollaborationMLInputChannel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCollaborationMLInputChannel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCollaborationMLInputChannel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCollaborationMLInputChannelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCollaborationMLInputChannel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCollaborationMLInputChannel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCollaborationMLInputChannel",
	}
}
