// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the stack refactor actions that will be taken after calling the ExecuteStackRefactor action.
func (c *Client) ListStackRefactorActions(ctx context.Context, params *ListStackRefactorActionsInput, optFns ...func(*Options)) (*ListStackRefactorActionsOutput, error) {
	if params == nil {
		params = &ListStackRefactorActionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListStackRefactorActions", params, optFns, c.addOperationListStackRefactorActionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListStackRefactorActionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListStackRefactorActionsInput struct {

	// The ID associated with the stack refactor created from the CreateStackRefactor action.
	//
	// This member is required.
	StackRefactorId *string

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int32

	// If the request doesn't return all the remaining results, NextToken is set to a
	// token. To retrieve the next set of results, call this action again and assign
	// that token to the request object's NextToken parameter. If the request returns
	// all results, NextToken is set to null .
	NextToken *string

	noSmithyDocumentSerde
}

type ListStackRefactorActionsOutput struct {

	// The stack refactor actions.
	//
	// This member is required.
	StackRefactorActions []types.StackRefactorAction

	// If the request doesn't return all the remaining results, NextToken is set to a
	// token. To retrieve the next set of results, call this action again and assign
	// that token to the request object's NextToken parameter. If the request returns
	// all results, NextToken is set to null .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListStackRefactorActionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpListStackRefactorActions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpListStackRefactorActions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListStackRefactorActions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListStackRefactorActionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListStackRefactorActions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListStackRefactorActionsPaginatorOptions is the paginator options for
// ListStackRefactorActions
type ListStackRefactorActionsPaginatorOptions struct {
	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListStackRefactorActionsPaginator is a paginator for ListStackRefactorActions
type ListStackRefactorActionsPaginator struct {
	options   ListStackRefactorActionsPaginatorOptions
	client    ListStackRefactorActionsAPIClient
	params    *ListStackRefactorActionsInput
	nextToken *string
	firstPage bool
}

// NewListStackRefactorActionsPaginator returns a new
// ListStackRefactorActionsPaginator
func NewListStackRefactorActionsPaginator(client ListStackRefactorActionsAPIClient, params *ListStackRefactorActionsInput, optFns ...func(*ListStackRefactorActionsPaginatorOptions)) *ListStackRefactorActionsPaginator {
	if params == nil {
		params = &ListStackRefactorActionsInput{}
	}

	options := ListStackRefactorActionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListStackRefactorActionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListStackRefactorActionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListStackRefactorActions page.
func (p *ListStackRefactorActionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListStackRefactorActionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListStackRefactorActions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListStackRefactorActionsAPIClient is a client that implements the
// ListStackRefactorActions operation.
type ListStackRefactorActionsAPIClient interface {
	ListStackRefactorActions(context.Context, *ListStackRefactorActionsInput, ...func(*Options)) (*ListStackRefactorActionsOutput, error)
}

var _ ListStackRefactorActionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListStackRefactorActions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListStackRefactorActions",
	}
}
