// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the connection groups in your Amazon Web Services account.
func (c *Client) ListConnectionGroups(ctx context.Context, params *ListConnectionGroupsInput, optFns ...func(*Options)) (*ListConnectionGroupsOutput, error) {
	if params == nil {
		params = &ListConnectionGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConnectionGroups", params, optFns, c.addOperationListConnectionGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConnectionGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConnectionGroupsInput struct {

	// Filter by associated Anycast IP list ID.
	AssociationFilter *types.ConnectionGroupAssociationFilter

	// The marker for the next set of connection groups to retrieve.
	Marker *string

	// The maximum number of connection groups to return.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListConnectionGroupsOutput struct {

	// The list of connection groups that you retrieved.
	ConnectionGroups []types.ConnectionGroupSummary

	// A token used for pagination of results returned in the response. You can use
	// the token from the previous request to define where the current request should
	// begin.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConnectionGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListConnectionGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListConnectionGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConnectionGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConnectionGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListConnectionGroupsPaginatorOptions is the paginator options for
// ListConnectionGroups
type ListConnectionGroupsPaginatorOptions struct {
	// The maximum number of connection groups to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConnectionGroupsPaginator is a paginator for ListConnectionGroups
type ListConnectionGroupsPaginator struct {
	options   ListConnectionGroupsPaginatorOptions
	client    ListConnectionGroupsAPIClient
	params    *ListConnectionGroupsInput
	nextToken *string
	firstPage bool
}

// NewListConnectionGroupsPaginator returns a new ListConnectionGroupsPaginator
func NewListConnectionGroupsPaginator(client ListConnectionGroupsAPIClient, params *ListConnectionGroupsInput, optFns ...func(*ListConnectionGroupsPaginatorOptions)) *ListConnectionGroupsPaginator {
	if params == nil {
		params = &ListConnectionGroupsInput{}
	}

	options := ListConnectionGroupsPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConnectionGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConnectionGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConnectionGroups page.
func (p *ListConnectionGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConnectionGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConnectionGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConnectionGroupsAPIClient is a client that implements the
// ListConnectionGroups operation.
type ListConnectionGroupsAPIClient interface {
	ListConnectionGroups(context.Context, *ListConnectionGroupsInput, ...func(*Options)) (*ListConnectionGroupsOutput, error)
}

var _ ListConnectionGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConnectionGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConnectionGroups",
	}
}
