// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// For [PutServiceLinkedConfigurationRecorder], you cannot create a service-linked recorder because a service-linked
// recorder already exists for the specified service.
//
// For [DeleteServiceLinkedConfigurationRecorder], you cannot delete the service-linked recorder because it is currently in
// use by the linked Amazon Web Services service.
//
// For [DeleteDeliveryChannel], you cannot delete the specified delivery channel because the customer
// managed configuration recorder is running. Use the [StopConfigurationRecorder]operation to stop the
// customer managed configuration recorder.
//
// For [AssociateResourceTypes] and [DisassociateResourceTypes], one of the following errors:
//
//   - For service-linked configuration recorders, the configuration recorder is
//     not in use by the service. No association or dissociation of resource types is
//     permitted.
//
//   - For service-linked configuration recorders, your requested change to the
//     configuration recorder has been denied by its linked Amazon Web Services
//     service.
//
// [PutServiceLinkedConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html
// [DisassociateResourceTypes]: https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html
// [DeleteServiceLinkedConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html
// [StopConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html
// [AssociateResourceTypes]: https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html
// [DeleteDeliveryChannel]: https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html
type ConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConflictException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have specified a template that is not valid or supported.
type ConformancePackTemplateValidationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConformancePackTemplateValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConformancePackTemplateValidationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConformancePackTemplateValidationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConformancePackTemplateValidationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Using the same client token with one or more different parameters. Specify a
// new client token with the parameter changes and try again.
type IdempotentParameterMismatch struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IdempotentParameterMismatch) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotentParameterMismatch) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotentParameterMismatch) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IdempotentParameterMismatch"
	}
	return *e.ErrorCodeOverride
}
func (e *IdempotentParameterMismatch) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your Amazon S3 bucket policy does not allow Config to write to it.
type InsufficientDeliveryPolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientDeliveryPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientDeliveryPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientDeliveryPolicyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientDeliveryPolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientDeliveryPolicyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Indicates one of the following errors:
//
//   - For [PutConfigRule], the rule cannot be created because the IAM role assigned to Config
//     lacks permissions to perform the config:Put* action.
//
//   - For [PutConfigRule], the Lambda function cannot be invoked. Check the function ARN, and
//     check the function's permissions.
//
//   - For [PutOrganizationConfigRule], organization Config rule cannot be created because you do not have
//     permissions to call IAM GetRole action or create a service-linked role.
//
//   - For [PutConformancePack]and [PutOrganizationConformancePack], a conformance pack cannot be created because you do not have the
//     following permissions:
//
//   - You do not have permission to call IAM GetRole action or create a
//     service-linked role.
//
//   - You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
//
//   - For [PutServiceLinkedConfigurationRecorder], a service-linked configuration recorder cannot be created because you
//     do not have the following permissions: IAM CreateServiceLinkedRole .
//
// [PutOrganizationConfigRule]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html
// [PutServiceLinkedConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html
// [PutConfigRule]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html
// [PutConformancePack]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html
// [PutOrganizationConformancePack]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html
type InsufficientPermissionsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientPermissionsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientPermissionsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientPermissionsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientPermissionsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientPermissionsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have provided a name for the customer managed configuration recorder that
// is not valid.
type InvalidConfigurationRecorderNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidConfigurationRecorderNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidConfigurationRecorderNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidConfigurationRecorderNameException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidConfigurationRecorderNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidConfigurationRecorderNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified delivery channel name is not valid.
type InvalidDeliveryChannelNameException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDeliveryChannelNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeliveryChannelNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeliveryChannelNameException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDeliveryChannelNameException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDeliveryChannelNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The syntax of the query is incorrect.
type InvalidExpressionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidExpressionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidExpressionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidExpressionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidExpressionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidExpressionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified limit is outside the allowable range.
type InvalidLimitException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidLimitException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLimitException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLimitException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidLimitException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidLimitException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified next token is not valid. Specify the nextToken string that was
// returned in the previous response to get the next page of results.
type InvalidNextTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextTokenException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidNextTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNextTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more of the specified parameters are not valid. Verify that your
// parameters are valid and try again.
type InvalidParameterValueException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterValueException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterValueException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterValueException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One of the following errors:
//
//   - You have provided a combination of parameter values that is not valid. For
//     example:
//
//   - Setting the allSupported field of [RecordingGroup]to true , but providing a non-empty list
//     for the resourceTypes field of [RecordingGroup].
//
//   - Setting the allSupported field of [RecordingGroup]to true , but also setting the useOnly
//     field of [RecordingStrategy]to EXCLUSION_BY_RESOURCE_TYPES .
//
//   - Every parameter is either null, false, or empty.
//
//   - You have reached the limit of the number of resource types you can provide
//     for the recording group.
//
//   - You have provided resource types or a recording strategy that are not valid.
//
// [RecordingStrategy]: https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html
// [RecordingGroup]: https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html
type InvalidRecordingGroupException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRecordingGroupException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRecordingGroupException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRecordingGroupException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRecordingGroupException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRecordingGroupException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified ResultToken is not valid.
type InvalidResultTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidResultTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResultTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResultTokenException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidResultTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidResultTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have provided a null or empty Amazon Resource Name (ARN) for the IAM role
// assumed by Config and used by the customer managed configuration recorder.
type InvalidRoleException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRoleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRoleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRoleException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRoleException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRoleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon S3 key prefix is not valid.
type InvalidS3KeyPrefixException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidS3KeyPrefixException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3KeyPrefixException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3KeyPrefixException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidS3KeyPrefixException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidS3KeyPrefixException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon KMS Key ARN is not valid.
type InvalidS3KmsKeyArnException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidS3KmsKeyArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3KmsKeyArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3KmsKeyArnException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidS3KmsKeyArnException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidS3KmsKeyArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon SNS topic does not exist.
type InvalidSNSTopicARNException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSNSTopicARNException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSNSTopicARNException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSNSTopicARNException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSNSTopicARNException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSNSTopicARNException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified time range is not valid. The earlier time is not chronologically
// before the later time.
type InvalidTimeRangeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidTimeRangeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTimeRangeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTimeRangeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidTimeRangeException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidTimeRangeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You cannot delete the delivery channel you specified because the customer
// managed configuration recorder is running.
type LastDeliveryChannelDeleteFailedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LastDeliveryChannelDeleteFailedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LastDeliveryChannelDeleteFailedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LastDeliveryChannelDeleteFailedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LastDeliveryChannelDeleteFailedException"
	}
	return *e.ErrorCodeOverride
}
func (e *LastDeliveryChannelDeleteFailedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// For PutServiceLinkedConfigurationRecorder API, this exception is thrown if the
// number of service-linked roles in the account exceeds the limit.
//
// For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
// is in progress or if you call the StartConfigRulesEvaluationAPI more than once per minute.
//
// For PutConfigurationAggregator API, this exception is thrown if the number of
// accounts and aggregators exceeds the limit.
type LimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the limit of active custom resource types in your account.
// There is a limit of 100,000. Delete unused resources using [DeleteResourceConfig].
//
// [DeleteResourceConfig]: https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteResourceConfig.html
type MaxActiveResourcesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxActiveResourcesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxActiveResourcesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxActiveResourcesExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxActiveResourcesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxActiveResourcesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Failed to add the Config rule because the account already contains the maximum
// number of 1000 rules. Consider deleting any deactivated rules before you add new
// rules.
type MaxNumberOfConfigRulesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfConfigRulesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfConfigRulesExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxNumberOfConfigRulesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxNumberOfConfigRulesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of configuration recorders you can
// create.
type MaxNumberOfConfigurationRecordersExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfConfigurationRecordersExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfConfigurationRecordersExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfConfigurationRecordersExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxNumberOfConfigurationRecordersExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxNumberOfConfigurationRecordersExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of conformance packs you can create in
// an account. For more information, see [Service Limits]in the Config Developer Guide.
//
// [Service Limits]: https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html
type MaxNumberOfConformancePacksExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfConformancePacksExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfConformancePacksExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxNumberOfConformancePacksExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxNumberOfConformancePacksExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of delivery channels you can create.
type MaxNumberOfDeliveryChannelsExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfDeliveryChannelsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfDeliveryChannelsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfDeliveryChannelsExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxNumberOfDeliveryChannelsExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxNumberOfDeliveryChannelsExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of organization Config rules you can
// create. For more information, see see [Service Limits]in the Config Developer Guide.
//
// [Service Limits]: https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html
type MaxNumberOfOrganizationConfigRulesExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfOrganizationConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfOrganizationConfigRulesExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfOrganizationConfigRulesExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxNumberOfOrganizationConfigRulesExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxNumberOfOrganizationConfigRulesExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the limit of the number of organization conformance packs you
// can create in an account. For more information, see [Service Limits]in the Config Developer
// Guide.
//
// [Service Limits]: https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html
type MaxNumberOfOrganizationConformancePacksExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfOrganizationConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfOrganizationConformancePacksExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfOrganizationConformancePacksExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxNumberOfOrganizationConformancePacksExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxNumberOfOrganizationConformancePacksExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Failed to add the retention configuration because a retention configuration
// with that name already exists.
type MaxNumberOfRetentionConfigurationsExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MaxNumberOfRetentionConfigurationsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MaxNumberOfRetentionConfigurationsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MaxNumberOfRetentionConfigurationsExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MaxNumberOfRetentionConfigurationsExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MaxNumberOfRetentionConfigurationsExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There are no customer managed configuration recorders available to record your
// resources. Use the [PutConfigurationRecorder]operation to create the customer managed configuration
// recorder.
//
// [PutConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html
type NoAvailableConfigurationRecorderException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoAvailableConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoAvailableConfigurationRecorderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoAvailableConfigurationRecorderException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoAvailableConfigurationRecorderException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoAvailableConfigurationRecorderException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is no delivery channel available to record configurations.
type NoAvailableDeliveryChannelException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoAvailableDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoAvailableDeliveryChannelException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoAvailableDeliveryChannelException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoAvailableDeliveryChannelException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoAvailableDeliveryChannelException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Organization is no longer available.
type NoAvailableOrganizationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoAvailableOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoAvailableOrganizationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoAvailableOrganizationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoAvailableOrganizationException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoAvailableOrganizationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There is no configuration recorder running.
type NoRunningConfigurationRecorderException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoRunningConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoRunningConfigurationRecorderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoRunningConfigurationRecorderException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoRunningConfigurationRecorderException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoRunningConfigurationRecorderException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified Amazon S3 bucket does not exist.
type NoSuchBucketException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchBucketException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchBucketException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchBucketException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchBucketException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchBucketException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Config rule in the request is not valid. Verify that the rule is an Config
// Process Check rule, that the rule name is correct, and that valid Amazon Resouce
// Names (ARNs) are used before trying again.
type NoSuchConfigRuleException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigRuleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigRuleException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchConfigRuleException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchConfigRuleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Config rule that you passed in the filter does not exist.
type NoSuchConfigRuleInConformancePackException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigRuleInConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigRuleInConformancePackException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigRuleInConformancePackException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchConfigRuleInConformancePackException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchConfigRuleInConformancePackException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a configuration aggregator that does not exist.
type NoSuchConfigurationAggregatorException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigurationAggregatorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigurationAggregatorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigurationAggregatorException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchConfigurationAggregatorException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchConfigurationAggregatorException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a configuration recorder that does not exist.
type NoSuchConfigurationRecorderException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConfigurationRecorderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConfigurationRecorderException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchConfigurationRecorderException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchConfigurationRecorderException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You specified one or more conformance packs that do not exist.
type NoSuchConformancePackException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchConformancePackException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchConformancePackException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchConformancePackException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchConformancePackException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have specified a delivery channel that does not exist.
type NoSuchDeliveryChannelException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchDeliveryChannelException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchDeliveryChannelException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchDeliveryChannelException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchDeliveryChannelException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Config rule in the request is not valid. Verify that the rule is an
// organization Config Process Check rule, that the rule name is correct, and that
// valid Amazon Resouce Names (ARNs) are used before trying again.
type NoSuchOrganizationConfigRuleException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchOrganizationConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOrganizationConfigRuleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOrganizationConfigRuleException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchOrganizationConfigRuleException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchOrganizationConfigRuleException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Config organization conformance pack that you passed in the filter does not
// exist.
//
// For DeleteOrganizationConformancePack, you tried to delete an organization
// conformance pack that does not exist.
type NoSuchOrganizationConformancePackException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchOrganizationConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchOrganizationConformancePackException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchOrganizationConformancePackException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchOrganizationConformancePackException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchOrganizationConformancePackException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You specified an Config rule without a remediation configuration.
type NoSuchRemediationConfigurationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchRemediationConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRemediationConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRemediationConfigurationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchRemediationConfigurationException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchRemediationConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You tried to delete a remediation exception that does not exist.
type NoSuchRemediationExceptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchRemediationExceptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRemediationExceptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRemediationExceptionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchRemediationExceptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchRemediationExceptionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a retention configuration that does not exist.
type NoSuchRetentionConfigurationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchRetentionConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchRetentionConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchRetentionConfigurationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoSuchRetentionConfigurationException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchRetentionConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// For PutConfigurationAggregator API, you can see this exception for the
// following reasons:
//
//   - No permission to call EnableAWSServiceAccess API
//
//   - The configuration aggregator cannot be updated because your Amazon Web
//     Services Organization management account or the delegated administrator role
//     changed. Delete this aggregator and create a new one with the current Amazon Web
//     Services Organization.
//
//   - The configuration aggregator is associated with a previous Amazon Web
//     Services Organization and Config cannot aggregate data with current Amazon Web
//     Services Organization. Delete this aggregator and create a new one with the
//     current Amazon Web Services Organization.
//
//   - You are not a registered delegated administrator for Config with
//     permissions to call ListDelegatedAdministrators API. Ensure that the
//     management account registers delagated administrator for Config service
//     principal name before the delegated administrator creates an aggregator.
//
// For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
// throws an exception if APIs are called from member accounts. All APIs must be
// called from organization management account.
type OrganizationAccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationAccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationAccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationAccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationAccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Config resource cannot be created because your organization does not have all
// features enabled.
type OrganizationAllFeaturesNotEnabledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationAllFeaturesNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationAllFeaturesNotEnabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationAllFeaturesNotEnabledException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationAllFeaturesNotEnabledException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationAllFeaturesNotEnabledException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have specified a template that is not valid or supported.
type OrganizationConformancePackTemplateValidationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationConformancePackTemplateValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationConformancePackTemplateValidationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationConformancePackTemplateValidationException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationConformancePackTemplateValidationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The configuration item size is outside the allowable range.
type OversizedConfigurationItemException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OversizedConfigurationItemException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OversizedConfigurationItemException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OversizedConfigurationItemException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OversizedConfigurationItemException"
	}
	return *e.ErrorCodeOverride
}
func (e *OversizedConfigurationItemException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Remediation action is in progress. You can either cancel execution in Amazon
// Web Services Systems Manager or wait and try again later.
type RemediationInProgressException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RemediationInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RemediationInProgressException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RemediationInProgressException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RemediationInProgressException"
	}
	return *e.ErrorCodeOverride
}
func (e *RemediationInProgressException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Two users are trying to modify the same query at the same time. Wait for a
// moment and try again.
type ResourceConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceConcurrentModificationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceConcurrentModificationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceConcurrentModificationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You see this exception in the following cases:
//
//   - For DeleteConfigRule, Config is deleting this rule. Try your request again
//     later.
//
//   - For DeleteConfigRule, the rule is deleting your evaluation results. Try
//     your request again later.
//
//   - For DeleteConfigRule, a remediation action is associated with the rule and
//     Config cannot delete this rule. Delete the remediation action associated with
//     the rule before deleting the rule and try your request again later.
//
//   - For PutConfigOrganizationRule, organization Config rule deletion is in
//     progress. Try your request again later.
//
//   - For DeleteOrganizationConfigRule, organization Config rule creation is in
//     progress. Try your request again later.
//
//   - For PutConformancePack and PutOrganizationConformancePack, a conformance
//     pack creation, update, and deletion is in progress. Try your request again
//     later.
//
//   - For DeleteConformancePack, a conformance pack creation, update, and
//     deletion is in progress. Try your request again later.
type ResourceInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have specified a resource that is either unknown or has not been discovered.
type ResourceNotDiscoveredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotDiscoveredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotDiscoveredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotDiscoveredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotDiscoveredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotDiscoveredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have specified a resource that does not exist.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have reached the limit of the number of tags you can use. For more
// information, see [Service Limits]in the Config Developer Guide.
//
// [Service Limits]: https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html
type TooManyTagsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTagsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation is not valid.
//
// For [PutConfigurationRecorder], you will see this exception because you cannot use this operation to
// create a service-linked configuration recorder. Use the [PutServiceLinkedConfigurationRecorder]operation to create a
// service-linked configuration recorder.
//
// For [DeleteConfigurationRecorder], you will see this exception because you cannot use this operation to
// delete a service-linked configuration recorder. Use the [DeleteServiceLinkedConfigurationRecorder]operation to delete a
// service-linked configuration recorder.
//
// For [StartConfigurationRecorder] and [StopConfigurationRecorder], you will see this exception because these operations do not affect
// service-linked configuration recorders. Service-linked configuration recorders
// are always recording. To stop recording, you must delete the service-linked
// configuration recorder. Use the [DeleteServiceLinkedConfigurationRecorder]operation to delete a service-linked
// configuration recorder.
//
// [PutServiceLinkedConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html
// [DeleteConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html
// [DeleteServiceLinkedConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html
// [StopConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html
// [StartConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html
// [PutConfigurationRecorder]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html
type UnmodifiableEntityException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnmodifiableEntityException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnmodifiableEntityException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnmodifiableEntityException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnmodifiableEntityException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnmodifiableEntityException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation is not valid. You will see this exception if there are
// missing required fields or if the input value fails the validation.
//
// For [PutStoredQuery], one of the following errors:
//
//   - There are missing required fields.
//
//   - The input value fails the validation.
//
//   - You are trying to create more than 300 queries.
//
// For [DescribeConfigurationRecorders] and [DescribeConfigurationRecorderStatus], one of the following errors:
//
//   - You have specified more than one configuration recorder.
//
//   - You have provided a service principal for service-linked configuration
//     recorder that is not valid.
//
// For [AssociateResourceTypes] and [DisassociateResourceTypes], one of the following errors:
//
//   - Your configuraiton recorder has a recording strategy that does not allow
//     the association or disassociation of resource types.
//
//   - One or more of the specified resource types are already associated or
//     disassociated with the configuration recorder.
//
//   - For service-linked configuration recorders, the configuration recorder does
//     not record one or more of the specified resource types.
//
// [DescribeConfigurationRecorders]: https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html
// [PutStoredQuery]: https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html
// [DisassociateResourceTypes]: https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html
// [DescribeConfigurationRecorderStatus]: https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html
// [AssociateResourceTypes]: https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html
type ValidationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ValidationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ValidationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ValidationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
