// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Runs an AWS Lambda job that does the following:
//
//   - All the profileKeys in the ProfileToBeMerged will be moved to the main
//     profile.
//
//   - All the objects in the ProfileToBeMerged will be moved to the main profile.
//
//   - All the ProfileToBeMerged will be deleted at the end.
//
//   - All the profileKeys in the ProfileIdsToBeMerged will be moved to the main
//     profile.
//
//   - Standard fields are merged as follows:
//
//   - Fields are always "union"-ed if there are no conflicts in standard fields
//     or attributeKeys.
//
//   - When there are conflicting fields:
//
//   - If no SourceProfileIds entry is specified, the main Profile value is always
//     taken.
//
//   - If a SourceProfileIds entry is specified, the specified profileId is always
//     taken, even if it is a NULL value.
//
// You can use MergeProfiles together with [GetMatches], which returns potentially matching
// profiles, or use it with the results of another matching system. After profiles
// have been merged, they cannot be separated (unmerged).
//
// [GetMatches]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html
func (c *Client) MergeProfiles(ctx context.Context, params *MergeProfilesInput, optFns ...func(*Options)) (*MergeProfilesOutput, error) {
	if params == nil {
		params = &MergeProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "MergeProfiles", params, optFns, c.addOperationMergeProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*MergeProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type MergeProfilesInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The identifier of the profile to be taken.
	//
	// This member is required.
	MainProfileId *string

	// The identifier of the profile to be merged into MainProfileId.
	//
	// This member is required.
	ProfileIdsToBeMerged []string

	// The identifiers of the fields in the profile that has the information you want
	// to apply to the merge. For example, say you want to merge EmailAddress from
	// Profile1 into MainProfile. This would be the identifier of the EmailAddress
	// field in Profile1.
	FieldSourceProfileIds *types.FieldSourceProfileIds

	noSmithyDocumentSerde
}

type MergeProfilesOutput struct {

	// A message that indicates the merge request is complete.
	Message *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationMergeProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpMergeProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpMergeProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "MergeProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpMergeProfilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opMergeProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opMergeProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "MergeProfiles",
	}
}
