// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// For a given DMS Serverless replication configuration, DMS connects to the
// source endpoint and collects the metadata to analyze the replication workload.
// Using this metadata, DMS then computes and provisions the required capacity and
// starts replicating to the target endpoint using the server resources that DMS
// has provisioned for the DMS Serverless replication.
func (c *Client) StartReplication(ctx context.Context, params *StartReplicationInput, optFns ...func(*Options)) (*StartReplicationOutput, error) {
	if params == nil {
		params = &StartReplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartReplication", params, optFns, c.addOperationStartReplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartReplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartReplicationInput struct {

	// The Amazon Resource Name of the replication for which to start replication.
	//
	// This member is required.
	ReplicationConfigArn *string

	// The replication type.
	//
	// When the replication type is full-load or full-load-and-cdc , the only valid
	// value for the first run of the replication is start-replication . This option
	// will start the replication.
	//
	// You can also use ReloadTables to reload specific tables that failed during replication
	// instead of restarting the replication.
	//
	// The resume-processing option isn't applicable for a full-load replication,
	// because you can't resume partially loaded tables during the full load phase.
	//
	// For a full-load-and-cdc replication, DMS migrates table data, and then applies
	// data changes that occur on the source. To load all the tables again, and start
	// capturing source changes, use reload-target . Otherwise use resume-processing ,
	// to replicate the changes from the last stop position.
	//
	// This member is required.
	StartReplicationType *string

	// Indicates when you want a change data capture (CDC) operation to start. Use
	// either CdcStartPosition or CdcStartTime to specify when you want a CDC
	// operation to start. Specifying both values results in an error.
	//
	// The value can be in date, checkpoint, or LSN/SCN format.
	CdcStartPosition *string

	// Indicates the start time for a change data capture (CDC) operation. Use either
	// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to
	// start. Specifying both values results in an error.
	CdcStartTime *time.Time

	// Indicates when you want a change data capture (CDC) operation to stop. The
	// value can be either server time or commit time.
	CdcStopPosition *string

	// User-defined settings for the premigration assessment. The possible values are:
	//
	//   - ResultLocationFolder : The folder within an Amazon S3 bucket where you want
	//   DMS to store the results of this assessment run.
	//
	//   - ResultEncryptionMode : The supported values are SSE_KMS and SSE_S3 . If
	//   these values are not provided, then the files are not encrypted at rest. For
	//   more information, see [Creating Amazon Web Services KMS keys to encrypt Amazon S3 target objects].
	//
	//   - ResultKmsKeyArn : The ARN of a customer KMS encryption key that you specify
	//   when you set ResultEncryptionMode to SSE_KMS .
	//
	//   - IncludeOnly : A space-separated list of names for specific individual
	//   assessments that you want to include. These names come from the default list of
	//   individual assessments that Database Migration Service supports for the
	//   associated migration.
	//
	//   - Exclude : A space-separated list of names for specific individual
	//   assessments that you want to exclude. These names come from the default list of
	//   individual assessments that Database Migration Service supports for the
	//   associated migration.
	//
	//   - FailOnAssessmentFailure : A configurable setting you can set to true (the
	//   default setting) or false . Use this setting to to stop the replication from
	//   starting automatically if the assessment fails. This can help you evaluate the
	//   issue that is preventing the replication from running successfully.
	//
	// [Creating Amazon Web Services KMS keys to encrypt Amazon S3 target objects]: https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.KMSKeys
	PremigrationAssessmentSettings *string

	noSmithyDocumentSerde
}

type StartReplicationOutput struct {

	// The replication that DMS started.
	Replication *types.Replication

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartReplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartReplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartReplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartReplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartReplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartReplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartReplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartReplication",
	}
}
