// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists policy grants.
func (c *Client) ListPolicyGrants(ctx context.Context, params *ListPolicyGrantsInput, optFns ...func(*Options)) (*ListPolicyGrantsOutput, error) {
	if params == nil {
		params = &ListPolicyGrantsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPolicyGrants", params, optFns, c.addOperationListPolicyGrantsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPolicyGrantsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPolicyGrantsInput struct {

	// The ID of the domain where you want to list policy grants.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the entity for which you want to list policy grants.
	//
	// This member is required.
	EntityIdentifier *string

	// The type of entity for which you want to list policy grants.
	//
	// This member is required.
	EntityType types.TargetEntityType

	// The type of policy that you want to list.
	//
	// This member is required.
	PolicyType types.ManagedPolicyType

	// The maximum number of grants to return in a single call to ListPolicyGrants .
	// When the number of grants to be listed is greater than the value of MaxResults ,
	// the response contains a NextToken value that you can use in a subsequent call
	// to ListPolicyGrants to list the next set of grants.
	MaxResults *int32

	// When the number of grants is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of grants, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// ListPolicyGrants to list the next set of grants.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPolicyGrantsOutput struct {

	// The results of this action - the listed grants.
	//
	// This member is required.
	GrantList []types.PolicyGrantMember

	// When the number of grants is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of grants, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// ListPolicyGrants to list the next set of grants.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPolicyGrantsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPolicyGrants{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPolicyGrants{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPolicyGrants"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPolicyGrantsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPolicyGrants(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListPolicyGrantsPaginatorOptions is the paginator options for ListPolicyGrants
type ListPolicyGrantsPaginatorOptions struct {
	// The maximum number of grants to return in a single call to ListPolicyGrants .
	// When the number of grants to be listed is greater than the value of MaxResults ,
	// the response contains a NextToken value that you can use in a subsequent call
	// to ListPolicyGrants to list the next set of grants.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPolicyGrantsPaginator is a paginator for ListPolicyGrants
type ListPolicyGrantsPaginator struct {
	options   ListPolicyGrantsPaginatorOptions
	client    ListPolicyGrantsAPIClient
	params    *ListPolicyGrantsInput
	nextToken *string
	firstPage bool
}

// NewListPolicyGrantsPaginator returns a new ListPolicyGrantsPaginator
func NewListPolicyGrantsPaginator(client ListPolicyGrantsAPIClient, params *ListPolicyGrantsInput, optFns ...func(*ListPolicyGrantsPaginatorOptions)) *ListPolicyGrantsPaginator {
	if params == nil {
		params = &ListPolicyGrantsInput{}
	}

	options := ListPolicyGrantsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPolicyGrantsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPolicyGrantsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPolicyGrants page.
func (p *ListPolicyGrantsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPolicyGrantsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPolicyGrants(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPolicyGrantsAPIClient is a client that implements the ListPolicyGrants
// operation.
type ListPolicyGrantsAPIClient interface {
	ListPolicyGrants(context.Context, *ListPolicyGrantsInput, ...func(*Options)) (*ListPolicyGrantsOutput, error)
}

var _ ListPolicyGrantsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPolicyGrants(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPolicyGrants",
	}
}
