// Code generated by smithy-go-codegen DO NOT EDIT.

package types

type AcceptRuleBehavior string

// Enum values for AcceptRuleBehavior
const (
	AcceptRuleBehaviorAll  AcceptRuleBehavior = "ALL"
	AcceptRuleBehaviorNone AcceptRuleBehavior = "NONE"
)

// Values returns all known values for AcceptRuleBehavior. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AcceptRuleBehavior) Values() []AcceptRuleBehavior {
	return []AcceptRuleBehavior{
		"ALL",
		"NONE",
	}
}

type AuthenticationType string

// Enum values for AuthenticationType
const (
	AuthenticationTypeBasic  AuthenticationType = "BASIC"
	AuthenticationTypeOauth2 AuthenticationType = "OAUTH2"
	AuthenticationTypeCustom AuthenticationType = "CUSTOM"
)

// Values returns all known values for AuthenticationType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AuthenticationType) Values() []AuthenticationType {
	return []AuthenticationType{
		"BASIC",
		"OAUTH2",
		"CUSTOM",
	}
}

type AuthType string

// Enum values for AuthType
const (
	AuthTypeIamIdc   AuthType = "IAM_IDC"
	AuthTypeDisabled AuthType = "DISABLED"
)

// Values returns all known values for AuthType. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AuthType) Values() []AuthType {
	return []AuthType{
		"IAM_IDC",
		"DISABLED",
	}
}

type ChangeAction string

// Enum values for ChangeAction
const (
	ChangeActionPublish   ChangeAction = "PUBLISH"
	ChangeActionUnpublish ChangeAction = "UNPUBLISH"
)

// Values returns all known values for ChangeAction. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ChangeAction) Values() []ChangeAction {
	return []ChangeAction{
		"PUBLISH",
		"UNPUBLISH",
	}
}

type ComputeEnvironments string

// Enum values for ComputeEnvironments
const (
	ComputeEnvironmentsSpark  ComputeEnvironments = "SPARK"
	ComputeEnvironmentsAthena ComputeEnvironments = "ATHENA"
	ComputeEnvironmentsPython ComputeEnvironments = "PYTHON"
)

// Values returns all known values for ComputeEnvironments. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ComputeEnvironments) Values() []ComputeEnvironments {
	return []ComputeEnvironments{
		"SPARK",
		"ATHENA",
		"PYTHON",
	}
}

type ConfigurableActionTypeAuthorization string

// Enum values for ConfigurableActionTypeAuthorization
const (
	ConfigurableActionTypeAuthorizationIam   ConfigurableActionTypeAuthorization = "IAM"
	ConfigurableActionTypeAuthorizationHttps ConfigurableActionTypeAuthorization = "HTTPS"
)

// Values returns all known values for ConfigurableActionTypeAuthorization. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ConfigurableActionTypeAuthorization) Values() []ConfigurableActionTypeAuthorization {
	return []ConfigurableActionTypeAuthorization{
		"IAM",
		"HTTPS",
	}
}

type ConnectionStatus string

// Enum values for ConnectionStatus
const (
	ConnectionStatusCreating     ConnectionStatus = "CREATING"
	ConnectionStatusCreateFailed ConnectionStatus = "CREATE_FAILED"
	ConnectionStatusDeleting     ConnectionStatus = "DELETING"
	ConnectionStatusDeleteFailed ConnectionStatus = "DELETE_FAILED"
	ConnectionStatusReady        ConnectionStatus = "READY"
	ConnectionStatusUpdating     ConnectionStatus = "UPDATING"
	ConnectionStatusUpdateFailed ConnectionStatus = "UPDATE_FAILED"
	ConnectionStatusDeleted      ConnectionStatus = "DELETED"
)

// Values returns all known values for ConnectionStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ConnectionStatus) Values() []ConnectionStatus {
	return []ConnectionStatus{
		"CREATING",
		"CREATE_FAILED",
		"DELETING",
		"DELETE_FAILED",
		"READY",
		"UPDATING",
		"UPDATE_FAILED",
		"DELETED",
	}
}

type ConnectionType string

// Enum values for ConnectionType
const (
	ConnectionTypeAthena        ConnectionType = "ATHENA"
	ConnectionTypeBigquery      ConnectionType = "BIGQUERY"
	ConnectionTypeDatabricks    ConnectionType = "DATABRICKS"
	ConnectionTypeDocumentdb    ConnectionType = "DOCUMENTDB"
	ConnectionTypeDynamodb      ConnectionType = "DYNAMODB"
	ConnectionTypeHyperpod      ConnectionType = "HYPERPOD"
	ConnectionTypeIam           ConnectionType = "IAM"
	ConnectionTypeMysql         ConnectionType = "MYSQL"
	ConnectionTypeOpensearch    ConnectionType = "OPENSEARCH"
	ConnectionTypeOracle        ConnectionType = "ORACLE"
	ConnectionTypePostgresql    ConnectionType = "POSTGRESQL"
	ConnectionTypeRedshift      ConnectionType = "REDSHIFT"
	ConnectionTypeSaphana       ConnectionType = "SAPHANA"
	ConnectionTypeSnowflake     ConnectionType = "SNOWFLAKE"
	ConnectionTypeSpark         ConnectionType = "SPARK"
	ConnectionTypeSqlserver     ConnectionType = "SQLSERVER"
	ConnectionTypeTeradata      ConnectionType = "TERADATA"
	ConnectionTypeVertica       ConnectionType = "VERTICA"
	ConnectionTypeWorkflowsMwaa ConnectionType = "WORKFLOWS_MWAA"
)

// Values returns all known values for ConnectionType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ConnectionType) Values() []ConnectionType {
	return []ConnectionType{
		"ATHENA",
		"BIGQUERY",
		"DATABRICKS",
		"DOCUMENTDB",
		"DYNAMODB",
		"HYPERPOD",
		"IAM",
		"MYSQL",
		"OPENSEARCH",
		"ORACLE",
		"POSTGRESQL",
		"REDSHIFT",
		"SAPHANA",
		"SNOWFLAKE",
		"SPARK",
		"SQLSERVER",
		"TERADATA",
		"VERTICA",
		"WORKFLOWS_MWAA",
	}
}

type DataAssetActivityStatus string

// Enum values for DataAssetActivityStatus
const (
	DataAssetActivityStatusFailed                 DataAssetActivityStatus = "FAILED"
	DataAssetActivityStatusPublishingFailed       DataAssetActivityStatus = "PUBLISHING_FAILED"
	DataAssetActivityStatusSucceededCreated       DataAssetActivityStatus = "SUCCEEDED_CREATED"
	DataAssetActivityStatusSucceededUpdated       DataAssetActivityStatus = "SUCCEEDED_UPDATED"
	DataAssetActivityStatusSkippedAlreadyImported DataAssetActivityStatus = "SKIPPED_ALREADY_IMPORTED"
	DataAssetActivityStatusSkippedArchived        DataAssetActivityStatus = "SKIPPED_ARCHIVED"
	DataAssetActivityStatusSkippedNoAccess        DataAssetActivityStatus = "SKIPPED_NO_ACCESS"
	DataAssetActivityStatusUnchanged              DataAssetActivityStatus = "UNCHANGED"
)

// Values returns all known values for DataAssetActivityStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataAssetActivityStatus) Values() []DataAssetActivityStatus {
	return []DataAssetActivityStatus{
		"FAILED",
		"PUBLISHING_FAILED",
		"SUCCEEDED_CREATED",
		"SUCCEEDED_UPDATED",
		"SKIPPED_ALREADY_IMPORTED",
		"SKIPPED_ARCHIVED",
		"SKIPPED_NO_ACCESS",
		"UNCHANGED",
	}
}

type DataProductItemType string

// Enum values for DataProductItemType
const (
	DataProductItemTypeAsset DataProductItemType = "ASSET"
)

// Values returns all known values for DataProductItemType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataProductItemType) Values() []DataProductItemType {
	return []DataProductItemType{
		"ASSET",
	}
}

type DataProductStatus string

// Enum values for DataProductStatus
const (
	DataProductStatusCreated      DataProductStatus = "CREATED"
	DataProductStatusCreating     DataProductStatus = "CREATING"
	DataProductStatusCreateFailed DataProductStatus = "CREATE_FAILED"
)

// Values returns all known values for DataProductStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataProductStatus) Values() []DataProductStatus {
	return []DataProductStatus{
		"CREATED",
		"CREATING",
		"CREATE_FAILED",
	}
}

type DataSourceErrorType string

// Enum values for DataSourceErrorType
const (
	DataSourceErrorTypeAccessDeniedException         DataSourceErrorType = "ACCESS_DENIED_EXCEPTION"
	DataSourceErrorTypeConflictException             DataSourceErrorType = "CONFLICT_EXCEPTION"
	DataSourceErrorTypeInternalServerException       DataSourceErrorType = "INTERNAL_SERVER_EXCEPTION"
	DataSourceErrorTypeResourceNotFoundException     DataSourceErrorType = "RESOURCE_NOT_FOUND_EXCEPTION"
	DataSourceErrorTypeServiceQuotaExceededException DataSourceErrorType = "SERVICE_QUOTA_EXCEEDED_EXCEPTION"
	DataSourceErrorTypeThrottlingException           DataSourceErrorType = "THROTTLING_EXCEPTION"
	DataSourceErrorTypeValidationException           DataSourceErrorType = "VALIDATION_EXCEPTION"
)

// Values returns all known values for DataSourceErrorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceErrorType) Values() []DataSourceErrorType {
	return []DataSourceErrorType{
		"ACCESS_DENIED_EXCEPTION",
		"CONFLICT_EXCEPTION",
		"INTERNAL_SERVER_EXCEPTION",
		"RESOURCE_NOT_FOUND_EXCEPTION",
		"SERVICE_QUOTA_EXCEEDED_EXCEPTION",
		"THROTTLING_EXCEPTION",
		"VALIDATION_EXCEPTION",
	}
}

type DataSourceRunStatus string

// Enum values for DataSourceRunStatus
const (
	DataSourceRunStatusRequested          DataSourceRunStatus = "REQUESTED"
	DataSourceRunStatusRunning            DataSourceRunStatus = "RUNNING"
	DataSourceRunStatusFailed             DataSourceRunStatus = "FAILED"
	DataSourceRunStatusPartiallySucceeded DataSourceRunStatus = "PARTIALLY_SUCCEEDED"
	DataSourceRunStatusSuccess            DataSourceRunStatus = "SUCCESS"
)

// Values returns all known values for DataSourceRunStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceRunStatus) Values() []DataSourceRunStatus {
	return []DataSourceRunStatus{
		"REQUESTED",
		"RUNNING",
		"FAILED",
		"PARTIALLY_SUCCEEDED",
		"SUCCESS",
	}
}

type DataSourceRunType string

// Enum values for DataSourceRunType
const (
	DataSourceRunTypePrioritized DataSourceRunType = "PRIORITIZED"
	DataSourceRunTypeScheduled   DataSourceRunType = "SCHEDULED"
)

// Values returns all known values for DataSourceRunType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceRunType) Values() []DataSourceRunType {
	return []DataSourceRunType{
		"PRIORITIZED",
		"SCHEDULED",
	}
}

type DataSourceStatus string

// Enum values for DataSourceStatus
const (
	DataSourceStatusCreating       DataSourceStatus = "CREATING"
	DataSourceStatusFailedCreation DataSourceStatus = "FAILED_CREATION"
	DataSourceStatusReady          DataSourceStatus = "READY"
	DataSourceStatusUpdating       DataSourceStatus = "UPDATING"
	DataSourceStatusFailedUpdate   DataSourceStatus = "FAILED_UPDATE"
	DataSourceStatusRunning        DataSourceStatus = "RUNNING"
	DataSourceStatusDeleting       DataSourceStatus = "DELETING"
	DataSourceStatusFailedDeletion DataSourceStatus = "FAILED_DELETION"
)

// Values returns all known values for DataSourceStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceStatus) Values() []DataSourceStatus {
	return []DataSourceStatus{
		"CREATING",
		"FAILED_CREATION",
		"READY",
		"UPDATING",
		"FAILED_UPDATE",
		"RUNNING",
		"DELETING",
		"FAILED_DELETION",
	}
}

type DataZoneEntityType string

// Enum values for DataZoneEntityType
const (
	DataZoneEntityTypeDomainUnit DataZoneEntityType = "DOMAIN_UNIT"
)

// Values returns all known values for DataZoneEntityType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataZoneEntityType) Values() []DataZoneEntityType {
	return []DataZoneEntityType{
		"DOMAIN_UNIT",
	}
}

type DeploymentMode string

// Enum values for DeploymentMode
const (
	DeploymentModeOnCreate DeploymentMode = "ON_CREATE"
	DeploymentModeOnDemand DeploymentMode = "ON_DEMAND"
)

// Values returns all known values for DeploymentMode. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DeploymentMode) Values() []DeploymentMode {
	return []DeploymentMode{
		"ON_CREATE",
		"ON_DEMAND",
	}
}

type DeploymentStatus string

// Enum values for DeploymentStatus
const (
	DeploymentStatusInProgress        DeploymentStatus = "IN_PROGRESS"
	DeploymentStatusSuccessful        DeploymentStatus = "SUCCESSFUL"
	DeploymentStatusFailed            DeploymentStatus = "FAILED"
	DeploymentStatusPendingDeployment DeploymentStatus = "PENDING_DEPLOYMENT"
)

// Values returns all known values for DeploymentStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DeploymentStatus) Values() []DeploymentStatus {
	return []DeploymentStatus{
		"IN_PROGRESS",
		"SUCCESSFUL",
		"FAILED",
		"PENDING_DEPLOYMENT",
	}
}

type DeploymentType string

// Enum values for DeploymentType
const (
	DeploymentTypeCreate DeploymentType = "CREATE"
	DeploymentTypeUpdate DeploymentType = "UPDATE"
	DeploymentTypeDelete DeploymentType = "DELETE"
)

// Values returns all known values for DeploymentType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DeploymentType) Values() []DeploymentType {
	return []DeploymentType{
		"CREATE",
		"UPDATE",
		"DELETE",
	}
}

type DomainStatus string

// Enum values for DomainStatus
const (
	DomainStatusCreating       DomainStatus = "CREATING"
	DomainStatusAvailable      DomainStatus = "AVAILABLE"
	DomainStatusCreationFailed DomainStatus = "CREATION_FAILED"
	DomainStatusDeleting       DomainStatus = "DELETING"
	DomainStatusDeleted        DomainStatus = "DELETED"
	DomainStatusDeletionFailed DomainStatus = "DELETION_FAILED"
)

// Values returns all known values for DomainStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DomainStatus) Values() []DomainStatus {
	return []DomainStatus{
		"CREATING",
		"AVAILABLE",
		"CREATION_FAILED",
		"DELETING",
		"DELETED",
		"DELETION_FAILED",
	}
}

type DomainUnitDesignation string

// Enum values for DomainUnitDesignation
const (
	DomainUnitDesignationOwner DomainUnitDesignation = "OWNER"
)

// Values returns all known values for DomainUnitDesignation. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DomainUnitDesignation) Values() []DomainUnitDesignation {
	return []DomainUnitDesignation{
		"OWNER",
	}
}

type DomainVersion string

// Enum values for DomainVersion
const (
	DomainVersionV1 DomainVersion = "V1"
	DomainVersionV2 DomainVersion = "V2"
)

// Values returns all known values for DomainVersion. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DomainVersion) Values() []DomainVersion {
	return []DomainVersion{
		"V1",
		"V2",
	}
}

type EdgeDirection string

// Enum values for EdgeDirection
const (
	EdgeDirectionUpstream   EdgeDirection = "UPSTREAM"
	EdgeDirectionDownstream EdgeDirection = "DOWNSTREAM"
)

// Values returns all known values for EdgeDirection. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (EdgeDirection) Values() []EdgeDirection {
	return []EdgeDirection{
		"UPSTREAM",
		"DOWNSTREAM",
	}
}

type EnableSetting string

// Enum values for EnableSetting
const (
	EnableSettingEnabled  EnableSetting = "ENABLED"
	EnableSettingDisabled EnableSetting = "DISABLED"
)

// Values returns all known values for EnableSetting. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (EnableSetting) Values() []EnableSetting {
	return []EnableSetting{
		"ENABLED",
		"DISABLED",
	}
}

type EntityType string

// Enum values for EntityType
const (
	EntityTypeAsset       EntityType = "ASSET"
	EntityTypeDataProduct EntityType = "DATA_PRODUCT"
)

// Values returns all known values for EntityType. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (EntityType) Values() []EntityType {
	return []EntityType{
		"ASSET",
		"DATA_PRODUCT",
	}
}

type EnvironmentStatus string

// Enum values for EnvironmentStatus
const (
	EnvironmentStatusActive           EnvironmentStatus = "ACTIVE"
	EnvironmentStatusCreating         EnvironmentStatus = "CREATING"
	EnvironmentStatusUpdating         EnvironmentStatus = "UPDATING"
	EnvironmentStatusDeleting         EnvironmentStatus = "DELETING"
	EnvironmentStatusCreateFailed     EnvironmentStatus = "CREATE_FAILED"
	EnvironmentStatusUpdateFailed     EnvironmentStatus = "UPDATE_FAILED"
	EnvironmentStatusDeleteFailed     EnvironmentStatus = "DELETE_FAILED"
	EnvironmentStatusValidationFailed EnvironmentStatus = "VALIDATION_FAILED"
	EnvironmentStatusSuspended        EnvironmentStatus = "SUSPENDED"
	EnvironmentStatusDisabled         EnvironmentStatus = "DISABLED"
	EnvironmentStatusExpired          EnvironmentStatus = "EXPIRED"
	EnvironmentStatusDeleted          EnvironmentStatus = "DELETED"
	EnvironmentStatusInaccessible     EnvironmentStatus = "INACCESSIBLE"
)

// Values returns all known values for EnvironmentStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (EnvironmentStatus) Values() []EnvironmentStatus {
	return []EnvironmentStatus{
		"ACTIVE",
		"CREATING",
		"UPDATING",
		"DELETING",
		"CREATE_FAILED",
		"UPDATE_FAILED",
		"DELETE_FAILED",
		"VALIDATION_FAILED",
		"SUSPENDED",
		"DISABLED",
		"EXPIRED",
		"DELETED",
		"INACCESSIBLE",
	}
}

type FilterExpressionType string

// Enum values for FilterExpressionType
const (
	FilterExpressionTypeInclude FilterExpressionType = "INCLUDE"
	FilterExpressionTypeExclude FilterExpressionType = "EXCLUDE"
)

// Values returns all known values for FilterExpressionType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (FilterExpressionType) Values() []FilterExpressionType {
	return []FilterExpressionType{
		"INCLUDE",
		"EXCLUDE",
	}
}

type FilterStatus string

// Enum values for FilterStatus
const (
	FilterStatusValid   FilterStatus = "VALID"
	FilterStatusInvalid FilterStatus = "INVALID"
)

// Values returns all known values for FilterStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (FilterStatus) Values() []FilterStatus {
	return []FilterStatus{
		"VALID",
		"INVALID",
	}
}

type FormTypeStatus string

// Enum values for FormTypeStatus
const (
	FormTypeStatusEnabled  FormTypeStatus = "ENABLED"
	FormTypeStatusDisabled FormTypeStatus = "DISABLED"
)

// Values returns all known values for FormTypeStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (FormTypeStatus) Values() []FormTypeStatus {
	return []FormTypeStatus{
		"ENABLED",
		"DISABLED",
	}
}

type GlossaryStatus string

// Enum values for GlossaryStatus
const (
	GlossaryStatusDisabled GlossaryStatus = "DISABLED"
	GlossaryStatusEnabled  GlossaryStatus = "ENABLED"
)

// Values returns all known values for GlossaryStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (GlossaryStatus) Values() []GlossaryStatus {
	return []GlossaryStatus{
		"DISABLED",
		"ENABLED",
	}
}

type GlossaryTermStatus string

// Enum values for GlossaryTermStatus
const (
	GlossaryTermStatusEnabled  GlossaryTermStatus = "ENABLED"
	GlossaryTermStatusDisabled GlossaryTermStatus = "DISABLED"
)

// Values returns all known values for GlossaryTermStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (GlossaryTermStatus) Values() []GlossaryTermStatus {
	return []GlossaryTermStatus{
		"ENABLED",
		"DISABLED",
	}
}

type GlueConnectionType string

// Enum values for GlueConnectionType
const (
	GlueConnectionTypeSnowflake  GlueConnectionType = "SNOWFLAKE"
	GlueConnectionTypeBigquery   GlueConnectionType = "BIGQUERY"
	GlueConnectionTypeDocumentdb GlueConnectionType = "DOCUMENTDB"
	GlueConnectionTypeDynamodb   GlueConnectionType = "DYNAMODB"
	GlueConnectionTypeMysql      GlueConnectionType = "MYSQL"
	GlueConnectionTypeOpensearch GlueConnectionType = "OPENSEARCH"
	GlueConnectionTypeOracle     GlueConnectionType = "ORACLE"
	GlueConnectionTypePostgresql GlueConnectionType = "POSTGRESQL"
	GlueConnectionTypeRedshift   GlueConnectionType = "REDSHIFT"
	GlueConnectionTypeSaphana    GlueConnectionType = "SAPHANA"
	GlueConnectionTypeSqlserver  GlueConnectionType = "SQLSERVER"
	GlueConnectionTypeTeradata   GlueConnectionType = "TERADATA"
	GlueConnectionTypeVertica    GlueConnectionType = "VERTICA"
)

// Values returns all known values for GlueConnectionType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (GlueConnectionType) Values() []GlueConnectionType {
	return []GlueConnectionType{
		"SNOWFLAKE",
		"BIGQUERY",
		"DOCUMENTDB",
		"DYNAMODB",
		"MYSQL",
		"OPENSEARCH",
		"ORACLE",
		"POSTGRESQL",
		"REDSHIFT",
		"SAPHANA",
		"SQLSERVER",
		"TERADATA",
		"VERTICA",
	}
}

type GovernanceType string

// Enum values for GovernanceType
const (
	GovernanceTypeAwsManaged  GovernanceType = "AWS_MANAGED"
	GovernanceTypeUserManaged GovernanceType = "USER_MANAGED"
)

// Values returns all known values for GovernanceType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (GovernanceType) Values() []GovernanceType {
	return []GovernanceType{
		"AWS_MANAGED",
		"USER_MANAGED",
	}
}

type GroupProfileStatus string

// Enum values for GroupProfileStatus
const (
	GroupProfileStatusAssigned    GroupProfileStatus = "ASSIGNED"
	GroupProfileStatusNotAssigned GroupProfileStatus = "NOT_ASSIGNED"
)

// Values returns all known values for GroupProfileStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (GroupProfileStatus) Values() []GroupProfileStatus {
	return []GroupProfileStatus{
		"ASSIGNED",
		"NOT_ASSIGNED",
	}
}

type GroupSearchType string

// Enum values for GroupSearchType
const (
	GroupSearchTypeSsoGroup         GroupSearchType = "SSO_GROUP"
	GroupSearchTypeDatazoneSsoGroup GroupSearchType = "DATAZONE_SSO_GROUP"
)

// Values returns all known values for GroupSearchType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (GroupSearchType) Values() []GroupSearchType {
	return []GroupSearchType{
		"SSO_GROUP",
		"DATAZONE_SSO_GROUP",
	}
}

type HyperPodOrchestrator string

// Enum values for HyperPodOrchestrator
const (
	HyperPodOrchestratorEks   HyperPodOrchestrator = "EKS"
	HyperPodOrchestratorSlurm HyperPodOrchestrator = "SLURM"
)

// Values returns all known values for HyperPodOrchestrator. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (HyperPodOrchestrator) Values() []HyperPodOrchestrator {
	return []HyperPodOrchestrator{
		"EKS",
		"SLURM",
	}
}

type InventorySearchScope string

// Enum values for InventorySearchScope
const (
	InventorySearchScopeAsset        InventorySearchScope = "ASSET"
	InventorySearchScopeGlossary     InventorySearchScope = "GLOSSARY"
	InventorySearchScopeGlossaryTerm InventorySearchScope = "GLOSSARY_TERM"
	InventorySearchScopeDataProduct  InventorySearchScope = "DATA_PRODUCT"
)

// Values returns all known values for InventorySearchScope. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (InventorySearchScope) Values() []InventorySearchScope {
	return []InventorySearchScope{
		"ASSET",
		"GLOSSARY",
		"GLOSSARY_TERM",
		"DATA_PRODUCT",
	}
}

type JobRunMode string

// Enum values for JobRunMode
const (
	JobRunModeScheduled JobRunMode = "SCHEDULED"
	JobRunModeOnDemand  JobRunMode = "ON_DEMAND"
)

// Values returns all known values for JobRunMode. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobRunMode) Values() []JobRunMode {
	return []JobRunMode{
		"SCHEDULED",
		"ON_DEMAND",
	}
}

type JobRunStatus string

// Enum values for JobRunStatus
const (
	JobRunStatusScheduled          JobRunStatus = "SCHEDULED"
	JobRunStatusInProgress         JobRunStatus = "IN_PROGRESS"
	JobRunStatusSuccess            JobRunStatus = "SUCCESS"
	JobRunStatusPartiallySucceeded JobRunStatus = "PARTIALLY_SUCCEEDED"
	JobRunStatusFailed             JobRunStatus = "FAILED"
	JobRunStatusAborted            JobRunStatus = "ABORTED"
	JobRunStatusTimedOut           JobRunStatus = "TIMED_OUT"
	JobRunStatusCanceled           JobRunStatus = "CANCELED"
)

// Values returns all known values for JobRunStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobRunStatus) Values() []JobRunStatus {
	return []JobRunStatus{
		"SCHEDULED",
		"IN_PROGRESS",
		"SUCCESS",
		"PARTIALLY_SUCCEEDED",
		"FAILED",
		"ABORTED",
		"TIMED_OUT",
		"CANCELED",
	}
}

type JobType string

// Enum values for JobType
const (
	JobTypeLineage JobType = "LINEAGE"
)

// Values returns all known values for JobType. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobType) Values() []JobType {
	return []JobType{
		"LINEAGE",
	}
}

type LineageEventProcessingStatus string

// Enum values for LineageEventProcessingStatus
const (
	LineageEventProcessingStatusRequested  LineageEventProcessingStatus = "REQUESTED"
	LineageEventProcessingStatusProcessing LineageEventProcessingStatus = "PROCESSING"
	LineageEventProcessingStatusSuccess    LineageEventProcessingStatus = "SUCCESS"
	LineageEventProcessingStatusFailed     LineageEventProcessingStatus = "FAILED"
)

// Values returns all known values for LineageEventProcessingStatus. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (LineageEventProcessingStatus) Values() []LineageEventProcessingStatus {
	return []LineageEventProcessingStatus{
		"REQUESTED",
		"PROCESSING",
		"SUCCESS",
		"FAILED",
	}
}

type LineageImportStatus string

// Enum values for LineageImportStatus
const (
	LineageImportStatusInProgress         LineageImportStatus = "IN_PROGRESS"
	LineageImportStatusSuccess            LineageImportStatus = "SUCCESS"
	LineageImportStatusFailed             LineageImportStatus = "FAILED"
	LineageImportStatusPartiallySucceeded LineageImportStatus = "PARTIALLY_SUCCEEDED"
)

// Values returns all known values for LineageImportStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (LineageImportStatus) Values() []LineageImportStatus {
	return []LineageImportStatus{
		"IN_PROGRESS",
		"SUCCESS",
		"FAILED",
		"PARTIALLY_SUCCEEDED",
	}
}

type ListingStatus string

// Enum values for ListingStatus
const (
	ListingStatusCreating ListingStatus = "CREATING"
	ListingStatusActive   ListingStatus = "ACTIVE"
	ListingStatusInactive ListingStatus = "INACTIVE"
)

// Values returns all known values for ListingStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ListingStatus) Values() []ListingStatus {
	return []ListingStatus{
		"CREATING",
		"ACTIVE",
		"INACTIVE",
	}
}

type ManagedPolicyType string

// Enum values for ManagedPolicyType
const (
	ManagedPolicyTypeCreateDomainUnit                 ManagedPolicyType = "CREATE_DOMAIN_UNIT"
	ManagedPolicyTypeOverrideDomainUnitOwners         ManagedPolicyType = "OVERRIDE_DOMAIN_UNIT_OWNERS"
	ManagedPolicyTypeAddToProjectMemberPool           ManagedPolicyType = "ADD_TO_PROJECT_MEMBER_POOL"
	ManagedPolicyTypeOverrideProjectOwners            ManagedPolicyType = "OVERRIDE_PROJECT_OWNERS"
	ManagedPolicyTypeCreateGlossary                   ManagedPolicyType = "CREATE_GLOSSARY"
	ManagedPolicyTypeCreateFormType                   ManagedPolicyType = "CREATE_FORM_TYPE"
	ManagedPolicyTypeCreateAssetType                  ManagedPolicyType = "CREATE_ASSET_TYPE"
	ManagedPolicyTypeCreateProject                    ManagedPolicyType = "CREATE_PROJECT"
	ManagedPolicyTypeCreateEnvironmentProfile         ManagedPolicyType = "CREATE_ENVIRONMENT_PROFILE"
	ManagedPolicyTypeDelegateCreateEnvironmentProfile ManagedPolicyType = "DELEGATE_CREATE_ENVIRONMENT_PROFILE"
	ManagedPolicyTypeCreateEnvironment                ManagedPolicyType = "CREATE_ENVIRONMENT"
	ManagedPolicyTypeCreateEnvironmentFromBlueprint   ManagedPolicyType = "CREATE_ENVIRONMENT_FROM_BLUEPRINT"
	ManagedPolicyTypeCreateProjectFromProjectProfile  ManagedPolicyType = "CREATE_PROJECT_FROM_PROJECT_PROFILE"
	ManagedPolicyTypeUseAssetType                     ManagedPolicyType = "USE_ASSET_TYPE"
)

// Values returns all known values for ManagedPolicyType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ManagedPolicyType) Values() []ManagedPolicyType {
	return []ManagedPolicyType{
		"CREATE_DOMAIN_UNIT",
		"OVERRIDE_DOMAIN_UNIT_OWNERS",
		"ADD_TO_PROJECT_MEMBER_POOL",
		"OVERRIDE_PROJECT_OWNERS",
		"CREATE_GLOSSARY",
		"CREATE_FORM_TYPE",
		"CREATE_ASSET_TYPE",
		"CREATE_PROJECT",
		"CREATE_ENVIRONMENT_PROFILE",
		"DELEGATE_CREATE_ENVIRONMENT_PROFILE",
		"CREATE_ENVIRONMENT",
		"CREATE_ENVIRONMENT_FROM_BLUEPRINT",
		"CREATE_PROJECT_FROM_PROJECT_PROFILE",
		"USE_ASSET_TYPE",
	}
}

type MetadataGenerationRunStatus string

// Enum values for MetadataGenerationRunStatus
const (
	MetadataGenerationRunStatusSubmitted  MetadataGenerationRunStatus = "SUBMITTED"
	MetadataGenerationRunStatusInProgress MetadataGenerationRunStatus = "IN_PROGRESS"
	MetadataGenerationRunStatusCanceled   MetadataGenerationRunStatus = "CANCELED"
	MetadataGenerationRunStatusSucceeded  MetadataGenerationRunStatus = "SUCCEEDED"
	MetadataGenerationRunStatusFailed     MetadataGenerationRunStatus = "FAILED"
)

// Values returns all known values for MetadataGenerationRunStatus. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (MetadataGenerationRunStatus) Values() []MetadataGenerationRunStatus {
	return []MetadataGenerationRunStatus{
		"SUBMITTED",
		"IN_PROGRESS",
		"CANCELED",
		"SUCCEEDED",
		"FAILED",
	}
}

type MetadataGenerationRunType string

// Enum values for MetadataGenerationRunType
const (
	MetadataGenerationRunTypeBusinessDescriptions MetadataGenerationRunType = "BUSINESS_DESCRIPTIONS"
)

// Values returns all known values for MetadataGenerationRunType. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (MetadataGenerationRunType) Values() []MetadataGenerationRunType {
	return []MetadataGenerationRunType{
		"BUSINESS_DESCRIPTIONS",
	}
}

type MetadataGenerationTargetType string

// Enum values for MetadataGenerationTargetType
const (
	MetadataGenerationTargetTypeAsset MetadataGenerationTargetType = "ASSET"
)

// Values returns all known values for MetadataGenerationTargetType. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (MetadataGenerationTargetType) Values() []MetadataGenerationTargetType {
	return []MetadataGenerationTargetType{
		"ASSET",
	}
}

type NotificationResourceType string

// Enum values for NotificationResourceType
const (
	NotificationResourceTypeProject NotificationResourceType = "PROJECT"
)

// Values returns all known values for NotificationResourceType. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (NotificationResourceType) Values() []NotificationResourceType {
	return []NotificationResourceType{
		"PROJECT",
	}
}

type NotificationRole string

// Enum values for NotificationRole
const (
	NotificationRoleProjectOwner       NotificationRole = "PROJECT_OWNER"
	NotificationRoleProjectContributor NotificationRole = "PROJECT_CONTRIBUTOR"
	NotificationRoleProjectViewer      NotificationRole = "PROJECT_VIEWER"
	NotificationRoleDomainOwner        NotificationRole = "DOMAIN_OWNER"
	NotificationRoleProjectSubscriber  NotificationRole = "PROJECT_SUBSCRIBER"
)

// Values returns all known values for NotificationRole. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (NotificationRole) Values() []NotificationRole {
	return []NotificationRole{
		"PROJECT_OWNER",
		"PROJECT_CONTRIBUTOR",
		"PROJECT_VIEWER",
		"DOMAIN_OWNER",
		"PROJECT_SUBSCRIBER",
	}
}

type NotificationType string

// Enum values for NotificationType
const (
	NotificationTypeTask  NotificationType = "TASK"
	NotificationTypeEvent NotificationType = "EVENT"
)

// Values returns all known values for NotificationType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (NotificationType) Values() []NotificationType {
	return []NotificationType{
		"TASK",
		"EVENT",
	}
}

type OAuth2GrantType string

// Enum values for OAuth2GrantType
const (
	OAuth2GrantTypeAuthorizationCode OAuth2GrantType = "AUTHORIZATION_CODE"
	OAuth2GrantTypeClientCredentials OAuth2GrantType = "CLIENT_CREDENTIALS"
	OAuth2GrantTypeJwtBearer         OAuth2GrantType = "JWT_BEARER"
)

// Values returns all known values for OAuth2GrantType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (OAuth2GrantType) Values() []OAuth2GrantType {
	return []OAuth2GrantType{
		"AUTHORIZATION_CODE",
		"CLIENT_CREDENTIALS",
		"JWT_BEARER",
	}
}

type OpenLineageRunState string

// Enum values for OpenLineageRunState
const (
	OpenLineageRunStateStart    OpenLineageRunState = "START"
	OpenLineageRunStateRunning  OpenLineageRunState = "RUNNING"
	OpenLineageRunStateComplete OpenLineageRunState = "COMPLETE"
	OpenLineageRunStateAbort    OpenLineageRunState = "ABORT"
	OpenLineageRunStateFail     OpenLineageRunState = "FAIL"
	OpenLineageRunStateOther    OpenLineageRunState = "OTHER"
)

// Values returns all known values for OpenLineageRunState. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (OpenLineageRunState) Values() []OpenLineageRunState {
	return []OpenLineageRunState{
		"START",
		"RUNNING",
		"COMPLETE",
		"ABORT",
		"FAIL",
		"OTHER",
	}
}

type OverallDeploymentStatus string

// Enum values for OverallDeploymentStatus
const (
	OverallDeploymentStatusPendingDeployment OverallDeploymentStatus = "PENDING_DEPLOYMENT"
	OverallDeploymentStatusInProgress        OverallDeploymentStatus = "IN_PROGRESS"
	OverallDeploymentStatusSuccessful        OverallDeploymentStatus = "SUCCESSFUL"
	OverallDeploymentStatusFailedValidation  OverallDeploymentStatus = "FAILED_VALIDATION"
	OverallDeploymentStatusFailedDeployment  OverallDeploymentStatus = "FAILED_DEPLOYMENT"
)

// Values returns all known values for OverallDeploymentStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (OverallDeploymentStatus) Values() []OverallDeploymentStatus {
	return []OverallDeploymentStatus{
		"PENDING_DEPLOYMENT",
		"IN_PROGRESS",
		"SUCCESSFUL",
		"FAILED_VALIDATION",
		"FAILED_DEPLOYMENT",
	}
}

type ProjectDesignation string

// Enum values for ProjectDesignation
const (
	ProjectDesignationOwner                 ProjectDesignation = "OWNER"
	ProjectDesignationContributor           ProjectDesignation = "CONTRIBUTOR"
	ProjectDesignationProjectCatalogSteward ProjectDesignation = "PROJECT_CATALOG_STEWARD"
)

// Values returns all known values for ProjectDesignation. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ProjectDesignation) Values() []ProjectDesignation {
	return []ProjectDesignation{
		"OWNER",
		"CONTRIBUTOR",
		"PROJECT_CATALOG_STEWARD",
	}
}

type ProjectStatus string

// Enum values for ProjectStatus
const (
	ProjectStatusActive       ProjectStatus = "ACTIVE"
	ProjectStatusDeleting     ProjectStatus = "DELETING"
	ProjectStatusDeleteFailed ProjectStatus = "DELETE_FAILED"
	ProjectStatusUpdating     ProjectStatus = "UPDATING"
	ProjectStatusUpdateFailed ProjectStatus = "UPDATE_FAILED"
)

// Values returns all known values for ProjectStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ProjectStatus) Values() []ProjectStatus {
	return []ProjectStatus{
		"ACTIVE",
		"DELETING",
		"DELETE_FAILED",
		"UPDATING",
		"UPDATE_FAILED",
	}
}

type Protocol string

// Enum values for Protocol
const (
	ProtocolAthena                 Protocol = "ATHENA"
	ProtocolGlueInteractiveSession Protocol = "GLUE_INTERACTIVE_SESSION"
	ProtocolHttps                  Protocol = "HTTPS"
	ProtocolJdbc                   Protocol = "JDBC"
	ProtocolLivy                   Protocol = "LIVY"
	ProtocolOdbc                   Protocol = "ODBC"
	ProtocolPrism                  Protocol = "PRISM"
)

// Values returns all known values for Protocol. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (Protocol) Values() []Protocol {
	return []Protocol{
		"ATHENA",
		"GLUE_INTERACTIVE_SESSION",
		"HTTPS",
		"JDBC",
		"LIVY",
		"ODBC",
		"PRISM",
	}
}

type RejectRuleBehavior string

// Enum values for RejectRuleBehavior
const (
	RejectRuleBehaviorAll  RejectRuleBehavior = "ALL"
	RejectRuleBehaviorNone RejectRuleBehavior = "NONE"
)

// Values returns all known values for RejectRuleBehavior. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (RejectRuleBehavior) Values() []RejectRuleBehavior {
	return []RejectRuleBehavior{
		"ALL",
		"NONE",
	}
}

type RuleAction string

// Enum values for RuleAction
const (
	RuleActionCreateListingChangeSet    RuleAction = "CREATE_LISTING_CHANGE_SET"
	RuleActionCreateSubscriptionRequest RuleAction = "CREATE_SUBSCRIPTION_REQUEST"
)

// Values returns all known values for RuleAction. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (RuleAction) Values() []RuleAction {
	return []RuleAction{
		"CREATE_LISTING_CHANGE_SET",
		"CREATE_SUBSCRIPTION_REQUEST",
	}
}

type RuleScopeSelectionMode string

// Enum values for RuleScopeSelectionMode
const (
	RuleScopeSelectionModeAll      RuleScopeSelectionMode = "ALL"
	RuleScopeSelectionModeSpecific RuleScopeSelectionMode = "SPECIFIC"
)

// Values returns all known values for RuleScopeSelectionMode. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (RuleScopeSelectionMode) Values() []RuleScopeSelectionMode {
	return []RuleScopeSelectionMode{
		"ALL",
		"SPECIFIC",
	}
}

type RuleTargetType string

// Enum values for RuleTargetType
const (
	RuleTargetTypeDomainUnit RuleTargetType = "DOMAIN_UNIT"
)

// Values returns all known values for RuleTargetType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (RuleTargetType) Values() []RuleTargetType {
	return []RuleTargetType{
		"DOMAIN_UNIT",
	}
}

type RuleType string

// Enum values for RuleType
const (
	RuleTypeMetadataFormEnforcement RuleType = "METADATA_FORM_ENFORCEMENT"
)

// Values returns all known values for RuleType. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (RuleType) Values() []RuleType {
	return []RuleType{
		"METADATA_FORM_ENFORCEMENT",
	}
}

type SearchOutputAdditionalAttribute string

// Enum values for SearchOutputAdditionalAttribute
const (
	SearchOutputAdditionalAttributeForms                    SearchOutputAdditionalAttribute = "FORMS"
	SearchOutputAdditionalAttributeTimeSeriesDataPointForms SearchOutputAdditionalAttribute = "TIME_SERIES_DATA_POINT_FORMS"
)

// Values returns all known values for SearchOutputAdditionalAttribute. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SearchOutputAdditionalAttribute) Values() []SearchOutputAdditionalAttribute {
	return []SearchOutputAdditionalAttribute{
		"FORMS",
		"TIME_SERIES_DATA_POINT_FORMS",
	}
}

type SelfGrantStatus string

// Enum values for SelfGrantStatus
const (
	SelfGrantStatusGrantPending     SelfGrantStatus = "GRANT_PENDING"
	SelfGrantStatusRevokePending    SelfGrantStatus = "REVOKE_PENDING"
	SelfGrantStatusGrantInProgress  SelfGrantStatus = "GRANT_IN_PROGRESS"
	SelfGrantStatusRevokeInProgress SelfGrantStatus = "REVOKE_IN_PROGRESS"
	SelfGrantStatusGranted          SelfGrantStatus = "GRANTED"
	SelfGrantStatusGrantFailed      SelfGrantStatus = "GRANT_FAILED"
	SelfGrantStatusRevokeFailed     SelfGrantStatus = "REVOKE_FAILED"
)

// Values returns all known values for SelfGrantStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SelfGrantStatus) Values() []SelfGrantStatus {
	return []SelfGrantStatus{
		"GRANT_PENDING",
		"REVOKE_PENDING",
		"GRANT_IN_PROGRESS",
		"REVOKE_IN_PROGRESS",
		"GRANTED",
		"GRANT_FAILED",
		"REVOKE_FAILED",
	}
}

type SortFieldConnection string

// Enum values for SortFieldConnection
const (
	SortFieldConnectionName SortFieldConnection = "NAME"
)

// Values returns all known values for SortFieldConnection. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SortFieldConnection) Values() []SortFieldConnection {
	return []SortFieldConnection{
		"NAME",
	}
}

type SortFieldProject string

// Enum values for SortFieldProject
const (
	SortFieldProjectName SortFieldProject = "NAME"
)

// Values returns all known values for SortFieldProject. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SortFieldProject) Values() []SortFieldProject {
	return []SortFieldProject{
		"NAME",
	}
}

type SortKey string

// Enum values for SortKey
const (
	SortKeyCreatedAt SortKey = "CREATED_AT"
	SortKeyUpdatedAt SortKey = "UPDATED_AT"
)

// Values returns all known values for SortKey. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SortKey) Values() []SortKey {
	return []SortKey{
		"CREATED_AT",
		"UPDATED_AT",
	}
}

type SortOrder string

// Enum values for SortOrder
const (
	SortOrderAscending  SortOrder = "ASCENDING"
	SortOrderDescending SortOrder = "DESCENDING"
)

// Values returns all known values for SortOrder. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SortOrder) Values() []SortOrder {
	return []SortOrder{
		"ASCENDING",
		"DESCENDING",
	}
}

type Status string

// Enum values for Status
const (
	StatusEnabled  Status = "ENABLED"
	StatusDisabled Status = "DISABLED"
)

// Values returns all known values for Status. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (Status) Values() []Status {
	return []Status{
		"ENABLED",
		"DISABLED",
	}
}

type SubscriptionGrantOverallStatus string

// Enum values for SubscriptionGrantOverallStatus
const (
	SubscriptionGrantOverallStatusPending              SubscriptionGrantOverallStatus = "PENDING"
	SubscriptionGrantOverallStatusInProgress           SubscriptionGrantOverallStatus = "IN_PROGRESS"
	SubscriptionGrantOverallStatusGrantFailed          SubscriptionGrantOverallStatus = "GRANT_FAILED"
	SubscriptionGrantOverallStatusRevokeFailed         SubscriptionGrantOverallStatus = "REVOKE_FAILED"
	SubscriptionGrantOverallStatusGrantAndRevokeFailed SubscriptionGrantOverallStatus = "GRANT_AND_REVOKE_FAILED"
	SubscriptionGrantOverallStatusCompleted            SubscriptionGrantOverallStatus = "COMPLETED"
	SubscriptionGrantOverallStatusInaccessible         SubscriptionGrantOverallStatus = "INACCESSIBLE"
)

// Values returns all known values for SubscriptionGrantOverallStatus. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SubscriptionGrantOverallStatus) Values() []SubscriptionGrantOverallStatus {
	return []SubscriptionGrantOverallStatus{
		"PENDING",
		"IN_PROGRESS",
		"GRANT_FAILED",
		"REVOKE_FAILED",
		"GRANT_AND_REVOKE_FAILED",
		"COMPLETED",
		"INACCESSIBLE",
	}
}

type SubscriptionGrantStatus string

// Enum values for SubscriptionGrantStatus
const (
	SubscriptionGrantStatusGrantPending     SubscriptionGrantStatus = "GRANT_PENDING"
	SubscriptionGrantStatusRevokePending    SubscriptionGrantStatus = "REVOKE_PENDING"
	SubscriptionGrantStatusGrantInProgress  SubscriptionGrantStatus = "GRANT_IN_PROGRESS"
	SubscriptionGrantStatusRevokeInProgress SubscriptionGrantStatus = "REVOKE_IN_PROGRESS"
	SubscriptionGrantStatusGranted          SubscriptionGrantStatus = "GRANTED"
	SubscriptionGrantStatusRevoked          SubscriptionGrantStatus = "REVOKED"
	SubscriptionGrantStatusGrantFailed      SubscriptionGrantStatus = "GRANT_FAILED"
	SubscriptionGrantStatusRevokeFailed     SubscriptionGrantStatus = "REVOKE_FAILED"
)

// Values returns all known values for SubscriptionGrantStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SubscriptionGrantStatus) Values() []SubscriptionGrantStatus {
	return []SubscriptionGrantStatus{
		"GRANT_PENDING",
		"REVOKE_PENDING",
		"GRANT_IN_PROGRESS",
		"REVOKE_IN_PROGRESS",
		"GRANTED",
		"REVOKED",
		"GRANT_FAILED",
		"REVOKE_FAILED",
	}
}

type SubscriptionRequestStatus string

// Enum values for SubscriptionRequestStatus
const (
	SubscriptionRequestStatusPending  SubscriptionRequestStatus = "PENDING"
	SubscriptionRequestStatusAccepted SubscriptionRequestStatus = "ACCEPTED"
	SubscriptionRequestStatusRejected SubscriptionRequestStatus = "REJECTED"
)

// Values returns all known values for SubscriptionRequestStatus. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SubscriptionRequestStatus) Values() []SubscriptionRequestStatus {
	return []SubscriptionRequestStatus{
		"PENDING",
		"ACCEPTED",
		"REJECTED",
	}
}

type SubscriptionStatus string

// Enum values for SubscriptionStatus
const (
	SubscriptionStatusApproved  SubscriptionStatus = "APPROVED"
	SubscriptionStatusRevoked   SubscriptionStatus = "REVOKED"
	SubscriptionStatusCancelled SubscriptionStatus = "CANCELLED"
)

// Values returns all known values for SubscriptionStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SubscriptionStatus) Values() []SubscriptionStatus {
	return []SubscriptionStatus{
		"APPROVED",
		"REVOKED",
		"CANCELLED",
	}
}

type TargetEntityType string

// Enum values for TargetEntityType
const (
	TargetEntityTypeDomainUnit                        TargetEntityType = "DOMAIN_UNIT"
	TargetEntityTypeEnvironmentBlueprintConfiguration TargetEntityType = "ENVIRONMENT_BLUEPRINT_CONFIGURATION"
	TargetEntityTypeEnvironmentProfile                TargetEntityType = "ENVIRONMENT_PROFILE"
	TargetEntityTypeAssetType                         TargetEntityType = "ASSET_TYPE"
)

// Values returns all known values for TargetEntityType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (TargetEntityType) Values() []TargetEntityType {
	return []TargetEntityType{
		"DOMAIN_UNIT",
		"ENVIRONMENT_BLUEPRINT_CONFIGURATION",
		"ENVIRONMENT_PROFILE",
		"ASSET_TYPE",
	}
}

type TaskStatus string

// Enum values for TaskStatus
const (
	TaskStatusActive   TaskStatus = "ACTIVE"
	TaskStatusInactive TaskStatus = "INACTIVE"
)

// Values returns all known values for TaskStatus. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (TaskStatus) Values() []TaskStatus {
	return []TaskStatus{
		"ACTIVE",
		"INACTIVE",
	}
}

type TimeSeriesEntityType string

// Enum values for TimeSeriesEntityType
const (
	TimeSeriesEntityTypeAsset   TimeSeriesEntityType = "ASSET"
	TimeSeriesEntityTypeListing TimeSeriesEntityType = "LISTING"
)

// Values returns all known values for TimeSeriesEntityType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (TimeSeriesEntityType) Values() []TimeSeriesEntityType {
	return []TimeSeriesEntityType{
		"ASSET",
		"LISTING",
	}
}

type Timezone string

// Enum values for Timezone
const (
	TimezoneUtc                Timezone = "UTC"
	TimezoneAfricaJohannesburg Timezone = "AFRICA_JOHANNESBURG"
	TimezoneAmericaMontreal    Timezone = "AMERICA_MONTREAL"
	TimezoneAmericaSaoPaulo    Timezone = "AMERICA_SAO_PAULO"
	TimezoneAsiaBahrain        Timezone = "ASIA_BAHRAIN"
	TimezoneAsiaBangkok        Timezone = "ASIA_BANGKOK"
	TimezoneAsiaCalcutta       Timezone = "ASIA_CALCUTTA"
	TimezoneAsiaDubai          Timezone = "ASIA_DUBAI"
	TimezoneAsiaHongKong       Timezone = "ASIA_HONG_KONG"
	TimezoneAsiaJakarta        Timezone = "ASIA_JAKARTA"
	TimezoneAsiaKualaLumpur    Timezone = "ASIA_KUALA_LUMPUR"
	TimezoneAsiaSeoul          Timezone = "ASIA_SEOUL"
	TimezoneAsiaShanghai       Timezone = "ASIA_SHANGHAI"
	TimezoneAsiaSingapore      Timezone = "ASIA_SINGAPORE"
	TimezoneAsiaTaipei         Timezone = "ASIA_TAIPEI"
	TimezoneAsiaTokyo          Timezone = "ASIA_TOKYO"
	TimezoneAustraliaMelbourne Timezone = "AUSTRALIA_MELBOURNE"
	TimezoneAustraliaSydney    Timezone = "AUSTRALIA_SYDNEY"
	TimezoneCanadaCentral      Timezone = "CANADA_CENTRAL"
	TimezoneCet                Timezone = "CET"
	TimezoneCst6cdt            Timezone = "CST6CDT"
	TimezoneEtcGmt             Timezone = "ETC_GMT"
	TimezoneEtcGmt0            Timezone = "ETC_GMT0"
	TimezoneEtcGmtAdd0         Timezone = "ETC_GMT_ADD_0"
	TimezoneEtcGmtAdd1         Timezone = "ETC_GMT_ADD_1"
	TimezoneEtcGmtAdd10        Timezone = "ETC_GMT_ADD_10"
	TimezoneEtcGmtAdd11        Timezone = "ETC_GMT_ADD_11"
	TimezoneEtcGmtAdd12        Timezone = "ETC_GMT_ADD_12"
	TimezoneEtcGmtAdd2         Timezone = "ETC_GMT_ADD_2"
	TimezoneEtcGmtAdd3         Timezone = "ETC_GMT_ADD_3"
	TimezoneEtcGmtAdd4         Timezone = "ETC_GMT_ADD_4"
	TimezoneEtcGmtAdd5         Timezone = "ETC_GMT_ADD_5"
	TimezoneEtcGmtAdd6         Timezone = "ETC_GMT_ADD_6"
	TimezoneEtcGmtAdd7         Timezone = "ETC_GMT_ADD_7"
	TimezoneEtcGmtAdd8         Timezone = "ETC_GMT_ADD_8"
	TimezoneEtcGmtAdd9         Timezone = "ETC_GMT_ADD_9"
	TimezoneEtcGmtNeg0         Timezone = "ETC_GMT_NEG_0"
	TimezoneEtcGmtNeg1         Timezone = "ETC_GMT_NEG_1"
	TimezoneEtcGmtNeg10        Timezone = "ETC_GMT_NEG_10"
	TimezoneEtcGmtNeg11        Timezone = "ETC_GMT_NEG_11"
	TimezoneEtcGmtNeg12        Timezone = "ETC_GMT_NEG_12"
	TimezoneEtcGmtNeg13        Timezone = "ETC_GMT_NEG_13"
	TimezoneEtcGmtNeg14        Timezone = "ETC_GMT_NEG_14"
	TimezoneEtcGmtNeg2         Timezone = "ETC_GMT_NEG_2"
	TimezoneEtcGmtNeg3         Timezone = "ETC_GMT_NEG_3"
	TimezoneEtcGmtNeg4         Timezone = "ETC_GMT_NEG_4"
	TimezoneEtcGmtNeg5         Timezone = "ETC_GMT_NEG_5"
	TimezoneEtcGmtNeg6         Timezone = "ETC_GMT_NEG_6"
	TimezoneEtcGmtNeg7         Timezone = "ETC_GMT_NEG_7"
	TimezoneEtcGmtNeg8         Timezone = "ETC_GMT_NEG_8"
	TimezoneEtcGmtNeg9         Timezone = "ETC_GMT_NEG_9"
	TimezoneEuropeDublin       Timezone = "EUROPE_DUBLIN"
	TimezoneEuropeLondon       Timezone = "EUROPE_LONDON"
	TimezoneEuropeParis        Timezone = "EUROPE_PARIS"
	TimezoneEuropeStockholm    Timezone = "EUROPE_STOCKHOLM"
	TimezoneEuropeZurich       Timezone = "EUROPE_ZURICH"
	TimezoneIsrael             Timezone = "ISRAEL"
	TimezoneMexicoGeneral      Timezone = "MEXICO_GENERAL"
	TimezoneMst7mdt            Timezone = "MST7MDT"
	TimezonePacificAuckland    Timezone = "PACIFIC_AUCKLAND"
	TimezoneUsCentral          Timezone = "US_CENTRAL"
	TimezoneUsEastern          Timezone = "US_EASTERN"
	TimezoneUsMountain         Timezone = "US_MOUNTAIN"
	TimezoneUsPacific          Timezone = "US_PACIFIC"
)

// Values returns all known values for Timezone. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (Timezone) Values() []Timezone {
	return []Timezone{
		"UTC",
		"AFRICA_JOHANNESBURG",
		"AMERICA_MONTREAL",
		"AMERICA_SAO_PAULO",
		"ASIA_BAHRAIN",
		"ASIA_BANGKOK",
		"ASIA_CALCUTTA",
		"ASIA_DUBAI",
		"ASIA_HONG_KONG",
		"ASIA_JAKARTA",
		"ASIA_KUALA_LUMPUR",
		"ASIA_SEOUL",
		"ASIA_SHANGHAI",
		"ASIA_SINGAPORE",
		"ASIA_TAIPEI",
		"ASIA_TOKYO",
		"AUSTRALIA_MELBOURNE",
		"AUSTRALIA_SYDNEY",
		"CANADA_CENTRAL",
		"CET",
		"CST6CDT",
		"ETC_GMT",
		"ETC_GMT0",
		"ETC_GMT_ADD_0",
		"ETC_GMT_ADD_1",
		"ETC_GMT_ADD_10",
		"ETC_GMT_ADD_11",
		"ETC_GMT_ADD_12",
		"ETC_GMT_ADD_2",
		"ETC_GMT_ADD_3",
		"ETC_GMT_ADD_4",
		"ETC_GMT_ADD_5",
		"ETC_GMT_ADD_6",
		"ETC_GMT_ADD_7",
		"ETC_GMT_ADD_8",
		"ETC_GMT_ADD_9",
		"ETC_GMT_NEG_0",
		"ETC_GMT_NEG_1",
		"ETC_GMT_NEG_10",
		"ETC_GMT_NEG_11",
		"ETC_GMT_NEG_12",
		"ETC_GMT_NEG_13",
		"ETC_GMT_NEG_14",
		"ETC_GMT_NEG_2",
		"ETC_GMT_NEG_3",
		"ETC_GMT_NEG_4",
		"ETC_GMT_NEG_5",
		"ETC_GMT_NEG_6",
		"ETC_GMT_NEG_7",
		"ETC_GMT_NEG_8",
		"ETC_GMT_NEG_9",
		"EUROPE_DUBLIN",
		"EUROPE_LONDON",
		"EUROPE_PARIS",
		"EUROPE_STOCKHOLM",
		"EUROPE_ZURICH",
		"ISRAEL",
		"MEXICO_GENERAL",
		"MST7MDT",
		"PACIFIC_AUCKLAND",
		"US_CENTRAL",
		"US_EASTERN",
		"US_MOUNTAIN",
		"US_PACIFIC",
	}
}

type TypesSearchScope string

// Enum values for TypesSearchScope
const (
	TypesSearchScopeAssetType       TypesSearchScope = "ASSET_TYPE"
	TypesSearchScopeFormType        TypesSearchScope = "FORM_TYPE"
	TypesSearchScopeLineageNodeType TypesSearchScope = "LINEAGE_NODE_TYPE"
)

// Values returns all known values for TypesSearchScope. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (TypesSearchScope) Values() []TypesSearchScope {
	return []TypesSearchScope{
		"ASSET_TYPE",
		"FORM_TYPE",
		"LINEAGE_NODE_TYPE",
	}
}

type UserAssignment string

// Enum values for UserAssignment
const (
	UserAssignmentAutomatic UserAssignment = "AUTOMATIC"
	UserAssignmentManual    UserAssignment = "MANUAL"
)

// Values returns all known values for UserAssignment. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UserAssignment) Values() []UserAssignment {
	return []UserAssignment{
		"AUTOMATIC",
		"MANUAL",
	}
}

type UserDesignation string

// Enum values for UserDesignation
const (
	UserDesignationProjectOwner           UserDesignation = "PROJECT_OWNER"
	UserDesignationProjectContributor     UserDesignation = "PROJECT_CONTRIBUTOR"
	UserDesignationProjectCatalogViewer   UserDesignation = "PROJECT_CATALOG_VIEWER"
	UserDesignationProjectCatalogConsumer UserDesignation = "PROJECT_CATALOG_CONSUMER"
	UserDesignationProjectCatalogSteward  UserDesignation = "PROJECT_CATALOG_STEWARD"
)

// Values returns all known values for UserDesignation. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UserDesignation) Values() []UserDesignation {
	return []UserDesignation{
		"PROJECT_OWNER",
		"PROJECT_CONTRIBUTOR",
		"PROJECT_CATALOG_VIEWER",
		"PROJECT_CATALOG_CONSUMER",
		"PROJECT_CATALOG_STEWARD",
	}
}

type UserProfileStatus string

// Enum values for UserProfileStatus
const (
	UserProfileStatusAssigned    UserProfileStatus = "ASSIGNED"
	UserProfileStatusNotAssigned UserProfileStatus = "NOT_ASSIGNED"
	UserProfileStatusActivated   UserProfileStatus = "ACTIVATED"
	UserProfileStatusDeactivated UserProfileStatus = "DEACTIVATED"
)

// Values returns all known values for UserProfileStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UserProfileStatus) Values() []UserProfileStatus {
	return []UserProfileStatus{
		"ASSIGNED",
		"NOT_ASSIGNED",
		"ACTIVATED",
		"DEACTIVATED",
	}
}

type UserProfileType string

// Enum values for UserProfileType
const (
	UserProfileTypeIam UserProfileType = "IAM"
	UserProfileTypeSso UserProfileType = "SSO"
)

// Values returns all known values for UserProfileType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UserProfileType) Values() []UserProfileType {
	return []UserProfileType{
		"IAM",
		"SSO",
	}
}

type UserSearchType string

// Enum values for UserSearchType
const (
	UserSearchTypeSsoUser         UserSearchType = "SSO_USER"
	UserSearchTypeDatazoneUser    UserSearchType = "DATAZONE_USER"
	UserSearchTypeDatazoneSsoUser UserSearchType = "DATAZONE_SSO_USER"
	UserSearchTypeDatazoneIamUser UserSearchType = "DATAZONE_IAM_USER"
)

// Values returns all known values for UserSearchType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UserSearchType) Values() []UserSearchType {
	return []UserSearchType{
		"SSO_USER",
		"DATAZONE_USER",
		"DATAZONE_SSO_USER",
		"DATAZONE_IAM_USER",
	}
}

type UserType string

// Enum values for UserType
const (
	UserTypeIamUser UserType = "IAM_USER"
	UserTypeIamRole UserType = "IAM_ROLE"
	UserTypeSsoUser UserType = "SSO_USER"
)

// Values returns all known values for UserType. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UserType) Values() []UserType {
	return []UserType{
		"IAM_USER",
		"IAM_ROLE",
		"SSO_USER",
	}
}
