// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/deadline/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Provides information about the GPU accelerators used for jobs processed by a
// fleet.
type AcceleratorCapabilities struct {

	// A list of accelerator capabilities requested for this fleet. Only Amazon
	// Elastic Compute Cloud instances that provide these capabilities will be used.
	// For example, if you specify both L4 and T4 chips, Deadline Cloud will use Amazon
	// EC2 instances that have either the L4 or the T4 chip installed.
	//
	// This member is required.
	Selections []AcceleratorSelection

	// The number of GPU accelerators specified for worker hosts in this fleet.
	Count *AcceleratorCountRange

	noSmithyDocumentSerde
}

// Defines the maximum and minimum number of GPU accelerators required for a
// worker instance..
type AcceleratorCountRange struct {

	// The minimum number of GPU accelerators in the worker host.
	//
	// This member is required.
	Min *int32

	// The maximum number of GPU accelerators in the worker host.
	Max *int32

	noSmithyDocumentSerde
}

// Describes a specific GPU accelerator required for an Amazon Elastic Compute
// Cloud worker host.
type AcceleratorSelection struct {

	// The name of the chip used by the GPU accelerator.
	//
	// If you specify l4 as the name of the accelerator, you must specify latest or
	// grid:r550 as the runtime.
	//
	// The available GPU accelerators are:
	//
	//   - t4 - NVIDIA T4 Tensor Core GPU
	//
	//   - a10g - NVIDIA A10G Tensor Core GPU
	//
	//   - l4 - NVIDIA L4 Tensor Core GPU
	//
	//   - l40s - NVIDIA L40S Tensor Core GPU
	//
	// This member is required.
	Name AcceleratorName

	// Specifies the runtime driver to use for the GPU accelerator. You must use the
	// same runtime for all GPUs.
	//
	// You can choose from the following runtimes:
	//
	//   - latest - Use the latest runtime available for the chip. If you specify
	//   latest and a new version of the runtime is released, the new version of the
	//   runtime is used.
	//
	//   - grid:r550 - [NVIDIA vGPU software 17]
	//
	//   - grid:r535 - [NVIDIA vGPU software 16]
	//
	// If you don't specify a runtime, Deadline Cloud uses latest as the default.
	// However, if you have multiple accelerators and specify latest for some and
	// leave others blank, Deadline Cloud raises an exception.
	//
	// [NVIDIA vGPU software 16]: https://docs.nvidia.com/vgpu/16.0/index.html
	// [NVIDIA vGPU software 17]: https://docs.nvidia.com/vgpu/17.0/index.html
	Runtime *string

	noSmithyDocumentSerde
}

// Defines the maximum and minimum amount of memory, in MiB, to use for the
// accelerator.
type AcceleratorTotalMemoryMiBRange struct {

	// The minimum amount of memory to use for the accelerator, measured in MiB.
	//
	// This member is required.
	Min *int32

	// The maximum amount of memory to use for the accelerator, measured in MiB.
	Max *int32

	noSmithyDocumentSerde
}

// Provides information about the number of resources used.
type AcquiredLimit struct {

	// The number of limit resources used.
	//
	// This member is required.
	Count *int32

	// The unique identifier of the limit.
	//
	// This member is required.
	LimitId *string

	noSmithyDocumentSerde
}

// The assigned starting environment for a worker during session.
type AssignedEnvironmentEnterSessionActionDefinition struct {

	// The environment ID of the assigned environment at the start of a session.
	//
	// This member is required.
	EnvironmentId *string

	noSmithyDocumentSerde
}

// The assigned environment when a worker exits a session.
type AssignedEnvironmentExitSessionActionDefinition struct {

	// The environment ID of the assigned environment when exiting a session.
	//
	// This member is required.
	EnvironmentId *string

	noSmithyDocumentSerde
}

// The assigned session for the worker.
type AssignedSession struct {

	// The job ID for the assigned session.
	//
	// This member is required.
	JobId *string

	// The log configuration for the worker's assigned session.
	//
	// This member is required.
	LogConfiguration *LogConfiguration

	// The queue ID of the assigned session.
	//
	// This member is required.
	QueueId *string

	// The session actions to apply to the assigned session.
	//
	// This member is required.
	SessionActions []AssignedSessionAction

	noSmithyDocumentSerde
}

// The action for a session defined by the session action ID.
type AssignedSessionAction struct {

	// The definition of the assigned session action.
	//
	// This member is required.
	Definition AssignedSessionActionDefinition

	// The session action ID for the assigned session.
	//
	// This member is required.
	SessionActionId *string

	noSmithyDocumentSerde
}

// The definition of the assigned session action.
//
// The following types satisfy this interface:
//
//	AssignedSessionActionDefinitionMemberEnvEnter
//	AssignedSessionActionDefinitionMemberEnvExit
//	AssignedSessionActionDefinitionMemberSyncInputJobAttachments
//	AssignedSessionActionDefinitionMemberTaskRun
type AssignedSessionActionDefinition interface {
	isAssignedSessionActionDefinition()
}

// The environment a session starts on.
type AssignedSessionActionDefinitionMemberEnvEnter struct {
	Value AssignedEnvironmentEnterSessionActionDefinition

	noSmithyDocumentSerde
}

func (*AssignedSessionActionDefinitionMemberEnvEnter) isAssignedSessionActionDefinition() {}

// The environment a session exits from.
type AssignedSessionActionDefinitionMemberEnvExit struct {
	Value AssignedEnvironmentExitSessionActionDefinition

	noSmithyDocumentSerde
}

func (*AssignedSessionActionDefinitionMemberEnvExit) isAssignedSessionActionDefinition() {}

// The job attachment to sync with an assigned session action.
type AssignedSessionActionDefinitionMemberSyncInputJobAttachments struct {
	Value AssignedSyncInputJobAttachmentsSessionActionDefinition

	noSmithyDocumentSerde
}

func (*AssignedSessionActionDefinitionMemberSyncInputJobAttachments) isAssignedSessionActionDefinition() {
}

// The task run.
type AssignedSessionActionDefinitionMemberTaskRun struct {
	Value AssignedTaskRunSessionActionDefinition

	noSmithyDocumentSerde
}

func (*AssignedSessionActionDefinitionMemberTaskRun) isAssignedSessionActionDefinition() {}

// The details for an assigned session action as it relates to a job attachment.
type AssignedSyncInputJobAttachmentsSessionActionDefinition struct {

	// The step ID.
	StepId *string

	noSmithyDocumentSerde
}

// The specific task, step, and parameters to include.
type AssignedTaskRunSessionActionDefinition struct {

	// The parameters to include.
	//
	// This member is required.
	Parameters map[string]TaskParameterValue

	// The step ID.
	//
	// This member is required.
	StepId *string

	// The task ID.
	TaskId *string

	noSmithyDocumentSerde
}

// The attachments for jobs.
type Attachments struct {

	// A list of manifests which describe job attachment configurations.
	//
	// This member is required.
	Manifests []ManifestProperties

	// The file system.
	FileSystem JobAttachmentsFileSystem

	noSmithyDocumentSerde
}

// The Identity and Access Management credentials.
type AwsCredentials struct {

	// The IAM access key ID.
	//
	// This member is required.
	AccessKeyId *string

	// The expiration date and time of the IAM credentials.
	//
	// This member is required.
	Expiration *time.Time

	// The IAM secret access key.
	//
	// This member is required.
	SecretAccessKey *string

	// The IAM session token
	//
	// This member is required.
	SessionToken *string

	noSmithyDocumentSerde
}

// The budget action to add.
type BudgetActionToAdd struct {

	// The percentage threshold for the budget action to add.
	//
	// This member is required.
	ThresholdPercentage *float32

	// The type of budget action to add.
	//
	// This member is required.
	Type BudgetActionType

	// A description for the budget action to add.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	Description *string

	noSmithyDocumentSerde
}

// The budget action to remove.
type BudgetActionToRemove struct {

	// The percentage threshold for the budget action to remove.
	//
	// This member is required.
	ThresholdPercentage *float32

	// The type of budget action to remove.
	//
	// This member is required.
	Type BudgetActionType

	noSmithyDocumentSerde
}

// The start and end time of the budget.
//
// The following types satisfy this interface:
//
//	BudgetScheduleMemberFixed
type BudgetSchedule interface {
	isBudgetSchedule()
}

// The fixed start and end time of the budget's schedule.
type BudgetScheduleMemberFixed struct {
	Value FixedBudgetSchedule

	noSmithyDocumentSerde
}

func (*BudgetScheduleMemberFixed) isBudgetSchedule() {}

// The budget summary.
type BudgetSummary struct {

	// The approximate dollar limit of the budget.
	//
	// This member is required.
	ApproximateDollarLimit *float32

	// The budget ID.
	//
	// This member is required.
	BudgetId *string

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The display name of the budget summary to update.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The status of the budget.
	//
	//   - ACTIVE –The budget is being evaluated.
	//
	//   - INACTIVE –The budget is inactive. This can include Expired, Canceled, or
	//   deleted Deleted statuses.
	//
	// This member is required.
	Status BudgetStatus

	// The resource used to track expenditure in the budget.
	//
	// This member is required.
	UsageTrackingResource UsageTrackingResource

	// The consumed usage for the budget.
	//
	// This member is required.
	Usages *ConsumedUsages

	// The description of the budget summary.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// Deprecated: ListBudgets no longer supports description. Use GetBudget if
	// description is needed.
	Description *string

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The consumed usage for the resource.
type ConsumedUsages struct {

	// The amount of the budget consumed.
	//
	// This member is required.
	ApproximateDollarUsage *float32

	noSmithyDocumentSerde
}

// The details of a customer managed fleet configuration.
type CustomerManagedFleetConfiguration struct {

	// The Auto Scaling mode for the customer managed fleet configuration.
	//
	// This member is required.
	Mode AutoScalingMode

	// The worker capabilities for a customer managed fleet configuration.
	//
	// This member is required.
	WorkerCapabilities *CustomerManagedWorkerCapabilities

	// The storage profile ID.
	StorageProfileId *string

	// Specifies whether tags associated with a fleet are attached to workers when the
	// worker is launched.
	//
	// When the tagPropagationMode is set to PROPAGATE_TAGS_TO_WORKERS_AT_LAUNCH any
	// tag associated with a fleet is attached to workers when they launch. If the tags
	// for a fleet change, the tags associated with running workers do not change.
	//
	// If you don't specify tagPropagationMode , the default is NO_PROPAGATION .
	TagPropagationMode TagPropagationMode

	noSmithyDocumentSerde
}

// The worker capabilities for a customer managed workflow.
type CustomerManagedWorkerCapabilities struct {

	// The CPU architecture type for the customer managed worker capabilities.
	//
	// This member is required.
	CpuArchitectureType CpuArchitectureType

	// The memory (MiB).
	//
	// This member is required.
	MemoryMiB *MemoryMiBRange

	// The operating system (OS) family.
	//
	// This member is required.
	OsFamily CustomerManagedFleetOperatingSystemFamily

	// The vCPU count for the customer manged worker capabilities.
	//
	// This member is required.
	VCpuCount *VCpuCountRange

	// The range of the accelerator.
	AcceleratorCount *AcceleratorCountRange

	// The total memory (MiB) for the customer managed worker capabilities.
	AcceleratorTotalMemoryMiB *AcceleratorTotalMemoryMiBRange

	// The accelerator types for the customer managed worker capabilities.
	AcceleratorTypes []AcceleratorType

	// Custom requirement ranges for customer managed worker capabilities.
	CustomAmounts []FleetAmountCapability

	// Custom attributes for the customer manged worker capabilities.
	CustomAttributes []FleetAttributeCapability

	noSmithyDocumentSerde
}

// The time stamp in date-time format.
type DateTimeFilterExpression struct {

	// The date and time.
	//
	// This member is required.
	DateTime *time.Time

	// The name of the date-time field to filter on.
	//
	// This member is required.
	Name *string

	// The type of comparison to use to filter the results.
	//
	// This member is required.
	Operator ComparisonOperator

	noSmithyDocumentSerde
}

// The number of dependencies for the consumer.
type DependencyCounts struct {

	// The number of consumers resolved.
	//
	// This member is required.
	ConsumersResolved *int32

	// The number of unresolved consumers.
	//
	// This member is required.
	ConsumersUnresolved *int32

	// The number of resolved dependencies.
	//
	// This member is required.
	DependenciesResolved *int32

	// The number of unresolved dependencies.
	//
	// This member is required.
	DependenciesUnresolved *int32

	noSmithyDocumentSerde
}

// Specifies the EBS volume.
type Ec2EbsVolume struct {

	// The IOPS per volume.
	Iops *int32

	// The EBS volume size in GiB.
	SizeGiB *int32

	// The throughput per volume in MiB.
	ThroughputMiB *int32

	noSmithyDocumentSerde
}

// The details of a specified environment.
type EnvironmentDetailsEntity struct {

	// The environment ID.
	//
	// This member is required.
	EnvironmentId *string

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The schema version in the environment.
	//
	// This member is required.
	SchemaVersion *string

	// The template used for the environment.
	//
	// This member is required.
	Template document.Interface

	noSmithyDocumentSerde
}

// The error details for the environment.
type EnvironmentDetailsError struct {

	// The error code.
	//
	// This member is required.
	Code JobEntityErrorCode

	// The environment ID.
	//
	// This member is required.
	EnvironmentId *string

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The error message detailing the error's cause.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// The IDs of the job and environment.
type EnvironmentDetailsIdentifiers struct {

	// The environment ID.
	//
	// This member is required.
	EnvironmentId *string

	// The job ID.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

// The environment ID to use to enter a session action.
type EnvironmentEnterSessionActionDefinition struct {

	// The environment ID.
	//
	// This member is required.
	EnvironmentId *string

	noSmithyDocumentSerde
}

// Defines the environment a session action enters in.
type EnvironmentEnterSessionActionDefinitionSummary struct {

	// The environment ID.
	//
	// This member is required.
	EnvironmentId *string

	noSmithyDocumentSerde
}

// Defines the environment a session action exits from.
type EnvironmentExitSessionActionDefinition struct {

	// The environment ID.
	//
	// This member is required.
	EnvironmentId *string

	noSmithyDocumentSerde
}

// A summary of the environment details for which a session action to exits.
type EnvironmentExitSessionActionDefinitionSummary struct {

	// The environment ID.
	//
	// This member is required.
	EnvironmentId *string

	noSmithyDocumentSerde
}

// The member of a farm.
type FarmMember struct {

	// The farm ID of the farm member.
	//
	// This member is required.
	FarmId *string

	// The identity store ID of the farm member.
	//
	// This member is required.
	IdentityStoreId *string

	// The farm member's membership level.
	//
	// This member is required.
	MembershipLevel MembershipLevel

	// The principal ID of the farm member.
	//
	// This member is required.
	PrincipalId *string

	// The principal type of the farm member.
	//
	// This member is required.
	PrincipalType DeadlinePrincipalType

	noSmithyDocumentSerde
}

// The summary of details for a farm.
type FarmSummary struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The display name of the farm.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The farm ID.
	//
	// This member is required.
	FarmId *string

	// The ARN for the KMS key.
	KmsKeyArn *string

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The field sorting order and name of the field.
type FieldSortExpression struct {

	// The name of the field.
	//
	// This member is required.
	Name *string

	// The sort order for the field.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// The details of the file system location for the resource.
type FileSystemLocation struct {

	// The location name.
	//
	// This member is required.
	Name *string

	// The file path.
	//
	// This member is required.
	Path *string

	// The type of file.
	//
	// This member is required.
	Type FileSystemLocationType

	noSmithyDocumentSerde
}

// The details of a fixed budget schedule.
type FixedBudgetSchedule struct {

	// When the budget ends.
	//
	// This member is required.
	EndTime *time.Time

	// When the budget starts.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// The fleet amount and attribute capabilities.
type FleetAmountCapability struct {

	// The minimum amount of fleet worker capability.
	//
	// This member is required.
	Min *float32

	// The name of the fleet capability.
	//
	// This member is required.
	Name *string

	// The maximum amount of the fleet worker capability.
	Max *float32

	noSmithyDocumentSerde
}

// Defines the fleet's capability name, minimum, and maximum.
type FleetAttributeCapability struct {

	// The name of the fleet attribute capability for the worker.
	//
	// This member is required.
	Name *string

	// The number of fleet attribute capabilities.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The amounts and attributes of fleets.
type FleetCapabilities struct {

	// Amount capabilities of the fleet.
	Amounts []FleetAmountCapability

	// Attribute capabilities of the fleet.
	Attributes []FleetAttributeCapability

	noSmithyDocumentSerde
}

// Fleet configuration details.
//
// The following types satisfy this interface:
//
//	FleetConfigurationMemberCustomerManaged
//	FleetConfigurationMemberServiceManagedEc2
type FleetConfiguration interface {
	isFleetConfiguration()
}

// The customer managed fleets within a fleet configuration.
type FleetConfigurationMemberCustomerManaged struct {
	Value CustomerManagedFleetConfiguration

	noSmithyDocumentSerde
}

func (*FleetConfigurationMemberCustomerManaged) isFleetConfiguration() {}

// The service managed Amazon EC2 instances for a fleet configuration.
type FleetConfigurationMemberServiceManagedEc2 struct {
	Value ServiceManagedEc2FleetConfiguration

	noSmithyDocumentSerde
}

func (*FleetConfigurationMemberServiceManagedEc2) isFleetConfiguration() {}

// The fleet member.
type FleetMember struct {

	// The farm ID.
	//
	// This member is required.
	FarmId *string

	// The fleet ID.
	//
	// This member is required.
	FleetId *string

	// The identity store ID.
	//
	// This member is required.
	IdentityStoreId *string

	// The fleet member's membership level.
	//
	// This member is required.
	MembershipLevel MembershipLevel

	// The principal ID of the fleet member.
	//
	// This member is required.
	PrincipalId *string

	// The principal type of the fleet member.
	//
	// This member is required.
	PrincipalType DeadlinePrincipalType

	noSmithyDocumentSerde
}

// The details of a fleet.
type FleetSummary struct {

	// The configuration details for the fleet.
	//
	// This member is required.
	Configuration FleetConfiguration

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The display name of the fleet summary to update.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The farm ID.
	//
	// This member is required.
	FarmId *string

	// The fleet ID.
	//
	// This member is required.
	FleetId *string

	// The maximum number of workers specified in the fleet.
	//
	// This member is required.
	MaxWorkerCount *int32

	// The minimum number of workers in the fleet.
	//
	// This member is required.
	MinWorkerCount *int32

	// The status of the fleet.
	//
	// This member is required.
	Status FleetStatus

	// The number of workers in the fleet summary.
	//
	// This member is required.
	WorkerCount *int32

	// The Auto Scaling status of a fleet.
	AutoScalingStatus AutoScalingStatus

	// The target number of workers in a fleet.
	TargetWorkerCount *int32

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The error for the job entity.
//
// The following types satisfy this interface:
//
//	GetJobEntityErrorMemberEnvironmentDetails
//	GetJobEntityErrorMemberJobAttachmentDetails
//	GetJobEntityErrorMemberJobDetails
//	GetJobEntityErrorMemberStepDetails
type GetJobEntityError interface {
	isGetJobEntityError()
}

// The environment details for the failed job entity.
type GetJobEntityErrorMemberEnvironmentDetails struct {
	Value EnvironmentDetailsError

	noSmithyDocumentSerde
}

func (*GetJobEntityErrorMemberEnvironmentDetails) isGetJobEntityError() {}

// The job attachment details for the failed job entity.
type GetJobEntityErrorMemberJobAttachmentDetails struct {
	Value JobAttachmentDetailsError

	noSmithyDocumentSerde
}

func (*GetJobEntityErrorMemberJobAttachmentDetails) isGetJobEntityError() {}

// The job details for the failed job entity.
type GetJobEntityErrorMemberJobDetails struct {
	Value JobDetailsError

	noSmithyDocumentSerde
}

func (*GetJobEntityErrorMemberJobDetails) isGetJobEntityError() {}

// The step details for the failed job entity.
type GetJobEntityErrorMemberStepDetails struct {
	Value StepDetailsError

	noSmithyDocumentSerde
}

func (*GetJobEntityErrorMemberStepDetails) isGetJobEntityError() {}

// Provides a script that runs as a worker is starting up that you can use to
// provide additional configuration for workers in your fleet.
//
// To remove a script from a fleet, use the [UpdateFleet] operation with the hostConfiguration
// scriptBody parameter set to an empty string ("").
//
// [UpdateFleet]: https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html
type HostConfiguration struct {

	// The text of the script that runs as a worker is starting up that you can use to
	// provide additional configuration for workers in your fleet. The script runs
	// after a worker enters the STARTING state and before the worker processes tasks.
	//
	// For more information about using the script, see [Run scripts as an administrator to configure workers] in the Deadline Cloud
	// Developer Guide.
	//
	// The script runs as an administrative user ( sudo root on Linux, as an
	// Administrator on Windows).
	//
	// [Run scripts as an administrator to configure workers]: https://docs.aws.amazon.com/deadline-cloud/latest/developerguide/smf-admin.html
	//
	// This member is required.
	ScriptBody *string

	// The maximum time that the host configuration can run. If the timeout expires,
	// the worker enters the NOT RESPONDING state and shuts down. You are charged for
	// the time that the worker is running the host configuration script.
	//
	// You should configure your fleet for a maximum of one worker while testing your
	// host configuration script to avoid starting additional workers.
	//
	// The default is 300 seconds (5 minutes).
	ScriptTimeoutSeconds *int32

	noSmithyDocumentSerde
}

// The host property details.
type HostPropertiesRequest struct {

	// The host name.
	HostName *string

	// The IP address of the host.
	IpAddresses *IpAddresses

	noSmithyDocumentSerde
}

// The host property details.
type HostPropertiesResponse struct {

	// The ARN of the host EC2 instance.
	Ec2InstanceArn *string

	// The instance type of the host EC2 instance.
	Ec2InstanceType *string

	// The host name.
	HostName *string

	// The IP address of the host.
	IpAddresses *IpAddresses

	noSmithyDocumentSerde
}

// The IP addresses for a host.
type IpAddresses struct {

	// The IpV4 address of the network.
	IpV4Addresses []string

	// The IpV6 address for the network and node component.
	IpV6Addresses []string

	noSmithyDocumentSerde
}

// The job attachments.
type JobAttachmentDetailsEntity struct {

	// The job attachments.
	//
	// This member is required.
	Attachments *Attachments

	// The job ID.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

// The error details for job attachments.
type JobAttachmentDetailsError struct {

	// The error code.
	//
	// This member is required.
	Code JobEntityErrorCode

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The error message detailing the error's cause.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Identifier details for job attachments.
type JobAttachmentDetailsIdentifiers struct {

	// The job ID.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

// The job attachment settings. These are the Amazon S3 bucket name and the Amazon
// S3 prefix.
type JobAttachmentSettings struct {

	// The root prefix.
	//
	// This member is required.
	RootPrefix *string

	// The Amazon S3 bucket name.
	//
	// This member is required.
	S3BucketName *string

	noSmithyDocumentSerde
}

// The job details for a specific job.
type JobDetailsEntity struct {

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The log group name.
	//
	// This member is required.
	LogGroupName *string

	// The schema version.
	//
	// This member is required.
	SchemaVersion *string

	// The job attachment settings.
	JobAttachmentSettings *JobAttachmentSettings

	// The user name and group that the job uses when run.
	JobRunAsUser *JobRunAsUser

	// The parameters.
	Parameters map[string]JobParameter

	// The path mapping rules.
	PathMappingRules []PathMappingRule

	// The queue role ARN.
	QueueRoleArn *string

	noSmithyDocumentSerde
}

// The details of a job error.
type JobDetailsError struct {

	// The error code.
	//
	// This member is required.
	Code JobEntityErrorCode

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The error message detailing the error's cause.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// The identifiers for a job.
type JobDetailsIdentifiers struct {

	// The job ID.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

// The details of a job entity.
//
// The following types satisfy this interface:
//
//	JobEntityMemberEnvironmentDetails
//	JobEntityMemberJobAttachmentDetails
//	JobEntityMemberJobDetails
//	JobEntityMemberStepDetails
type JobEntity interface {
	isJobEntity()
}

// The environment details for the job entity.
type JobEntityMemberEnvironmentDetails struct {
	Value EnvironmentDetailsEntity

	noSmithyDocumentSerde
}

func (*JobEntityMemberEnvironmentDetails) isJobEntity() {}

// The job attachment details.
type JobEntityMemberJobAttachmentDetails struct {
	Value JobAttachmentDetailsEntity

	noSmithyDocumentSerde
}

func (*JobEntityMemberJobAttachmentDetails) isJobEntity() {}

// The job details.
type JobEntityMemberJobDetails struct {
	Value JobDetailsEntity

	noSmithyDocumentSerde
}

func (*JobEntityMemberJobDetails) isJobEntity() {}

// The step details.
type JobEntityMemberStepDetails struct {
	Value StepDetailsEntity

	noSmithyDocumentSerde
}

func (*JobEntityMemberStepDetails) isJobEntity() {}

// The details of a job entity identifier.
//
// The following types satisfy this interface:
//
//	JobEntityIdentifiersUnionMemberEnvironmentDetails
//	JobEntityIdentifiersUnionMemberJobAttachmentDetails
//	JobEntityIdentifiersUnionMemberJobDetails
//	JobEntityIdentifiersUnionMemberStepDetails
type JobEntityIdentifiersUnion interface {
	isJobEntityIdentifiersUnion()
}

// The environment details.
type JobEntityIdentifiersUnionMemberEnvironmentDetails struct {
	Value EnvironmentDetailsIdentifiers

	noSmithyDocumentSerde
}

func (*JobEntityIdentifiersUnionMemberEnvironmentDetails) isJobEntityIdentifiersUnion() {}

// The job attachment details.
type JobEntityIdentifiersUnionMemberJobAttachmentDetails struct {
	Value JobAttachmentDetailsIdentifiers

	noSmithyDocumentSerde
}

func (*JobEntityIdentifiersUnionMemberJobAttachmentDetails) isJobEntityIdentifiersUnion() {}

// The job details.
type JobEntityIdentifiersUnionMemberJobDetails struct {
	Value JobDetailsIdentifiers

	noSmithyDocumentSerde
}

func (*JobEntityIdentifiersUnionMemberJobDetails) isJobEntityIdentifiersUnion() {}

// The step details.
type JobEntityIdentifiersUnionMemberStepDetails struct {
	Value StepDetailsIdentifiers

	noSmithyDocumentSerde
}

func (*JobEntityIdentifiersUnionMemberStepDetails) isJobEntityIdentifiersUnion() {}

// The details for a job member.
type JobMember struct {

	// The farm ID.
	//
	// This member is required.
	FarmId *string

	// The identity store ID.
	//
	// This member is required.
	IdentityStoreId *string

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The job member's membership level.
	//
	// This member is required.
	MembershipLevel MembershipLevel

	// The principal ID of the job member.
	//
	// This member is required.
	PrincipalId *string

	// The principal type of the job member.
	//
	// This member is required.
	PrincipalType DeadlinePrincipalType

	// The queue ID.
	//
	// This member is required.
	QueueId *string

	noSmithyDocumentSerde
}

// The details of job parameters.
//
// The following types satisfy this interface:
//
//	JobParameterMemberFloat
//	JobParameterMemberInt
//	JobParameterMemberPath
//	JobParameterMemberString
type JobParameter interface {
	isJobParameter()
}

// A double precision IEEE-754 floating point number represented as a string.
type JobParameterMemberFloat struct {
	Value string

	noSmithyDocumentSerde
}

func (*JobParameterMemberFloat) isJobParameter() {}

// A signed integer represented as a string.
type JobParameterMemberInt struct {
	Value string

	noSmithyDocumentSerde
}

func (*JobParameterMemberInt) isJobParameter() {}

// A file system path represented as a string.
type JobParameterMemberPath struct {
	Value string

	noSmithyDocumentSerde
}

func (*JobParameterMemberPath) isJobParameter() {}

// A UTF-8 string.
type JobParameterMemberString struct {
	Value string

	noSmithyDocumentSerde
}

func (*JobParameterMemberString) isJobParameter() {}

// Identifies the user for a job.
type JobRunAsUser struct {

	// Specifies whether the job should run using the queue's system user or if the
	// job should run using the worker agent system user.
	//
	// This member is required.
	RunAs RunAs

	// The user and group that the jobs in the queue run as.
	Posix *PosixUser

	// Identifies a Microsoft Windows user.
	Windows *WindowsUser

	noSmithyDocumentSerde
}

// The details of a job search.
type JobSearchSummary struct {

	// The date and time the resource was created.
	CreatedAt *time.Time

	// The user or system that created this resource.
	CreatedBy *string

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The job ID.
	JobId *string

	// The job parameters.
	JobParameters map[string]JobParameter

	// The life cycle status.
	LifecycleStatus JobLifecycleStatus

	// The life cycle status message.
	LifecycleStatusMessage *string

	// The number of task failures before the job stops running and is marked as FAILED
	// .
	MaxFailedTasksCount *int32

	// The maximum number of retries for a job.
	MaxRetriesPerTask *int32

	// The maximum number of worker hosts that can concurrently process a job. When
	// the maxWorkerCount is reached, no more workers will be assigned to process the
	// job, even if the fleets assigned to the job's queue has available workers.
	//
	// You can't set the maxWorkerCount to 0. If you set it to -1, there is no maximum
	// number of workers.
	//
	// If you don't specify the maxWorkerCount , the default is -1.
	MaxWorkerCount *int32

	// The job name.
	Name *string

	// The job priority.
	Priority *int32

	// The queue ID.
	QueueId *string

	// The job ID for the source job.
	SourceJobId *string

	// The date and time the resource started running.
	StartedAt *time.Time

	// The task status to start with on the job.
	TargetTaskRunStatus JobTargetTaskRunStatus

	// The task run status for the job.
	//
	//   - PENDING –pending and waiting for resources.
	//
	//   - READY –ready to be processed.
	//
	//   - ASSIGNED –assigned and will run next on a worker.
	//
	//   - SCHEDULED –scheduled to be run on a worker.
	//
	//   - INTERRUPTING –being interrupted.
	//
	//   - RUNNING –running on a worker.
	//
	//   - SUSPENDED –the task is suspended.
	//
	//   - CANCELED –the task has been canceled.
	//
	//   - FAILED –the task has failed.
	//
	//   - SUCCEEDED –the task has succeeded.
	TaskRunStatus TaskRunStatus

	// The number of tasks running on the job.
	TaskRunStatusCounts map[string]int32

	noSmithyDocumentSerde
}

// A summary of job details.
type JobSummary struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The life cycle status.
	//
	// This member is required.
	LifecycleStatus JobLifecycleStatus

	// The life cycle status message.
	//
	// This member is required.
	LifecycleStatusMessage *string

	// The job name.
	//
	// This member is required.
	Name *string

	// The job priority.
	//
	// This member is required.
	Priority *int32

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The number of task failures before the job stops running and is marked as FAILED
	// .
	MaxFailedTasksCount *int32

	// The maximum number of retries for a job.
	MaxRetriesPerTask *int32

	// The maximum number of worker hosts that can concurrently process a job. When
	// the maxWorkerCount is reached, no more workers will be assigned to process the
	// job, even if the fleets assigned to the job's queue has available workers.
	//
	// You can't set the maxWorkerCount to 0. If you set it to -1, there is no maximum
	// number of workers.
	//
	// If you don't specify the maxWorkerCount , the default is -1.
	MaxWorkerCount *int32

	// The job ID for the source job.
	SourceJobId *string

	// The date and time the resource started running.
	StartedAt *time.Time

	// The task status to start with on the job.
	TargetTaskRunStatus JobTargetTaskRunStatus

	// The task run status for the job.
	//
	//   - PENDING –pending and waiting for resources.
	//
	//   - READY –ready to be processed.
	//
	//   - ASSIGNED –assigned and will run next on a worker.
	//
	//   - SCHEDULED –scheduled to be run on a worker.
	//
	//   - INTERRUPTING –being interrupted.
	//
	//   - RUNNING –running on a worker.
	//
	//   - SUSPENDED –the task is suspended.
	//
	//   - CANCELED –the task has been canceled.
	//
	//   - FAILED –the task has failed.
	//
	//   - SUCCEEDED –the task has succeeded.
	TaskRunStatus TaskRunStatus

	// The number of tasks running on the job.
	TaskRunStatusCounts map[string]int32

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details for a license endpoint.
type LicenseEndpointSummary struct {

	// The license endpoint ID.
	LicenseEndpointId *string

	// The status of the license endpoint.
	Status LicenseEndpointStatus

	// The status message of the license endpoint.
	StatusMessage *string

	// The VCP(virtual private cloud) ID associated with the license endpoint.
	VpcId *string

	noSmithyDocumentSerde
}

// Provides information about a specific limit.
type LimitSummary struct {

	// The value that you specify as the name in the amounts field of the
	// hostRequirements in a step of a job template to declare the limit requirement.
	//
	// This member is required.
	AmountRequirementName *string

	// The Unix timestamp of the date and time that the limit was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user identifier of the person that created the limit.
	//
	// This member is required.
	CreatedBy *string

	// The number of resources from the limit that are being used by jobs. The result
	// is delayed and may not be the count at the time that you called the operation.
	//
	// This member is required.
	CurrentCount *int32

	// The name of the limit used in lists to identify the limit.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The unique identifier of the farm that contains the limit.
	//
	// This member is required.
	FarmId *string

	// The unique identifier of the limit.
	//
	// This member is required.
	LimitId *string

	// The maximum number of resources constrained by this limit. When all of the
	// resources are in use, steps that require the limit won't be scheduled until the
	// resource is available.
	//
	// The maxValue must not be 0. If the value is -1, there is no restriction on the
	// number of resources that can be acquired for this limit.
	//
	// This member is required.
	MaxCount *int32

	// The Unix timestamp of the date and time that the limit was last updated.
	UpdatedAt *time.Time

	// The user identifier of the person that last updated the limit.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// Log configuration details.
type LogConfiguration struct {

	// The log drivers for worker related logs.
	//
	// This member is required.
	LogDriver *string

	// The log configuration error details.
	Error *string

	// The options for a log driver.
	Options map[string]string

	// The parameters for the log configuration.
	Parameters map[string]string

	noSmithyDocumentSerde
}

// The details of the manifest that links a job's source information.
type ManifestProperties struct {

	// The file's root path.
	//
	// This member is required.
	RootPath *string

	// The format of the root path.
	//
	// This member is required.
	RootPathFormat PathFormat

	// The file system location name.
	FileSystemLocationName *string

	// The hash value of the file.
	InputManifestHash *string

	// The file path.
	InputManifestPath *string

	// The file path relative to the directory.
	OutputRelativeDirectories []string

	noSmithyDocumentSerde
}

// The range of memory in MiB.
type MemoryMiBRange struct {

	// The minimum amount of memory (in MiB).
	//
	// This member is required.
	Min *int32

	// The maximum amount of memory (in MiB).
	Max *int32

	noSmithyDocumentSerde
}

// The details of a metered product.
type MeteredProductSummary struct {

	// The family to which the metered product belongs.
	//
	// This member is required.
	Family *string

	// The port on which the metered product should run.
	//
	// This member is required.
	Port *int32

	// The product ID.
	//
	// This member is required.
	ProductId *string

	// The vendor.
	//
	// This member is required.
	Vendor *string

	noSmithyDocumentSerde
}

// Provides information about a monitor in Deadline Cloud.
type MonitorSummary struct {

	// The UNIX timestamp of the date and time that the monitor was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user name of the person that created the monitor.
	//
	// This member is required.
	CreatedBy *string

	// The name of the monitor that displays on the Deadline Cloud console.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the
	// monitor when it was created.
	//
	// This member is required.
	IdentityCenterApplicationArn *string

	// The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible
	// for authenticating monitor users.
	//
	// This member is required.
	IdentityCenterInstanceArn *string

	// The unique identifier for the monitor.
	//
	// This member is required.
	MonitorId *string

	// The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the
	// monitor use this role to access Deadline Cloud resources.
	//
	// This member is required.
	RoleArn *string

	// The subdomain used for the monitor URL. The full URL of the monitor is
	// subdomain.Region.deadlinecloud.amazonaws.com.
	//
	// This member is required.
	Subdomain *string

	// The complete URL of the monitor. The full URL of the monitor is
	// subdomain.Region.deadlinecloud.amazonaws.com.
	//
	// This member is required.
	Url *string

	// The UNIX timestamp of the date and time that the monitor was last updated.
	UpdatedAt *time.Time

	// The user name of the person that last updated the monitor.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a filtered search for parameters.
type ParameterFilterExpression struct {

	// The name of the parameter to filter on.
	//
	// This member is required.
	Name *string

	// The type of comparison to use to filter results.
	//
	// This member is required.
	Operator ComparisonOperator

	// The parameter's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Organizes parameters according to your specifications.
type ParameterSortExpression struct {

	// The parameter name to sort by.
	//
	// This member is required.
	Name *string

	// The sort order for the parameter.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// The details of a search for two or more step parameters.
type ParameterSpace struct {

	// The parameters to search for.
	//
	// This member is required.
	Parameters []StepParameter

	// The combination expression to use in the search.
	Combination *string

	noSmithyDocumentSerde
}

// The details of a source and destination path.
type PathMappingRule struct {

	// The destination path.
	//
	// This member is required.
	DestinationPath *string

	// The source path.
	//
	// This member is required.
	SourcePath *string

	// The source path format.
	//
	// This member is required.
	SourcePathFormat PathFormat

	noSmithyDocumentSerde
}

// The POSIX user.
type PosixUser struct {

	// The name of the POSIX user's group.
	//
	// This member is required.
	Group *string

	// The name of the POSIX user.
	//
	// This member is required.
	User *string

	noSmithyDocumentSerde
}

// The summary of a queue environment.
type QueueEnvironmentSummary struct {

	// The name of the queue environment.
	//
	// This member is required.
	Name *string

	// The queue environment's priority.
	//
	// This member is required.
	Priority *int32

	// The queue environment ID.
	//
	// This member is required.
	QueueEnvironmentId *string

	noSmithyDocumentSerde
}

// The details of a queue-fleet association.
type QueueFleetAssociationSummary struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The fleet ID.
	//
	// This member is required.
	FleetId *string

	// The queue ID.
	//
	// This member is required.
	QueueId *string

	// The status of task scheduling in the queue-fleet association.
	//
	//   - ACTIVE –Association is active.
	//
	//   - STOP_SCHEDULING_AND_COMPLETE_TASKS –Association has stopped scheduling new
	//   tasks and is completing current tasks.
	//
	//   - STOP_SCHEDULING_AND_CANCEL_TASKS –Association has stopped scheduling new
	//   tasks and is canceling current tasks.
	//
	//   - STOPPED –Association has been stopped.
	//
	// This member is required.
	Status QueueFleetAssociationStatus

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// Provides information about the association between a queue and a limit.
type QueueLimitAssociationSummary struct {

	// The Unix timestamp of the date and time that the association was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user identifier of the person that created the association.
	//
	// This member is required.
	CreatedBy *string

	// The unique identifier of the limit in the association.
	//
	// This member is required.
	LimitId *string

	// The unique identifier of the queue in the association.
	//
	// This member is required.
	QueueId *string

	// The status of task scheduling in the queue-limit association.
	//
	//   - ACTIVE - Association is active.
	//
	//   - STOP_LIMIT_USAGE_AND_COMPLETE_TASKS - Association has stopped scheduling new
	//   tasks and is completing current tasks.
	//
	//   - STOP_LIMIT_USAGE_AND_CANCEL_TASKS - Association has stopped scheduling new
	//   tasks and is canceling current tasks.
	//
	//   - STOPPED - Association has been stopped.
	//
	// This member is required.
	Status QueueLimitAssociationStatus

	// The Unix timestamp of the date and time that the association was last updated.
	UpdatedAt *time.Time

	// The user identifier of the person that updated the association.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a queue member.
type QueueMember struct {

	// The farm ID.
	//
	// This member is required.
	FarmId *string

	// The identity store ID.
	//
	// This member is required.
	IdentityStoreId *string

	// The queue member's membership level.
	//
	// This member is required.
	MembershipLevel MembershipLevel

	// The principal ID of the queue member.
	//
	// This member is required.
	PrincipalId *string

	// The principal type of the queue member.
	//
	// This member is required.
	PrincipalType DeadlinePrincipalType

	// The queue ID.
	//
	// This member is required.
	QueueId *string

	noSmithyDocumentSerde
}

// The details of a queue summary.
type QueueSummary struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The default action taken on a queue summary if a budget wasn't configured.
	//
	// This member is required.
	DefaultBudgetAction DefaultQueueBudgetAction

	// The display name of the queue summary to update.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The farm ID.
	//
	// This member is required.
	FarmId *string

	// The queue ID.
	//
	// This member is required.
	QueueId *string

	// That status of the queue.
	//
	// This member is required.
	Status QueueStatus

	// The reason the queue is blocked, if applicable.
	BlockedReason QueueBlockedReason

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a budget action.
type ResponseBudgetAction struct {

	// The percentage threshold for the budget.
	//
	// This member is required.
	ThresholdPercentage *float32

	// The action taken on the budget once scheduling stops.
	//
	// This member is required.
	Type BudgetActionType

	// The budget action description.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	Description *string

	noSmithyDocumentSerde
}

// The Amazon S3 location information.
type S3Location struct {

	// The name of the Amazon S3 bucket.
	//
	// This member is required.
	BucketName *string

	// The Amazon S3 object key that uniquely identifies the Amazon S3 bucket.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// The type of search filter to apply.
//
// The following types satisfy this interface:
//
//	SearchFilterExpressionMemberDateTimeFilter
//	SearchFilterExpressionMemberGroupFilter
//	SearchFilterExpressionMemberParameterFilter
//	SearchFilterExpressionMemberSearchTermFilter
//	SearchFilterExpressionMemberStringFilter
type SearchFilterExpression interface {
	isSearchFilterExpression()
}

// Filters based on date and time.
type SearchFilterExpressionMemberDateTimeFilter struct {
	Value DateTimeFilterExpression

	noSmithyDocumentSerde
}

func (*SearchFilterExpressionMemberDateTimeFilter) isSearchFilterExpression() {}

// Filters by group.
type SearchFilterExpressionMemberGroupFilter struct {
	Value SearchGroupedFilterExpressions

	noSmithyDocumentSerde
}

func (*SearchFilterExpressionMemberGroupFilter) isSearchFilterExpression() {}

// Filters by parameter.
type SearchFilterExpressionMemberParameterFilter struct {
	Value ParameterFilterExpression

	noSmithyDocumentSerde
}

func (*SearchFilterExpressionMemberParameterFilter) isSearchFilterExpression() {}

// Filters by a specified search term.
type SearchFilterExpressionMemberSearchTermFilter struct {
	Value SearchTermFilterExpression

	noSmithyDocumentSerde
}

func (*SearchFilterExpressionMemberSearchTermFilter) isSearchFilterExpression() {}

// Filters by a string.
type SearchFilterExpressionMemberStringFilter struct {
	Value StringFilterExpression

	noSmithyDocumentSerde
}

func (*SearchFilterExpressionMemberStringFilter) isSearchFilterExpression() {}

// The filter expression, AND or OR , to use when searching among a group of search
// strings in a resource. You can use two groupings per search each within
// parenthesis () .
type SearchGroupedFilterExpressions struct {

	// The filters to use for the search.
	//
	// This member is required.
	Filters []SearchFilterExpression

	// The operators to include in the search.
	//
	// This member is required.
	Operator LogicalOperator

	noSmithyDocumentSerde
}

// The resources to search.
//
// The following types satisfy this interface:
//
//	SearchSortExpressionMemberFieldSort
//	SearchSortExpressionMemberParameterSort
//	SearchSortExpressionMemberUserJobsFirst
type SearchSortExpression interface {
	isSearchSortExpression()
}

// Options for sorting by a field.
type SearchSortExpressionMemberFieldSort struct {
	Value FieldSortExpression

	noSmithyDocumentSerde
}

func (*SearchSortExpressionMemberFieldSort) isSearchSortExpression() {}

// Options for sorting by a parameter.
type SearchSortExpressionMemberParameterSort struct {
	Value ParameterSortExpression

	noSmithyDocumentSerde
}

func (*SearchSortExpressionMemberParameterSort) isSearchSortExpression() {}

// Options for sorting a particular user's jobs first.
type SearchSortExpressionMemberUserJobsFirst struct {
	Value UserJobsFirst

	noSmithyDocumentSerde
}

func (*SearchSortExpressionMemberUserJobsFirst) isSearchSortExpression() {}

// Searches for a particular search term.
type SearchTermFilterExpression struct {

	// The term to search for.
	//
	// This member is required.
	SearchTerm *string

	// Specifies how Deadline Cloud matches your search term in the results. If you
	// don't specify a matchType the default is FUZZY_MATCH .
	//
	//   - FUZZY_MATCH - Matches if a portion of the search term is found in the result.
	//
	//   - CONTAINS - Matches if the exact search term is contained in the result.
	MatchType SearchTermMatchingType

	noSmithyDocumentSerde
}

// The configuration details for a service managed Amazon EC2 fleet.
type ServiceManagedEc2FleetConfiguration struct {

	// The Amazon EC2 instance capabilities.
	//
	// This member is required.
	InstanceCapabilities *ServiceManagedEc2InstanceCapabilities

	// The Amazon EC2 market type.
	//
	// This member is required.
	InstanceMarketOptions *ServiceManagedEc2InstanceMarketOptions

	// The storage profile ID.
	StorageProfileId *string

	noSmithyDocumentSerde
}

// The Amazon EC2 instance capabilities.
type ServiceManagedEc2InstanceCapabilities struct {

	// The CPU architecture type.
	//
	// This member is required.
	CpuArchitectureType CpuArchitectureType

	// The memory, as MiB, for the Amazon EC2 instance type.
	//
	// This member is required.
	MemoryMiB *MemoryMiBRange

	// The operating system (OS) family.
	//
	// This member is required.
	OsFamily ServiceManagedFleetOperatingSystemFamily

	// The amount of vCPU to require for instances in this fleet.
	//
	// This member is required.
	VCpuCount *VCpuCountRange

	// Describes the GPU accelerator capabilities required for worker host instances
	// in this fleet.
	AcceleratorCapabilities *AcceleratorCapabilities

	// The allowable Amazon EC2 instance types.
	AllowedInstanceTypes []string

	// The custom capability amounts to require for instances in this fleet.
	CustomAmounts []FleetAmountCapability

	// The custom capability attributes to require for instances in this fleet.
	CustomAttributes []FleetAttributeCapability

	// The instance types to exclude from the fleet.
	ExcludedInstanceTypes []string

	// The root EBS volume.
	RootEbsVolume *Ec2EbsVolume

	noSmithyDocumentSerde
}

// The details of the Amazon EC2 instance market options for a service managed
// fleet.
type ServiceManagedEc2InstanceMarketOptions struct {

	// The Amazon EC2 instance type.
	//
	// This member is required.
	Type Ec2MarketType

	noSmithyDocumentSerde
}

// The definition of the session action.
//
// The following types satisfy this interface:
//
//	SessionActionDefinitionMemberEnvEnter
//	SessionActionDefinitionMemberEnvExit
//	SessionActionDefinitionMemberSyncInputJobAttachments
//	SessionActionDefinitionMemberTaskRun
type SessionActionDefinition interface {
	isSessionActionDefinition()
}

// The environment to enter into.
type SessionActionDefinitionMemberEnvEnter struct {
	Value EnvironmentEnterSessionActionDefinition

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionMemberEnvEnter) isSessionActionDefinition() {}

// The environment to exit from.
type SessionActionDefinitionMemberEnvExit struct {
	Value EnvironmentExitSessionActionDefinition

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionMemberEnvExit) isSessionActionDefinition() {}

// The job attachments to sync with a session action.
type SessionActionDefinitionMemberSyncInputJobAttachments struct {
	Value SyncInputJobAttachmentsSessionActionDefinition

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionMemberSyncInputJobAttachments) isSessionActionDefinition() {}

// The task run in the session.
type SessionActionDefinitionMemberTaskRun struct {
	Value TaskRunSessionActionDefinition

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionMemberTaskRun) isSessionActionDefinition() {}

// The details of a session action definition.
//
// The following types satisfy this interface:
//
//	SessionActionDefinitionSummaryMemberEnvEnter
//	SessionActionDefinitionSummaryMemberEnvExit
//	SessionActionDefinitionSummaryMemberSyncInputJobAttachments
//	SessionActionDefinitionSummaryMemberTaskRun
type SessionActionDefinitionSummary interface {
	isSessionActionDefinitionSummary()
}

// The environment to enter into.
type SessionActionDefinitionSummaryMemberEnvEnter struct {
	Value EnvironmentEnterSessionActionDefinitionSummary

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionSummaryMemberEnvEnter) isSessionActionDefinitionSummary() {}

// The environment to exit from.
type SessionActionDefinitionSummaryMemberEnvExit struct {
	Value EnvironmentExitSessionActionDefinitionSummary

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionSummaryMemberEnvExit) isSessionActionDefinitionSummary() {}

// The job attachments to sync with the session action definition.
type SessionActionDefinitionSummaryMemberSyncInputJobAttachments struct {
	Value SyncInputJobAttachmentsSessionActionDefinitionSummary

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionSummaryMemberSyncInputJobAttachments) isSessionActionDefinitionSummary() {
}

// The task run.
type SessionActionDefinitionSummaryMemberTaskRun struct {
	Value TaskRunSessionActionDefinitionSummary

	noSmithyDocumentSerde
}

func (*SessionActionDefinitionSummaryMemberTaskRun) isSessionActionDefinitionSummary() {}

// The details of a session action.
type SessionActionSummary struct {

	// The session action definition.
	//
	// This member is required.
	Definition SessionActionDefinitionSummary

	// The session action ID.
	//
	// This member is required.
	SessionActionId *string

	// The status of the session action.
	//
	// This member is required.
	Status SessionActionStatus

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The completion percentage for the session action.
	ProgressPercent *float32

	// The date and time the resource started running.
	StartedAt *time.Time

	// The Linux timestamp of the last date and time that the session action was
	// updated.
	WorkerUpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the fleet IDs or queue IDs to return statistics. You can specify only
// fleet IDs or queue IDS, not both.
//
// The following types satisfy this interface:
//
//	SessionsStatisticsResourcesMemberFleetIds
//	SessionsStatisticsResourcesMemberQueueIds
type SessionsStatisticsResources interface {
	isSessionsStatisticsResources()
}

// One to 10 fleet IDs that specify the fleets to return statistics for. If you
// specify the fleetIds field, you can't specify the queueIds field.
type SessionsStatisticsResourcesMemberFleetIds struct {
	Value []string

	noSmithyDocumentSerde
}

func (*SessionsStatisticsResourcesMemberFleetIds) isSessionsStatisticsResources() {}

// One to 10 queue IDs that specify the queues to return statistics for. If you
// specify the queueIds field, you can't specify the fleetIds field.
type SessionsStatisticsResourcesMemberQueueIds struct {
	Value []string

	noSmithyDocumentSerde
}

func (*SessionsStatisticsResourcesMemberQueueIds) isSessionsStatisticsResources() {}

// The summary of a session.
type SessionSummary struct {

	// The fleet ID.
	//
	// This member is required.
	FleetId *string

	// The life cycle status for the session.
	//
	// This member is required.
	LifecycleStatus SessionLifecycleStatus

	// The session ID.
	//
	// This member is required.
	SessionId *string

	// The date and time the resource started running.
	//
	// This member is required.
	StartedAt *time.Time

	// The worker ID.
	//
	// This member is required.
	WorkerId *string

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The target life cycle status for the session.
	TargetLifecycleStatus SessionLifecycleTargetStatus

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// A list of statistics for a session.
type Statistics struct {

	// How the statistics should appear in USD. Options include: minimum, maximum,
	// average or sum.
	//
	// This member is required.
	CostInUsd *Stats

	// The number of instances in a list of statistics.
	//
	// This member is required.
	Count *int32

	// The total aggregated runtime.
	//
	// This member is required.
	RuntimeInSeconds *Stats

	// The end time for the aggregation.
	AggregationEndTime *time.Time

	// The start time for the aggregation.
	AggregationStartTime *time.Time

	// The fleet ID.
	FleetId *string

	// The type of instance.
	InstanceType *string

	// The job ID.
	JobId *string

	// The job name.
	JobName *string

	// The licensed product.
	LicenseProduct *string

	// The queue ID.
	QueueId *string

	// The type of usage for the statistics.
	UsageType UsageType

	// The user ID.
	UserId *string

	noSmithyDocumentSerde
}

// The minimum, maximum, average, and sum.
type Stats struct {

	// The average of the usage statistics.
	Avg *float64

	// The maximum among the usage statistics.
	Max *float64

	// The minimum of the usage statistics.
	Min *float64

	// The sum of the usage statistics.
	Sum *float64

	noSmithyDocumentSerde
}

// The details outlining the minimum and maximum capability of a step.
type StepAmountCapability struct {

	// The name of the step.
	//
	// This member is required.
	Name *string

	// The maximum amount.
	Max *float64

	// The minimum amount.
	Min *float64

	// The amount value.
	Value *float64

	noSmithyDocumentSerde
}

// The list of step attributes.
type StepAttributeCapability struct {

	// The name of the step attribute.
	//
	// This member is required.
	Name *string

	// Requires all of the step attribute values.
	AllOf []string

	// Requires any of the step attributes in a given list.
	AnyOf []string

	noSmithyDocumentSerde
}

// The details of a step consumer.
type StepConsumer struct {

	// The step consumer status.
	//
	// This member is required.
	Status DependencyConsumerResolutionStatus

	// The step ID.
	//
	// This member is required.
	StepId *string

	noSmithyDocumentSerde
}

// The details of step dependency.
type StepDependency struct {

	// The step dependency status.
	//
	// This member is required.
	Status DependencyConsumerResolutionStatus

	// The step ID.
	//
	// This member is required.
	StepId *string

	noSmithyDocumentSerde
}

// The details of a step entity.
type StepDetailsEntity struct {

	// The dependencies for a step.
	//
	// This member is required.
	Dependencies []string

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The schema version for a step template.
	//
	// This member is required.
	SchemaVersion *string

	// The step ID.
	//
	// This member is required.
	StepId *string

	// The template for a step.
	//
	// This member is required.
	Template document.Interface

	noSmithyDocumentSerde
}

// The details of the step error.
type StepDetailsError struct {

	// The error code.
	//
	// This member is required.
	Code JobEntityErrorCode

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The error message detailing the error's cause.
	//
	// This member is required.
	Message *string

	// The step ID.
	//
	// This member is required.
	StepId *string

	noSmithyDocumentSerde
}

// The details of identifiers for a step.
type StepDetailsIdentifiers struct {

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The step ID.
	//
	// This member is required.
	StepId *string

	noSmithyDocumentSerde
}

// The details of a step parameter.
type StepParameter struct {

	// The name of the parameter.
	//
	// This member is required.
	Name *string

	// The data type of the parameter.
	//
	// This member is required.
	Type StepParameterType

	noSmithyDocumentSerde
}

// The details of required step capabilities.
type StepRequiredCapabilities struct {

	// The capability amounts that the step requires.
	//
	// This member is required.
	Amounts []StepAmountCapability

	// The capability attributes that the step requires.
	//
	// This member is required.
	Attributes []StepAttributeCapability

	noSmithyDocumentSerde
}

// The details of a step search.
type StepSearchSummary struct {

	// The date and time the resource was created.
	CreatedAt *time.Time

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The job ID.
	JobId *string

	// The life cycle status.
	LifecycleStatus StepLifecycleStatus

	// The life cycle status message.
	LifecycleStatusMessage *string

	// The step name.
	Name *string

	// The parameters and combination expressions for the search.
	ParameterSpace *ParameterSpace

	// The queue ID.
	QueueId *string

	// The date and time the resource started running.
	StartedAt *time.Time

	// The step ID.
	StepId *string

	// The task status to start with on the job.
	TargetTaskRunStatus StepTargetTaskRunStatus

	// The task run status for the job.
	//
	//   - PENDING –pending and waiting for resources.
	//
	//   - READY –ready to be processed.
	//
	//   - ASSIGNED –assigned and will run next on a worker.
	//
	//   - SCHEDULED –scheduled to be run on a worker.
	//
	//   - INTERRUPTING –being interrupted.
	//
	//   - RUNNING –running on a worker.
	//
	//   - SUSPENDED –the task is suspended.
	//
	//   - CANCELED –the task has been canceled.
	//
	//   - FAILED –the task has failed.
	//
	//   - SUCCEEDED –the task has succeeded.
	TaskRunStatus TaskRunStatus

	// The number of tasks running on the job.
	TaskRunStatusCounts map[string]int32

	noSmithyDocumentSerde
}

// The details for a step.
type StepSummary struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The life cycle status.
	//
	// This member is required.
	LifecycleStatus StepLifecycleStatus

	// The name of the step.
	//
	// This member is required.
	Name *string

	// The step ID.
	//
	// This member is required.
	StepId *string

	// The task run status for the job.
	//
	//   - PENDING –pending and waiting for resources.
	//
	//   - READY –ready to process.
	//
	//   - ASSIGNED –assigned and will run next on a worker.
	//
	//   - SCHEDULED –scheduled to run on a worker.
	//
	//   - INTERRUPTING –being interrupted.
	//
	//   - RUNNING –running on a worker.
	//
	//   - SUSPENDED –the task is suspended.
	//
	//   - CANCELED –the task has been canceled.
	//
	//   - FAILED –the task has failed.
	//
	//   - SUCCEEDED –the task has succeeded.
	//
	// This member is required.
	TaskRunStatus TaskRunStatus

	// The number of tasks running on the job.
	//
	// This member is required.
	TaskRunStatusCounts map[string]int32

	// The number of dependencies for the step.
	DependencyCounts *DependencyCounts

	// The date and time the resource ended running.
	EndedAt *time.Time

	// A message that describes the lifecycle of the step.
	LifecycleStatusMessage *string

	// The date and time the resource started running.
	StartedAt *time.Time

	// The task status to start with on the job.
	TargetTaskRunStatus StepTargetTaskRunStatus

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a storage profile.
type StorageProfileSummary struct {

	// The display name of the storage profile summary to update.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The operating system (OS) family.
	//
	// This member is required.
	OsFamily StorageProfileOperatingSystemFamily

	// The storage profile ID.
	//
	// This member is required.
	StorageProfileId *string

	noSmithyDocumentSerde
}

// Searches for a particular string.
type StringFilterExpression struct {

	// The field name to search.
	//
	// This member is required.
	Name *string

	// The type of comparison to use for this search.
	//
	// This member is required.
	Operator ComparisonOperator

	// The string to search for.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The job attachment in a session action to sync.
type SyncInputJobAttachmentsSessionActionDefinition struct {

	// The step ID for the step in the job attachment.
	StepId *string

	noSmithyDocumentSerde
}

// The details of a synced job attachment.
type SyncInputJobAttachmentsSessionActionDefinitionSummary struct {

	// The step ID of the step in the job attachment.
	StepId *string

	noSmithyDocumentSerde
}

// The data types for the task parameters.
//
// The following types satisfy this interface:
//
//	TaskParameterValueMemberFloat
//	TaskParameterValueMemberInt
//	TaskParameterValueMemberPath
//	TaskParameterValueMemberString
type TaskParameterValue interface {
	isTaskParameterValue()
}

// A double precision IEEE-754 floating point number represented as a string.
type TaskParameterValueMemberFloat struct {
	Value string

	noSmithyDocumentSerde
}

func (*TaskParameterValueMemberFloat) isTaskParameterValue() {}

// A signed integer represented as a string.
type TaskParameterValueMemberInt struct {
	Value string

	noSmithyDocumentSerde
}

func (*TaskParameterValueMemberInt) isTaskParameterValue() {}

// A file system path represented as a string.
type TaskParameterValueMemberPath struct {
	Value string

	noSmithyDocumentSerde
}

func (*TaskParameterValueMemberPath) isTaskParameterValue() {}

// A UTF-8 string.
type TaskParameterValueMemberString struct {
	Value string

	noSmithyDocumentSerde
}

func (*TaskParameterValueMemberString) isTaskParameterValue() {}

// The task, step, and parameters for the task run in the session action.
type TaskRunSessionActionDefinition struct {

	// The task parameters.
	//
	// This member is required.
	Parameters map[string]TaskParameterValue

	// The step ID.
	//
	// This member is required.
	StepId *string

	// The task ID.
	TaskId *string

	noSmithyDocumentSerde
}

// The details of a task run in a session action.
type TaskRunSessionActionDefinitionSummary struct {

	// The step ID.
	//
	// This member is required.
	StepId *string

	// The task ID.
	TaskId *string

	noSmithyDocumentSerde
}

// The details of a task search.
type TaskSearchSummary struct {

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The number of times that the task failed and was retried.
	FailureRetryCount *int32

	// The job ID.
	JobId *string

	// The parameters to search for.
	Parameters map[string]TaskParameterValue

	// The queue ID.
	QueueId *string

	// The run status of the task.
	RunStatus TaskRunStatus

	// The date and time the resource started running.
	StartedAt *time.Time

	// The step ID.
	StepId *string

	// The run status that the task is being updated to.
	TargetRunStatus TaskTargetRunStatus

	// The task ID.
	TaskId *string

	noSmithyDocumentSerde
}

// The details of a task.
type TaskSummary struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The run status of the task.
	//
	// This member is required.
	RunStatus TaskRunStatus

	// The task ID.
	//
	// This member is required.
	TaskId *string

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The number of times that the task failed and was retried.
	FailureRetryCount *int32

	// The latest session action for the task.
	LatestSessionActionId *string

	// The task parameters.
	Parameters map[string]TaskParameterValue

	// The date and time the resource started running.
	StartedAt *time.Time

	// The run status on which the started.
	TargetRunStatus TaskTargetRunStatus

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The updated session action information as it relates to completion and progress
// of the session.
type UpdatedSessionActionInfo struct {

	// The status of the session upon completion.
	CompletedStatus CompletedStatus

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The process exit code. The default Deadline Cloud worker agent converts
	// unsigned 32-bit exit codes to signed 32-bit exit codes.
	ProcessExitCode *int32

	// A message to indicate the progress of the updated session action.
	ProgressMessage *string

	// The percentage completed.
	ProgressPercent *float32

	// The date and time the resource started running.
	StartedAt *time.Time

	// The updated time.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The usage details of the allotted budget.
//
// The following types satisfy this interface:
//
//	UsageTrackingResourceMemberQueueId
type UsageTrackingResource interface {
	isUsageTrackingResource()
}

// The queue ID.
type UsageTrackingResourceMemberQueueId struct {
	Value string

	noSmithyDocumentSerde
}

func (*UsageTrackingResourceMemberQueueId) isUsageTrackingResource() {}

// Allows setting a specific user's job to run first.
type UserJobsFirst struct {

	// The user's ID.
	//
	// This member is required.
	UserIdentityId *string

	noSmithyDocumentSerde
}

// The details of a validation exception.
type ValidationExceptionField struct {

	// The error message for the validation exception.
	//
	// This member is required.
	Message *string

	// The name of the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The allowable range of vCPU processing power for the fleet.
type VCpuCountRange struct {

	// The minimum amount of vCPU.
	//
	// This member is required.
	Min *int32

	// The maximum amount of vCPU.
	Max *int32

	noSmithyDocumentSerde
}

// The Windows user details.
type WindowsUser struct {

	// The password ARN for the Windows user.
	//
	// This member is required.
	PasswordArn *string

	// The user.
	//
	// This member is required.
	User *string

	noSmithyDocumentSerde
}

// The details of the worker amount capability.
type WorkerAmountCapability struct {

	// The name of the worker amount capability.
	//
	// This member is required.
	Name *string

	// The value of the worker amount capability.
	//
	// This member is required.
	Value *float32

	noSmithyDocumentSerde
}

// The details of the worker attribute capability.
type WorkerAttributeCapability struct {

	// The name of the worker attribute capability.
	//
	// This member is required.
	Name *string

	// The values of the worker amount capability.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The details for worker capabilities.
type WorkerCapabilities struct {

	// The worker capabilities amounts on a list of worker capabilities.
	//
	// This member is required.
	Amounts []WorkerAmountCapability

	// The worker attribute capabilities in the list of attribute capabilities.
	//
	// This member is required.
	Attributes []WorkerAttributeCapability

	noSmithyDocumentSerde
}

// The details of a worker search.
type WorkerSearchSummary struct {

	// The date and time the resource was created.
	CreatedAt *time.Time

	// The user or system that created this resource.
	CreatedBy *string

	// The fleet ID.
	FleetId *string

	// Provides the Amazon EC2 instance properties of the worker host.
	HostProperties *HostPropertiesResponse

	// The status of the worker search.
	Status WorkerStatus

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	// The worker ID.
	WorkerId *string

	noSmithyDocumentSerde
}

// Summarizes the session for a particular worker.
type WorkerSessionSummary struct {

	// The job ID for the job associated with the worker's session.
	//
	// This member is required.
	JobId *string

	// The life cycle status for the worker's session.
	//
	// This member is required.
	LifecycleStatus SessionLifecycleStatus

	// The queue ID for the queue associated to the worker.
	//
	// This member is required.
	QueueId *string

	// The session ID for the session action.
	//
	// This member is required.
	SessionId *string

	// The date and time the resource started running.
	//
	// This member is required.
	StartedAt *time.Time

	// The date and time the resource ended running.
	EndedAt *time.Time

	// The life cycle status
	TargetLifecycleStatus SessionLifecycleTargetStatus

	noSmithyDocumentSerde
}

// The summary of details for a worker.
type WorkerSummary struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The farm ID.
	//
	// This member is required.
	FarmId *string

	// The fleet ID.
	//
	// This member is required.
	FleetId *string

	// The status of the worker.
	//
	// This member is required.
	Status WorkerStatus

	// The worker ID.
	//
	// This member is required.
	WorkerId *string

	// The host properties of the worker.
	HostProperties *HostPropertiesResponse

	// The log configuration for the worker.
	Log *LogConfiguration

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAssignedSessionActionDefinition() {}
func (*UnknownUnionMember) isBudgetSchedule()                  {}
func (*UnknownUnionMember) isFleetConfiguration()              {}
func (*UnknownUnionMember) isGetJobEntityError()               {}
func (*UnknownUnionMember) isJobEntity()                       {}
func (*UnknownUnionMember) isJobEntityIdentifiersUnion()       {}
func (*UnknownUnionMember) isJobParameter()                    {}
func (*UnknownUnionMember) isSearchFilterExpression()          {}
func (*UnknownUnionMember) isSearchSortExpression()            {}
func (*UnknownUnionMember) isSessionActionDefinition()         {}
func (*UnknownUnionMember) isSessionActionDefinitionSummary()  {}
func (*UnknownUnionMember) isSessionsStatisticsResources()     {}
func (*UnknownUnionMember) isTaskParameterValue()              {}
func (*UnknownUnionMember) isUsageTrackingResource()           {}
