// Code generated by smithy-go-codegen DO NOT EDIT.

package entityresolution

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/entityresolution/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates or retrieves Match IDs for records using a rule-based matching
// workflow. When you call this operation, it processes your records against the
// workflow's matching rules to identify potential matches. For existing records,
// it retrieves their Match IDs and associated rules. For records without matches,
// it generates new Match IDs. The operation saves results to Amazon S3.
//
// The processing type ( processingType ) you choose affects both the accuracy and
// response time of the operation. Additional charges apply for each API call,
// whether made through the Entity Resolution console or directly via the API. The
// rule-based matching workflow must exist and be active before calling this
// operation.
func (c *Client) GenerateMatchId(ctx context.Context, params *GenerateMatchIdInput, optFns ...func(*Options)) (*GenerateMatchIdOutput, error) {
	if params == nil {
		params = &GenerateMatchIdInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GenerateMatchId", params, optFns, c.addOperationGenerateMatchIdMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GenerateMatchIdOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GenerateMatchIdInput struct {

	//  The records to match.
	//
	// This member is required.
	Records []types.Record

	//  The name of the rule-based matching workflow.
	//
	// This member is required.
	WorkflowName *string

	// The processing mode that determines how Match IDs are generated and results are
	// saved. Each mode provides different levels of accuracy, response time, and
	// completeness of results.
	//
	// If not specified, defaults to CONSISTENT .
	//
	// CONSISTENT : Performs immediate lookup and matching against all existing
	// records, with results saved synchronously. Provides highest accuracy but slower
	// response time.
	//
	// EVENTUAL (shown as Background in the console): Performs initial match ID lookup
	// or generation immediately, with record updates processed asynchronously in the
	// background. Offers faster initial response time, with complete matching results
	// available later in S3.
	//
	// EVENTUAL_NO_LOOKUP (shown as Quick ID generation in the console): Generates new
	// match IDs without checking existing matches, with updates processed
	// asynchronously. Provides fastest response time but should only be used for
	// records known to be unique.
	ProcessingType types.ProcessingType

	noSmithyDocumentSerde
}

type GenerateMatchIdOutput struct {

	//  The records that didn't receive a generated Match ID.
	//
	// This member is required.
	FailedRecords []types.FailedRecord

	//  The match groups from the generated match ID.
	//
	// This member is required.
	MatchGroups []types.MatchGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGenerateMatchIdMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGenerateMatchId{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGenerateMatchId{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GenerateMatchId"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGenerateMatchIdValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGenerateMatchId(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGenerateMatchId(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GenerateMatchId",
	}
}
