// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a collection of container fleet deployments in an Amazon Web Services
// Region. Use the pagination parameters to retrieve results as a set of sequential
// pages.
//
// Request options
//
//   - Get a list of all deployments. Call this operation without specifying a
//     fleet ID.
//
//   - Get a list of all deployments for a fleet. Specify the container fleet ID
//     or ARN value.
//
// # Results
//
// If successful, this operation returns a list of deployments that match the
// request parameters. A NextToken value is also returned if there are more result
// pages to retrieve.
//
// Deployments are returned starting with the latest.
func (c *Client) ListFleetDeployments(ctx context.Context, params *ListFleetDeploymentsInput, optFns ...func(*Options)) (*ListFleetDeploymentsOutput, error) {
	if params == nil {
		params = &ListFleetDeploymentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFleetDeployments", params, optFns, c.addOperationListFleetDeploymentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFleetDeploymentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFleetDeploymentsInput struct {

	// A unique identifier for the container fleet. You can use either the fleet ID or
	// ARN value.
	FleetId *string

	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int32

	// A token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this operation. To start at
	// the beginning of the result set, do not specify a value.
	NextToken *string

	noSmithyDocumentSerde
}

type ListFleetDeploymentsOutput struct {

	// The requested deployment information.
	FleetDeployments []types.FleetDeployment

	// A token that indicates where to resume retrieving results on the next call to
	// this operation. If no token is returned, these results represent the end of the
	// list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFleetDeploymentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListFleetDeployments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListFleetDeployments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFleetDeployments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFleetDeployments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListFleetDeploymentsPaginatorOptions is the paginator options for
// ListFleetDeployments
type ListFleetDeploymentsPaginatorOptions struct {
	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFleetDeploymentsPaginator is a paginator for ListFleetDeployments
type ListFleetDeploymentsPaginator struct {
	options   ListFleetDeploymentsPaginatorOptions
	client    ListFleetDeploymentsAPIClient
	params    *ListFleetDeploymentsInput
	nextToken *string
	firstPage bool
}

// NewListFleetDeploymentsPaginator returns a new ListFleetDeploymentsPaginator
func NewListFleetDeploymentsPaginator(client ListFleetDeploymentsAPIClient, params *ListFleetDeploymentsInput, optFns ...func(*ListFleetDeploymentsPaginatorOptions)) *ListFleetDeploymentsPaginator {
	if params == nil {
		params = &ListFleetDeploymentsInput{}
	}

	options := ListFleetDeploymentsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFleetDeploymentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFleetDeploymentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFleetDeployments page.
func (p *ListFleetDeploymentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFleetDeploymentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFleetDeployments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFleetDeploymentsAPIClient is a client that implements the
// ListFleetDeployments operation.
type ListFleetDeploymentsAPIClient interface {
	ListFleetDeployments(context.Context, *ListFleetDeploymentsInput, ...func(*Options)) (*ListFleetDeploymentsOutput, error)
}

var _ ListFleetDeploymentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFleetDeployments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFleetDeployments",
	}
}
