// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets details for a specific task run on a machine learning transform. Machine
// learning task runs are asynchronous tasks that Glue runs on your behalf as part
// of various machine learning workflows. You can check the stats of any task run
// by calling GetMLTaskRun with the TaskRunID and its parent transform's
// TransformID .
func (c *Client) GetMLTaskRun(ctx context.Context, params *GetMLTaskRunInput, optFns ...func(*Options)) (*GetMLTaskRunOutput, error) {
	if params == nil {
		params = &GetMLTaskRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMLTaskRun", params, optFns, c.addOperationGetMLTaskRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMLTaskRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMLTaskRunInput struct {

	// The unique identifier of the task run.
	//
	// This member is required.
	TaskRunId *string

	// The unique identifier of the machine learning transform.
	//
	// This member is required.
	TransformId *string

	noSmithyDocumentSerde
}

type GetMLTaskRunOutput struct {

	// The date and time when this task run was completed.
	CompletedOn *time.Time

	// The error strings that are associated with the task run.
	ErrorString *string

	// The amount of time (in seconds) that the task run consumed resources.
	ExecutionTime int32

	// The date and time when this task run was last modified.
	LastModifiedOn *time.Time

	// The names of the log groups that are associated with the task run.
	LogGroupName *string

	// The list of properties that are associated with the task run.
	Properties *types.TaskRunProperties

	// The date and time when this task run started.
	StartedOn *time.Time

	// The status for this task run.
	Status types.TaskStatusType

	// The unique run identifier associated with this run.
	TaskRunId *string

	// The unique identifier of the task run.
	TransformId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMLTaskRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetMLTaskRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetMLTaskRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMLTaskRun"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetMLTaskRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMLTaskRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMLTaskRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMLTaskRun",
	}
}
