// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves your invoice details programmatically, without line item details.
func (c *Client) ListInvoiceSummaries(ctx context.Context, params *ListInvoiceSummariesInput, optFns ...func(*Options)) (*ListInvoiceSummariesOutput, error) {
	if params == nil {
		params = &ListInvoiceSummariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInvoiceSummaries", params, optFns, c.addOperationListInvoiceSummariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInvoiceSummariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInvoiceSummariesInput struct {

	// The option to retrieve details for a specific invoice by providing its unique
	// ID. Alternatively, access information for all invoices linked to the account by
	// providing an account ID.
	//
	// This member is required.
	Selector *types.InvoiceSummariesSelector

	// Filters you can use to customize your invoice summary.
	Filter *types.InvoiceSummariesFilter

	// The maximum number of invoice summaries a paginated response can contain.
	MaxResults *int32

	// The token to retrieve the next set of results. Amazon Web Services provides the
	// token when the response from a previous call has more results than the maximum
	// page size.
	NextToken *string

	noSmithyDocumentSerde
}

type ListInvoiceSummariesOutput struct {

	// List of key (summary level) invoice details without line item details.
	//
	// This member is required.
	InvoiceSummaries []types.InvoiceSummary

	// The token to retrieve the next set of results. Amazon Web Services provides the
	// token when the response from a previous call has more results than the maximum
	// page size.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInvoiceSummariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListInvoiceSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListInvoiceSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInvoiceSummaries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListInvoiceSummariesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInvoiceSummaries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListInvoiceSummariesPaginatorOptions is the paginator options for
// ListInvoiceSummaries
type ListInvoiceSummariesPaginatorOptions struct {
	// The maximum number of invoice summaries a paginated response can contain.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInvoiceSummariesPaginator is a paginator for ListInvoiceSummaries
type ListInvoiceSummariesPaginator struct {
	options   ListInvoiceSummariesPaginatorOptions
	client    ListInvoiceSummariesAPIClient
	params    *ListInvoiceSummariesInput
	nextToken *string
	firstPage bool
}

// NewListInvoiceSummariesPaginator returns a new ListInvoiceSummariesPaginator
func NewListInvoiceSummariesPaginator(client ListInvoiceSummariesAPIClient, params *ListInvoiceSummariesInput, optFns ...func(*ListInvoiceSummariesPaginatorOptions)) *ListInvoiceSummariesPaginator {
	if params == nil {
		params = &ListInvoiceSummariesInput{}
	}

	options := ListInvoiceSummariesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInvoiceSummariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInvoiceSummariesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInvoiceSummaries page.
func (p *ListInvoiceSummariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInvoiceSummariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInvoiceSummaries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInvoiceSummariesAPIClient is a client that implements the
// ListInvoiceSummaries operation.
type ListInvoiceSummariesAPIClient interface {
	ListInvoiceSummaries(context.Context, *ListInvoiceSummariesInput, ...func(*Options)) (*ListInvoiceSummariesOutput, error)
}

var _ ListInvoiceSummariesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInvoiceSummaries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInvoiceSummaries",
	}
}
