// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Details about how the total amount was calculated and categorized.
type AmountBreakdown struct {

	//  The discounted amount.
	Discounts *DiscountsBreakdown

	//  The fee amount.
	Fees *FeesBreakdown

	//  The total of a set of the breakdown.
	SubTotalAmount *string

	//  The tax amount.
	Taxes *TaxesBreakdown

	noSmithyDocumentSerde
}

// The billing period for which you want to retrieve invoice-related documents.
type BillingPeriod struct {

	//  The billing period month.
	//
	// This member is required.
	Month *int32

	//  The billing period year.
	//
	// This member is required.
	Year *int32

	noSmithyDocumentSerde
}

// The details of currency exchange.
type CurrencyExchangeDetails struct {

	// The currency exchange rate.
	Rate *string

	// The exchange source currency.
	SourceCurrencyCode *string

	// The exchange target currency.
	TargetCurrencyCode *string

	noSmithyDocumentSerde
}

// The time period that you want invoice-related documents for.
type DateInterval struct {

	//  The end of the time period that you want invoice-related documents for. The
	// end date is exclusive. For example, if end is 2019-01-10 , Amazon Web Services
	// retrieves invoice-related documents from the start date up to, but not
	// including, 2018-01-10 .
	//
	// This member is required.
	EndDate *time.Time

	//  The beginning of the time period that you want invoice-related documents for.
	// The start date is inclusive. For example, if start is 2019-01-01 , AWS retrieves
	// invoices starting at 2019-01-01 up to the end date.
	//
	// This member is required.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// The discounts details.
type DiscountsBreakdown struct {

	// The list of discounts information.
	Breakdown []DiscountsBreakdownAmount

	//  The discount's total amount.
	TotalAmount *string

	noSmithyDocumentSerde
}

// The discounted amount.
type DiscountsBreakdownAmount struct {

	// The discounted amount.
	Amount *string

	//  The list of discounts information.
	Description *string

	//  The details for the discount rate..
	Rate *string

	noSmithyDocumentSerde
}

// The organization name providing Amazon Web Services services.
type Entity struct {

	// The name of the entity that issues the Amazon Web Services invoice.
	InvoicingEntity *string

	noSmithyDocumentSerde
}

// The details of fees.
type FeesBreakdown struct {

	// The list of fees information.
	Breakdown []FeesBreakdownAmount

	//  The total amount of fees.
	TotalAmount *string

	noSmithyDocumentSerde
}

// The fee amount.
type FeesBreakdownAmount struct {

	//  The fee amount.
	Amount *string

	//  The list of fees information.
	Description *string

	//  Details about the rate amount.
	Rate *string

	noSmithyDocumentSerde
}

// An optional input to the list API. If multiple filters are specified, the
// returned list will be a configuration that match all of the provided filters.
// Supported filter types are InvoiceReceivers , Names , and Accounts .
type Filters struct {

	//  You can specify a list of Amazon Web Services account IDs inside filters to
	// return invoice units that match only the specified accounts. If multiple
	// accounts are provided, the result is an OR condition (match any) of the
	// specified accounts. The specified account IDs are matched with either the
	// receiver or the linked accounts in the rules.
	Accounts []string

	//  You can specify a list of Amazon Web Services account IDs inside filters to
	// return invoice units that match only the specified accounts. If multiple
	// accounts are provided, the result is an OR condition (match any) of the
	// specified accounts. This filter only matches the specified accounts on the
	// invoice receivers of the invoice units.
	InvoiceReceivers []string

	//  An optional input to the list API. You can specify a list of invoice unit
	// names inside filters to return invoice units that match only the specified
	// invoice unit names. If multiple names are provided, the result is an OR
	// condition (match any) of the specified invoice unit names.
	Names []string

	noSmithyDocumentSerde
}

// The amount charged after taxes, in the preferred currency.
type InvoiceCurrencyAmount struct {

	//  Details about the invoice currency amount.
	AmountBreakdown *AmountBreakdown

	// The currency dominion of the invoice document.
	CurrencyCode *string

	//  The details of currency exchange.
	CurrencyExchangeDetails *CurrencyExchangeDetails

	//  The invoice currency amount.
	TotalAmount *string

	//  Details about the invoice total amount before tax.
	TotalAmountBeforeTax *string

	noSmithyDocumentSerde
}

// Contains high-level information about the invoice receiver.
type InvoiceProfile struct {

	//  The account ID the invoice profile is generated for.
	AccountId *string

	//  This specifies the issuing entity of the invoice.
	Issuer *string

	// The address of the receiver that will be printed on the invoice.
	ReceiverAddress *ReceiverAddress

	// The email address for the invoice profile receiver.
	ReceiverEmail *string

	//  The name of the person receiving the invoice profile.
	ReceiverName *string

	//  Your Tax Registration Number (TRN) information.
	TaxRegistrationNumber *string

	noSmithyDocumentSerde
}

// Filters for your invoice summaries.
type InvoiceSummariesFilter struct {

	// The billing period associated with the invoice documents.
	BillingPeriod *BillingPeriod

	// The name of the entity that issues the Amazon Web Services invoice.
	InvoicingEntity *string

	// The date range for invoice summary retrieval.
	TimeInterval *DateInterval

	noSmithyDocumentSerde
}

// Specifies the invoice summary.
type InvoiceSummariesSelector struct {

	// The query identifier type ( INVOICE_ID or ACCOUNT_ID ).
	//
	// This member is required.
	ResourceType ListInvoiceSummariesResourceType

	// The value of the query identifier.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The invoice that the API retrieved.
type InvoiceSummary struct {

	//  The Amazon Web Services account ID.
	AccountId *string

	//  The summary with the product and service currency.
	BaseCurrencyAmount *InvoiceCurrencyAmount

	//  The billing period of the invoice-related document.
	BillingPeriod *BillingPeriod

	//  The invoice due date.
	DueDate *time.Time

	// The organization name providing Amazon Web Services services.
	Entity *Entity

	//  The invoice ID.
	InvoiceId *string

	//  The type of invoice.
	InvoiceType InvoiceType

	//  The issued date of the invoice.
	IssuedDate *time.Time

	// The initial or original invoice ID.
	OriginalInvoiceId *string

	//  The summary with the customer configured currency.
	PaymentCurrencyAmount *InvoiceCurrencyAmount

	//  The purchase order number associated to the invoice.
	PurchaseOrderNumber *string

	//  The summary with the tax currency.
	TaxCurrencyAmount *InvoiceCurrencyAmount

	noSmithyDocumentSerde
}

// An invoice unit is a set of mutually exclusive accounts that correspond to your
// business entity. Invoice units allow you separate Amazon Web Services account
// costs and configures your invoice for each business entity going forward.
type InvoiceUnit struct {

	// The assigned description for an invoice unit. This information can't be
	// modified or deleted.
	Description *string

	// The account that receives invoices related to the invoice unit.
	InvoiceReceiver *string

	// ARN to identify an invoice unit. This information can't be modified or deleted.
	InvoiceUnitArn *string

	//  The last time the invoice unit was updated. This is important to determine the
	// version of invoice unit configuration used to create the invoices. Any invoice
	// created after this modified time will use this invoice unit configuration.
	LastModified *time.Time

	//  A unique name that is distinctive within your Amazon Web Services.
	Name *string

	//  An InvoiceUnitRule object used the categorize invoice units.
	Rule *InvoiceUnitRule

	// Whether the invoice unit based tax inheritance is/ should be enabled or
	// disabled.
	TaxInheritanceDisabled *bool

	noSmithyDocumentSerde
}

//	This is used to categorize the invoice unit. Values are Amazon Web Services
//
// account IDs. Currently, the only supported rule is LINKED_ACCOUNT .
type InvoiceUnitRule struct {

	// The list of LINKED_ACCOUNT IDs where charges are included within the invoice
	// unit.
	LinkedAccounts []string

	noSmithyDocumentSerde
}

// The details of the address associated with the receiver.
type ReceiverAddress struct {

	//  The first line of the address.
	AddressLine1 *string

	//  The second line of the address, if applicable.
	AddressLine2 *string

	//  The third line of the address, if applicable.
	AddressLine3 *string

	//  The city that the address is in.
	City *string

	//  A unique company name.
	CompanyName *string

	//  The country code for the country the address is in.
	CountryCode *string

	//  The district or country the address is located in.
	DistrictOrCounty *string

	//  The postal code associated with the address.
	PostalCode *string

	//  The state, region, or province the address is located.
	StateOrRegion *string

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value.
type ResourceTag struct {

	// The object key of your of your resource tag.
	//
	// This member is required.
	Key *string

	//  The specific value of the resource tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The details of the taxes.
type TaxesBreakdown struct {

	//  A list of tax information.
	Breakdown []TaxesBreakdownAmount

	//  The total amount for your taxes.
	TotalAmount *string

	noSmithyDocumentSerde
}

// The tax amount.
type TaxesBreakdownAmount struct {

	//  The tax amount.
	Amount *string

	//  The details of the taxes.
	Description *string

	//  The details of the tax rate.
	Rate *string

	noSmithyDocumentSerde
}

//	The input fails to satisfy the constraints specified by an Amazon Web Services
//
// service.
type ValidationExceptionField struct {

	//  The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	//
	// This member is required.
	Message *string

	//  The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
