// Code generated by smithy-go-codegen DO NOT EDIT.

package iotdeviceadvisor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists runs of the specified Device Advisor test suite. You can list all runs of
// the test suite, or the runs of a specific version of the test suite.
//
// Requires permission to access the [ListSuiteRuns] action.
//
// [ListSuiteRuns]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions
func (c *Client) ListSuiteRuns(ctx context.Context, params *ListSuiteRunsInput, optFns ...func(*Options)) (*ListSuiteRunsOutput, error) {
	if params == nil {
		params = &ListSuiteRunsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSuiteRuns", params, optFns, c.addOperationListSuiteRunsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSuiteRunsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSuiteRunsInput struct {

	// The maximum number of results to return at once.
	MaxResults *int32

	// A token to retrieve the next set of results.
	NextToken *string

	// Lists the test suite runs of the specified test suite based on suite definition
	// ID.
	SuiteDefinitionId *string

	// Must be passed along with suiteDefinitionId . Lists the test suite runs of the
	// specified test suite based on suite definition version.
	SuiteDefinitionVersion *string

	noSmithyDocumentSerde
}

type ListSuiteRunsOutput struct {

	// A token to retrieve the next set of results.
	NextToken *string

	// An array of objects that provide summaries of information about the suite runs
	// in the list.
	SuiteRunsList []types.SuiteRunInformation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSuiteRunsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSuiteRuns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSuiteRuns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSuiteRuns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSuiteRuns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSuiteRunsPaginatorOptions is the paginator options for ListSuiteRuns
type ListSuiteRunsPaginatorOptions struct {
	// The maximum number of results to return at once.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSuiteRunsPaginator is a paginator for ListSuiteRuns
type ListSuiteRunsPaginator struct {
	options   ListSuiteRunsPaginatorOptions
	client    ListSuiteRunsAPIClient
	params    *ListSuiteRunsInput
	nextToken *string
	firstPage bool
}

// NewListSuiteRunsPaginator returns a new ListSuiteRunsPaginator
func NewListSuiteRunsPaginator(client ListSuiteRunsAPIClient, params *ListSuiteRunsInput, optFns ...func(*ListSuiteRunsPaginatorOptions)) *ListSuiteRunsPaginator {
	if params == nil {
		params = &ListSuiteRunsInput{}
	}

	options := ListSuiteRunsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSuiteRunsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSuiteRunsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSuiteRuns page.
func (p *ListSuiteRunsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSuiteRunsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSuiteRuns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSuiteRunsAPIClient is a client that implements the ListSuiteRuns operation.
type ListSuiteRunsAPIClient interface {
	ListSuiteRuns(context.Context, *ListSuiteRunsInput, ...func(*Options)) (*ListSuiteRunsOutput, error)
}

var _ ListSuiteRunsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSuiteRuns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSuiteRuns",
	}
}
