// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Get the attributes and capabilities associated with a managed thing.
func (c *Client) GetManagedThing(ctx context.Context, params *GetManagedThingInput, optFns ...func(*Options)) (*GetManagedThingOutput, error) {
	if params == nil {
		params = &GetManagedThingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetManagedThing", params, optFns, c.addOperationGetManagedThingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetManagedThingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetManagedThingInput struct {

	// The id of the managed thing.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetManagedThingOutput struct {

	// The timestampe value of when the device was activated.
	ActivatedAt *time.Time

	// The id of the advertised product.
	AdvertisedProductId *string

	// The Amazon Resource Name (ARN) of the managed thing.
	Arn *string

	// The brand of the device.
	Brand *string

	// The classification of the managed thing such as light bulb or thermostat.
	Classification *string

	// The third-party device id as defined by the connector. This device id must not
	// contain personal identifiable information (PII).
	//
	// This parameter is used for cloud-to-cloud devices only.
	ConnectorDeviceId *string

	// The id of the connector policy.
	//
	// This parameter is used for cloud-to-cloud devices only.
	ConnectorPolicyId *string

	// The timestamp value of when the device creation request occurred.
	CreatedAt *time.Time

	// The identifier of the credential locker for the managed thing.
	CredentialLockerId *string

	// A Zwave device-specific key used during device activation.
	//
	// This parameter is used for Zwave devices only.
	DeviceSpecificKey *string

	// The network mode for the hub-connected device.
	HubNetworkMode types.HubNetworkMode

	// The id of the managed thing.
	Id *string

	// The unique 13 digit number that identifies the managed thing.
	InternationalArticleNumber *string

	// The media access control (MAC) address for the device represented by the
	// managed thing.
	//
	// This parameter is used for Zigbee devices only.
	MacAddress *string

	// The metadata for the managed thing.
	MetaData map[string]string

	// The model of the device.
	Model *string

	// The name of the managed thing representing the physical device.
	Name *string

	// Owner of the device, usually an indication of whom the device belongs to. This
	// value should not contain personal identifiable information.
	Owner *string

	// Id of the controller device used for the discovery job.
	ParentControllerId *string

	// The provisioning status of the device in the provisioning workflow for
	// onboarding to IoT managed integrations.
	ProvisioningStatus types.ProvisioningStatus

	// The type of device used. This will be the Amazon Web Services hub controller,
	// cloud device, or IoT device.
	Role types.Role

	// The serial number of the device.
	SerialNumber *string

	// A set of key/value pairs that are used to manage the managed thing.
	Tags map[string]string

	// The universal product code (UPC) of the device model. The UPC is typically used
	// in the United States of America and Canada.
	UniversalProductCode *string

	// The timestamp value of when the managed thing was last updated at.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetManagedThingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetManagedThing{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetManagedThing{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetManagedThing"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetManagedThingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetManagedThing(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetManagedThing(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetManagedThing",
	}
}
