// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Evaluates device positions against geofence geometries from a given geofence
// collection. The event forecasts three states for which a device can be in
// relative to a geofence:
//
// ENTER : If a device is outside of a geofence, but would breach the fence if the
// device is moving at its current speed within time horizon window.
//
// EXIT : If a device is inside of a geofence, but would breach the fence if the
// device is moving at its current speed within time horizon window.
//
// IDLE : If a device is inside of a geofence, and the device is not moving.
func (c *Client) ForecastGeofenceEvents(ctx context.Context, params *ForecastGeofenceEventsInput, optFns ...func(*Options)) (*ForecastGeofenceEventsOutput, error) {
	if params == nil {
		params = &ForecastGeofenceEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ForecastGeofenceEvents", params, optFns, c.addOperationForecastGeofenceEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ForecastGeofenceEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ForecastGeofenceEventsInput struct {

	// The name of the geofence collection.
	//
	// This member is required.
	CollectionName *string

	// The device's state, including current position and speed.
	//
	// This member is required.
	DeviceState *types.ForecastGeofenceEventsDeviceState

	// The distance unit used for the NearestDistance property returned in a
	// forecasted event. The measurement system must match for DistanceUnit and
	// SpeedUnit ; if Kilometers is specified for DistanceUnit , then SpeedUnit must
	// be KilometersPerHour .
	//
	// Default Value: Kilometers
	DistanceUnit types.DistanceUnit

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 20
	MaxResults *int32

	// The pagination token specifying which page of results to return in the
	// response. If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string

	// The speed unit for the device captured by the device state. The measurement
	// system must match for DistanceUnit and SpeedUnit ; if Kilometers is specified
	// for DistanceUnit , then SpeedUnit must be KilometersPerHour .
	//
	// Default Value: KilometersPerHour .
	SpeedUnit types.SpeedUnit

	// Specifies the time horizon in minutes for the forecasted events.
	TimeHorizonMinutes *float64

	noSmithyDocumentSerde
}

type ForecastGeofenceEventsOutput struct {

	// The distance unit for the forecasted events.
	//
	// This member is required.
	DistanceUnit types.DistanceUnit

	// The list of forecasted events.
	//
	// This member is required.
	ForecastedEvents []types.ForecastedEvent

	// The speed unit for the forecasted events.
	//
	// This member is required.
	SpeedUnit types.SpeedUnit

	// The pagination token specifying which page of results to return in the
	// response. If no token is provided, the default page is the first page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationForecastGeofenceEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpForecastGeofenceEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpForecastGeofenceEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ForecastGeofenceEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opForecastGeofenceEventsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpForecastGeofenceEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opForecastGeofenceEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ForecastGeofenceEventsPaginatorOptions is the paginator options for
// ForecastGeofenceEvents
type ForecastGeofenceEventsPaginatorOptions struct {
	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 20
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ForecastGeofenceEventsPaginator is a paginator for ForecastGeofenceEvents
type ForecastGeofenceEventsPaginator struct {
	options   ForecastGeofenceEventsPaginatorOptions
	client    ForecastGeofenceEventsAPIClient
	params    *ForecastGeofenceEventsInput
	nextToken *string
	firstPage bool
}

// NewForecastGeofenceEventsPaginator returns a new ForecastGeofenceEventsPaginator
func NewForecastGeofenceEventsPaginator(client ForecastGeofenceEventsAPIClient, params *ForecastGeofenceEventsInput, optFns ...func(*ForecastGeofenceEventsPaginatorOptions)) *ForecastGeofenceEventsPaginator {
	if params == nil {
		params = &ForecastGeofenceEventsInput{}
	}

	options := ForecastGeofenceEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ForecastGeofenceEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ForecastGeofenceEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ForecastGeofenceEvents page.
func (p *ForecastGeofenceEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ForecastGeofenceEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ForecastGeofenceEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

type endpointPrefix_opForecastGeofenceEventsMiddleware struct {
}

func (*endpointPrefix_opForecastGeofenceEventsMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opForecastGeofenceEventsMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "geofencing." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opForecastGeofenceEventsMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opForecastGeofenceEventsMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ForecastGeofenceEventsAPIClient is a client that implements the
// ForecastGeofenceEvents operation.
type ForecastGeofenceEventsAPIClient interface {
	ForecastGeofenceEvents(context.Context, *ForecastGeofenceEventsInput, ...func(*Options)) (*ForecastGeofenceEventsOutput, error)
}

var _ ForecastGeofenceEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opForecastGeofenceEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ForecastGeofenceEvents",
	}
}
