// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a firewall endpoint for an Network Firewall firewall. This type of
// firewall endpoint is independent of the firewall endpoints that you specify in
// the Firewall itself, and you define it in addition to those endpoints after the
// firewall has been created. You can define a VPC endpoint association using a
// different VPC than the one you used in the firewall specifications.
func (c *Client) CreateVpcEndpointAssociation(ctx context.Context, params *CreateVpcEndpointAssociationInput, optFns ...func(*Options)) (*CreateVpcEndpointAssociationOutput, error) {
	if params == nil {
		params = &CreateVpcEndpointAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateVpcEndpointAssociation", params, optFns, c.addOperationCreateVpcEndpointAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateVpcEndpointAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateVpcEndpointAssociationInput struct {

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// This member is required.
	FirewallArn *string

	// The ID for a subnet that's used in an association with a firewall. This is used
	// in CreateFirewall, AssociateSubnets, and CreateVpcEndpointAssociation. Network Firewall creates an instance of the associated firewall in
	// each subnet that you specify, to filter traffic in the subnet's Availability
	// Zone.
	//
	// This member is required.
	SubnetMapping *types.SubnetMapping

	// The unique identifier of the VPC where you want to create a firewall endpoint.
	//
	// This member is required.
	VpcId *string

	// A description of the VPC endpoint association.
	Description *string

	// The key:value pairs to associate with the resource.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateVpcEndpointAssociationOutput struct {

	// The configuration settings for the VPC endpoint association. These settings
	// include the firewall and the VPC and subnet to use for the firewall endpoint.
	VpcEndpointAssociation *types.VpcEndpointAssociation

	// Detailed information about the current status of a VpcEndpointAssociation. You can retrieve this by
	// calling DescribeVpcEndpointAssociationand providing the VPC endpoint association ARN.
	VpcEndpointAssociationStatus *types.VpcEndpointAssociationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateVpcEndpointAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateVpcEndpointAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateVpcEndpointAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateVpcEndpointAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateVpcEndpointAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateVpcEndpointAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateVpcEndpointAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateVpcEndpointAssociation",
	}
}
