// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the data objects for the specified rule group.
func (c *Client) DescribeRuleGroup(ctx context.Context, params *DescribeRuleGroupInput, optFns ...func(*Options)) (*DescribeRuleGroupOutput, error) {
	if params == nil {
		params = &DescribeRuleGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRuleGroup", params, optFns, c.addOperationDescribeRuleGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRuleGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRuleGroupInput struct {

	// Indicates whether you want Network Firewall to analyze the stateless rules in
	// the rule group for rule behavior such as asymmetric routing. If set to TRUE ,
	// Network Firewall runs the analysis.
	AnalyzeRuleGroup bool

	// The Amazon Resource Name (ARN) of the rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupArn *string

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupName *string

	// Indicates whether the rule group is stateless or stateful. If the rule group is
	// stateless, it contains stateless rules. If it is stateful, it contains stateful
	// rules.
	//
	// This setting is required for requests that do not include the RuleGroupARN .
	Type types.RuleGroupType

	noSmithyDocumentSerde
}

type DescribeRuleGroupOutput struct {

	// The high-level properties of a rule group. This, along with the RuleGroup, define the
	// rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
	//
	// This member is required.
	RuleGroupResponse *types.RuleGroupResponse

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the rule group. The token marks the state of the rule group
	// resource at the time of the request.
	//
	// To make changes to the rule group, you provide the token in your request.
	// Network Firewall uses the token to ensure that the rule group hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with an
	// InvalidTokenException . If this happens, retrieve the rule group again to get a
	// current copy of it with a current token. Reapply your changes as needed, then
	// try the operation again using the new token.
	//
	// This member is required.
	UpdateToken *string

	// The object that defines the rules in a rule group. This, along with RuleGroupResponse, define
	// the rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
	//
	// Network Firewall uses a rule group to inspect and control network traffic. You
	// define stateless rule groups to inspect individual packets and you define
	// stateful rule groups to inspect packets in the context of their traffic flow.
	//
	// To use a rule group, you include it by reference in an Network Firewall
	// firewall policy, then you use the policy in a firewall. You can reference a rule
	// group from more than one firewall policy, and you can use a firewall policy in
	// more than one firewall.
	RuleGroup *types.RuleGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRuleGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeRuleGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeRuleGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeRuleGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRuleGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeRuleGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRuleGroup",
	}
}
