// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Return the data for a query with the Network Flow Monitor query interface.
// Specify the query that you want to return results for by providing a query ID
// and a scope ID. This query returns data for the top contributors for workload
// insights. Workload insights provide a high level view of network flow
// performance data collected by agents for a scope.
//
// Top contributors in Network Flow Monitor are network flows with the highest
// values for a specific metric type, related to a scope (for workload insights) or
// a monitor.
//
// The top contributor network flows overall for a specific metric type, for
// example, the number of retransmissions.
func (c *Client) StopQueryWorkloadInsightsTopContributorsData(ctx context.Context, params *StopQueryWorkloadInsightsTopContributorsDataInput, optFns ...func(*Options)) (*StopQueryWorkloadInsightsTopContributorsDataOutput, error) {
	if params == nil {
		params = &StopQueryWorkloadInsightsTopContributorsDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StopQueryWorkloadInsightsTopContributorsData", params, optFns, c.addOperationStopQueryWorkloadInsightsTopContributorsDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StopQueryWorkloadInsightsTopContributorsDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StopQueryWorkloadInsightsTopContributorsDataInput struct {

	// The identifier for the query. A query ID is an internally-generated identifier
	// for a specific query returned from an API call to start a query.
	//
	// This member is required.
	QueryId *string

	// The identifier for the scope that includes the resources you want to get data
	// results for. A scope ID is an internally-generated identifier that includes all
	// the resources for a specific root account.
	//
	// This member is required.
	ScopeId *string

	noSmithyDocumentSerde
}

type StopQueryWorkloadInsightsTopContributorsDataOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStopQueryWorkloadInsightsTopContributorsDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStopQueryWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStopQueryWorkloadInsightsTopContributorsData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StopQueryWorkloadInsightsTopContributorsData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStopQueryWorkloadInsightsTopContributorsDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStopQueryWorkloadInsightsTopContributorsData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStopQueryWorkloadInsightsTopContributorsData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StopQueryWorkloadInsightsTopContributorsData",
	}
}
