// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/notifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of Account contacts and Channels associated with a
// ManagedNotificationConfiguration , in paginated format.
func (c *Client) ListManagedNotificationChannelAssociations(ctx context.Context, params *ListManagedNotificationChannelAssociationsInput, optFns ...func(*Options)) (*ListManagedNotificationChannelAssociationsOutput, error) {
	if params == nil {
		params = &ListManagedNotificationChannelAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedNotificationChannelAssociations", params, optFns, c.addOperationListManagedNotificationChannelAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedNotificationChannelAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedNotificationChannelAssociationsInput struct {

	// The Amazon Resource Name (ARN) of the ManagedNotificationConfiguration to match.
	//
	// This member is required.
	ManagedNotificationConfigurationArn *string

	// The maximum number of results to be returned in this call. Defaults to 20.
	MaxResults *int32

	// The start token for paginated calls. Retrieved from the response of a previous
	// ListManagedNotificationChannelAssociations call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListManagedNotificationChannelAssociationsOutput struct {

	// A list that contains the following information about a channel association.
	//
	// This member is required.
	ChannelAssociations []types.ManagedNotificationChannelAssociationSummary

	// A pagination token. If a non-null pagination token is returned in a result,
	// pass its value in another request to retrieve more entries.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedNotificationChannelAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedNotificationChannelAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedNotificationChannelAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedNotificationChannelAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListManagedNotificationChannelAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedNotificationChannelAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListManagedNotificationChannelAssociationsPaginatorOptions is the paginator
// options for ListManagedNotificationChannelAssociations
type ListManagedNotificationChannelAssociationsPaginatorOptions struct {
	// The maximum number of results to be returned in this call. Defaults to 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedNotificationChannelAssociationsPaginator is a paginator for
// ListManagedNotificationChannelAssociations
type ListManagedNotificationChannelAssociationsPaginator struct {
	options   ListManagedNotificationChannelAssociationsPaginatorOptions
	client    ListManagedNotificationChannelAssociationsAPIClient
	params    *ListManagedNotificationChannelAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListManagedNotificationChannelAssociationsPaginator returns a new
// ListManagedNotificationChannelAssociationsPaginator
func NewListManagedNotificationChannelAssociationsPaginator(client ListManagedNotificationChannelAssociationsAPIClient, params *ListManagedNotificationChannelAssociationsInput, optFns ...func(*ListManagedNotificationChannelAssociationsPaginatorOptions)) *ListManagedNotificationChannelAssociationsPaginator {
	if params == nil {
		params = &ListManagedNotificationChannelAssociationsInput{}
	}

	options := ListManagedNotificationChannelAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedNotificationChannelAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedNotificationChannelAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedNotificationChannelAssociations page.
func (p *ListManagedNotificationChannelAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedNotificationChannelAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedNotificationChannelAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedNotificationChannelAssociationsAPIClient is a client that implements
// the ListManagedNotificationChannelAssociations operation.
type ListManagedNotificationChannelAssociationsAPIClient interface {
	ListManagedNotificationChannelAssociations(context.Context, *ListManagedNotificationChannelAssociationsInput, ...func(*Options)) (*ListManagedNotificationChannelAssociationsOutput, error)
}

var _ ListManagedNotificationChannelAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedNotificationChannelAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedNotificationChannelAssociations",
	}
}
