// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

//	An access control entry allows or denies Active Directory groups based on
//
// their security identifiers (SIDs) from enrolling and/or autoenrolling with the
// template.
type AccessControlEntry struct {

	// Permissions to allow or deny an Active Directory group to enroll or autoenroll
	// certificates issued against a template.
	AccessRights *AccessRights

	// The date and time that the Access Control Entry was created.
	CreatedAt *time.Time

	// Name of the Active Directory group. This name does not need to match the group
	// name in Active Directory.
	GroupDisplayName *string

	// Security identifier (SID) of the group object from Active Directory. The SID
	// starts with "S-".
	GroupSecurityIdentifier *string

	// The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate].
	//
	// [CreateTemplate]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html
	TemplateArn *string

	// The date and time that the Access Control Entry was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Summary of group access control entries that allow or deny Active Directory
// groups based on their security identifiers (SIDs) from enrolling and/or
// autofenrolling with the template.
type AccessControlEntrySummary struct {

	// Allow or deny an Active Directory group from enrolling and autoenrolling
	// certificates issued against a template.
	AccessRights *AccessRights

	// The date and time that the Access Control Entry was created.
	CreatedAt *time.Time

	// Name of the Active Directory group. This name does not need to match the group
	// name in Active Directory.
	GroupDisplayName *string

	// Security identifier (SID) of the group object from Active Directory. The SID
	// starts with "S-".
	GroupSecurityIdentifier *string

	// The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate].
	//
	// [CreateTemplate]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html
	TemplateArn *string

	// The date and time that the Access Control Entry was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

//	Allow or deny permissions for an Active Directory group to enroll or
//
// autoenroll certificates for a template.
type AccessRights struct {

	// Allow or deny an Active Directory group from autoenrolling certificates issued
	// against a template. The Active Directory group must be allowed to enroll to
	// allow autoenrollment
	AutoEnroll AccessRight

	// Allow or deny an Active Directory group from enrolling certificates issued
	// against a template.
	Enroll AccessRight

	noSmithyDocumentSerde
}

// Application policies describe what the certificate can be used for.
type ApplicationPolicies struct {

	// Application policies describe what the certificate can be used for.
	//
	// This member is required.
	Policies []ApplicationPolicy

	// Marks the application policy extension as critical.
	Critical *bool

	noSmithyDocumentSerde
}

// Application policies describe what the certificate can be used for.
//
// The following types satisfy this interface:
//
//	ApplicationPolicyMemberPolicyObjectIdentifier
//	ApplicationPolicyMemberPolicyType
type ApplicationPolicy interface {
	isApplicationPolicy()
}

// The object identifier (OID) of an application policy.
type ApplicationPolicyMemberPolicyObjectIdentifier struct {
	Value string

	noSmithyDocumentSerde
}

func (*ApplicationPolicyMemberPolicyObjectIdentifier) isApplicationPolicy() {}

// The type of application policy
type ApplicationPolicyMemberPolicyType struct {
	Value ApplicationPolicyType

	noSmithyDocumentSerde
}

func (*ApplicationPolicyMemberPolicyType) isApplicationPolicy() {}

// Information describing the end of the validity period of the certificate. This
// parameter sets the “Not After” date for the certificate. Certificate validity is
// the period of time during which a certificate is valid. Validity can be
// expressed as an explicit date and time when the certificate expires, or as a
// span of time after issuance, stated in days, months, or years. For more
// information, see Validity in RFC 5280. This value is unaffected when
// ValidityNotBefore is also specified. For example, if Validity is set to 20 days
// in the future, the certificate will expire 20 days from issuance time regardless
// of the ValidityNotBefore value.
type CertificateValidity struct {

	// Renewal period is the period of time before certificate expiration when a new
	// certificate will be requested.
	//
	// This member is required.
	RenewalPeriod *ValidityPeriod

	// Information describing the end of the validity period of the certificate. This
	// parameter sets the “Not After” date for the certificate. Certificate validity is
	// the period of time during which a certificate is valid. Validity can be
	// expressed as an explicit date and time when the certificate expires, or as a
	// span of time after issuance, stated in days, months, or years. For more
	// information, see Validity in RFC 5280. This value is unaffected when
	// ValidityNotBefore is also specified. For example, if Validity is set to 20 days
	// in the future, the certificate will expire 20 days from issuance time regardless
	// of the ValidityNotBefore value.
	//
	// This member is required.
	ValidityPeriod *ValidityPeriod

	noSmithyDocumentSerde
}

// Amazon Web Services Private CA Connector for Active Directory is a service that
// links your Active Directory with Amazon Web Services Private CA. The connector
// brokers the exchange of certificates from Amazon Web Services Private CA to
// domain-joined users and machines managed with Active Directory.
type Connector struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateConnector].
	//
	// [CreateConnector]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html
	Arn *string

	// The Amazon Resource Name (ARN) of the certificate authority being used.
	CertificateAuthorityArn *string

	// Certificate enrollment endpoint for Active Directory domain-joined objects
	// reach out to when requesting certificates.
	CertificateEnrollmentPolicyServerEndpoint *string

	// The date and time that the connector was created.
	CreatedAt *time.Time

	// The identifier of the Active Directory.
	DirectoryId *string

	// Status of the connector. Status can be creating, active, deleting, or failed.
	Status ConnectorStatus

	// Additional information about the connector status if the status is failed.
	StatusReason ConnectorStatusReason

	// The date and time that the connector was updated.
	UpdatedAt *time.Time

	// Information of the VPC and security group(s) used with the connector.
	VpcInformation *VpcInformation

	noSmithyDocumentSerde
}

// Summary description of the Amazon Web Services Private CA AD connectors
// belonging to an Amazon Web Services account.
type ConnectorSummary struct {

	//  The Amazon Resource Name (ARN) that was returned when you called [CreateConnector].
	//
	// [CreateConnector]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html
	Arn *string

	// The Amazon Resource Name (ARN) of the certificate authority being used.
	CertificateAuthorityArn *string

	// Certificate enrollment endpoint for Active Directory domain-joined objects to
	// request certificates.
	CertificateEnrollmentPolicyServerEndpoint *string

	// The date and time that the connector was created.
	CreatedAt *time.Time

	// The identifier of the Active Directory.
	DirectoryId *string

	// Status of the connector. Status can be creating, active, deleting, or failed.
	Status ConnectorStatus

	// Additional information about the connector status if the status is failed.
	StatusReason ConnectorStatusReason

	// The date and time that the connector was updated.
	UpdatedAt *time.Time

	// Information of the VPC and security group(s) used with the connector.
	VpcInformation *VpcInformation

	noSmithyDocumentSerde
}

// The directory registration represents the authorization of the connector
// service with a directory.
type DirectoryRegistration struct {

	// The Amazon Resource Name (ARN) that was returned when you called
	// CreateDirectoryRegistration.
	Arn *string

	// The date and time that the directory registration was created.
	CreatedAt *time.Time

	// The identifier of the Active Directory.
	DirectoryId *string

	// Status of the directory registration.
	Status DirectoryRegistrationStatus

	// Additional information about the directory registration status if the status is
	// failed.
	StatusReason DirectoryRegistrationStatusReason

	// The date and time that the directory registration was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The directory registration represents the authorization of the connector
// service with the Active Directory.
type DirectoryRegistrationSummary struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateDirectoryRegistration].
	//
	// [CreateDirectoryRegistration]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html
	Arn *string

	// The date and time that the directory registration was created.
	CreatedAt *time.Time

	// The identifier of the Active Directory.
	DirectoryId *string

	// Status of the directory registration.
	Status DirectoryRegistrationStatus

	// Additional information about the directory registration status if the status is
	// failed.
	StatusReason DirectoryRegistrationStatusReason

	// The date and time that the directory registration was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Template configurations for v2 template schema.
type EnrollmentFlagsV2 struct {

	// Allow renewal using the same key.
	EnableKeyReuseOnNtTokenKeysetStorageFull *bool

	// Include symmetric algorithms allowed by the subject.
	IncludeSymmetricAlgorithms *bool

	// This flag instructs the CA to not include the security extension
	// szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE]
	// sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This
	// addresses a Windows Kerberos elevation-of-privilege vulnerability.
	NoSecurityExtension *bool

	// Delete expired or revoked certificates instead of archiving them.
	RemoveInvalidCertificateFromPersonalStore *bool

	// Require user interaction when the subject is enrolled and the private key
	// associated with the certificate is used.
	UserInteractionRequired *bool

	noSmithyDocumentSerde
}

// Template configurations for v3 template schema.
type EnrollmentFlagsV3 struct {

	// Allow renewal using the same key.
	EnableKeyReuseOnNtTokenKeysetStorageFull *bool

	// Include symmetric algorithms allowed by the subject.
	IncludeSymmetricAlgorithms *bool

	// This flag instructs the CA to not include the security extension
	// szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE]
	// sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This
	// addresses a Windows Kerberos elevation-of-privilege vulnerability.
	NoSecurityExtension *bool

	// Delete expired or revoked certificates instead of archiving them.
	RemoveInvalidCertificateFromPersonalStore *bool

	// Require user interaction when the subject is enrolled and the private key
	// associated with the certificate is used.
	UserInteractionRequired *bool

	noSmithyDocumentSerde
}

// Template configurations for v4 template schema.
type EnrollmentFlagsV4 struct {

	// Allow renewal using the same key.
	EnableKeyReuseOnNtTokenKeysetStorageFull *bool

	// Include symmetric algorithms allowed by the subject.
	IncludeSymmetricAlgorithms *bool

	// This flag instructs the CA to not include the security extension
	// szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE]
	// sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This
	// addresses a Windows Kerberos elevation-of-privilege vulnerability.
	NoSecurityExtension *bool

	// Delete expired or revoked certificates instead of archiving them.
	RemoveInvalidCertificateFromPersonalStore *bool

	// Require user interaction when the subject is enrolled and the private key
	// associated with the certificate is used.
	UserInteractionRequired *bool

	noSmithyDocumentSerde
}

// Certificate extensions for v2 template schema
type ExtensionsV2 struct {

	// The key usage extension defines the purpose (e.g., encipherment, signature,
	// certificate signing) of the key contained in the certificate.
	//
	// This member is required.
	KeyUsage *KeyUsage

	// Application policies specify what the certificate is used for and its purpose.
	ApplicationPolicies *ApplicationPolicies

	noSmithyDocumentSerde
}

// Certificate extensions for v3 template schema
type ExtensionsV3 struct {

	// The key usage extension defines the purpose (e.g., encipherment, signature,
	// certificate signing) of the key contained in the certificate.
	//
	// This member is required.
	KeyUsage *KeyUsage

	// Application policies specify what the certificate is used for and its purpose.
	ApplicationPolicies *ApplicationPolicies

	noSmithyDocumentSerde
}

// Certificate extensions for v4 template schema
type ExtensionsV4 struct {

	// The key usage extension defines the purpose (e.g., encipherment, signature) of
	// the key contained in the certificate.
	//
	// This member is required.
	KeyUsage *KeyUsage

	// Application policies specify what the certificate is used for and its purpose.
	ApplicationPolicies *ApplicationPolicies

	noSmithyDocumentSerde
}

// General flags for v2 template schema that defines if the template is for a
// machine or a user and if the template can be issued using autoenrollment.
type GeneralFlagsV2 struct {

	// Allows certificate issuance using autoenrollment. Set to TRUE to allow
	// autoenrollment.
	AutoEnrollment *bool

	// Defines if the template is for machines or users. Set to TRUE if the template
	// is for machines. Set to FALSE if the template is for users.
	MachineType *bool

	noSmithyDocumentSerde
}

// General flags for v3 template schema that defines if the template is for a
// machine or a user and if the template can be issued using autoenrollment.
type GeneralFlagsV3 struct {

	// Allows certificate issuance using autoenrollment. Set to TRUE to allow
	// autoenrollment.
	AutoEnrollment *bool

	// Defines if the template is for machines or users. Set to TRUE if the template
	// is for machines. Set to FALSE if the template is for users
	MachineType *bool

	noSmithyDocumentSerde
}

// General flags for v4 template schema that defines if the template is for a
// machine or a user and if the template can be issued using autoenrollment.
type GeneralFlagsV4 struct {

	// Allows certificate issuance using autoenrollment. Set to TRUE to allow
	// autoenrollment.
	AutoEnrollment *bool

	// Defines if the template is for machines or users. Set to TRUE if the template
	// is for machines. Set to FALSE if the template is for users
	MachineType *bool

	noSmithyDocumentSerde
}

// The key usage extension defines the purpose (e.g., encipherment, signature) of
// the key contained in the certificate.
type KeyUsage struct {

	// The key usage flags represent the purpose (e.g., encipherment, signature) of
	// the key contained in the certificate.
	//
	// This member is required.
	UsageFlags *KeyUsageFlags

	// Sets the key usage extension to critical.
	Critical *bool

	noSmithyDocumentSerde
}

// The key usage flags represent the purpose (e.g., encipherment, signature) of
// the key contained in the certificate.
type KeyUsageFlags struct {

	// DataEncipherment is asserted when the subject public key is used for directly
	// enciphering raw user data without the use of an intermediate symmetric cipher.
	DataEncipherment *bool

	// The digitalSignature is asserted when the subject public key is used for
	// verifying digital signatures.
	DigitalSignature *bool

	// KeyAgreement is asserted when the subject public key is used for key agreement.
	KeyAgreement *bool

	// KeyEncipherment is asserted when the subject public key is used for enciphering
	// private or secret keys, i.e., for key transport.
	KeyEncipherment *bool

	// NonRepudiation is asserted when the subject public key is used to verify
	// digital signatures.
	NonRepudiation *bool

	noSmithyDocumentSerde
}

// The key usage property defines the purpose of the private key contained in the
// certificate. You can specify specific purposes using property flags or all by
// using property type ALL.
//
// The following types satisfy this interface:
//
//	KeyUsagePropertyMemberPropertyFlags
//	KeyUsagePropertyMemberPropertyType
type KeyUsageProperty interface {
	isKeyUsageProperty()
}

// You can specify key usage for encryption, key agreement, and signature. You can
// use property flags or property type but not both.
type KeyUsagePropertyMemberPropertyFlags struct {
	Value KeyUsagePropertyFlags

	noSmithyDocumentSerde
}

func (*KeyUsagePropertyMemberPropertyFlags) isKeyUsageProperty() {}

// You can specify all key usages using property type ALL. You can use property
// type or property flags but not both.
type KeyUsagePropertyMemberPropertyType struct {
	Value KeyUsagePropertyType

	noSmithyDocumentSerde
}

func (*KeyUsagePropertyMemberPropertyType) isKeyUsageProperty() {}

// Specifies key usage.
type KeyUsagePropertyFlags struct {

	// Allows key for encryption and decryption.
	Decrypt *bool

	// Allows key exchange without encryption.
	KeyAgreement *bool

	// Allow key use for digital signature.
	Sign *bool

	noSmithyDocumentSerde
}

// Defines the attributes of the private key.
type PrivateKeyAttributesV2 struct {

	// Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE"
	// value.
	//
	// This member is required.
	KeySpec KeySpec

	// Set the minimum key length of the private key.
	//
	// This member is required.
	MinimalKeyLength *int32

	// Defines the cryptographic providers used to generate the private key.
	CryptoProviders []string

	noSmithyDocumentSerde
}

// Defines the attributes of the private key.
type PrivateKeyAttributesV3 struct {

	// Defines the algorithm used to generate the private key.
	//
	// This member is required.
	Algorithm PrivateKeyAlgorithm

	// Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE"
	// value.
	//
	// This member is required.
	KeySpec KeySpec

	// The key usage property defines the purpose of the private key contained in the
	// certificate. You can specify specific purposes using property flags or all by
	// using property type ALL.
	//
	// This member is required.
	KeyUsageProperty KeyUsageProperty

	// Set the minimum key length of the private key.
	//
	// This member is required.
	MinimalKeyLength *int32

	// Defines the cryptographic providers used to generate the private key.
	CryptoProviders []string

	noSmithyDocumentSerde
}

// Defines the attributes of the private key.
type PrivateKeyAttributesV4 struct {

	// Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE"
	// value.
	//
	// This member is required.
	KeySpec KeySpec

	// Set the minimum key length of the private key.
	//
	// This member is required.
	MinimalKeyLength *int32

	// Defines the algorithm used to generate the private key.
	Algorithm PrivateKeyAlgorithm

	// Defines the cryptographic providers used to generate the private key.
	CryptoProviders []string

	// The key usage property defines the purpose of the private key contained in the
	// certificate. You can specify specific purposes using property flags or all by
	// using property type ALL.
	KeyUsageProperty KeyUsageProperty

	noSmithyDocumentSerde
}

// Private key flags for v2 templates specify the client compatibility, if the
// private key can be exported, and if user input is required when using a private
// key.
type PrivateKeyFlagsV2 struct {

	// Defines the minimum client compatibility.
	//
	// This member is required.
	ClientVersion ClientCompatibilityV2

	// Allows the private key to be exported.
	ExportableKey *bool

	// Require user input when using the private key for enrollment.
	StrongKeyProtectionRequired *bool

	noSmithyDocumentSerde
}

// Private key flags for v3 templates specify the client compatibility, if the
// private key can be exported, if user input is required when using a private key,
// and if an alternate signature algorithm should be used.
type PrivateKeyFlagsV3 struct {

	// Defines the minimum client compatibility.
	//
	// This member is required.
	ClientVersion ClientCompatibilityV3

	// Allows the private key to be exported.
	ExportableKey *bool

	// Reguires the PKCS #1 v2.1 signature format for certificates. You should verify
	// that your CA, objects, and applications can accept this signature format.
	RequireAlternateSignatureAlgorithm *bool

	// Requirer user input when using the private key for enrollment.
	StrongKeyProtectionRequired *bool

	noSmithyDocumentSerde
}

// Private key flags for v4 templates specify the client compatibility, if the
// private key can be exported, if user input is required when using a private key,
// if an alternate signature algorithm should be used, and if certificates are
// renewed using the same private key.
type PrivateKeyFlagsV4 struct {

	// Defines the minimum client compatibility.
	//
	// This member is required.
	ClientVersion ClientCompatibilityV4

	// Allows the private key to be exported.
	ExportableKey *bool

	// Requires the PKCS #1 v2.1 signature format for certificates. You should verify
	// that your CA, objects, and applications can accept this signature format.
	RequireAlternateSignatureAlgorithm *bool

	// Renew certificate using the same private key.
	RequireSameKeyRenewal *bool

	// Require user input when using the private key for enrollment.
	StrongKeyProtectionRequired *bool

	// Specifies the cryptographic service provider category used to generate private
	// keys. Set to TRUE to use Legacy Cryptographic Service Providers and FALSE to use
	// Key Storage Providers.
	UseLegacyProvider *bool

	noSmithyDocumentSerde
}

// The service principal name that the connector uses to authenticate with Active
// Directory.
type ServicePrincipalName struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateConnector.html].
	//
	// [CreateConnector.html]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html
	ConnectorArn *string

	// The date and time that the service principal name was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) that was returned when you called [CreateDirectoryRegistration].
	//
	// [CreateDirectoryRegistration]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html
	DirectoryRegistrationArn *string

	// The status of a service principal name.
	Status ServicePrincipalNameStatus

	// Additional information for the status of a service principal name if the status
	// is failed.
	StatusReason ServicePrincipalNameStatusReason

	// The date and time that the service principal name was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The service principal name that the connector uses to authenticate with Active
// Directory.
type ServicePrincipalNameSummary struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateConnector].
	//
	// [CreateConnector]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html
	ConnectorArn *string

	// The date and time that the service principal name was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) that was returned when you called [CreateDirectoryRegistration].
	//
	// [CreateDirectoryRegistration]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html
	DirectoryRegistrationArn *string

	// The status of a service principal name.
	Status ServicePrincipalNameStatus

	// Additional information for the status of a service principal name if the status
	// is failed.
	StatusReason ServicePrincipalNameStatusReason

	// Time when the service principal name was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information to include in the subject name and alternate subject name of the
// certificate. The subject name can be common name, directory path, DNS as common
// name, or left blank. You can optionally include email to the subject name for
// user templates. If you leave the subject name blank then you must set a subject
// alternate name. The subject alternate name (SAN) can include globally unique
// identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and
// user principal name (UPN). You can leave the SAN blank. If you leave the SAN
// blank, then you must set a subject name.
type SubjectNameFlagsV2 struct {

	// Include the common name in the subject name.
	RequireCommonName *bool

	// Include the directory path in the subject name.
	RequireDirectoryPath *bool

	// Include the DNS as common name in the subject name.
	RequireDnsAsCn *bool

	// Include the subject's email in the subject name.
	RequireEmail *bool

	// Include the globally unique identifier (GUID) in the subject alternate name.
	SanRequireDirectoryGuid *bool

	// Include the DNS in the subject alternate name.
	SanRequireDns *bool

	// Include the domain DNS in the subject alternate name.
	SanRequireDomainDns *bool

	// Include the subject's email in the subject alternate name.
	SanRequireEmail *bool

	// Include the service principal name (SPN) in the subject alternate name.
	SanRequireSpn *bool

	// Include the user principal name (UPN) in the subject alternate name.
	SanRequireUpn *bool

	noSmithyDocumentSerde
}

// Information to include in the subject name and alternate subject name of the
// certificate. The subject name can be common name, directory path, DNS as common
// name, or left blank. You can optionally include email to the subject name for
// user templates. If you leave the subject name blank then you must set a subject
// alternate name. The subject alternate name (SAN) can include globally unique
// identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and
// user principal name (UPN). You can leave the SAN blank. If you leave the SAN
// blank, then you must set a subject name.
type SubjectNameFlagsV3 struct {

	// Include the common name in the subject name.
	RequireCommonName *bool

	// Include the directory path in the subject name.
	RequireDirectoryPath *bool

	// Include the DNS as common name in the subject name.
	RequireDnsAsCn *bool

	// Include the subject's email in the subject name.
	RequireEmail *bool

	// Include the globally unique identifier (GUID) in the subject alternate name.
	SanRequireDirectoryGuid *bool

	// Include the DNS in the subject alternate name.
	SanRequireDns *bool

	// Include the domain DNS in the subject alternate name.
	SanRequireDomainDns *bool

	// Include the subject's email in the subject alternate name.
	SanRequireEmail *bool

	// Include the service principal name (SPN) in the subject alternate name.
	SanRequireSpn *bool

	// Include the user principal name (UPN) in the subject alternate name.
	SanRequireUpn *bool

	noSmithyDocumentSerde
}

// Information to include in the subject name and alternate subject name of the
// certificate. The subject name can be common name, directory path, DNS as common
// name, or left blank. You can optionally include email to the subject name for
// user templates. If you leave the subject name blank then you must set a subject
// alternate name. The subject alternate name (SAN) can include globally unique
// identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and
// user principal name (UPN). You can leave the SAN blank. If you leave the SAN
// blank, then you must set a subject name.
type SubjectNameFlagsV4 struct {

	// Include the common name in the subject name.
	RequireCommonName *bool

	// Include the directory path in the subject name.
	RequireDirectoryPath *bool

	// Include the DNS as common name in the subject name.
	RequireDnsAsCn *bool

	// Include the subject's email in the subject name.
	RequireEmail *bool

	// Include the globally unique identifier (GUID) in the subject alternate name.
	SanRequireDirectoryGuid *bool

	// Include the DNS in the subject alternate name.
	SanRequireDns *bool

	// Include the domain DNS in the subject alternate name.
	SanRequireDomainDns *bool

	// Include the subject's email in the subject alternate name.
	SanRequireEmail *bool

	// Include the service principal name (SPN) in the subject alternate name.
	SanRequireSpn *bool

	// Include the user principal name (UPN) in the subject alternate name.
	SanRequireUpn *bool

	noSmithyDocumentSerde
}

// An Active Directory compatible certificate template. Connectors issue
// certificates against these templates based on the requestor's Active Directory
// group membership.
type Template struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate].
	//
	// [CreateTemplate]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html
	Arn *string

	//  The Amazon Resource Name (ARN) that was returned when you called [CreateConnector].
	//
	// [CreateConnector]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html
	ConnectorArn *string

	// The date and time that the template was created.
	CreatedAt *time.Time

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and
	// cryptography settings.
	Definition TemplateDefinition

	// Name of the templates. Template names must be unique.
	Name *string

	// Object identifier of a template.
	ObjectIdentifier *string

	// The template schema version. Template schema versions can be v2, v3, or v4. The
	// template configuration options change based on the template schema version.
	PolicySchema *int32

	// The version of the template. Template updates will increment the minor
	// revision. Re-enrolling all certificate holders will increment the major
	// revision.
	Revision *TemplateRevision

	// Status of the template. Status can be creating, active, deleting, or failed.
	Status TemplateStatus

	// The date and time that the template was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Template configuration to define the information included in certificates.
// Define certificate validity and renewal periods, certificate request handling
// and enrollment options, key usage extensions, application policies, and
// cryptography settings.
//
// The following types satisfy this interface:
//
//	TemplateDefinitionMemberTemplateV2
//	TemplateDefinitionMemberTemplateV3
//	TemplateDefinitionMemberTemplateV4
type TemplateDefinition interface {
	isTemplateDefinition()
}

// Template configuration to define the information included in certificates.
// Define certificate validity and renewal periods, certificate request handling
// and enrollment options, key usage extensions, application policies, and
// cryptography settings.
type TemplateDefinitionMemberTemplateV2 struct {
	Value TemplateV2

	noSmithyDocumentSerde
}

func (*TemplateDefinitionMemberTemplateV2) isTemplateDefinition() {}

// Template configuration to define the information included in certificates.
// Define certificate validity and renewal periods, certificate request handling
// and enrollment options, key usage extensions, application policies, and
// cryptography settings.
type TemplateDefinitionMemberTemplateV3 struct {
	Value TemplateV3

	noSmithyDocumentSerde
}

func (*TemplateDefinitionMemberTemplateV3) isTemplateDefinition() {}

// Template configuration to define the information included in certificates.
// Define certificate validity and renewal periods, certificate request handling
// and enrollment options, key usage extensions, application policies, and
// cryptography settings.
type TemplateDefinitionMemberTemplateV4 struct {
	Value TemplateV4

	noSmithyDocumentSerde
}

func (*TemplateDefinitionMemberTemplateV4) isTemplateDefinition() {}

// The revision version of the template. Template updates will increment the minor
// revision. Re-enrolling all certificate holders will increment the major
// revision.
type TemplateRevision struct {

	// The revision version of the template. Re-enrolling all certificate holders will
	// increment the major revision.
	//
	// This member is required.
	MajorRevision *int32

	// The revision version of the template. Re-enrolling all certificate holders will
	// increment the major revision.
	//
	// This member is required.
	MinorRevision *int32

	noSmithyDocumentSerde
}

// An Active Directory compatible certificate template. Connectors issue
// certificates against these templates based on the requestor's Active Directory
// group membership.
type TemplateSummary struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateTemplate].
	//
	// [CreateTemplate]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html
	Arn *string

	//  The Amazon Resource Name (ARN) that was returned when you called [CreateConnector].
	//
	// [CreateConnector]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html
	ConnectorArn *string

	// The date and time that the template was created.
	CreatedAt *time.Time

	// Template configuration to define the information included in certificates.
	// Define certificate validity and renewal periods, certificate request handling
	// and enrollment options, key usage extensions, application policies, and
	// cryptography settings.
	Definition TemplateDefinition

	// Name of the template. The template name must be unique.
	Name *string

	// Object identifier of a template.
	ObjectIdentifier *string

	// The template schema version. Template schema versions can be v2, v3, or v4. The
	// template configuration options change based on the template schema version.
	PolicySchema *int32

	// The revision version of the template. Template updates will increment the minor
	// revision. Re-enrolling all certificate holders will increment the major
	// revision.
	Revision *TemplateRevision

	// Status of the template. Status can be creating, active, deleting, or failed.
	Status TemplateStatus

	// The date and time that the template was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// v2 template schema that uses Legacy Cryptographic Providers.
type TemplateV2 struct {

	// Certificate validity describes the validity and renewal periods of a
	// certificate.
	//
	// This member is required.
	CertificateValidity *CertificateValidity

	// Enrollment flags describe the enrollment settings for certificates such as
	// using the existing private key and deleting expired or revoked certificates.
	//
	// This member is required.
	EnrollmentFlags *EnrollmentFlagsV2

	// Extensions describe the key usage extensions and application policies for a
	// template.
	//
	// This member is required.
	Extensions *ExtensionsV2

	// General flags describe whether the template is used for computers or users and
	// if the template can be used with autoenrollment.
	//
	// This member is required.
	GeneralFlags *GeneralFlagsV2

	// Private key attributes allow you to specify the minimal key length, key spec,
	// and cryptographic providers for the private key of a certificate for v2
	// templates. V2 templates allow you to use Legacy Cryptographic Service Providers.
	//
	// This member is required.
	PrivateKeyAttributes *PrivateKeyAttributesV2

	// Private key flags for v2 templates specify the client compatibility, if the
	// private key can be exported, and if user input is required when using a private
	// key.
	//
	// This member is required.
	PrivateKeyFlags *PrivateKeyFlagsV2

	// Subject name flags describe the subject name and subject alternate name that is
	// included in a certificate.
	//
	// This member is required.
	SubjectNameFlags *SubjectNameFlagsV2

	// List of templates in Active Directory that are superseded by this template.
	SupersededTemplates []string

	noSmithyDocumentSerde
}

// v3 template schema that uses Key Storage Providers.
type TemplateV3 struct {

	// Certificate validity describes the validity and renewal periods of a
	// certificate.
	//
	// This member is required.
	CertificateValidity *CertificateValidity

	// Enrollment flags describe the enrollment settings for certificates such as
	// using the existing private key and deleting expired or revoked certificates.
	//
	// This member is required.
	EnrollmentFlags *EnrollmentFlagsV3

	// Extensions describe the key usage extensions and application policies for a
	// template.
	//
	// This member is required.
	Extensions *ExtensionsV3

	// General flags describe whether the template is used for computers or users and
	// if the template can be used with autoenrollment.
	//
	// This member is required.
	GeneralFlags *GeneralFlagsV3

	// Specifies the hash algorithm used to hash the private key.
	//
	// This member is required.
	HashAlgorithm HashAlgorithm

	// Private key attributes allow you to specify the algorithm, minimal key length,
	// key spec, key usage, and cryptographic providers for the private key of a
	// certificate for v3 templates. V3 templates allow you to use Key Storage
	// Providers.
	//
	// This member is required.
	PrivateKeyAttributes *PrivateKeyAttributesV3

	// Private key flags for v3 templates specify the client compatibility, if the
	// private key can be exported, if user input is required when using a private key,
	// and if an alternate signature algorithm should be used.
	//
	// This member is required.
	PrivateKeyFlags *PrivateKeyFlagsV3

	// Subject name flags describe the subject name and subject alternate name that is
	// included in a certificate.
	//
	// This member is required.
	SubjectNameFlags *SubjectNameFlagsV3

	// List of templates in Active Directory that are superseded by this template.
	SupersededTemplates []string

	noSmithyDocumentSerde
}

// v4 template schema that can use either Legacy Cryptographic Providers or Key
// Storage Providers.
type TemplateV4 struct {

	// Certificate validity describes the validity and renewal periods of a
	// certificate.
	//
	// This member is required.
	CertificateValidity *CertificateValidity

	// Enrollment flags describe the enrollment settings for certificates using the
	// existing private key and deleting expired or revoked certificates.
	//
	// This member is required.
	EnrollmentFlags *EnrollmentFlagsV4

	// Extensions describe the key usage extensions and application policies for a
	// template.
	//
	// This member is required.
	Extensions *ExtensionsV4

	// General flags describe whether the template is used for computers or users and
	// if the template can be used with autoenrollment.
	//
	// This member is required.
	GeneralFlags *GeneralFlagsV4

	// Private key attributes allow you to specify the minimal key length, key spec,
	// key usage, and cryptographic providers for the private key of a certificate for
	// v4 templates. V4 templates allow you to use either Key Storage Providers or
	// Legacy Cryptographic Service Providers. You specify the cryptography provider
	// category in private key flags.
	//
	// This member is required.
	PrivateKeyAttributes *PrivateKeyAttributesV4

	// Private key flags for v4 templates specify the client compatibility, if the
	// private key can be exported, if user input is required when using a private key,
	// if an alternate signature algorithm should be used, and if certificates are
	// renewed using the same private key.
	//
	// This member is required.
	PrivateKeyFlags *PrivateKeyFlagsV4

	// Subject name flags describe the subject name and subject alternate name that is
	// included in a certificate.
	//
	// This member is required.
	SubjectNameFlags *SubjectNameFlagsV4

	// Specifies the hash algorithm used to hash the private key. Hash algorithm can
	// only be specified when using Key Storage Providers.
	HashAlgorithm HashAlgorithm

	// List of templates in Active Directory that are superseded by this template.
	SupersededTemplates []string

	noSmithyDocumentSerde
}

// Information describing the end of the validity period of the certificate. This
// parameter sets the “Not After” date for the certificate. Certificate validity is
// the period of time during which a certificate is valid. Validity can be
// expressed as an explicit date and time when the certificate expires, or as a
// span of time after issuance, stated in hours, days, months, or years. For more
// information, see Validity in RFC 5280. This value is unaffected when
// ValidityNotBefore is also specified. For example, if Validity is set to 20 days
// in the future, the certificate will expire 20 days from issuance time regardless
// of the ValidityNotBefore value.
type ValidityPeriod struct {

	// The numeric value for the validity period.
	//
	// This member is required.
	Period *int64

	// The unit of time. You can select hours, days, weeks, months, and years.
	//
	// This member is required.
	PeriodType ValidityPeriodType

	noSmithyDocumentSerde
}

// Information about your VPC and security groups used with the connector.
type VpcInformation struct {

	// The security groups used with the connector. You can use a maximum of 4
	// security groups with a connector.
	//
	// This member is required.
	SecurityGroupIds []string

	// The VPC IP address type.
	IpAddressType IpAddressType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isApplicationPolicy()  {}
func (*UnknownUnionMember) isKeyUsageProperty()   {}
func (*UnknownUnionMember) isTemplateDefinition() {}
