// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new cluster with the specified parameters.
//
// To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster
// subnet group name. The cluster subnet group identifies the subnets of your VPC
// that Amazon Redshift uses when creating the cluster. For more information about
// managing clusters, go to [Amazon Redshift Clusters]in the Amazon Redshift Cluster Management Guide.
//
// VPC Block Public Access (BPA) enables you to block resources in VPCs and
// subnets that you own in a Region from reaching or being reached from the
// internet through internet gateways and egress-only internet gateways. If a
// subnet group for a provisioned cluster is in an account with VPC BPA turned on,
// the following capabilities are blocked:
//
//   - Creating a public cluster
//
//   - Restoring a public cluster
//
//   - Modifying a private cluster to be public
//
//   - Adding a subnet with VPC BPA turned on to the subnet group when there's at
//     least one public cluster within the group
//
// For more information about VPC BPA, see [Block public access to VPCs and subnets] in the Amazon VPC User Guide.
//
// [Amazon Redshift Clusters]: https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html
// [Block public access to VPCs and subnets]: https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html
func (c *Client) CreateCluster(ctx context.Context, params *CreateClusterInput, optFns ...func(*Options)) (*CreateClusterOutput, error) {
	if params == nil {
		params = &CreateClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCluster", params, optFns, c.addOperationCreateClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateClusterInput struct {

	// A unique identifier for the cluster. You use this identifier to refer to the
	// cluster for any subsequent cluster operations such as deleting or modifying. The
	// identifier also appears in the Amazon Redshift console.
	//
	// Constraints:
	//
	//   - Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//   - Alphabetic characters must be lowercase.
	//
	//   - First character must be a letter.
	//
	//   - Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//   - Must be unique for all clusters within an Amazon Web Services account.
	//
	// Example: myexamplecluster
	//
	// This member is required.
	ClusterIdentifier *string

	// The user name associated with the admin user account for the cluster that is
	// being created.
	//
	// Constraints:
	//
	//   - Must be 1 - 128 alphanumeric characters or hyphens. The user name can't be
	//   PUBLIC .
	//
	//   - Must contain only lowercase letters, numbers, underscore, plus sign, period
	//   (dot), at symbol (@), or hyphen.
	//
	//   - The first character must be a letter.
	//
	//   - Must not contain a colon (:) or a slash (/).
	//
	//   - Cannot be a reserved word. A list of reserved words can be found in [Reserved Words]in the
	//   Amazon Redshift Database Developer Guide.
	//
	// [Reserved Words]: https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html
	//
	// This member is required.
	MasterUsername *string

	// The node type to be provisioned for the cluster. For information about node
	// types, go to [Working with Clusters]in the Amazon Redshift Cluster Management Guide.
	//
	// Valid Values: dc2.large | dc2.8xlarge | ra3.large | ra3.xlplus | ra3.4xlarge |
	// ra3.16xlarge
	//
	// [Working with Clusters]: https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes
	//
	// This member is required.
	NodeType *string

	// Reserved.
	AdditionalInfo *string

	// If true , major version upgrades can be applied during the maintenance window to
	// the Amazon Redshift engine that is running on the cluster.
	//
	// When a new major version of the Amazon Redshift engine is released, you can
	// request that the service automatically apply upgrades during the maintenance
	// window to the Amazon Redshift engine that is running on your cluster.
	//
	// Default: true
	AllowVersionUpgrade *bool

	// This parameter is retired. It does not set the AQUA configuration status.
	// Amazon Redshift automatically determines whether to use AQUA (Advanced Query
	// Accelerator).
	AquaConfigurationStatus types.AquaConfigurationStatus

	// The number of days that automated snapshots are retained. If the value is 0,
	// automated snapshots are disabled. Even if automated snapshots are disabled, you
	// can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	// You can't disable automated snapshots for RA3 node types. Set the automated
	// retention period from 1-35 days.
	//
	// Default: 1
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int32

	// The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision
	// the cluster. For example, if you have several EC2 instances running in a
	// specific Availability Zone, then you might want the cluster to be provisioned in
	// the same zone in order to decrease network latency.
	//
	// Default: A random, system-chosen Availability Zone in the region that is
	// specified by the endpoint.
	//
	// Example: us-east-2d
	//
	// Constraint: The specified Availability Zone must be in the same region as the
	// current endpoint.
	AvailabilityZone *string

	// The option to enable relocation for an Amazon Redshift cluster between
	// Availability Zones after the cluster is created.
	AvailabilityZoneRelocation *bool

	// The name of the parameter group to be associated with this cluster.
	//
	// Default: The default Amazon Redshift cluster parameter group. For information
	// about the default parameter group, go to [Working with Amazon Redshift Parameter Groups]
	//
	// Constraints:
	//
	//   - Must be 1 to 255 alphanumeric characters or hyphens.
	//
	//   - First character must be a letter.
	//
	//   - Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// [Working with Amazon Redshift Parameter Groups]: https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html
	ClusterParameterGroupName *string

	// A list of security groups to be associated with this cluster.
	//
	// Default: The default cluster security group for Amazon Redshift.
	ClusterSecurityGroups []string

	// The name of a cluster subnet group to be associated with this cluster.
	//
	// If this parameter is not provided the resulting cluster will be deployed
	// outside virtual private cloud (VPC).
	ClusterSubnetGroupName *string

	// The type of the cluster. When cluster type is specified as
	//
	//   - single-node , the NumberOfNodes parameter is not required.
	//
	//   - multi-node , the NumberOfNodes parameter is required.
	//
	// Valid Values: multi-node | single-node
	//
	// Default: multi-node
	ClusterType *string

	// The version of the Amazon Redshift engine software that you want to deploy on
	// the cluster.
	//
	// The version selected runs on all the nodes in the cluster.
	//
	// Constraints: Only version 1.0 is currently available.
	//
	// Example: 1.0
	ClusterVersion *string

	// The name of the first database to be created when the cluster is created.
	//
	// To create additional databases after the cluster is created, connect to the
	// cluster with a SQL client and use SQL commands to create a database. For more
	// information, go to [Create a Database]in the Amazon Redshift Database Developer Guide.
	//
	// Default: dev
	//
	// Constraints:
	//
	//   - Must contain 1 to 64 alphanumeric characters.
	//
	//   - Must contain only lowercase letters.
	//
	//   - Cannot be a word that is reserved by the service. A list of reserved words
	//   can be found in [Reserved Words]in the Amazon Redshift Database Developer Guide.
	//
	// [Reserved Words]: https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html
	// [Create a Database]: https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html
	DBName *string

	// The Amazon Resource Name (ARN) for the IAM role that was set as default for the
	// cluster when the cluster was created.
	DefaultIamRoleArn *string

	// The Elastic IP (EIP) address for the cluster.
	//
	// Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
	// through an Internet gateway. Don't specify the Elastic IP address for a publicly
	// accessible cluster with availability zone relocation turned on. For more
	// information about provisioning clusters in EC2-VPC, go to [Supported Platforms to Launch Your Cluster]in the Amazon
	// Redshift Cluster Management Guide.
	//
	// [Supported Platforms to Launch Your Cluster]: https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms
	ElasticIp *string

	// If true , the data in the cluster is encrypted at rest. If you set the value on
	// this parameter to false , the request will fail.
	//
	// Default: true
	Encrypted *bool

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the cluster
	// must be in a VPC. For more information, see [Enhanced VPC Routing]in the Amazon Redshift Cluster
	// Management Guide.
	//
	// If this option is true , enhanced VPC routing is enabled.
	//
	// Default: false
	//
	// [Enhanced VPC Routing]: https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html
	EnhancedVpcRouting *bool

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string

	// Specifies the name of the HSM configuration that contains the information the
	// Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string

	// A list of Identity and Access Management (IAM) roles that can be used by the
	// cluster to access other Amazon Web Services services. You must supply the IAM
	// roles in their Amazon Resource Name (ARN) format.
	//
	// The maximum number of IAM roles that you can associate is subject to a quota.
	// For more information, go to [Quotas and limits]in the Amazon Redshift Cluster Management Guide.
	//
	// [Quotas and limits]: https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html
	IamRoles []string

	// The IP address types that the cluster supports. Possible values are ipv4 and
	// dualstack .
	IpAddressType *string

	// The Key Management Service (KMS) key ID of the encryption key that you want to
	// use to encrypt data in the cluster.
	KmsKeyId *string

	// A flag that specifies whether to load sample data once the cluster is created.
	LoadSampleData *string

	// An optional parameter for the name of the maintenance track for the cluster. If
	// you don't provide a maintenance track name, the cluster is assigned to the
	// current track.
	MaintenanceTrackName *string

	// If true , Amazon Redshift uses Secrets Manager to manage this cluster's admin
	// credentials. You can't use MasterUserPassword if ManageMasterPassword is true.
	// If ManageMasterPassword is false or not set, Amazon Redshift uses
	// MasterUserPassword for the admin user account's password.
	ManageMasterPassword *bool

	// The default number of days to retain a manual snapshot. If the value is -1, the
	// snapshot is retained indefinitely. This setting doesn't change the retention
	// period of existing snapshots.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int32

	// The ID of the Key Management Service (KMS) key used to encrypt and store the
	// cluster's admin credentials secret. You can only use this parameter if
	// ManageMasterPassword is true.
	MasterPasswordSecretKmsKeyId *string

	// The password associated with the admin user account for the cluster that is
	// being created.
	//
	// You can't use MasterUserPassword if ManageMasterPassword is true .
	//
	// Constraints:
	//
	//   - Must be between 8 and 64 characters in length.
	//
	//   - Must contain at least one uppercase letter.
	//
	//   - Must contain at least one lowercase letter.
	//
	//   - Must contain one number.
	//
	//   - Can be any printable ASCII character (ASCII code 33-126) except ' (single
	//   quote), " (double quote), \ , / , or @ .
	MasterUserPassword *string

	// If true, Amazon Redshift will deploy the cluster in two Availability Zones (AZ).
	MultiAZ *bool

	// The number of compute nodes in the cluster. This parameter is required when the
	// ClusterType parameter is specified as multi-node .
	//
	// For information about determining how many nodes you need, go to [Working with Clusters] in the Amazon
	// Redshift Cluster Management Guide.
	//
	// If you don't specify this parameter, you get a single-node cluster. When
	// requesting a multi-node cluster, you must specify the number of nodes that you
	// want in the cluster.
	//
	// Default: 1
	//
	// Constraints: Value must be at least 1 and no more than 100.
	//
	// [Working with Clusters]: https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes
	NumberOfNodes *int32

	// The port number on which the cluster accepts incoming connections.
	//
	// The cluster is accessible only via the JDBC and ODBC connection strings. Part
	// of the connection string requires the port on which the cluster will listen for
	// incoming connections.
	//
	// Default: 5439
	//
	// Valid Values:
	//
	//   - For clusters with ra3 nodes - Select a port within the ranges 5431-5455 or
	//   8191-8215 . (If you have an existing cluster with ra3 nodes, it isn't required
	//   that you change the port to these ranges.)
	//
	//   - For clusters with dc2 nodes - Select a port within the range 1150-65535 .
	Port *int32

	// The weekly time range (in UTC) during which automated cluster maintenance can
	// occur.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time per
	// region, occurring on a random day of the week. For more information about the
	// time blocks for each region, see [Maintenance Windows]in Amazon Redshift Cluster Management Guide.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Minimum 30-minute window.
	//
	// [Maintenance Windows]: https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows
	PreferredMaintenanceWindow *string

	// If true , the cluster can be accessed from a public network.
	//
	// Default: false
	PubliclyAccessible *bool

	// The Amazon resource name (ARN) of the Amazon Redshift IAM Identity Center
	// application.
	RedshiftIdcApplicationArn *string

	// A unique identifier for the snapshot schedule.
	SnapshotScheduleIdentifier *string

	// A list of tag instances.
	Tags []types.Tag

	// A list of Virtual Private Cloud (VPC) security groups to be associated with the
	// cluster.
	//
	// Default: The default VPC security group is associated with the cluster.
	VpcSecurityGroupIds []string

	noSmithyDocumentSerde
}

type CreateClusterOutput struct {

	// Describes a cluster.
	Cluster *types.Cluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCluster",
	}
}
