// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon Redshift application for use with IAM Identity Center.
func (c *Client) CreateRedshiftIdcApplication(ctx context.Context, params *CreateRedshiftIdcApplicationInput, optFns ...func(*Options)) (*CreateRedshiftIdcApplicationOutput, error) {
	if params == nil {
		params = &CreateRedshiftIdcApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRedshiftIdcApplication", params, optFns, c.addOperationCreateRedshiftIdcApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRedshiftIdcApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRedshiftIdcApplicationInput struct {

	// The IAM role ARN for the Amazon Redshift IAM Identity Center application
	// instance. It has the required permissions to be assumed and invoke the IDC
	// Identity Center API.
	//
	// This member is required.
	IamRoleArn *string

	// The display name for the Amazon Redshift IAM Identity Center application
	// instance. It appears in the console.
	//
	// This member is required.
	IdcDisplayName *string

	// The Amazon resource name (ARN) of the IAM Identity Center instance where Amazon
	// Redshift creates a new managed application.
	//
	// This member is required.
	IdcInstanceArn *string

	// The name of the Redshift application in IAM Identity Center.
	//
	// This member is required.
	RedshiftIdcApplicationName *string

	// The token issuer list for the Amazon Redshift IAM Identity Center application
	// instance.
	AuthorizedTokenIssuerList []types.AuthorizedTokenIssuer

	// The namespace for the Amazon Redshift IAM Identity Center application instance.
	// It determines which managed application verifies the connection token.
	IdentityNamespace *string

	// A collection of service integrations for the Redshift IAM Identity Center
	// application.
	ServiceIntegrations []types.ServiceIntegrationsUnion

	noSmithyDocumentSerde
}

type CreateRedshiftIdcApplicationOutput struct {

	// Contains properties for the Redshift IDC application.
	RedshiftIdcApplication *types.RedshiftIdcApplication

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRedshiftIdcApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateRedshiftIdcApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateRedshiftIdcApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRedshiftIdcApplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRedshiftIdcApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRedshiftIdcApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRedshiftIdcApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRedshiftIdcApplication",
	}
}
