// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	smithy "github.com/aws/smithy-go"
	smithyauth "github.com/aws/smithy-go/auth"
	smithyendpoints "github.com/aws/smithy-go/endpoints"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"net/http"
	"net/url"
	"reflect"
	"strings"
	"testing"
)

// Vanilla outposts without ARN region + access point ARN@us-west-2
func TestEndpointCase0(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Vanilla outposts with ARN region + access point ARN@us-west-2
func TestEndpointCase1(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// accept an access point ARN@us-west-2
func TestEndpointCase2(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// vanilla outposts china@cn-north-1
func TestEndpointCase3(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("cn-north-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// gov region@us-west-2
func TestEndpointCase4(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// gov cloud with fips@us-west-2
func TestEndpointCase5(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// govcloud with fips + arn region@us-gov-west-1
func TestEndpointCase6(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-gov-west-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// gov region@cn-north-1
func TestEndpointCase7(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("cn-north-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// gov cloud with fips@cn-north-1
func TestEndpointCase8(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("cn-north-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// govcloud with fips + arn region@us-gov-west-1
func TestEndpointCase9(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-gov-west-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// gov region@af-south-1
func TestEndpointCase10(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("af-south-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// gov cloud with fips@af-south-1
func TestEndpointCase11(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("af-south-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// govcloud with fips + arn region@us-gov-west-1
func TestEndpointCase12(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-gov-west-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// CreateBucket + OutpostId = outposts endpoint@us-east-2
func TestEndpointCase13(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("blah"),
		OutpostId:         ptr.String("123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// CreateBucket + OutpostId with fips = outposts endpoint@us-east-2
func TestEndpointCase14(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("blah"),
		OutpostId:         ptr.String("123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// CreateBucket without OutpostId = regular endpoint@us-east-2
func TestEndpointCase15(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("blah"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-control.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// ListRegionalBuckets + OutpostId = outposts endpoint@us-east-2
func TestEndpointCase16(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// ListRegionalBuckets without OutpostId = regular endpoint@us-east-2
func TestEndpointCase17(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.s3-control.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// ListRegionalBucket + OutpostId with fips = outposts endpoint@us-east-2
func TestEndpointCase18(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// outpost access points support dualstack@us-west-2
func TestEndpointCase19(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// outpost access points support dualstack@af-south-1
func TestEndpointCase20(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("af-south-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.af-south-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// outpost access points support fips + dualstack@af-south-1
func TestEndpointCase21(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("af-south-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.af-south-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// invalid ARN: must be include outpost ID@us-west-2
func TestEndpointCase22(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The Outpost Id was not set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid ARN: must specify access point@us-west-2
func TestEndpointCase23(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected a 4-component resource", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid ARN@us-west-2
func TestEndpointCase24(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:myaccesspoint"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected a 4-component resource", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// when set, AccountId drives AP construction@us-west-2
func TestEndpointCase25(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("myaccesspoint"),
		AccountId:         ptr.String("myid-1234"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myid-1234.s3-control.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Account ID set inline and in ARN but they both match@us-west-2
func TestEndpointCase26(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseArnRegion:      ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Account ID set inline and in ARN and they do not match@us-west-2
func TestEndpointCase27(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("999999999999"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseArnRegion:      ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: the accountId specified in the ARN (`123456789012`) does not match the parameter (`999999999999`)", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// get access point prefixed with account id using endpoint url@us-west-2
func TestEndpointCase28(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("apname"),
		AccountId:         ptr.String("123456789012"),
		Endpoint:          ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// endpoint url with s3-outposts@us-west-2
func TestEndpointCase29(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Endpoint:          ptr.String("https://beta.example.com"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// access point name with a bucket arn@us-west-2
func TestEndpointCase30(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Endpoint:          ptr.String("beta.example.com"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Expected an outpost type `accesspoint`, found `bucket`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// bucket arn with access point name@us-west-2
func TestEndpointCase31(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		Endpoint:          ptr.String("beta.example.com"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected an outpost type `bucket`, found `accesspoint`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// create bucket with outposts@us-west-2
func TestEndpointCase32(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("bucketname"),
		Endpoint:          ptr.String("https://beta.example.com"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// get bucket with endpoint_url@us-west-2
func TestEndpointCase33(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Endpoint:          ptr.String("https://beta.example.com"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// ListRegionalBucket + OutpostId endpoint url@us-east-2
func TestEndpointCase34(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Endpoint:          ptr.String("https://beta.example.com"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// ListRegionalBucket + OutpostId + fips + endpoint url@us-east-2
func TestEndpointCase35(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Endpoint:          ptr.String("https://beta.example.com"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// ListRegionalBucket + OutpostId + fips + dualstack@us-east-2
func TestEndpointCase36(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-east-2.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// CreateBucket + OutpostId endpoint url@us-east-2
func TestEndpointCase37(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("blah"),
		Endpoint:          ptr.String("https://beta.example.com"),
		OutpostId:         ptr.String("123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// dualstack cannot be used with outposts when an endpoint URL is set@us-west-2.
func TestEndpointCase38(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		Endpoint:          ptr.String("https://s3-outposts.us-west-2.api.aws"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: DualStack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// vanilla bucket arn requires account id@us-west-2
func TestEndpointCase39(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket arn with UseArnRegion = true (arn region supercedes client configured
// region)@us-west-2
func TestEndpointCase40(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in gov partition (non-fips)@us-gov-east-1
func TestEndpointCase41(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-gov-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in gov partition with FIPS@us-gov-west-1
func TestEndpointCase42(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws-us-gov:s3-outposts:us-gov-west-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-gov-west-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-gov-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-west-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in aws partition with FIPS@us-east-2
func TestEndpointCase43(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in aws partition with fips + dualstack@us-east-2
func TestEndpointCase44(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-east-2.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// vanilla bucket arn requires account id@cn-north-1
func TestEndpointCase45(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws-cn:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("cn-north-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket arn with UseArnRegion = true (arn region supercedes client configured
// region)@us-west-2
func TestEndpointCase46(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in gov partition (non-fips)@us-gov-east-1
func TestEndpointCase47(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-gov-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in gov partition with FIPS@us-gov-west-1
func TestEndpointCase48(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws-us-gov:s3-outposts:us-gov-west-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-gov-west-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-gov-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-west-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in aws partition with FIPS@us-east-2
func TestEndpointCase49(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Outposts support dualstack @us-west-2
func TestEndpointCase50(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// vanilla bucket arn requires account id@af-south-1
func TestEndpointCase51(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:af-south-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("af-south-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket arn with UseArnRegion = true (arn region supercedes client configured
// region)@us-west-2
func TestEndpointCase52(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in gov partition (non-fips)@us-gov-east-1
func TestEndpointCase53(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws-us-gov:s3-outposts:us-gov-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-gov-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in gov partition with FIPS@us-gov-west-1
func TestEndpointCase54(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws-us-gov:s3-outposts:us-gov-west-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-gov-west-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-gov-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-west-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// bucket ARN in aws partition with FIPS@us-east-2
func TestEndpointCase55(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts-fips.us-east-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Invalid ARN: missing outpost id and bucket@us-west-2
func TestEndpointCase56(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The Outpost Id was not set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid ARN: missing bucket@us-west-2
func TestEndpointCase57(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected a 4-component resource", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid ARN: missing outpost and bucket ids@us-west-2
func TestEndpointCase58(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:bucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected a 4-component resource", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid ARN: missing bucket id@us-west-2
func TestEndpointCase59(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: expected a bucket name", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// account id inserted into hostname@us-west-2
func TestEndpointCase60(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("1234567890"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://1234567890.s3-control.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// account id prefix with dualstack@us-east-1
func TestEndpointCase61(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("1234567890"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://1234567890.s3-control.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// account id prefix with fips@us-east-1
func TestEndpointCase62(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("1234567890"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://1234567890.s3-control-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// custom account id prefix with fips@us-east-1
func TestEndpointCase63(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.s3-control-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// standard url @ us-east-1
func TestEndpointCase64(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-control.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// fips url @ us-east-1
func TestEndpointCase65(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("us-east-1"),
		UseFIPS: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-control-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// dualstack url @ us-east-1
func TestEndpointCase66(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-control.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// fips,dualstack url @ us-east-1
func TestEndpointCase67(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseDualStack: ptr.Bool(true),
		UseFIPS:      ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-control-fips.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// standard url @ cn-north-1
func TestEndpointCase68(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("cn-north-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-control.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// fips @ cn-north-1
func TestEndpointCase69(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-north-1"),
		UseDualStack: ptr.Bool(true),
		UseFIPS:      ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// custom account id prefix @us-east-1
func TestEndpointCase70(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.s3-control.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// invalid account id prefix @us-east-1
func TestEndpointCase71(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("/?invalid&not-host*label"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountId must only contain a-z, A-Z, 0-9 and `-`.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// custom account id prefix with fips@us-east-1
func TestEndpointCase72(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.s3-control-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// custom account id prefix with dualstack,fips@us-east-1
func TestEndpointCase73(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.s3-control-fips.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// custom account id with custom endpoint
func TestEndpointCase74(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		Endpoint:          ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// RequiresAccountId with AccountId unset
func TestEndpointCase75(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountId is required but not set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// RequiresAccountId with AccountId unset and custom endpoint
func TestEndpointCase76(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Endpoint:          ptr.String("https://beta.example.com"),
		RequiresAccountId: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountId is required but not set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// RequiresAccountId with invalid AccountId and custom endpoint
func TestEndpointCase77(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Endpoint:          ptr.String("https://beta.example.com"),
		AccountId:         ptr.String("/?invalid&not-host*label"),
		RequiresAccountId: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountId must only contain a-z, A-Z, 0-9 and `-`.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// account id with custom endpoint, fips
func TestEndpointCase78(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		Endpoint:          ptr.String("https://example.com"),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// custom endpoint, fips
func TestEndpointCase79(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("us-east-1"),
		Endpoint: ptr.String("https://example.com"),
		UseFIPS:  ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// custom endpoint, fips
func TestEndpointCase80(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("us-east-1"),
		Endpoint: ptr.String("https://example.com"),
		UseFIPS:  ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// custom endpoint, DualStack
func TestEndpointCase81(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Endpoint:     ptr.String("https://example.com"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: DualStack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// region not set
func TestEndpointCase82(t *testing.T) {
	var params = EndpointParameters{}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Region must be set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid partition
func TestEndpointCase83(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("invalid-region 42"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region: region was not a valid DNS name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// ListRegionalBuckets + OutpostId without accountId set.
func TestEndpointCase84(t *testing.T) {
	var params = EndpointParameters{
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountId is required but not set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// ListRegionalBuckets + OutpostId with invalid accountId set.
func TestEndpointCase85(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("/?invalid&not-host*label"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("us-east-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountId must only contain a-z, A-Z, 0-9 and `-`.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// accesspoint set but missing accountId
func TestEndpointCase86(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("myaccesspoint"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "AccountId is required but not set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// outpost accesspoint ARN with missing accountId
func TestEndpointCase87(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2::outpost:op-01234567890123456:outpost:op1"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: missing account ID", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// bucket ARN with missing accountId
func TestEndpointCase88(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2::outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: missing account ID", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// endpoint url with accesspoint (non-arn)
func TestEndpointCase89(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("apname"),
		Endpoint:          ptr.String("https://beta.example.com"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123456789012.beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// access point name with an accesspoint arn@us-west-2
func TestEndpointCase90(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		Endpoint:          ptr.String("https://beta.example.com"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// DualStack + Custom endpoint is not supported(non-arn)
func TestEndpointCase91(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("apname"),
		Endpoint:          ptr.String("https://beta.example.com"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: DualStack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// get bucket with custom endpoint and dualstack is not supported@us-west-2
func TestEndpointCase92(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Endpoint:          ptr.String("https://s3-outposts.us-west-2.api.aws"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: DualStack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// ListRegionalBuckets + OutpostId with fips in CN.
func TestEndpointCase93(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("012345678912"),
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("cn-north-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// ListRegionalBuckets + invalid OutpostId.
func TestEndpointCase94(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("012345678912"),
		OutpostId:         ptr.String("?outpost/invalid+"),
		Region:            ptr.String("us-west-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "OutpostId must only contain a-z, A-Z, 0-9 and `-`.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// bucket ARN with mismatched accountId
func TestEndpointCase95(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:999999:outpost:op-01234567890123456:bucket:mybucket"),
		AccountId:         ptr.String("012345678912"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: the accountId specified in the ARN (`999999`) does not match the parameter (`012345678912`)", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// OutpostId with invalid region
func TestEndpointCase96(t *testing.T) {
	var params = EndpointParameters{
		OutpostId:         ptr.String("op-123"),
		Region:            ptr.String("invalid-region 42"),
		AccountId:         ptr.String("0123456"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region: region was not a valid DNS name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// OutpostId with RequireAccountId unset
func TestEndpointCase97(t *testing.T) {
	var params = EndpointParameters{
		OutpostId:    ptr.String("op-123"),
		Region:       ptr.String("us-west-2"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Outpost Accesspoint ARN with arn region and client region mismatch with
// UseArnRegion=false
func TestEndpointCase98(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseArnRegion:      ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Outpost Bucket ARN with arn region and client region mismatch with
// UseArnRegion=false
func TestEndpointCase99(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Endpoint:          ptr.String("https://beta.example.com"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseArnRegion:      ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Accesspoint ARN with region mismatch and UseArnRegion unset
func TestEndpointCase100(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Bucket ARN with region mismatch and UseArnRegion unset
func TestEndpointCase101(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Outpost Bucket ARN with partition mismatch with UseArnRegion=true
func TestEndpointCase102(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseArnRegion:      ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Client was configured for partition `aws` but ARN has `aws-cn`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Accesspoint ARN with partition mismatch and UseArnRegion=true
func TestEndpointCase103(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		AccountId:         ptr.String("123456789012"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseArnRegion:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Client was configured for partition `aws` but ARN has `aws-cn`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Accesspoint ARN with region mismatch, UseArnRegion=false and custom endpoint
func TestEndpointCase104(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		Region:            ptr.String("us-west-2"),
		Endpoint:          ptr.String("https://example.com"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseArnRegion:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `cn-north-1` does not match client region `us-west-2` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// outpost bucket arn@us-west-2
func TestEndpointCase105(t *testing.T) {
	var params = EndpointParameters{
		Bucket:            ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		Region:            ptr.String("us-west-2"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI: *uri,
		Headers: func() http.Header {
			headers := http.Header{}
			headers.Set("x-amz-account-id", "123456789012")
			headers.Set("x-amz-outpost-id", "op-01234567890123456")
			return headers
		}(),
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// S3 Snow Control with bucket
func TestEndpointCase106(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("https://10.0.1.12:433"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://10.0.1.12:433")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// S3 Snow Control without bucket
func TestEndpointCase107(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Endpoint:     ptr.String("https://10.0.1.12:433"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://10.0.1.12:433")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// S3 Snow Control with bucket and without port
func TestEndpointCase108(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("https://10.0.1.12"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://10.0.1.12")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// S3 Snow Control with bucket and with DNS
func TestEndpointCase109(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("http://s3snow.com"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://s3snow.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// S3 Snow Control with FIPS enabled
func TestEndpointCase110(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("https://10.0.1.12:433"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Snow does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// S3 Snow Control with Dualstack enabled
func TestEndpointCase111(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("https://10.0.1.12:433"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Snow does not support DualStack", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Access Point APIs on express bucket routed to s3express-control
func TestEndpointCase112(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("871317572157"),
		AccessPointName:   ptr.String("myaccesspoint--abcd-ab1--xa-s3"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Access Point APIs on express bucket routed to s3express-control for List
func TestEndpointCase113(t *testing.T) {
	var params = EndpointParameters{
		AccountId:                   ptr.String("871317572157"),
		Region:                      ptr.String("us-east-1"),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		RequiresAccountId:           ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		UseFIPS:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Access Point APIs on express bucket routed to s3express-control for FIPS
func TestEndpointCase114(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("871317572157"),
		AccessPointName:   ptr.String("myaccesspoint--abcd-ab1--xa-s3"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Access Point APIs on express bucket routed to s3express-control for FIPS for
// List
func TestEndpointCase115(t *testing.T) {
	var params = EndpointParameters{
		AccountId:                   ptr.String("871317572157"),
		Region:                      ptr.String("us-east-1"),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		RequiresAccountId:           ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		UseFIPS:                     ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Access Point APIs on express bucket routed to s3express-control for china region
func TestEndpointCase116(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("myaccesspoint--abcd-ab1--xa-s3"),
		AccountId:         ptr.String("871317572157"),
		Region:            ptr.String("cn-north-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Access Point APIs on express bucket routed to s3express-control for china region
// for List
func TestEndpointCase117(t *testing.T) {
	var params = EndpointParameters{
		AccountId:                   ptr.String("871317572157"),
		Region:                      ptr.String("cn-north-1"),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		RequiresAccountId:           ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		UseFIPS:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Error when Access Point APIs on express bucket routed to s3express-control for
// china and FIPS
func TestEndpointCase118(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("871317572157"),
		Region:            ptr.String("cn-north-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Error Access Point APIs on express bucket routed to s3express-control invalid
// zone
func TestEndpointCase119(t *testing.T) {
	var params = EndpointParameters{
		AccessPointName:   ptr.String("myaccesspoint-garbage-zone--xa-s3"),
		AccountId:         ptr.String("871317572157"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Unrecognized S3Express Access Point name format.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Access Point APIs on express bucket routed to custom endpoint if provided
func TestEndpointCase120(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("871317572157"),
		AccessPointName:   ptr.String("myaccesspoint--abcd-ab1--xa-s3"),
		Endpoint:          ptr.String("https://my-endpoint.express-control.s3.aws.dev"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://my-endpoint.express-control.s3.aws.dev")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Access Point APIs on express bucket routed to custom endpoint if provided for
// List
func TestEndpointCase121(t *testing.T) {
	var params = EndpointParameters{
		AccountId:                   ptr.String("871317572157"),
		Region:                      ptr.String("us-east-1"),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		Endpoint:                    ptr.String("https://my-endpoint.express-control.s3.aws.dev"),
		RequiresAccountId:           ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		UseFIPS:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://my-endpoint.express-control.s3.aws.dev")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if !reflect.DeepEqual(expectEndpoint.Headers, result.Headers) {
		t.Errorf("expect headers to match\n%v != %v", expectEndpoint.Headers, result.Headers)
	}

	if !reflect.DeepEqual(expectEndpoint.Properties, result.Properties) {
		t.Errorf("expect properties to match\n%v != %v", expectEndpoint.Properties, result.Properties)
	}
}

// Error on Access Point APIs on express bucket for dual stack
func TestEndpointCase122(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("871317572157"),
		AccessPointName:   ptr.String("myaccesspoint--abcd-ab1--xa-s3"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3Express does not support Dual-stack.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Error Access Point APIs on express bucket for dual stack for List
func TestEndpointCase123(t *testing.T) {
	var params = EndpointParameters{
		AccountId:                   ptr.String("871317572157"),
		Region:                      ptr.String("us-east-1"),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		RequiresAccountId:           ptr.Bool(true),
		UseDualStack:                ptr.Bool(true),
		UseFIPS:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3Express does not support Dual-stack.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Error on Access Point APIs on express bucket for custom endpoint and dual stack
func TestEndpointCase124(t *testing.T) {
	var params = EndpointParameters{
		AccountId:         ptr.String("871317572157"),
		AccessPointName:   ptr.String("myaccesspoint--abcd-ab1--xa-s3"),
		Endpoint:          ptr.String("https://my-endpoint.express-control.s3.aws.dev"),
		Region:            ptr.String("us-east-1"),
		RequiresAccountId: ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: DualStack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Error Access Point APIs on express bucket for custom endpoint and dual stack for
// List
func TestEndpointCase125(t *testing.T) {
	var params = EndpointParameters{
		AccountId:                   ptr.String("871317572157"),
		Region:                      ptr.String("us-east-1"),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		Endpoint:                    ptr.String("https://my-endpoint.express-control.s3.aws.dev"),
		RequiresAccountId:           ptr.Bool(true),
		UseDualStack:                ptr.Bool(true),
		UseFIPS:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: DualStack and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}
