// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists table buckets for your account. For more information, see [S3 Table buckets] in the Amazon
// Simple Storage Service User Guide.
//
// Permissions You must have the s3tables:ListTableBuckets permission to use this
// operation.
//
// [S3 Table buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html
func (c *Client) ListTableBuckets(ctx context.Context, params *ListTableBucketsInput, optFns ...func(*Options)) (*ListTableBucketsOutput, error) {
	if params == nil {
		params = &ListTableBucketsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTableBuckets", params, optFns, c.addOperationListTableBucketsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTableBucketsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTableBucketsInput struct {

	// ContinuationToken indicates to Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key. You can use this ContinuationToken for pagination of the list results.
	ContinuationToken *string

	// The maximum number of table buckets to return in the list.
	MaxBuckets *int32

	// The prefix of the table buckets.
	Prefix *string

	noSmithyDocumentSerde
}

type ListTableBucketsOutput struct {

	// A list of table buckets.
	//
	// This member is required.
	TableBuckets []types.TableBucketSummary

	// You can use this ContinuationToken for pagination of the list results.
	ContinuationToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTableBucketsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTableBuckets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTableBuckets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTableBuckets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTableBuckets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTableBucketsPaginatorOptions is the paginator options for ListTableBuckets
type ListTableBucketsPaginatorOptions struct {
	// The maximum number of table buckets to return in the list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTableBucketsPaginator is a paginator for ListTableBuckets
type ListTableBucketsPaginator struct {
	options   ListTableBucketsPaginatorOptions
	client    ListTableBucketsAPIClient
	params    *ListTableBucketsInput
	nextToken *string
	firstPage bool
}

// NewListTableBucketsPaginator returns a new ListTableBucketsPaginator
func NewListTableBucketsPaginator(client ListTableBucketsAPIClient, params *ListTableBucketsInput, optFns ...func(*ListTableBucketsPaginatorOptions)) *ListTableBucketsPaginator {
	if params == nil {
		params = &ListTableBucketsInput{}
	}

	options := ListTableBucketsPaginatorOptions{}
	if params.MaxBuckets != nil {
		options.Limit = *params.MaxBuckets
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTableBucketsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.ContinuationToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTableBucketsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTableBuckets page.
func (p *ListTableBucketsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTableBucketsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.ContinuationToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxBuckets = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTableBuckets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.ContinuationToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTableBucketsAPIClient is a client that implements the ListTableBuckets
// operation.
type ListTableBucketsAPIClient interface {
	ListTableBuckets(context.Context, *ListTableBucketsInput, ...func(*Options)) (*ListTableBucketsOutput, error)
}

var _ ListTableBucketsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTableBuckets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTableBuckets",
	}
}
