// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all of the SageMaker Partner AI Apps in an account.
func (c *Client) ListPartnerApps(ctx context.Context, params *ListPartnerAppsInput, optFns ...func(*Options)) (*ListPartnerAppsOutput, error) {
	if params == nil {
		params = &ListPartnerAppsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPartnerApps", params, optFns, c.addOperationListPartnerAppsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPartnerAppsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPartnerAppsInput struct {

	// This parameter defines the maximum number of results that can be returned in a
	// single response. The MaxResults parameter is an upper bound, not a target. If
	// there are more results available than the value specified, a NextToken is
	// provided in the response. The NextToken indicates that the user should get the
	// next set of results by providing this token as a part of a subsequent call. The
	// default value for MaxResults is 10.
	MaxResults *int32

	// If the previous response was truncated, you will receive this token. Use it in
	// your next request to receive the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPartnerAppsOutput struct {

	// If the previous response was truncated, you will receive this token. Use it in
	// your next request to receive the next set of results.
	NextToken *string

	// The information related to each of the SageMaker Partner AI Apps in an account.
	Summaries []types.PartnerAppSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPartnerAppsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListPartnerApps{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListPartnerApps{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPartnerApps"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPartnerApps(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListPartnerAppsPaginatorOptions is the paginator options for ListPartnerApps
type ListPartnerAppsPaginatorOptions struct {
	// This parameter defines the maximum number of results that can be returned in a
	// single response. The MaxResults parameter is an upper bound, not a target. If
	// there are more results available than the value specified, a NextToken is
	// provided in the response. The NextToken indicates that the user should get the
	// next set of results by providing this token as a part of a subsequent call. The
	// default value for MaxResults is 10.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPartnerAppsPaginator is a paginator for ListPartnerApps
type ListPartnerAppsPaginator struct {
	options   ListPartnerAppsPaginatorOptions
	client    ListPartnerAppsAPIClient
	params    *ListPartnerAppsInput
	nextToken *string
	firstPage bool
}

// NewListPartnerAppsPaginator returns a new ListPartnerAppsPaginator
func NewListPartnerAppsPaginator(client ListPartnerAppsAPIClient, params *ListPartnerAppsInput, optFns ...func(*ListPartnerAppsPaginatorOptions)) *ListPartnerAppsPaginator {
	if params == nil {
		params = &ListPartnerAppsInput{}
	}

	options := ListPartnerAppsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPartnerAppsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPartnerAppsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPartnerApps page.
func (p *ListPartnerAppsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPartnerAppsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPartnerApps(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPartnerAppsAPIClient is a client that implements the ListPartnerApps
// operation.
type ListPartnerAppsAPIClient interface {
	ListPartnerApps(context.Context, *ListPartnerAppsInput, ...func(*Options)) (*ListPartnerAppsOutput, error)
}

var _ ListPartnerAppsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPartnerApps(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPartnerApps",
	}
}
