// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmquicksetup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssmquicksetup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns Quick Setup configuration managers.
func (c *Client) ListConfigurationManagers(ctx context.Context, params *ListConfigurationManagersInput, optFns ...func(*Options)) (*ListConfigurationManagersOutput, error) {
	if params == nil {
		params = &ListConfigurationManagersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConfigurationManagers", params, optFns, c.addOperationListConfigurationManagersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConfigurationManagersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConfigurationManagersInput struct {

	// Filters the results returned by the request.
	Filters []types.Filter

	// Specifies the maximum number of configuration managers that are returned by the
	// request.
	MaxItems *int32

	// The token to use when requesting a specific set of items from a list.
	StartingToken *string

	noSmithyDocumentSerde
}

type ListConfigurationManagersOutput struct {

	// The configuration managers returned by the request.
	ConfigurationManagersList []types.ConfigurationManagerSummary

	// The token to use when requesting the next set of configuration managers. If
	// there are no additional operations to return, the string is empty.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConfigurationManagersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListConfigurationManagers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListConfigurationManagers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConfigurationManagers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListConfigurationManagersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConfigurationManagers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListConfigurationManagersPaginatorOptions is the paginator options for
// ListConfigurationManagers
type ListConfigurationManagersPaginatorOptions struct {
	// Specifies the maximum number of configuration managers that are returned by the
	// request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConfigurationManagersPaginator is a paginator for ListConfigurationManagers
type ListConfigurationManagersPaginator struct {
	options   ListConfigurationManagersPaginatorOptions
	client    ListConfigurationManagersAPIClient
	params    *ListConfigurationManagersInput
	nextToken *string
	firstPage bool
}

// NewListConfigurationManagersPaginator returns a new
// ListConfigurationManagersPaginator
func NewListConfigurationManagersPaginator(client ListConfigurationManagersAPIClient, params *ListConfigurationManagersInput, optFns ...func(*ListConfigurationManagersPaginatorOptions)) *ListConfigurationManagersPaginator {
	if params == nil {
		params = &ListConfigurationManagersInput{}
	}

	options := ListConfigurationManagersPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConfigurationManagersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.StartingToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConfigurationManagersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConfigurationManagers page.
func (p *ListConfigurationManagersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConfigurationManagersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.StartingToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConfigurationManagers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConfigurationManagersAPIClient is a client that implements the
// ListConfigurationManagers operation.
type ListConfigurationManagersAPIClient interface {
	ListConfigurationManagers(context.Context, *ListConfigurationManagersInput, ...func(*Options)) (*ListConfigurationManagersOutput, error)
}

var _ ListConfigurationManagersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConfigurationManagers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConfigurationManagers",
	}
}
