// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A summarized representation of a plan execution. This structure contains key
// information about an execution without all the detailed step data.
type AbbreviatedExecution struct {

	// The plan execution action. Valid values are Activate , to activate an Amazon Web
	// Services Region, or Deactivate , to deactivate a Region.
	//
	// This member is required.
	ExecutionAction ExecutionAction

	// The execution identifier of a plan execution.
	//
	// This member is required.
	ExecutionId *string

	// The Amazon Web Services Region for a plan execution.
	//
	// This member is required.
	ExecutionRegion *string

	// The plan execution state. Provides the state of a plan execution, for example,
	// In Progress or Paused by Operator.
	//
	// This member is required.
	ExecutionState ExecutionState

	// The plan execution mode. Valid values are Practice , for testing without making
	// actual changes, or Recovery , for actual traffic shifting and application
	// recovery.
	//
	// This member is required.
	Mode ExecutionMode

	// The Amazon Resource Name (ARN) of the plan.
	//
	// This member is required.
	PlanArn *string

	// The timestamp when the plan execution was started.
	//
	// This member is required.
	StartTime *time.Time

	// The actual recovery time that Region switch calculates for a plan execution.
	// Actual recovery time includes the time for the plan to run added to the time
	// elapsed until the application health alarms that you've specified are healthy
	// again.
	ActualRecoveryTime *string

	// An optional comment about the plan execution.
	Comment *string

	// The timestamp when the plan execution was ended.
	EndTime *time.Time

	// The timestamp when the plan execution was last updated.
	UpdatedAt *time.Time

	// The version for the plan.
	Version *string

	noSmithyDocumentSerde
}

// A summarized representation of a Region switch plan. This structure contains
// key information about a plan without all the detailed workflow and step data.
type AbbreviatedPlan struct {

	// The Amazon Resource Name (ARN) of the Region switch plan.
	//
	// This member is required.
	Arn *string

	// The name of a Region switch plan.
	//
	// This member is required.
	Name *string

	// The owner of a Region switch plan.
	//
	// This member is required.
	Owner *string

	// The recovery approach for a Region switch plan, which can be active/active
	// (activeActive) or active/passive (activePassive).
	//
	// This member is required.
	RecoveryApproach RecoveryApproach

	// The Amazon Web Services Region specified for a Region switch plan.
	//
	// This member is required.
	Regions []string

	// Specifies if this is the active plan execution at this time.
	ActivePlanExecution *string

	// The description of a Region switch plan.
	Description *string

	// The execution role is a way to categorize a Region switch plan.
	ExecutionRole *string

	// The primary Region for a plan.
	PrimaryRegion *string

	// The recovery time objective that you've specified.
	RecoveryTimeObjectiveMinutes *int32

	// The timestamp when the plan execution was last updated.
	UpdatedAt *time.Time

	// The version for the plan.
	Version *string

	noSmithyDocumentSerde
}

// Configuration for ARC routing controls used in a Region switch plan. Routing
// controls are simple on/off switches that you can use to shift traffic away from
// an impaired Region.
type ArcRoutingControlConfiguration struct {

	// The Region and ARC routing controls for the configuration.
	//
	// This member is required.
	RegionAndRoutingControls map[string][]ArcRoutingControlState

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	// The timeout value specified for the configuration.
	TimeoutMinutes *int32

	noSmithyDocumentSerde
}

// Represents the state of an ARC routing control.
type ArcRoutingControlState struct {

	// The Amazon Resource Name (ARN) of a routing control.
	//
	// This member is required.
	RoutingControlArn *string

	// The state of an ARC routing control, On or Off.
	//
	// This member is required.
	State RoutingControlStateChange

	noSmithyDocumentSerde
}

// Configuration for an Amazon EC2 Auto Scaling group used in a Region switch plan.
type Asg struct {

	// The Amazon Resource Name (ARN) of the EC2 Auto Scaling group.
	Arn *string

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	noSmithyDocumentSerde
}

// An Amazon CloudWatch alarm associated with a Region switch plan. These alarms
// can be used to trigger automatic execution of the plan.
type AssociatedAlarm struct {

	// The alarm type for an associated alarm. An associated CloudWatch alarm can be
	// an application health alarm or a trigger alarm.
	//
	// This member is required.
	AlarmType AlarmType

	// The resource identifier for alarms that you associate with a plan.
	//
	// This member is required.
	ResourceIdentifier *string

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	noSmithyDocumentSerde
}

// Configuration for Amazon Web Services Lambda functions that perform custom
// actions during a Region switch.
type CustomActionLambdaConfiguration struct {

	// The Amazon Web Services Lambda functions for the execution block.
	//
	// This member is required.
	Lambdas []Lambdas

	// The Amazon Web Services Region for the function to run in.
	//
	// This member is required.
	RegionToRun RegionToRunIn

	// The retry interval specified.
	//
	// This member is required.
	RetryIntervalMinutes *float32

	// The timeout value specified for the configuration.
	TimeoutMinutes *int32

	// The settings for ungraceful execution.
	Ungraceful *LambdaUngraceful

	noSmithyDocumentSerde
}

// Configuration for increasing the capacity of Amazon EC2 Auto Scaling groups
// during a Region switch.
type Ec2AsgCapacityIncreaseConfiguration struct {

	// The EC2 Auto Scaling groups for the configuration.
	//
	// This member is required.
	Asgs []Asg

	// The monitoring approach that you specify EC2 Auto Scaling groups for the
	// configuration.
	CapacityMonitoringApproach Ec2AsgCapacityMonitoringApproach

	// The target percentage that you specify for EC2 Auto Scaling groups.
	TargetPercent *int32

	// The timeout value specified for the configuration.
	TimeoutMinutes *int32

	// The settings for ungraceful execution.
	Ungraceful *Ec2Ungraceful

	noSmithyDocumentSerde
}

// Configuration for handling failures when performing operations on EC2 resources.
type Ec2Ungraceful struct {

	// The minimum success percentage that you specify for EC2 Auto Scaling groups.
	//
	// This member is required.
	MinimumSuccessPercentage *int32

	noSmithyDocumentSerde
}

// The configuration for an Amazon Web Services ECS capacity increase.
type EcsCapacityIncreaseConfiguration struct {

	// The services specified for the configuration.
	//
	// This member is required.
	Services []Service

	// The monitoring approach specified for the configuration, for example,
	// Most_Recent .
	CapacityMonitoringApproach EcsCapacityMonitoringApproach

	// The target percentage specified for the configuration.
	TargetPercent *int32

	// The timeout value specified for the configuration.
	TimeoutMinutes *int32

	// The settings for ungraceful execution.
	Ungraceful *EcsUngraceful

	noSmithyDocumentSerde
}

// The settings for ungraceful execution.
type EcsUngraceful struct {

	// The minimum success percentage specified for the configuration.
	//
	// This member is required.
	MinimumSuccessPercentage *int32

	noSmithyDocumentSerde
}

// The Amazon Web Services EKS cluster execution block configuration.
type EksCluster struct {

	// The Amazon Resource Name (ARN) of an Amazon Web Services EKS cluster.
	//
	// This member is required.
	ClusterArn *string

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	noSmithyDocumentSerde
}

// The Amazon Web Services EKS resource scaling configuration.
type EksResourceScalingConfiguration struct {

	// The Kubernetes resource type for the configuration.
	//
	// This member is required.
	KubernetesResourceType *KubernetesResourceType

	// The monitoring approach for the configuration, that is, whether it was sampled
	// in the last 24 hours or autoscaled in the last 24 hours.
	CapacityMonitoringApproach EksCapacityMonitoringApproach

	// The clusters for the configuration.
	EksClusters []EksCluster

	// The scaling resources for the configuration.
	ScalingResources []map[string]map[string]KubernetesScalingResource

	// The target percentage for the configuration.
	TargetPercent *int32

	// The timeout value specified for the configuration.
	TimeoutMinutes *int32

	// The settings for ungraceful execution.
	Ungraceful *EksResourceScalingUngraceful

	noSmithyDocumentSerde
}

// The ungraceful settings for Amazon Web Services EKS resource scaling.
type EksResourceScalingUngraceful struct {

	// The minimum success percentage for the configuration.
	//
	// This member is required.
	MinimumSuccessPercentage *int32

	noSmithyDocumentSerde
}

// Configuration for approval steps in a Region switch plan execution. Approval
// steps require manual intervention before the execution can proceed.
type ExecutionApprovalConfiguration struct {

	// The IAM approval role for the configuration.
	//
	// This member is required.
	ApprovalRole *string

	// The timeout value specified for the configuration.
	TimeoutMinutes *int32

	noSmithyDocumentSerde
}

// Execution block configurations for a workflow in a Region switch plan. An
// execution block represents a specific type of action to perform during a Region
// switch.
//
// The following types satisfy this interface:
//
//	ExecutionBlockConfigurationMemberArcRoutingControlConfig
//	ExecutionBlockConfigurationMemberCustomActionLambdaConfig
//	ExecutionBlockConfigurationMemberEc2AsgCapacityIncreaseConfig
//	ExecutionBlockConfigurationMemberEcsCapacityIncreaseConfig
//	ExecutionBlockConfigurationMemberEksResourceScalingConfig
//	ExecutionBlockConfigurationMemberExecutionApprovalConfig
//	ExecutionBlockConfigurationMemberGlobalAuroraConfig
//	ExecutionBlockConfigurationMemberParallelConfig
//	ExecutionBlockConfigurationMemberRegionSwitchPlanConfig
//	ExecutionBlockConfigurationMemberRoute53HealthCheckConfig
type ExecutionBlockConfiguration interface {
	isExecutionBlockConfiguration()
}

// An ARC routing control execution block.
type ExecutionBlockConfigurationMemberArcRoutingControlConfig struct {
	Value ArcRoutingControlConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberArcRoutingControlConfig) isExecutionBlockConfiguration() {}

// An Amazon Web Services Lambda execution block.
type ExecutionBlockConfigurationMemberCustomActionLambdaConfig struct {
	Value CustomActionLambdaConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberCustomActionLambdaConfig) isExecutionBlockConfiguration() {}

// An EC2 Auto Scaling group execution block.
type ExecutionBlockConfigurationMemberEc2AsgCapacityIncreaseConfig struct {
	Value Ec2AsgCapacityIncreaseConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberEc2AsgCapacityIncreaseConfig) isExecutionBlockConfiguration() {
}

// The capacity increase specified for the configuration.
type ExecutionBlockConfigurationMemberEcsCapacityIncreaseConfig struct {
	Value EcsCapacityIncreaseConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberEcsCapacityIncreaseConfig) isExecutionBlockConfiguration() {}

// An Amazon Web Services EKS resource scaling execution block.
type ExecutionBlockConfigurationMemberEksResourceScalingConfig struct {
	Value EksResourceScalingConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberEksResourceScalingConfig) isExecutionBlockConfiguration() {}

// A manual approval execution block.
type ExecutionBlockConfigurationMemberExecutionApprovalConfig struct {
	Value ExecutionApprovalConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberExecutionApprovalConfig) isExecutionBlockConfiguration() {}

// An Aurora Global Database execution block.
type ExecutionBlockConfigurationMemberGlobalAuroraConfig struct {
	Value GlobalAuroraConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberGlobalAuroraConfig) isExecutionBlockConfiguration() {}

// A parallel configuration execution block.
type ExecutionBlockConfigurationMemberParallelConfig struct {
	Value ParallelExecutionBlockConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberParallelConfig) isExecutionBlockConfiguration() {}

// A Region switch plan execution block.
type ExecutionBlockConfigurationMemberRegionSwitchPlanConfig struct {
	Value RegionSwitchPlanConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberRegionSwitchPlanConfig) isExecutionBlockConfiguration() {}

// The Amazon Route 53 health check configuration.
type ExecutionBlockConfigurationMemberRoute53HealthCheckConfig struct {
	Value Route53HealthCheckConfiguration

	noSmithyDocumentSerde
}

func (*ExecutionBlockConfigurationMemberRoute53HealthCheckConfig) isExecutionBlockConfiguration() {}

// Represents an event that occurred during a plan execution. These events provide
// a detailed timeline of the execution process.
type ExecutionEvent struct {

	// The event ID for an execution event.
	//
	// This member is required.
	EventId *string

	// The description for an execution event.
	Description *string

	// Errors for an execution event.
	Error *string

	// The execution block type for an execution event.
	ExecutionBlockType ExecutionBlockType

	// The event ID of the previous execution event.
	PreviousEventId *string

	// The resources for an execution event.
	Resources []string

	// The step name for an execution event.
	StepName *string

	// The timestamp for an execution event.
	Timestamp *time.Time

	// The type of an execution event.
	Type ExecutionEventType

	noSmithyDocumentSerde
}

// Configuration for Amazon Aurora global databases used in a Region switch plan.
type GlobalAuroraConfiguration struct {

	// The behavior for a global database, that is, only allow switchover or also
	// allow failover.
	//
	// This member is required.
	Behavior GlobalAuroraDefaultBehavior

	// The database cluster Amazon Resource Names (ARNs) for a global database.
	//
	// This member is required.
	DatabaseClusterArns []string

	// The global cluster identifier for a global database.
	//
	// This member is required.
	GlobalClusterIdentifier *string

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	// The timeout value specified for the configuration.
	TimeoutMinutes *int32

	// The settings for ungraceful execution.
	Ungraceful *GlobalAuroraUngraceful

	noSmithyDocumentSerde
}

// Configuration for handling failures when performing operations on Aurora global
// databases.
type GlobalAuroraUngraceful struct {

	// The settings for ungraceful execution.
	Ungraceful GlobalAuroraUngracefulBehavior

	noSmithyDocumentSerde
}

// Defines the type of Kubernetes resource to scale in an Amazon EKS cluster.
type KubernetesResourceType struct {

	// The API version type for the Kubernetes resource.
	//
	// This member is required.
	ApiVersion *string

	// The kind for the Kubernetes resource.
	//
	// This member is required.
	Kind *string

	noSmithyDocumentSerde
}

// Defines a Kubernetes resource to scale in an Amazon EKS cluster.
type KubernetesScalingResource struct {

	// The name for the Kubernetes resource.
	//
	// This member is required.
	Name *string

	// The namespace for the Kubernetes resource.
	//
	// This member is required.
	Namespace *string

	// The hpaname for the Kubernetes resource.
	HpaName *string

	noSmithyDocumentSerde
}

// Configuration for Amazon Web Services Lambda functions used in a Region switch
// plan.
type Lambdas struct {

	// The Amazon Resource Name (ARN) of the Lambda function.
	Arn *string

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	noSmithyDocumentSerde
}

// Configuration for handling failures when invoking Lambda functions.
type LambdaUngraceful struct {

	// The ungraceful behavior for a Lambda function, which must be set to skip .
	Behavior LambdaUngracefulBehavior

	noSmithyDocumentSerde
}

// A simplified representation of a workflow in a Region switch plan.
type MinimalWorkflow struct {

	// The action for a minimal workflow, which can be Activate or Deactivate.
	Action ExecutionAction

	// The name for a minimal workflow
	Name *string

	noSmithyDocumentSerde
}

// Configuration for steps that should be executed in parallel during a Region
// switch.
type ParallelExecutionBlockConfiguration struct {

	// The steps for a parallel execution block.
	//
	// This member is required.
	Steps []Step

	noSmithyDocumentSerde
}

// Represents a Region switch plan. A plan defines the steps required to shift
// traffic from one Amazon Web Services Region to another.
type Plan struct {

	// The Amazon Resource Name (ARN) of the plan.
	//
	// This member is required.
	Arn *string

	// The execution role for a plan.
	//
	// This member is required.
	ExecutionRole *string

	// The name for a plan.
	//
	// This member is required.
	Name *string

	// The owner of a plan.
	//
	// This member is required.
	Owner *string

	// The recovery approach for a Region switch plan, which can be active/active
	// (activeActive) or active/passive (activePassive).
	//
	// This member is required.
	RecoveryApproach RecoveryApproach

	// The Amazon Web Services Regions for a plan.
	//
	// This member is required.
	Regions []string

	// The workflows for a plan.
	//
	// This member is required.
	Workflows []Workflow

	// The associated application health alarms for a plan.
	AssociatedAlarms map[string]AssociatedAlarm

	// The description for a plan.
	Description *string

	// The primary Region for a plan.
	PrimaryRegion *string

	// The recovery time objective for a plan.
	RecoveryTimeObjectiveMinutes *int32

	// The triggers for a plan.
	Triggers []Trigger

	// The timestamp when the plan was last updated.
	UpdatedAt *time.Time

	// The version for the plan.
	Version *string

	noSmithyDocumentSerde
}

// Configuration for nested Region switch plans. This allows one Region switch
// plan to trigger another plan as part of its execution.
type RegionSwitchPlanConfiguration struct {

	// The Amazon Resource Name (ARN) of the plan configuration.
	//
	// This member is required.
	Arn *string

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	noSmithyDocumentSerde
}

// Represents a warning about a resource in a Region switch plan.
type ResourceWarning struct {

	// The version for the resource warning.
	//
	// This member is required.
	Version *string

	// The warning message about what needs to be corrected.
	//
	// This member is required.
	WarningMessage *string

	// The status of the resource warning.
	//
	// This member is required.
	WarningStatus ResourceWarningStatus

	// The timestamp when the warning was last updated.
	//
	// This member is required.
	WarningUpdatedTime *time.Time

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string

	// The name of the step for the resource warning.
	StepName *string

	// The workflow for the resource warning.
	Workflow *MinimalWorkflow

	noSmithyDocumentSerde
}

// The Amazon Route 53 health check.
type Route53HealthCheck struct {

	// The Amazon Route 53 health check hosted zone ID.
	//
	// This member is required.
	HostedZoneId *string

	// The Amazon Route 53 record name.
	//
	// This member is required.
	RecordName *string

	// The Amazon Route 53 Region.
	//
	// This member is required.
	Region *string

	// The Amazon Route 53 health check ID.
	HealthCheckId *string

	noSmithyDocumentSerde
}

// The Amazon Route 53 health check configuration.
type Route53HealthCheckConfiguration struct {

	// The Amazon Route 53 health check configuration hosted zone ID.
	//
	// This member is required.
	HostedZoneId *string

	// The Amazon Route 53 health check configuration record name.
	//
	// This member is required.
	RecordName *string

	// The cross account role for the configuration.
	CrossAccountRole *string

	// The external ID (secret key) for the configuration.
	ExternalId *string

	// The Amazon Route 53 health check configuration record sets.
	RecordSets []Route53ResourceRecordSet

	// The Amazon Route 53 health check configuration time out (in minutes).
	TimeoutMinutes *int32

	noSmithyDocumentSerde
}

// The Amazon Route 53 record set.
type Route53ResourceRecordSet struct {

	// The Amazon Route 53 record set identifier.
	RecordSetIdentifier *string

	// The Amazon Route 53 record set Region.
	Region *string

	noSmithyDocumentSerde
}

// The service for a cross account role.
type Service struct {

	// The cluster Amazon Resource Name (ARN) for a service.
	ClusterArn *string

	// The cross account role for a service.
	CrossAccountRole *string

	// The external ID (secret key) for the service.
	ExternalId *string

	// The Amazon Resource Name (ARN) for a service.
	ServiceArn *string

	noSmithyDocumentSerde
}

// Represents a step in a Region switch plan workflow. Each step performs a
// specific action during the Region switch process.
type Step struct {

	// The configuration for an execution block in a workflow.
	//
	// This member is required.
	ExecutionBlockConfiguration ExecutionBlockConfiguration

	// The type of an execution block in a workflow.
	//
	// This member is required.
	ExecutionBlockType ExecutionBlockType

	// The name of a step in a workflow.
	//
	// This member is required.
	Name *string

	// The description of a step in a workflow.
	Description *string

	noSmithyDocumentSerde
}

// Represents the state of a step in a plan execution.
type StepState struct {

	// The timestamp when a step endeded execution.
	EndTime *time.Time

	// The name of a step in a workflow.
	Name *string

	// The timestamp when a step started execution.
	StartTime *time.Time

	// The status of a step in a workflow. For example, a status might be Completed or
	// Pending Approval.
	Status StepStatus

	// The mode for a step execution. The mode can be Graceful or Ungraceful.
	StepMode ExecutionMode

	noSmithyDocumentSerde
}

// Defines a condition that can automatically trigger the execution of a Region
// switch plan.
type Trigger struct {

	// The action to perform when the trigger fires. Valid values include ACTIVATE and
	// DEACTIVATE.
	//
	// This member is required.
	Action WorkflowTargetAction

	// The conditions that must be met for the trigger to fire.
	//
	// This member is required.
	Conditions []TriggerCondition

	// The minimum time, in minutes, that must elapse between automatic executions of
	// the plan.
	//
	// This member is required.
	MinDelayMinutesBetweenExecutions *int32

	// The Amazon Web Services Region for a trigger.
	//
	// This member is required.
	TargetRegion *string

	// The description for a trigger.
	Description *string

	noSmithyDocumentSerde
}

// Defines a condition that must be met for a trigger to fire.
type TriggerCondition struct {

	// The name of the CloudWatch alarm associated with the condition.
	//
	// This member is required.
	AssociatedAlarmName *string

	// The condition that must be met. Valid values include ALARM and OK.
	//
	// This member is required.
	Condition AlarmCondition

	noSmithyDocumentSerde
}

// Represents a workflow in a Region switch plan. A workflow defines a sequence of
// steps to execute during a Region switch.
type Workflow struct {

	// The action that the workflow performs. Valid values include ACTIVATE and
	// DEACTIVATE.
	//
	// This member is required.
	WorkflowTargetAction WorkflowTargetAction

	// The steps that make up the workflow.
	Steps []Step

	// The description of the workflow.
	WorkflowDescription *string

	// The Amazon Web Services Region that the workflow targets.
	WorkflowTargetRegion *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isExecutionBlockConfiguration() {}
